/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.capsule.core;

import io.usethesource.capsule.Set;
import io.usethesource.capsule.SetMultimap;
import io.usethesource.capsule.core.AbstractPersistentTrieSetMultimap;
import io.usethesource.capsule.core.AbstractTrieSetMultimap;
import io.usethesource.capsule.core.trie.MultimapNode;
import io.usethesource.capsule.core.trie.MultimapResult;
import io.usethesource.capsule.core.trie.MultimapResultImpl;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;

public abstract class AbstractTransientTrieSetMultimap<K, V, C extends Iterable<V>, R extends MultimapNode<K, V, C, R>>
extends AbstractTrieSetMultimap<K, V, C, R>
implements SetMultimap.Transient<K, V> {
    protected static final boolean DEBUG = false;
    protected final AtomicReference<Thread> mutator = new AtomicReference<Thread>(Thread.currentThread());
    protected R rootNode;
    protected int cachedSize;
    protected int cachedKeySetHashCode;
    protected int cachedKeySetSize;

    protected AbstractTransientTrieSetMultimap(AbstractPersistentTrieSetMultimap<K, V, C, R> trieSetMultimap) {
        this.rootNode = trieSetMultimap.rootNode;
        this.cachedSize = trieSetMultimap.cachedSize;
        this.cachedKeySetHashCode = trieSetMultimap.cachedKeySetHashCode;
        this.cachedKeySetSize = trieSetMultimap.cachedKeySetSize;
        this.assertPropertiesCorrectness();
    }

    private void assertPropertiesCorrectness() {
    }

    @Override
    final R getRootNode() {
        return this.rootNode;
    }

    @Override
    final int getCachedSize() {
        return this.cachedSize;
    }

    @Override
    final int getCachedKeySetHashCode() {
        return this.cachedKeySetHashCode;
    }

    @Override
    final int getCachedKeySetSize() {
        return this.cachedKeySetSize;
    }

    @Override
    public final boolean __insert(K key, V value) {
        return this.__insert(key, this.valueToTemporaryBox(value));
    }

    @Override
    public final boolean __insert(K key, Set.Immutable<V> valueCollection) {
        if (this.mutator.get() == null) {
            throw new IllegalStateException("Transient already frozen.");
        }
        if (valueCollection.isEmpty()) {
            return false;
        }
        int keyHash = key.hashCode();
        MultimapResultImpl details = MultimapResult.unchanged();
        Object values = this.collectionToInternalFormat(valueCollection);
        Object newRootNode = this.rootNode.inserted(this.mutator, key, values, AbstractTransientTrieSetMultimap.transformHashCode(keyHash), 0, details);
        switch (details.getModificationEffect()) {
            case NOTHING: {
                return false;
            }
            case INSERTED_PAYLOAD: {
                this.cachedSize += details.sizeDelta().get().intValue();
                this.cachedKeySetHashCode = this.cachedKeySetHashCode;
                this.cachedKeySetSize = this.cachedKeySetSize++;
                if (details.containsModification(MultimapResult.Modification.INSERTED_KEY)) {
                    this.cachedKeySetHashCode += keyHash;
                }
                this.rootNode = newRootNode;
                this.assertPropertiesCorrectness();
                return true;
            }
        }
        throw new IllegalStateException("Unhandled modification effect.");
    }

    @Override
    public final boolean __put(K key, V value) {
        return this.__put(key, this.valueToTemporaryBox(value));
    }

    @Override
    public final boolean __put(K key, Set.Immutable<V> valueCollection) {
        if (this.mutator.get() == null) {
            throw new IllegalStateException("Transient already frozen.");
        }
        if (valueCollection.isEmpty()) {
            return this.__remove(key);
        }
        int keyHash = key.hashCode();
        MultimapResultImpl details = MultimapResult.unchanged();
        Object values = this.collectionToInternalFormat(valueCollection);
        Object newRootNode = this.rootNode.updated(this.mutator, key, values, AbstractTransientTrieSetMultimap.transformHashCode(keyHash), 0, details);
        switch (details.getModificationEffect()) {
            case NOTHING: {
                return false;
            }
            case REPLACED_PAYLOAD: {
                Set.Immutable evictedValueCollection = this.internalFormatToCollection((Iterable)details.getEvictedPayload().get());
                this.cachedSize = this.cachedSize - evictedValueCollection.size() + valueCollection.size();
                this.cachedKeySetHashCode = this.cachedKeySetHashCode;
                this.cachedKeySetSize = this.cachedKeySetSize;
                this.rootNode = newRootNode;
                this.assertPropertiesCorrectness();
                return true;
            }
            case INSERTED_PAYLOAD: {
                assert (details.containsModification(MultimapResult.Modification.INSERTED_KEY));
                this.cachedSize += valueCollection.size();
                this.cachedKeySetHashCode += keyHash;
                ++this.cachedKeySetSize;
                this.rootNode = newRootNode;
                this.assertPropertiesCorrectness();
                return true;
            }
        }
        throw new IllegalStateException("Unhandled modification effect.");
    }

    @Override
    public final boolean __remove(K key, V value) {
        if (this.mutator.get() == null) {
            throw new IllegalStateException("Transient already frozen.");
        }
        int keyHash = key.hashCode();
        MultimapResultImpl details = MultimapResult.unchanged();
        Object newRootNode = this.rootNode.removed(this.mutator, key, value, AbstractTransientTrieSetMultimap.transformHashCode(keyHash), 0, details);
        switch (details.getModificationEffect()) {
            case NOTHING: {
                return false;
            }
            case REMOVED_PAYLOAD: {
                --this.cachedSize;
                this.cachedKeySetHashCode = this.cachedKeySetHashCode;
                this.cachedKeySetSize = this.cachedKeySetSize--;
                if (details.containsModification(MultimapResult.Modification.REMOVED_KEY)) {
                    this.cachedKeySetHashCode -= keyHash;
                }
                this.rootNode = newRootNode;
                this.assertPropertiesCorrectness();
                return true;
            }
        }
        throw new IllegalStateException("Unhandled modification effect.");
    }

    @Override
    public final boolean __remove(K key) {
        if (this.mutator.get() == null) {
            throw new IllegalStateException("Transient already frozen.");
        }
        int keyHash = key.hashCode();
        MultimapResultImpl details = MultimapResult.unchanged();
        Object newRootNode = this.rootNode.removed(this.mutator, key, AbstractTransientTrieSetMultimap.transformHashCode(keyHash), 0, details);
        switch (details.getModificationEffect()) {
            case NOTHING: {
                return false;
            }
            case REMOVED_PAYLOAD: {
                assert (details.containsModification(MultimapResult.Modification.REMOVED_KEY));
                Set.Immutable evictedValueCollection = this.internalFormatToCollection((Iterable)details.getEvictedPayload().get());
                this.cachedSize -= evictedValueCollection.size();
                this.cachedKeySetHashCode -= keyHash;
                --this.cachedKeySetSize;
                this.rootNode = newRootNode;
                this.assertPropertiesCorrectness();
                return true;
            }
        }
        throw new IllegalStateException("Unhandled modification effect.");
    }

    public static class TransientSetMultimapTupleIterator<K, V, C extends Iterable<V>, R extends MultimapNode<K, V, C, R>, T>
    extends AbstractTrieSetMultimap.SetMultimapTupleIterator<K, V, C, R, T> {
        final AbstractTransientTrieSetMultimap<K, V, C, R> collection;

        public TransientSetMultimapTupleIterator(AbstractTransientTrieSetMultimap<K, V, C, R> collection, BiFunction<K, V, T> tupleOf) {
            super(collection.rootNode, tupleOf);
            this.collection = collection;
        }

        @Override
        public T next() {
            return super.next();
        }

        @Override
        public void remove() {
            this.collection.__remove(this.currentKey, this.currentValue);
        }
    }

    public static class TransientSetMultimapValueIterator<K, V, C extends Iterable<V>, R extends MultimapNode<K, V, C, R>>
    extends AbstractTrieSetMultimap.SetMultimapValueIterator<K, V, C, R> {
        final AbstractTransientTrieSetMultimap<K, V, C, R> collection;

        public TransientSetMultimapValueIterator(AbstractTransientTrieSetMultimap<K, V, C, R> collection, Function<V, C> converter) {
            super(collection.rootNode, converter);
            this.collection = collection;
        }

        @Override
        public C next() {
            return (C)((Iterable)super.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class TransientSetMultimapKeyIterator<K, V, C extends Iterable<V>, R extends MultimapNode<K, V, C, R>>
    extends AbstractTrieSetMultimap.SetMultimapKeyIterator<K, V, C, R> {
        final AbstractTransientTrieSetMultimap<K, V, C, R> collection;
        K lastKey;

        public TransientSetMultimapKeyIterator(AbstractTransientTrieSetMultimap<K, V, C, R> collection) {
            super(collection.rootNode);
            this.collection = collection;
        }

        @Override
        public K next() {
            this.lastKey = super.next();
            return this.lastKey;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

