/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.capsule.core;

import io.usethesource.capsule.Set;
import io.usethesource.capsule.SetMultimap;
import io.usethesource.capsule.core.trie.ArrayView;
import io.usethesource.capsule.core.trie.MultimapNode;
import io.usethesource.capsule.core.trie.Node;
import io.usethesource.capsule.util.collection.AbstractSpecialisedImmutableMap;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class AbstractTrieSetMultimap<K, V, C extends Iterable<V>, R extends MultimapNode<K, V, C, R>>
implements SetMultimap<K, V>,
Serializable {
    private static final long serialVersionUID = 42L;

    abstract R getRootNode();

    abstract int getCachedSize();

    abstract int getCachedKeySetHashCode();

    abstract int getCachedKeySetSize();

    protected abstract Set.Immutable<V> valueToTemporaryBox(V var1);

    protected abstract C collectionToInternalFormat(Set.Immutable<V> var1);

    protected abstract Set.Immutable<V> internalFormatToCollection(C var1);

    private static final <K, V> int tupleHash(int keyHash, int valueHash) {
        return keyHash ^ valueHash;
    }

    private static final <K, V> int tupleHash(int keyHash, V value) {
        return AbstractTrieSetMultimap.tupleHash(keyHash, Objects.hashCode(value));
    }

    private static final <K, V> int tupleHash(K key, V value) {
        return AbstractTrieSetMultimap.tupleHash(Objects.hashCode(key), Objects.hashCode(value));
    }

    private static final <K, V, C extends Collection<V>> int tupleHash(int keyHash, C values) {
        return values.stream().mapToInt(Objects::hashCode).map(valueHash -> AbstractTrieSetMultimap.tupleHash(keyHash, valueHash)).sum();
    }

    private static final <K, V, C extends Collection<V>> int tupleHash(K key, C values) {
        return AbstractTrieSetMultimap.tupleHash(Objects.hashCode(key), values);
    }

    public static final int transformHashCode(int hash) {
        return hash;
    }

    protected static <K, V, C extends Iterable<V>, R extends MultimapNode<K, V, C, R>> int hashCode(R rootNode) {
        int hash = 0;
        SetMultimapTupleIterator it = new SetMultimapTupleIterator(rootNode, AbstractSpecialisedImmutableMap::entryOf);
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Object key = entry.getKey();
            Object val = entry.getValue();
            hash += key.hashCode() ^ val.hashCode();
        }
        return hash;
    }

    protected static <K, V, C extends Iterable<V>, R extends MultimapNode<K, V, C, R>> int size(R rootNode) {
        int size = 0;
        SetMultimapTupleIterator it = new SetMultimapTupleIterator(rootNode, AbstractSpecialisedImmutableMap::entryOf);
        while (it.hasNext()) {
            it.next();
            ++size;
        }
        return size;
    }

    protected static <K, V, C extends Iterable<V>, R extends MultimapNode<K, V, C, R>> int keySetHashCode(R rootNode) {
        int hash = 0;
        SetMultimapKeyIterator it = new SetMultimapKeyIterator(rootNode);
        while (it.hasNext()) {
            Object key = it.next();
            hash += key.hashCode();
        }
        return hash;
    }

    protected static <K, V, C extends Iterable<V>, R extends MultimapNode<K, V, C, R>> int keySetSize(R rootNode) {
        int size = 0;
        SetMultimapKeyIterator it = new SetMultimapKeyIterator(rootNode);
        while (it.hasNext()) {
            it.next();
            ++size;
        }
        return size;
    }

    private static final <K, V> boolean checkHashCodeAndSize(int targetHash, int targetSize, Iterator<Map.Entry<K, V>> iterator) {
        int hash = 0;
        int size = 0;
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            K key = entry.getKey();
            V val = entry.getValue();
            hash += key.hashCode() ^ val.hashCode();
            ++size;
        }
        return hash == targetHash && size == targetSize;
    }

    private static final <K> boolean checkKeySetHashCodeAndSize(int targetHash, int targetSize, Iterator<K> iterator) {
        int hash = 0;
        int size = 0;
        while (iterator.hasNext()) {
            K key = iterator.next();
            hash += key.hashCode();
            ++size;
        }
        return hash == targetHash && size == targetSize;
    }

    protected Iterator<R> nodeIterator() {
        return new TrieSetMultimap_BleedingEdgeNodeIterator(this.getRootNode());
    }

    protected int getNodeCount() {
        Iterator<R> it = this.nodeIterator();
        int sumNodes = 0;
        while (it.hasNext()) {
            ++sumNodes;
            it.next();
        }
        return sumNodes;
    }

    @Override
    public final boolean containsKey(Object o) {
        try {
            Object key = o;
            return this.getRootNode().containsKey((Object)key, AbstractTrieSetMultimap.transformHashCode(key.hashCode()), 0);
        }
        catch (ClassCastException unused) {
            return false;
        }
    }

    @Override
    public final boolean containsValue(Object o) {
        Iterator<V> iterator = this.valueIterator();
        while (iterator.hasNext()) {
            if (!Objects.equals(iterator.next(), o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean containsEntry(Object o0, Object o1) {
        try {
            Object key = o0;
            Object val = o1;
            return this.getRootNode().containsTuple((Object)key, (Object)val, AbstractTrieSetMultimap.transformHashCode(key.hashCode()), 0);
        }
        catch (ClassCastException unused) {
            return false;
        }
    }

    @Override
    public final Set.Immutable<V> get(Object o) {
        try {
            Object key = o;
            Optional values = this.getRootNode().findByKey((Object)key, AbstractTrieSetMultimap.transformHashCode(key.hashCode()), 0);
            if (values.isPresent()) {
                return this.internalFormatToCollection((Iterable)values.get());
            }
            return Set.Immutable.of();
        }
        catch (ClassCastException unused) {
            return Set.Immutable.of();
        }
    }

    @Override
    public Iterator<K> keyIterator() {
        return new SetMultimapKeyIterator(this.getRootNode());
    }

    @Override
    public abstract Iterator<V> valueIterator();

    protected Iterator<V> valueIterator(Function<V, C> converter) {
        return this.valueCollectionsStream(converter).flatMap(values -> StreamSupport.stream(values.spliterator(), false)).iterator();
    }

    @Override
    public Iterator<Map.Entry<K, V>> entryIterator() {
        return new SetMultimapTupleIterator(this.getRootNode(), AbstractSpecialisedImmutableMap::entryOf);
    }

    @Override
    public Iterator<Map.Entry<K, Object>> nativeEntryIterator() {
        return new SetMultimapNativeTupleIterator(this.getRootNode());
    }

    @Override
    public <T> Iterator<T> tupleIterator(BiFunction<K, V, T> tupleOf) {
        return new SetMultimapTupleIterator(this.getRootNode(), tupleOf);
    }

    private Spliterator<C> valueCollectionsSpliterator(Function<V, C> converter) {
        int characteristics = 16704;
        return Spliterators.spliterator(new SetMultimapValueIterator(this.getRootNode(), converter), (long)this.size(), characteristics);
    }

    private Stream<C> valueCollectionsStream(Function<V, C> converter) {
        boolean isParallel = false;
        return StreamSupport.stream(this.valueCollectionsSpliterator(converter), isParallel);
    }

    @Override
    public final Set<K> keySet() {
        AbstractSet keySet = null;
        if (keySet == null) {
            keySet = new AbstractSet<K>(){

                @Override
                public Iterator<K> iterator() {
                    return AbstractTrieSetMultimap.this.keyIterator();
                }

                @Override
                public int size() {
                    return AbstractTrieSetMultimap.this.sizeDistinct();
                }

                @Override
                public boolean isEmpty() {
                    return AbstractTrieSetMultimap.this.isEmpty();
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean contains(Object k) {
                    return AbstractTrieSetMultimap.this.containsKey(k);
                }
            };
        }
        return keySet;
    }

    @Override
    public final Collection<V> values() {
        AbstractCollection values = null;
        if (values == null) {
            values = new AbstractCollection<V>(){

                @Override
                public Iterator<V> iterator() {
                    return AbstractTrieSetMultimap.this.valueIterator();
                }

                @Override
                public int size() {
                    return AbstractTrieSetMultimap.this.size();
                }

                @Override
                public boolean isEmpty() {
                    return AbstractTrieSetMultimap.this.isEmpty();
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean contains(Object v) {
                    return AbstractTrieSetMultimap.this.containsValue(v);
                }
            };
        }
        return values;
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        AbstractSet entrySet = null;
        if (entrySet == null) {
            entrySet = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        private final Iterator<Map.Entry<K, V>> i;
                        {
                            this.i = AbstractTrieSetMultimap.this.entryIterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            return this.i.next();
                        }

                        @Override
                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return AbstractTrieSetMultimap.this.size();
                }

                @Override
                public boolean isEmpty() {
                    return AbstractTrieSetMultimap.this.isEmpty();
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean contains(Object k) {
                    return AbstractTrieSetMultimap.this.containsKey(k);
                }
            };
        }
        return entrySet;
    }

    @Override
    public int hashCode() {
        return AbstractTrieSetMultimap.hashCode(this.getRootNode());
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() == other.getClass()) {
            AbstractTrieSetMultimap that = (AbstractTrieSetMultimap)other;
            if (this.getCachedSize() != that.getCachedSize()) {
                return false;
            }
            if (this.getCachedKeySetSize() != that.getCachedKeySetSize()) {
                return false;
            }
            if (this.getCachedKeySetHashCode() != that.getCachedKeySetHashCode()) {
                return false;
            }
            return Objects.equals(this.getRootNode(), that.getRootNode());
        }
        if (other instanceof SetMultimap) {
            SetMultimap that = (SetMultimap)other;
            if (this.size() != that.size()) {
                return false;
            }
            for (Map.Entry entry : that.entrySet()) {
                try {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    boolean containsTuple = this.getRootNode().containsTuple(key, value, AbstractTrieSetMultimap.transformHashCode(key.hashCode()), 0);
                    if (containsTuple) continue;
                    return false;
                }
                catch (ClassCastException unused) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public String toString() {
        int TO_STRING_MAX_COUNT = 10;
        String body = this.entrySet().stream().limit(10L).map(entry -> String.format("%s: %s", entry.getKey(), entry.getValue())).reduce((o1, o2) -> String.join((CharSequence)", ", o1, o2)).orElse("");
        if (this.size() > 10 && !body.isEmpty()) {
            return String.format("{%s, ...}", body);
        }
        return String.format("{%s}", body);
    }

    private static class TrieSetMultimap_BleedingEdgeNodeIterator<K, V, C, R extends MultimapNode<K, V, C, R>>
    implements Iterator<R> {
        final Deque<Iterator<? extends R>> nodeIteratorStack = new ArrayDeque<Iterator<? extends R>>();

        TrieSetMultimap_BleedingEdgeNodeIterator(R rootNode) {
            this.nodeIteratorStack.push(Collections.singleton(rootNode).iterator());
        }

        @Override
        public boolean hasNext() {
            while (!this.nodeIteratorStack.isEmpty()) {
                if (this.nodeIteratorStack.peek().hasNext()) {
                    return true;
                }
                this.nodeIteratorStack.pop();
            }
            return false;
        }

        @Override
        public R next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            MultimapNode innerNode = (MultimapNode)this.nodeIteratorStack.peek().next();
            ArrayView<? extends Node> subNodes = innerNode.nodeArray();
            if (!subNodes.isEmpty()) {
                this.nodeIteratorStack.push(subNodes.iterator());
            }
            return (R)innerNode;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class SetMultimapTupleIterator<K, V, C extends Iterable<V>, R extends MultimapNode<K, V, C, R>, T>
    extends AbstractSetMultimapIterator<K, V, C, R>
    implements Iterator<T> {
        final BiFunction<K, V, T> tupleOf;
        K currentKey = null;
        V currentValue = null;
        Iterator<V> currentSetIterator = Collections.emptyIterator();

        protected SetMultimapTupleIterator(R rootNode, BiFunction<K, V, T> tupleOf) {
            super(rootNode);
            this.tupleOf = tupleOf;
        }

        @Override
        public boolean hasNext() {
            if (this.currentSetIterator.hasNext()) {
                return true;
            }
            if (super.hasNext()) {
                if (this.currentValueSingletonCursor < this.currentValueSingletonLength) {
                    this.currentKey = this.currentValueNode.dataArray(0, 0).get(this.currentValueSingletonCursor);
                    this.currentSetIterator = Collections.singleton(this.currentValueNode.dataArray(0, 1).get(this.currentValueSingletonCursor)).iterator();
                    ++this.currentValueSingletonCursor;
                } else {
                    this.currentKey = this.currentValueNode.dataArray(1, 0).get(this.currentValueCollectionCursor);
                    this.currentSetIterator = ((Iterable)this.currentValueNode.dataArray(1, 1).get(this.currentValueCollectionCursor)).iterator();
                    ++this.currentValueCollectionCursor;
                }
                return true;
            }
            return false;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currentValue = this.currentSetIterator.next();
            return this.tupleOf.apply(this.currentKey, this.currentValue);
        }
    }

    protected static class SetMultimapNativeTupleIterator<K, V, C, R extends MultimapNode<K, V, C, R>>
    extends AbstractSetMultimapIterator<K, V, C, R>
    implements Iterator<Map.Entry<K, Object>> {
        protected SetMultimapNativeTupleIterator(R rootNode) {
            super(rootNode);
        }

        @Override
        public Map.Entry<K, Object> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.currentValueSingletonCursor < this.currentValueSingletonLength) {
                Object currentKey = this.currentValueNode.dataArray(0, 0).get(this.currentValueSingletonCursor);
                Object currentValue = this.currentValueNode.dataArray(0, 1).get(this.currentValueSingletonCursor);
                ++this.currentValueSingletonCursor;
                return AbstractSpecialisedImmutableMap.entryOf(currentKey, currentValue);
            }
            Object currentKey = this.currentValueNode.dataArray(1, 0).get(this.currentValueCollectionCursor);
            Object currentValue = this.currentValueNode.dataArray(1, 1).get(this.currentValueCollectionCursor);
            ++this.currentValueCollectionCursor;
            return AbstractSpecialisedImmutableMap.entryOf(currentKey, currentValue);
        }
    }

    protected static class SetMultimapValueIterator<K, V, C, R extends MultimapNode<K, V, C, R>>
    extends AbstractSetMultimapIterator<K, V, C, R>
    implements Iterator<C> {
        final Function<V, C> converter;

        public SetMultimapValueIterator(R rootNode, Function<V, C> converter) {
            super(rootNode);
            this.converter = converter;
        }

        @Override
        public C next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.currentValueSingletonCursor < this.currentValueSingletonLength) {
                Object value = this.currentValueNode.dataArray(0, 1).get(this.currentValueSingletonCursor++);
                return this.converter.apply(value);
            }
            return (C)this.currentValueNode.dataArray(1, 1).get(this.currentValueCollectionCursor++);
        }
    }

    protected static class SetMultimapKeyIterator<K, V, C, R extends MultimapNode<K, V, C, R>>
    extends AbstractSetMultimapIterator<K, V, C, R>
    implements Iterator<K> {
        SetMultimapKeyIterator(R rootNode) {
            super(rootNode);
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.currentValueSingletonCursor < this.currentValueSingletonLength) {
                return (K)this.currentValueNode.dataArray(0, 0).get(this.currentValueSingletonCursor++);
            }
            return (K)this.currentValueNode.dataArray(1, 0).get(this.currentValueCollectionCursor++);
        }
    }

    private static abstract class AbstractSetMultimapIterator<K, V, C, R extends MultimapNode<K, V, C, R>> {
        private static final int MAX_DEPTH = 7;
        protected int currentValueSingletonCursor;
        protected int currentValueSingletonLength;
        protected int currentValueCollectionCursor;
        protected int currentValueCollectionLength;
        protected Node currentValueNode;
        private int currentStackLevel = -1;
        private final int[] nodeCursorsAndLengths = new int[14];
        Node[] nodes = new Node[7];

        AbstractSetMultimapIterator(R rootNode) {
            ArrayView<? extends Node> subNodes = rootNode.nodeArray();
            if (!subNodes.isEmpty()) {
                this.currentStackLevel = 0;
                this.nodes[0] = rootNode;
                this.nodeCursorsAndLengths[0] = 0;
                this.nodeCursorsAndLengths[1] = subNodes.size();
            }
            ArrayView singletonPayload = rootNode.dataArray(0, 0);
            ArrayView collectionPayload = rootNode.dataArray(1, 0);
            if (!singletonPayload.isEmpty() || !collectionPayload.isEmpty()) {
                this.currentValueNode = rootNode;
                this.currentValueSingletonCursor = 0;
                this.currentValueSingletonLength = singletonPayload.size();
                this.currentValueCollectionCursor = 0;
                this.currentValueCollectionLength = collectionPayload.size();
            }
        }

        private boolean searchNextValueNode() {
            while (this.currentStackLevel >= 0) {
                int currentCursorIndex = this.currentStackLevel * 2;
                int nodeCursor = this.nodeCursorsAndLengths[currentCursorIndex];
                int currentLengthIndex = currentCursorIndex + 1;
                int nodeLength = this.nodeCursorsAndLengths[currentLengthIndex];
                if (nodeCursor < nodeLength) {
                    Node nextNode = this.nodes[this.currentStackLevel].nodeArray().get(nodeCursor);
                    int n = currentCursorIndex;
                    this.nodeCursorsAndLengths[n] = this.nodeCursorsAndLengths[n] + 1;
                    ArrayView<? extends Node> subNodes = nextNode.nodeArray();
                    if (!subNodes.isEmpty()) {
                        int nextStackLevel = ++this.currentStackLevel;
                        int nextCursorIndex = nextStackLevel * 2;
                        int nextLengthIndex = nextCursorIndex + 1;
                        this.nodes[nextStackLevel] = nextNode;
                        this.nodeCursorsAndLengths[nextCursorIndex] = 0;
                        this.nodeCursorsAndLengths[nextLengthIndex] = subNodes.size();
                    }
                    ArrayView singletonPayload = nextNode.dataArray(0, 0);
                    ArrayView collectionPayload = nextNode.dataArray(1, 0);
                    if (singletonPayload.isEmpty() && collectionPayload.isEmpty()) continue;
                    this.currentValueNode = nextNode;
                    this.currentValueSingletonCursor = 0;
                    this.currentValueSingletonLength = singletonPayload.size();
                    this.currentValueCollectionCursor = 0;
                    this.currentValueCollectionLength = collectionPayload.size();
                    return true;
                }
                --this.currentStackLevel;
            }
            return false;
        }

        public boolean hasNext() {
            if (this.currentValueSingletonCursor < this.currentValueSingletonLength || this.currentValueCollectionCursor < this.currentValueCollectionLength) {
                return true;
            }
            return this.searchNextValueNode();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

