/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.capsule.core.trie;

import io.usethesource.capsule.Set;

public abstract class EitherSingletonOrCollection<T> {
    public static final <T> EitherSingletonOrCollection<T> of(T value) {
        return new SomeSingleton<T>(value);
    }

    public static final <T> EitherSingletonOrCollection of(Set.Immutable<T> value) {
        return new SomeCollection<T>(value);
    }

    abstract boolean isType(Type var1);

    abstract T getSingleton();

    abstract Set.Immutable<T> getCollection();

    private static final class SomeCollection<T>
    extends EitherSingletonOrCollection<T> {
        private final Set.Immutable<T> value;

        private SomeCollection(Set.Immutable<T> value) {
            this.value = value;
        }

        @Override
        boolean isType(Type type) {
            return type == Type.COLLECTION;
        }

        @Override
        T getSingleton() {
            throw new UnsupportedOperationException(String.format("Requested type %s but actually found %s.", new Object[]{Type.SINGLETON, Type.COLLECTION}));
        }

        @Override
        Set.Immutable<T> getCollection() {
            return this.value;
        }
    }

    private static final class SomeSingleton<T>
    extends EitherSingletonOrCollection<T> {
        private final T value;

        private SomeSingleton(T value) {
            this.value = value;
        }

        @Override
        boolean isType(Type type) {
            return type == Type.SINGLETON;
        }

        @Override
        T getSingleton() {
            return this.value;
        }

        @Override
        Set.Immutable<T> getCollection() {
            throw new UnsupportedOperationException(String.format("Requested type %s but actually found %s.", new Object[]{Type.COLLECTION, Type.SINGLETON}));
        }
    }

    public static enum Type {
        SINGLETON,
        COLLECTION;

    }
}

