/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.capsule.util.collection;

import io.usethesource.capsule.Set;
import io.usethesource.capsule.util.collection.AbstractImmutableSet;
import io.usethesource.capsule.util.collection.Set0;
import io.usethesource.capsule.util.collection.Set1;
import io.usethesource.capsule.util.collection.Set2;
import io.usethesource.capsule.util.collection.Set3;
import io.usethesource.capsule.util.collection.Set4;
import io.usethesource.capsule.util.collection.Set5;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractSpecialisedImmutableSet<K>
extends AbstractImmutableSet<K>
implements Set.Immutable<K>,
Cloneable,
Serializable {
    private static Set.Immutable EMPTY_SET = new Set0();

    private static <K> Set.Immutable<K> of() {
        return EMPTY_SET;
    }

    public static <K> Set.Immutable<K> setOf() {
        return EMPTY_SET;
    }

    public static <K> Set.Immutable<K> setOf(K key1) {
        return new Set1<K>(key1);
    }

    public static <K> Set.Immutable<K> setOf(K key1, K key2) {
        return new Set2<K>(key1, key2);
    }

    public static <K> Set.Immutable<K> setOf(K key1, K key2, K key3) {
        return new Set3<K>(key1, key2, key3);
    }

    public static <K> Set.Immutable<K> setOf(K key1, K key2, K key3, K key4) {
        return new Set4<K>(key1, key2, key3, key4);
    }

    public static <K> Set.Immutable<K> setOf(K key1, K key2, K key3, K key4, K key5) {
        return new Set5<K>(key1, key2, key3, key4, key5);
    }

    public static <K> Set.Immutable<K> setOf(K key1, K key2, K key3, K key4, K key5, K key6) {
        Set.Transient<K> tmp = Set.Transient.of(key1, key2, key3, key4, key5, key6);
        return tmp.freeze();
    }

    public static <K> Set.Immutable<K> setOf(Set<K> set) {
        if (set instanceof AbstractSpecialisedImmutableSet) {
            return (Set.Immutable)set;
        }
        Set.Transient<K> tmp = Set.Transient.of();
        for (K item : set) {
            tmp.__insert(item);
        }
        return tmp.freeze();
    }

    @Override
    public boolean add(K k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends K> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<K> iterator() {
        return this.keyIterator();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof Set) {
            try {
                Set that = (Set)other;
                if (this.size() == that.size()) {
                    for (Object e : that) {
                        if (this.contains(e)) continue;
                        return false;
                    }
                    return true;
                }
            }
            catch (ClassCastException unused) {
                return false;
            }
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public boolean isTransientSupported() {
        return true;
    }

    @Override
    public Set.Immutable<K> __insertAll(Set<? extends K> set) {
        Set.Transient tmp = this.asTransient();
        if (tmp.__insertAll(set)) {
            return tmp.freeze();
        }
        return this;
    }

    @Override
    public Set.Immutable<K> __retainAll(Set<? extends K> set) {
        Set.Transient tmp = this.asTransient();
        if (tmp.__retainAll(set)) {
            return tmp.freeze();
        }
        return this;
    }

    @Override
    public Set.Immutable<K> __removeAll(Set<? extends K> set) {
        Set.Transient tmp = this.asTransient();
        if (tmp.__removeAll(set)) {
            return tmp.freeze();
        }
        return this;
    }
}

