/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.capsule.util.collection;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.util.collection.AbstractSpecialisedImmutableMap;
import io.usethesource.capsule.util.collection.AbstractSpecialisedImmutableSet;
import io.usethesource.capsule.util.iterator.SupplierIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

class Map2<K, V>
extends AbstractSpecialisedImmutableMap<K, V> {
    private final K key1;
    private final V val1;
    private final K key2;
    private final V val2;

    Map2(K key1, V val1, K key2, V val2) {
        if (key1.equals(key2)) {
            throw new IllegalArgumentException("Duplicate keys are not allowed in specialised map.");
        }
        this.key1 = key1;
        this.val1 = val1;
        this.key2 = key2;
        this.val2 = val2;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key.equals(this.key1)) {
            return true;
        }
        return key.equals(this.key2);
    }

    @Override
    public boolean containsValue(Object val) {
        if (val.equals(this.val1)) {
            return true;
        }
        return val.equals(this.val2);
    }

    @Override
    public V get(Object key) {
        if (key.equals(this.key1)) {
            return this.val1;
        }
        if (key.equals(this.key2)) {
            return this.val2;
        }
        return null;
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return AbstractSpecialisedImmutableSet.setOf(Map2.entryOf(this.key1, this.val1), Map2.entryOf(this.key2, this.val2));
    }

    @Override
    public Set<K> keySet() {
        return AbstractSpecialisedImmutableSet.setOf(this.key1, this.key2);
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableList(Arrays.asList(this.val1, this.val2));
    }

    public SupplierIterator<K, V> keyIterator() {
        return new SupplierIterator<K, V>(){
            int cursor = 1;
            boolean hasGet;

            @Override
            public boolean hasNext() {
                return this.cursor <= Map2.this.size();
            }

            @Override
            public K next() {
                switch (this.cursor++) {
                    case 1: {
                        return Map2.this.key1;
                    }
                    case 2: {
                        return Map2.this.key2;
                    }
                }
                throw new IllegalStateException();
            }

            @Override
            public V get() {
                if (this.hasGet) {
                    this.hasGet = false;
                    switch (this.cursor) {
                        case 1: {
                            return Map2.this.val1;
                        }
                        case 2: {
                            return Map2.this.val2;
                        }
                    }
                    throw new IllegalStateException();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Map.Immutable<K, V> __put(K key, V val) {
        if (key.equals(this.key1)) {
            return Map2.mapOf(key, val, this.key2, this.val2);
        }
        if (key.equals(this.key2)) {
            return Map2.mapOf(this.key1, this.val1, key, val);
        }
        return Map2.mapOf(this.key1, this.val1, this.key2, this.val2, key, val);
    }

    @Override
    public Map.Immutable<K, V> __remove(K key) {
        if (key.equals(this.key1)) {
            return Map2.mapOf(this.key2, this.val2);
        }
        if (key.equals(this.key2)) {
            return Map2.mapOf(this.key1, this.val1);
        }
        return this;
    }

    @Override
    public Map.Transient<K, V> asTransient() {
        return Map.Transient.of(this.key1, this.val1, this.key2, this.val2);
    }

    @Override
    public int hashCode() {
        return (Objects.hashCode(this.key1) ^ Objects.hashCode(this.val1)) + (Objects.hashCode(this.key2) ^ Objects.hashCode(this.val2));
    }

    public String toString() {
        return String.format("{%s=%s, %s=%s}", this.key1, this.val1, this.key2, this.val2);
    }
}

