/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.capsule.util.collection;

import io.usethesource.capsule.Set;
import io.usethesource.capsule.util.collection.AbstractSpecialisedImmutableSet;
import io.usethesource.capsule.util.iterator.SupplierIterator;
import java.util.NoSuchElementException;
import java.util.Objects;

class Set2<K>
extends AbstractSpecialisedImmutableSet<K> {
    private final K key1;
    private final K key2;

    Set2(K key1, K key2) {
        if (key1.equals(key2)) {
            throw new IllegalArgumentException("Duplicate elements are not allowed in specialised set.");
        }
        this.key1 = key1;
        this.key2 = key2;
    }

    @Override
    public boolean contains(Object key) {
        if (key.equals(this.key1)) {
            return true;
        }
        return key.equals(this.key2);
    }

    @Override
    public K get(Object key) {
        if (key.equals(this.key1)) {
            return this.key1;
        }
        if (key.equals(this.key2)) {
            return this.key2;
        }
        return null;
    }

    @Override
    public int size() {
        return 2;
    }

    public SupplierIterator<K, K> keyIterator() {
        return new SupplierIterator<K, K>(){
            int cursor = 1;
            boolean hasGet;

            @Override
            public boolean hasNext() {
                return this.cursor <= Set2.this.size();
            }

            @Override
            public K next() {
                switch (this.cursor++) {
                    case 1: {
                        return Set2.this.key1;
                    }
                    case 2: {
                        return Set2.this.key2;
                    }
                }
                throw new IllegalStateException();
            }

            @Override
            public K get() {
                if (this.hasGet) {
                    this.hasGet = false;
                    switch (this.cursor) {
                        case 1: {
                            return Set2.this.key1;
                        }
                        case 2: {
                            return Set2.this.key2;
                        }
                    }
                    throw new IllegalStateException();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Set.Immutable<K> __insert(K key) {
        if (key.equals(this.key1)) {
            return Set2.setOf(key, this.key2);
        }
        if (key.equals(this.key2)) {
            return Set2.setOf(this.key1, key);
        }
        return Set2.setOf(this.key1, this.key2, key);
    }

    @Override
    public Set.Immutable<K> __remove(K key) {
        if (key.equals(this.key1)) {
            return Set2.setOf(this.key2);
        }
        if (key.equals(this.key2)) {
            return Set2.setOf(this.key1);
        }
        return this;
    }

    @Override
    public Set.Transient<K> asTransient() {
        return Set.Transient.of(this.key1, this.key2);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.key1) + Objects.hashCode(this.key2);
    }

    @Override
    public String toString() {
        return String.format("{%s, %s}", this.key1, this.key2);
    }
}

