/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.util.collection.AbstractSpecialisedImmutableMap;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.impl.fields.AbstractDefaultWithKeywordParameters;
import io.usethesource.vallang.impl.fields.NodeWithKeywordParametersFacade;
import io.usethesource.vallang.visitors.IValueVisitor;
import java.util.ArrayList;
import java.util.Iterator;

public interface INode
extends IValue,
Iterable<IValue> {
    @Override
    default public int getMatchFingerprint() {
        int hash = this.getName().hashCode();
        if (hash == 0) {
            hash = 3386882;
        }
        return hash + 131 * this.arity();
    }

    public IValue get(int var1);

    public INode set(int var1, IValue var2);

    public int arity();

    public String getName();

    public Iterable<IValue> getChildren();

    @Override
    public Iterator<IValue> iterator();

    default public INode replace(int first, int second, int end, IList repl) {
        ArrayList<IValue> newChildren = new ArrayList<IValue>();
        int rlen = repl.length();
        int increment = Math.abs(second - first);
        if (first < end) {
            int childIndex = 0;
            while (childIndex < first) {
                newChildren.add(this.get(childIndex++));
            }
            int replIndex = 0;
            boolean wrapped = false;
            while (childIndex < end) {
                newChildren.add(repl.get(replIndex++));
                if (replIndex == rlen) {
                    replIndex = 0;
                    wrapped = true;
                }
                ++childIndex;
                for (int j = 1; j < increment && childIndex < end; ++j) {
                    newChildren.add(this.get(childIndex++));
                }
            }
            if (!wrapped) {
                while (replIndex < rlen) {
                    newChildren.add(repl.get(replIndex++));
                }
            }
            int dlen = this.arity();
            while (childIndex < dlen) {
                newChildren.add(this.get(childIndex++));
            }
        } else {
            int childIndex = this.arity() - 1;
            while (childIndex > first) {
                newChildren.add(0, this.get(childIndex--));
            }
            int replIndex = 0;
            boolean wrapped = false;
            while (childIndex > end) {
                newChildren.add(0, repl.get(replIndex++));
                if (replIndex == repl.length()) {
                    replIndex = 0;
                    wrapped = true;
                }
                --childIndex;
                for (int j = 1; j < increment && childIndex > end; ++j) {
                    newChildren.add(0, this.get(childIndex--));
                }
            }
            if (!wrapped) {
                while (replIndex < rlen) {
                    newChildren.add(0, repl.get(replIndex++));
                }
            }
            while (childIndex >= 0) {
                newChildren.add(0, this.get(childIndex--));
            }
        }
        return this.setChildren((IValue[])newChildren.toArray(IValue[]::new));
    }

    public INode setChildren(IValue[] var1);

    @Override
    default public <T, E extends Throwable> T accept(IValueVisitor<T, E> v) throws E {
        return v.visitNode(this);
    }

    @Override
    default public boolean mayHaveKeywordParameters() {
        return true;
    }

    default public IWithKeywordParameters<? extends INode> asWithKeywordParameters() {
        return new AbstractDefaultWithKeywordParameters<INode>(this, AbstractSpecialisedImmutableMap.mapOf()){

            @Override
            protected INode wrap(INode content, Map.Immutable<String, IValue> parameters) {
                return new NodeWithKeywordParametersFacade(content, parameters);
            }
        };
    }

    @Override
    default public boolean match(IValue value) {
        if (value == this) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (this.getType() != value.getType()) {
            return false;
        }
        if (value instanceof INode) {
            INode node2 = (INode)value;
            if (!this.getName().equals(node2.getName())) {
                return false;
            }
            if (this.arity() != node2.arity()) {
                return false;
            }
            Iterator<IValue> it1 = this.iterator();
            Iterator<IValue> it2 = node2.iterator();
            while (it1.hasNext()) {
                if (it1.next().match(it2.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

