/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang;

import io.usethesource.vallang.ICollection;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWriter;
import io.usethesource.vallang.exceptions.IllegalOperationException;
import io.usethesource.vallang.type.Type;
import java.util.Iterator;
import java.util.function.Function;

public interface IRelation<C extends ICollection<C>>
extends Iterable<IValue> {
    @Override
    default public Iterator<IValue> iterator() {
        return this.asContainer().iterator();
    }

    default public C compose(IRelation<C> that) {
        C thisContainer = this.asContainer();
        C thatContainer = that.asContainer();
        Type thisElementType = thisContainer.getElementType();
        Type thatElementType = thatContainer.getElementType();
        if (thisElementType.isBottom()) {
            return thisContainer;
        }
        if (thatElementType.isBottom()) {
            return thatContainer;
        }
        if (thisElementType.getArity() != 2 || thatElementType.getArity() != 2) {
            throw new IllegalOperationException("Incompatible types for composition.", thisElementType, thatElementType);
        }
        if (!thisElementType.getFieldType(1).comparable(thatElementType.getFieldType(0))) {
            return (C)this.asContainer().empty();
        }
        IWriter<C> w = this.writer();
        for (IValue elem1 : this) {
            ITuple tuple1 = (ITuple)elem1;
            for (IValue elem2 : that) {
                ITuple tuple2 = (ITuple)elem2;
                if (!tuple1.get(1).equals(tuple2.get(0))) continue;
                w.appendTuple(tuple1.get(0), tuple2.get(1));
            }
        }
        return w.done();
    }

    default public C closure() {
        IRelation result;
        if (!this.isBinary()) {
            throw new UnsupportedOperationException("relation is not binary");
        }
        C next = this.asContainer();
        while (!(next = (result = next.asRelation()).compose(result).union(next)).equals(result.asContainer())) {
        }
        return next;
    }

    default public C closureStar() {
        IWriter<C> w = this.writer();
        for (IValue val : this.carrier()) {
            w.appendTuple(val, val);
        }
        w.appendAll((Iterable<IValue>)this.closure());
        return w.done();
    }

    default public int arity() {
        return this.asContainer().getElementType().getArity();
    }

    default public C empty() {
        return (C)this.asContainer().empty();
    }

    default public C project(int ... fields) {
        IWriter<C> w = this.writer();
        for (IValue v : this) {
            w.append(((ITuple)v).select(fields));
        }
        return w.done();
    }

    default public C carrier() {
        IWriter<C> w = this.writer().unique();
        for (IValue t : this) {
            w.appendAll((ITuple)t);
        }
        return w.done();
    }

    default public C domain() {
        IWriter w = this.asContainer().writer();
        for (IValue elem : this) {
            w.insert(((ITuple)elem).get(0));
        }
        return (C)w.done();
    }

    default public C range() {
        int columnIndex = this.arity() - 1;
        IWriter<C> w = this.writer();
        for (IValue elem : this) {
            w.insert(((ITuple)elem).get(columnIndex));
        }
        return w.done();
    }

    default public C index(IValue key) {
        Function<ITuple, IValue> mapper;
        C set1 = this.asContainer();
        Type elementType = this.getElementType();
        if (elementType.isBottom()) {
            return (C)set1.empty();
        }
        int valueArity = elementType.getArity() - 1;
        if (valueArity == 0) {
            mapper = t -> t.get(1);
        } else {
            int[] newTupleIndex = new int[valueArity];
            for (int k = 1; k <= valueArity; ++k) {
                newTupleIndex[k - 1] = k;
            }
            mapper = t -> t.select(newTupleIndex);
        }
        IWriter<C> result = this.writer();
        for (IValue val : this) {
            ITuple tup = (ITuple)val;
            if (!tup.get(0).equals(key)) continue;
            result.insert(mapper.apply(tup));
        }
        return result.done();
    }

    public C asContainer();

    default public IWriter<C> writer() {
        return this.asContainer().writer();
    }

    default public Type getElementType() {
        return this.asContainer().getElementType();
    }

    default public boolean isBinary() {
        return this.getElementType().isBottom() || this.getElementType().getArity() == 2;
    }
}

