/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.persistent;

import io.usethesource.vallang.IRelation;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.impl.persistent.SetWriter;
import io.usethesource.vallang.impl.persistent.ValueCollectors;
import io.usethesource.vallang.impl.persistent.ValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class EmptySet
implements ISet {
    private static final Type EMPTY_SET_TYPE = TypeFactory.getInstance().setType(TypeFactory.getInstance().voidType());
    public static final EmptySet EMPTY_SET = new EmptySet();

    private EmptySet() {
    }

    public static final ISet of() {
        return EMPTY_SET;
    }

    @Override
    public String toString() {
        return this.defaultToString();
    }

    public static final ISet of(IValue firstElement) {
        Type firstElementType = firstElement.getType();
        if (SetWriter.isTupleOfArityTwo.test(firstElementType)) {
            return Stream.of(firstElement).map(SetWriter.asInstanceOf(ITuple.class)).collect(ValueCollectors.toSetMultimap(tuple -> tuple.get(0), tuple -> tuple.get(1)));
        }
        return Stream.of(firstElement).collect(ValueCollectors.toSet());
    }

    public ISetWriter writer() {
        return ValueFactory.getInstance().setWriter();
    }

    @Override
    public Type getType() {
        return EMPTY_SET_TYPE;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ISet insert(IValue value) {
        return EmptySet.of(value);
    }

    @Override
    public ISet delete(IValue value) {
        return this;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean contains(IValue value) {
        return false;
    }

    @Override
    public Iterator<IValue> iterator() {
        return Collections.emptyIterator();
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other == this;
    }

    @Override
    public boolean match(IValue other) {
        return other == this;
    }

    @Override
    public ISet union(ISet other) {
        return other;
    }

    @Override
    public ISet intersect(ISet other) {
        return this;
    }

    @Override
    public ISet subtract(ISet other) {
        return this;
    }

    @Override
    public ISet product(ISet that) {
        return this;
    }

    @Override
    public boolean isSubsetOf(ISet other) {
        return true;
    }

    @Override
    public IRelation<ISet> asRelation() {
        return new IRelation<ISet>(){

            @Override
            public ISet asContainer() {
                return EmptySet.this;
            }

            @Override
            public ISet compose(IRelation<ISet> that) {
                return EmptySet.this;
            }

            @Override
            public ISet closure() {
                return EmptySet.this;
            }

            @Override
            public ISet closureStar() {
                return EmptySet.this;
            }

            @Override
            public ISet carrier() {
                return EmptySet.this;
            }

            @Override
            public ISet domain() {
                return EmptySet.this;
            }

            @Override
            public ISet range() {
                return EmptySet.this;
            }

            @Override
            public ISet empty() {
                return EmptySet.this;
            }

            @Override
            public ISet index(IValue key) {
                return EmptySet.this;
            }
        };
    }
}

