/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.persistent;

import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IRelation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.impl.persistent.ListWriter;
import io.usethesource.vallang.impl.persistent.SubListIterator;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.Iterator;
import java.util.Random;
import org.checkerframework.checker.nullness.qual.Nullable;

class SubList
implements IList {
    private final IList base;
    private final int offset;
    private final int length;
    private int hashCode;
    private final Type elementType;

    SubList(IList base, int offset, int length) {
        this.base = base;
        this.offset = offset;
        this.length = length;
        int end = offset + length;
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Offset may not be smaller than 0.");
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Length may not be smaller than 0.");
        }
        if (end > base.length()) {
            throw new IndexOutOfBoundsException("'offset + length' may not be larger than 'list.size()'");
        }
        Type newElementType = TypeFactory.getInstance().voidType();
        Type baseElementType = base.getElementType();
        for (int i = offset; i < end; ++i) {
            IValue el = base.get(i);
            if (newElementType.equals(baseElementType)) break;
            newElementType = newElementType.lub(el.getType());
        }
        this.elementType = newElementType;
    }

    IList materialize() {
        ListWriter w = new ListWriter();
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            w.append(this.base.get(i));
        }
        return w.done();
    }

    IList maybeMaterialize(IList lst) {
        if (lst instanceof SubList) {
            return ((SubList)lst).materialize();
        }
        return lst;
    }

    @Override
    public Type getType() {
        return TF.listType(this.elementType);
    }

    @Override
    public Type getElementType() {
        return this.elementType;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.defaultHashCode();
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof SubList) {
            SubList otherList = (SubList)o;
            if (this.base.equals(otherList.base) && this.offset == otherList.offset && this.length == otherList.length) {
                return true;
            }
        }
        if (o instanceof IList) {
            return this.defaultEquals(o);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.defaultToString();
    }

    @Override
    public Iterator<IValue> iterator() {
        return new SubListIterator(this.base, this.offset, this.length);
    }

    @Override
    public IList append(IValue val) {
        ListWriter w = new ListWriter();
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            w.append(this.base.get(i));
        }
        w.append(val);
        return w.done();
    }

    @Override
    public IRelation<IList> asRelation() {
        return this.materialize().asRelation();
    }

    @Override
    public IList concat(IList lst) {
        ListWriter w = new ListWriter();
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            w.append(this.base.get(i));
        }
        for (IValue v : lst) {
            w.append(v);
        }
        return w.done();
    }

    @Override
    public boolean contains(IValue val) {
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            if (!this.base.get(i).equals(val)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IList delete(IValue val) {
        ListWriter w = new ListWriter();
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            IValue elm = this.base.get(i);
            if (elm.equals(val)) continue;
            w.append(elm);
        }
        return w.done();
    }

    @Override
    public IList delete(int n) {
        ListWriter w = new ListWriter();
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            if (i == n) continue;
            w.append(this.base.get(i));
        }
        return w.done();
    }

    @Override
    public IValue get(int n) {
        return this.base.get(this.offset + n);
    }

    @Override
    public IList insert(IValue val) {
        ListWriter w = new ListWriter();
        int end = this.offset + this.length;
        w.insert(val);
        for (int i = this.offset; i < end; ++i) {
            w.append(this.base.get(i));
        }
        return w.done();
    }

    @Override
    public IList intersect(IList arg0) {
        return this.materialize().intersect(this.maybeMaterialize(arg0));
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public boolean isRelation() {
        return this.getType().isListRelation();
    }

    @Override
    public boolean isSubListOf(IList lst) {
        int end = this.offset + this.length;
        int j = 0;
        block0: for (int i = this.offset; i < end; ++i) {
            IValue elm = this.base.get(i);
            while (j < lst.length()) {
                if (elm.equals(lst.get(j))) {
                    ++j;
                    continue block0;
                }
                ++j;
            }
            return false;
        }
        return true;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public IList product(IList arg0) {
        return this.materialize().product(this.maybeMaterialize(arg0));
    }

    @Override
    public IList put(int n, IValue val) {
        ListWriter w = new ListWriter();
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            if (i == n) {
                w.append(val);
                continue;
            }
            w.append(this.base.get(i));
        }
        return w.done();
    }

    @Override
    public IList replace(int arg0, int arg1, int arg2, IList arg3) {
        return this.materialize().replace(arg0, arg1, arg2, arg3);
    }

    @Override
    public IList reverse() {
        ListWriter w = new ListWriter();
        for (int i = this.offset + this.length - 1; i >= this.offset; --i) {
            w.append(this.base.get(i));
        }
        return w.done();
    }

    @Override
    public IList shuffle(Random arg0) {
        return this.materialize().shuffle(arg0);
    }

    @Override
    public IList sublist(int offset, int length) {
        return new SubList(this.base, this.offset + offset, length);
    }

    @Override
    public IList subtract(IList lst) {
        IListWriter w = this.writer();
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            IValue v = this.base.get(i);
            if (lst.contains(v)) {
                lst = lst.delete(v);
                continue;
            }
            w.append(v);
        }
        return (IList)w.done();
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public IListWriter writer() {
        return new ListWriter();
    }
}

