/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.persistent;

import io.usethesource.capsule.Set;
import io.usethesource.capsule.SetMultimap;
import io.usethesource.capsule.util.stream.CapsuleCollectors;
import io.usethesource.capsule.util.stream.DefaultCollector;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.impl.persistent.PersistentSetFactory;
import io.usethesource.vallang.impl.persistent.ValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.util.AbstractTypeBag;
import java.util.Collections;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;

class ValueCollectors {
    ValueCollectors() {
    }

    public static <T extends IValue> Collector<T, ?, ISet> toSet() {
        class SetStruct {
            AbstractTypeBag elementTypeBag = AbstractTypeBag.of(new Type[0]);
            Set.Transient<T> set = Set.Transient.of();

            SetStruct() {
            }
        }
        BiConsumer<SetStruct, IValue> accumulator = (struct, element) -> {
            if (struct.set.__insert(element)) {
                struct.elementTypeBag = struct.elementTypeBag.increase(element.getType());
            }
        };
        return new DefaultCollector(() -> new SetStruct(), accumulator, ValueCollectors.unsupportedCombiner(), struct -> PersistentSetFactory.from(struct.elementTypeBag, (Set.Immutable<IValue>)struct.set.freeze()), CapsuleCollectors.UNORDERED);
    }

    public static <T extends IValue> Collector<T, ?, IList> toList() {
        return new DefaultCollector(ValueFactory.getInstance()::listWriter, (w, e) -> w.append((IValue)e), ValueCollectors.unsupportedCombiner(), w -> (IList)w.done(), Collections.emptySet());
    }

    public static <T extends ITuple, K extends IValue, V extends IValue> Collector<T, ?, ISet> toSetMultimap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        class SetMultimapStruct {
            AbstractTypeBag keyTypeBag = AbstractTypeBag.of(new Type[0]);
            AbstractTypeBag valTypeBag = AbstractTypeBag.of(new Type[0]);
            SetMultimap.Transient<K, V> map = SetMultimap.Transient.of();

            SetMultimapStruct() {
            }
        }
        BiConsumer<SetMultimapStruct, ITuple> accumulator = (struct, element) -> {
            IValue val;
            IValue key = (IValue)keyMapper.apply(element);
            if (struct.map.__insert((Object)key, (Object)(val = (IValue)valueMapper.apply(element)))) {
                struct.keyTypeBag = struct.keyTypeBag.increase(key.getType());
                struct.valTypeBag = struct.valTypeBag.increase(val.getType());
            }
        };
        return new DefaultCollector(() -> new SetMultimapStruct(), accumulator, ValueCollectors.unsupportedCombiner(), struct -> PersistentSetFactory.from(struct.keyTypeBag, struct.valTypeBag, (SetMultimap.Immutable<IValue, IValue>)struct.map.freeze()), CapsuleCollectors.UNORDERED);
    }

    private static <T> BinaryOperator<T> unsupportedCombiner() {
        return (u, v) -> {
            throw new UnsupportedOperationException("Merging is not yet supported.");
        };
    }
}

