/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.primitive;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.impl.primitive.SourceLocationURIValues;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;

class SourceLocationValues {
    private static final Cache<ISourceLocation, URI> reverseLocationCache = Caffeine.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).maximumSize(1000L).build();
    private static final Cache<URI, ISourceLocation> locationCache = Caffeine.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).maximumSize(1000L).weakKeys().build();

    SourceLocationValues() {
    }

    static ISourceLocation newSourceLocation(ISourceLocation loc, int offset, int length) {
        ISourceLocation root = loc.top();
        if (offset < 0) {
            throw new IllegalArgumentException("offset should be positive");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length should be positive");
        }
        if (offset < 127 && length < 127) {
            return new ByteByte(root, (byte)offset, (byte)length);
        }
        if (offset < 65535 && length < 65535) {
            return new CharChar(root, (char)offset, (char)length);
        }
        return new IntInt(root, offset, length);
    }

    static ISourceLocation newSourceLocation(ISourceLocation loc, int offset, int length, int beginLine, int endLine, int beginCol, int endCol) {
        ISourceLocation root = loc.top();
        if (offset < 0) {
            throw new IllegalArgumentException("offset should be positive");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length should be positive");
        }
        if (beginLine < 0) {
            throw new IllegalArgumentException("beginLine should be positive");
        }
        if (beginCol < 0) {
            throw new IllegalArgumentException("beginCol should be positive");
        }
        if (endCol < 0) {
            throw new IllegalArgumentException("endCol should be positive");
        }
        if (endLine < beginLine) {
            throw new IllegalArgumentException("endLine should be larger than or equal to beginLine");
        }
        if (endLine == beginLine && endCol < beginCol) {
            throw new IllegalArgumentException("endCol should be larger than or equal to beginCol, if on the same line");
        }
        if (offset < 65535 && length < 65535 && beginLine < 127 && endLine < 127 && beginCol < 127 && endCol < 127) {
            return new CharCharByteByteByteByte(root, (char)offset, (char)length, (byte)beginLine, (byte)endLine, (byte)beginCol, (byte)endCol);
        }
        if (offset < 65535 && length < 65535 && beginLine < 65535 && endLine < 65535 && beginCol < 65535 && endCol < 65535) {
            return new CharCharCharCharCharChar(root, (char)offset, (char)length, (char)beginLine, (char)endLine, (char)beginCol, (char)endCol);
        }
        if (beginLine < 65535 && endLine < 65535 && beginCol < 127 && endCol < 127) {
            return new IntIntCharCharByteByte(root, offset, length, (char)beginLine, (char)endLine, (byte)beginCol, (byte)endCol);
        }
        if (beginCol < 127 && endCol < 127) {
            return new IntIntIntIntByteByte(root, offset, length, beginLine, endLine, (byte)beginCol, (byte)endCol);
        }
        return new IntIntIntIntIntInt(root, offset, length, beginLine, endLine, beginCol, endCol);
    }

    static ISourceLocation newSourceLocation(URI uri) throws URISyntaxException {
        if (uri.isOpaque()) {
            throw new UnsupportedOperationException("Opaque URI schemes are not supported; the scheme-specific part must start with a / character.");
        }
        ISourceLocation result = (ISourceLocation)locationCache.get((Object)uri, u -> {
            try {
                return SourceLocationValues.newSourceLocation(u.getScheme(), u.getAuthority(), u.getPath(), u.getQuery(), u.getFragment());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("We can't get a URISyntaxException when we start with an URI");
            }
        });
        if (result == null) {
            throw new RuntimeException("Cache is not working as expected");
        }
        return result;
    }

    static ISourceLocation newSourceLocation(String scheme, String authority, String path, @Nullable String query, @Nullable String fragment) throws URISyntaxException {
        return SourceLocationURIValues.newURI(scheme, authority, path, query, fragment);
    }

    private static class IntInt
    extends Incomplete {
        protected final int offset;
        protected final int length;

        private IntInt(ISourceLocation root, int offset, int length) {
            super(root);
            this.offset = offset;
            this.length = length;
        }

        @Override
        public boolean hasOffsetLength() {
            return true;
        }

        @Override
        public boolean hasLineColumn() {
            return false;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        public int hashCode() {
            int hash = this.root.hashCode();
            hash ^= this.offset << 8;
            return hash ^= this.length << 29;
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == null) {
                return false;
            }
            if (o.getClass() == this.getClass()) {
                IntInt otherSourceLocation = (IntInt)o;
                return this.root.equals(otherSourceLocation.root) && this.offset == otherSourceLocation.offset && this.length == otherSourceLocation.length;
            }
            return false;
        }
    }

    private static class CharChar
    extends Incomplete {
        protected final char offset;
        protected final char length;

        private CharChar(ISourceLocation root, char offset, char length) {
            super(root);
            this.offset = offset;
            this.length = length;
        }

        @Override
        public boolean hasOffsetLength() {
            return true;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        public int hashCode() {
            int hash = this.root.hashCode();
            hash ^= this.offset << 8;
            return hash ^= this.length << 29;
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == null) {
                return false;
            }
            if (o.getClass() == this.getClass()) {
                CharChar otherSourceLocation = (CharChar)o;
                return this.root.equals(otherSourceLocation.root) && this.offset == otherSourceLocation.offset && this.length == otherSourceLocation.length;
            }
            return false;
        }
    }

    private static class ByteByte
    extends Incomplete {
        protected final byte offset;
        protected final byte length;

        private ByteByte(ISourceLocation root, byte offset, byte length) {
            super(root);
            this.offset = offset;
            this.length = length;
        }

        @Override
        public boolean hasOffsetLength() {
            return true;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        public int hashCode() {
            int hash = this.root.hashCode();
            hash ^= this.offset << 8;
            return hash ^= this.length << 29;
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == null) {
                return false;
            }
            if (o.getClass() == this.getClass()) {
                ByteByte otherSourceLocation = (ByteByte)o;
                return this.root.equals(otherSourceLocation.root) && this.offset == otherSourceLocation.offset && this.length == otherSourceLocation.length;
            }
            return false;
        }
    }

    private static class IntIntCharCharByteByte
    extends Complete {
        protected final int offset;
        protected final int length;
        protected final char beginLine;
        protected final char endLine;
        protected final byte beginCol;
        protected final byte endCol;

        private IntIntCharCharByteByte(ISourceLocation root, int offset, int length, char beginLine, char endLine, byte beginCol, byte endCol) {
            super(root);
            this.offset = offset;
            this.length = length;
            this.beginLine = beginLine;
            this.endLine = endLine;
            this.beginCol = beginCol;
            this.endCol = endCol;
        }

        @Override
        public int getBeginLine() {
            return this.beginLine;
        }

        @Override
        public int getEndLine() {
            return this.endLine;
        }

        @Override
        public int getBeginColumn() {
            return this.beginCol;
        }

        @Override
        public int getEndColumn() {
            return this.endCol;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        public int hashCode() {
            int hash = this.root.hashCode();
            hash ^= this.beginLine << 3;
            hash ^= this.endLine << 23;
            hash ^= this.beginCol << 13;
            hash ^= this.endCol << 18;
            hash ^= this.offset << 8;
            return hash ^= this.length << 29;
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == null) {
                return false;
            }
            if (o.getClass() == this.getClass()) {
                IntIntCharCharByteByte otherSourceLocation = (IntIntCharCharByteByte)o;
                return this.root.equals(otherSourceLocation.root) && this.beginLine == otherSourceLocation.beginLine && this.endLine == otherSourceLocation.endLine && this.beginCol == otherSourceLocation.beginCol && this.endCol == otherSourceLocation.endCol && this.offset == otherSourceLocation.offset && this.length == otherSourceLocation.length;
            }
            return false;
        }
    }

    private static class IntIntIntIntByteByte
    extends Complete {
        protected final int offset;
        protected final int length;
        protected final int beginLine;
        protected final int endLine;
        protected final byte beginCol;
        protected final byte endCol;

        private IntIntIntIntByteByte(ISourceLocation root, int offset, int length, int beginLine, int endLine, byte beginCol, byte endCol) {
            super(root);
            this.offset = offset;
            this.length = length;
            this.beginLine = beginLine;
            this.endLine = endLine;
            this.beginCol = beginCol;
            this.endCol = endCol;
        }

        @Override
        public int getBeginLine() {
            return this.beginLine;
        }

        @Override
        public int getEndLine() {
            return this.endLine;
        }

        @Override
        public int getBeginColumn() {
            return this.beginCol;
        }

        @Override
        public int getEndColumn() {
            return this.endCol;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        public int hashCode() {
            int hash = this.root.hashCode();
            hash ^= this.beginLine << 3;
            hash ^= this.endLine << 23;
            hash ^= this.beginCol << 13;
            hash ^= this.endCol << 18;
            hash ^= this.offset << 8;
            return hash ^= this.length << 29;
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == null) {
                return false;
            }
            if (o.getClass() == this.getClass()) {
                IntIntIntIntByteByte otherSourceLocation = (IntIntIntIntByteByte)o;
                return this.root.equals(otherSourceLocation.root) && this.beginLine == otherSourceLocation.beginLine && this.endLine == otherSourceLocation.endLine && this.beginCol == otherSourceLocation.beginCol && this.endCol == otherSourceLocation.endCol && this.offset == otherSourceLocation.offset && this.length == otherSourceLocation.length;
            }
            return false;
        }
    }

    private static class CharCharCharCharCharChar
    extends Complete {
        protected final char offset;
        protected final char length;
        protected final char beginLine;
        protected final char endLine;
        protected final char beginCol;
        protected final char endCol;

        private CharCharCharCharCharChar(ISourceLocation root, char offset, char length, char beginLine, char endLine, char beginCol, char endCol) {
            super(root);
            this.offset = offset;
            this.length = length;
            this.beginLine = beginLine;
            this.endLine = endLine;
            this.beginCol = beginCol;
            this.endCol = endCol;
        }

        @Override
        public Type getType() {
            return TypeFactory.getInstance().sourceLocationType();
        }

        @Override
        public int getBeginLine() {
            return this.beginLine;
        }

        @Override
        public int getEndLine() {
            return this.endLine;
        }

        @Override
        public int getBeginColumn() {
            return this.beginCol;
        }

        @Override
        public int getEndColumn() {
            return this.endCol;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        public int hashCode() {
            int hash = this.root.hashCode();
            hash ^= this.beginLine << 3;
            hash ^= this.endLine << 23;
            hash ^= this.beginCol << 13;
            hash ^= this.endCol << 18;
            hash ^= this.offset << 8;
            return hash ^= this.length << 29;
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == null) {
                return false;
            }
            if (o.getClass() == this.getClass()) {
                CharCharCharCharCharChar otherSourceLocation = (CharCharCharCharCharChar)o;
                return this.root.equals(otherSourceLocation.root) && this.beginLine == otherSourceLocation.beginLine && this.endLine == otherSourceLocation.endLine && this.beginCol == otherSourceLocation.beginCol && this.endCol == otherSourceLocation.endCol && this.offset == otherSourceLocation.offset && this.length == otherSourceLocation.length;
            }
            return false;
        }
    }

    private static class CharCharByteByteByteByte
    extends Complete {
        protected final char offset;
        protected final char length;
        protected final byte beginLine;
        protected final byte endLine;
        protected final byte beginCol;
        protected final byte endCol;

        private CharCharByteByteByteByte(ISourceLocation root, char offset, char length, byte beginLine, byte endLine, byte beginCol, byte endCol) {
            super(root);
            this.offset = offset;
            this.length = length;
            this.beginLine = beginLine;
            this.endLine = endLine;
            this.beginCol = beginCol;
            this.endCol = endCol;
        }

        @Override
        public Type getType() {
            return TypeFactory.getInstance().sourceLocationType();
        }

        @Override
        public int getBeginLine() {
            return this.beginLine;
        }

        @Override
        public int getEndLine() {
            return this.endLine;
        }

        @Override
        public int getBeginColumn() {
            return this.beginCol;
        }

        @Override
        public int getEndColumn() {
            return this.endCol;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        public int hashCode() {
            int hash = this.root.hashCode();
            hash ^= this.beginLine << 3;
            hash ^= this.endLine << 23;
            hash ^= this.beginCol << 13;
            hash ^= this.endCol << 18;
            hash ^= this.offset << 8;
            return hash ^= this.length << 29;
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == null) {
                return false;
            }
            if (o.getClass() == this.getClass()) {
                CharCharByteByteByteByte otherSourceLocation = (CharCharByteByteByteByte)o;
                return this.root.equals(otherSourceLocation.root) && this.beginLine == otherSourceLocation.beginLine && this.endLine == otherSourceLocation.endLine && this.beginCol == otherSourceLocation.beginCol && this.endCol == otherSourceLocation.endCol && this.offset == otherSourceLocation.offset && this.length == otherSourceLocation.length;
            }
            return false;
        }
    }

    private static class IntIntIntIntIntInt
    extends Complete {
        protected final int offset;
        protected final int length;
        protected final int beginLine;
        protected final int endLine;
        protected final int beginCol;
        protected final int endCol;

        private IntIntIntIntIntInt(ISourceLocation root, int offset, int length, int beginLine, int endLine, int beginCol, int endCol) {
            super(root);
            this.offset = offset;
            this.length = length;
            this.beginLine = beginLine;
            this.endLine = endLine;
            this.beginCol = beginCol;
            this.endCol = endCol;
        }

        @Override
        public Type getType() {
            return TypeFactory.getInstance().sourceLocationType();
        }

        @Override
        public int getBeginLine() {
            return this.beginLine;
        }

        @Override
        public int getEndLine() {
            return this.endLine;
        }

        @Override
        public int getBeginColumn() {
            return this.beginCol;
        }

        @Override
        public int getEndColumn() {
            return this.endCol;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        public int hashCode() {
            int hash = this.root.hashCode();
            hash ^= this.beginLine << 3;
            hash ^= this.endLine << 23;
            hash ^= this.beginCol << 13;
            hash ^= this.endCol << 18;
            hash ^= this.offset << 8;
            return hash ^= this.length << 29;
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == null) {
                return false;
            }
            if (o.getClass() == this.getClass()) {
                IntIntIntIntIntInt otherSourceLocation = (IntIntIntIntIntInt)o;
                return this.root.equals(otherSourceLocation.root) && this.beginLine == otherSourceLocation.beginLine && this.endLine == otherSourceLocation.endLine && this.beginCol == otherSourceLocation.beginCol && this.endCol == otherSourceLocation.endCol && this.offset == otherSourceLocation.offset && this.length == otherSourceLocation.length;
            }
            return false;
        }
    }

    private static abstract class Incomplete
    implements ISourceLocation {
        protected ISourceLocation root;

        public Incomplete(ISourceLocation root) {
            this.root = root;
        }

        @Override
        public boolean hasAuthority() {
            return this.root.hasAuthority();
        }

        @Override
        public boolean hasFragment() {
            return this.root.hasFragment();
        }

        @Override
        public boolean hasPath() {
            return this.root.hasPath();
        }

        @Override
        public String toString() {
            return this.defaultToString();
        }

        @Override
        public boolean hasQuery() {
            return this.root.hasQuery();
        }

        @Override
        public String getAuthority() {
            return this.root.getAuthority();
        }

        @Override
        public String getFragment() {
            return this.root.getFragment();
        }

        @Override
        public String getPath() {
            return this.root.getPath();
        }

        @Override
        public String getQuery() {
            return this.root.getQuery();
        }

        @Override
        public String getScheme() {
            return this.root.getScheme();
        }

        @Override
        public ISourceLocation top() {
            return this.root;
        }

        @Override
        public URI getURI() {
            URI result = (URI)reverseLocationCache.get((Object)this.root, u -> {
                URI calculated = u.getURI();
                try {
                    return new URI(calculated.toASCIIString());
                }
                catch (URISyntaxException ignored) {
                    return calculated;
                }
            });
            if (result == null) {
                throw new RuntimeException("Error translating URI");
            }
            return result;
        }

        @Override
        public Type getType() {
            return TypeFactory.getInstance().sourceLocationType();
        }

        @Override
        public boolean hasLineColumn() {
            return false;
        }

        @Override
        public boolean hasOffsetLength() {
            return false;
        }

        @Override
        public int getBeginColumn() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getBeginLine() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getEndColumn() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getEndLine() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLength() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getOffset() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class Complete
    extends Incomplete {
        private Complete(ISourceLocation root) {
            super(root);
        }

        @Override
        public boolean hasOffsetLength() {
            return true;
        }

        @Override
        public boolean hasLineColumn() {
            return true;
        }
    }
}

