/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.reference;

import io.usethesource.vallang.IMap;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWriter;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.impl.reference.Map;
import io.usethesource.vallang.impl.reference.ValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.util.AbstractTypeBag;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class MapWriter
implements IMapWriter {
    private AbstractTypeBag keyTypeBag = AbstractTypeBag.of(new Type[0]);
    private AbstractTypeBag valTypeBag = AbstractTypeBag.of(new Type[0]);
    private final java.util.Map<IValue, IValue> mapContent = new HashMap<IValue, IValue>();
    private @MonotonicNonNull Map constructedMap;

    MapWriter() {
    }

    @Override
    public Iterator<IValue> iterator() {
        return this.mapContent.keySet().iterator();
    }

    @Override
    public @Nullable IValue get(IValue key) {
        return this.mapContent.get(key);
    }

    @Override
    public void insertTuple(IValue ... fields) {
        if (fields.length != 2) {
            throw new IllegalArgumentException("can only insert tuples of arity 2 into a map");
        }
        this.put(fields[0], fields[1]);
    }

    private void checkMutation() {
        if (this.constructedMap != null) {
            throw new UnsupportedOperationException("Mutation of a finalized list is not supported.");
        }
    }

    @Override
    public void putAll(IMap map) throws FactTypeUseException {
        this.checkMutation();
        for (Map.Entry entry : () -> map.entryIterator()) {
            this.updateTypes((IValue)entry.getKey(), (IValue)entry.getValue());
            this.mapContent.put((IValue)entry.getKey(), (IValue)entry.getValue());
        }
    }

    private void updateTypes(IValue key, IValue value) {
        if (this.mapContent.containsKey(key)) {
            this.valTypeBag = this.valTypeBag.decrease(this.mapContent.get(key).getType());
            this.valTypeBag = this.valTypeBag.increase(value.getType());
        } else {
            this.keyTypeBag = this.keyTypeBag.increase(key.getType());
            this.valTypeBag = this.valTypeBag.increase(value.getType());
        }
    }

    @Override
    public void putAll(java.util.Map<IValue, IValue> map) throws FactTypeUseException {
        this.checkMutation();
        for (Map.Entry<IValue, IValue> entry : map.entrySet()) {
            IValue value = entry.getValue();
            this.updateTypes(entry.getKey(), value);
            this.mapContent.put(entry.getKey(), value);
        }
    }

    @Override
    public void put(IValue key, IValue value) throws FactTypeUseException {
        this.checkMutation();
        this.updateTypes(key, value);
        this.mapContent.put(key, value);
    }

    @Override
    public void insert(IValue ... value) throws FactTypeUseException {
        for (IValue tuple : value) {
            ITuple t = (ITuple)tuple;
            IValue key = t.get(0);
            IValue value2 = t.get(1);
            this.updateTypes(key, value2);
            this.put(key, value2);
        }
    }

    @Override
    public IMap done() {
        if (this.constructedMap == null) {
            this.constructedMap = new Map(IMap.TF.mapType(this.keyTypeBag.lub(), this.valTypeBag.lub()), this.mapContent);
        }
        return this.constructedMap;
    }

    @Override
    public Supplier<IWriter<IMap>> supplier() {
        return () -> ValueFactory.getInstance().mapWriter();
    }
}

