/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.io.binary.message;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IDateTime;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.IRational;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.io.binary.util.StacklessStructuredVisitor;
import io.usethesource.vallang.io.binary.util.StructuredIValueVisitor;
import io.usethesource.vallang.io.binary.util.TrackLastWritten;
import io.usethesource.vallang.io.binary.util.WindowCacheFactory;
import io.usethesource.vallang.io.binary.util.WindowSizes;
import io.usethesource.vallang.io.binary.wire.IWireOutputStream;
import io.usethesource.vallang.type.ITypeVisitor;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeStore;
import java.io.IOException;
import java.util.HashSet;

public class IValueWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(IWireOutputStream writer, IValueFactory vf, WindowSizes size, IValue value) throws IOException {
        WindowCacheFactory windowFactory = WindowCacheFactory.getInstance();
        TrackLastWritten<Type> typeCache = windowFactory.getTrackLastWrittenReferenceEquality(size.typeWindow);
        TrackLastWritten<IValue> valueCache = windowFactory.getTrackLastWrittenReferenceEquality(size.valueWindow);
        TrackLastWritten<ISourceLocation> uriCache = windowFactory.getTrackLastWrittenReferenceEquality(size.uriWindow);
        try {
            IValueWriter.writeHeader(writer, size.valueWindow, size.typeWindow, size.uriWindow);
            writer.writeNestedField(4);
            IValueWriter.write(writer, vf, value, typeCache, valueCache, uriCache);
            writer.endMessage();
        }
        finally {
            windowFactory.returnTrackLastWrittenReferenceEquality(typeCache);
            windowFactory.returnTrackLastWrittenReferenceEquality(valueCache);
            windowFactory.returnTrackLastWrittenReferenceEquality(uriCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(IWireOutputStream writer, IValueFactory vf, WindowSizes size, Type type) throws IOException {
        WindowCacheFactory windowFactory = WindowCacheFactory.getInstance();
        TrackLastWritten<Type> typeCache = windowFactory.getTrackLastWrittenReferenceEquality(size.typeWindow);
        TrackLastWritten<IValue> valueCache = windowFactory.getTrackLastWrittenReferenceEquality(size.valueWindow);
        TrackLastWritten<ISourceLocation> uriCache = windowFactory.getTrackLastWrittenReferenceEquality(size.uriWindow);
        try {
            IValueWriter.writeHeader(writer, size.valueWindow, size.typeWindow, size.uriWindow);
            writer.writeNestedField(5);
            IValueWriter.write(writer, vf, type, typeCache, valueCache, uriCache);
            writer.endMessage();
        }
        finally {
            windowFactory.returnTrackLastWrittenReferenceEquality(typeCache);
            windowFactory.returnTrackLastWrittenReferenceEquality(valueCache);
            windowFactory.returnTrackLastWrittenReferenceEquality(uriCache);
        }
    }

    private static void writeHeader(IWireOutputStream writer, int valueWindowSize, int typeWindowSize, int uriWindowSize) throws IOException {
        writer.startMessage(4242);
        writer.writeField(1, valueWindowSize);
        writer.writeField(2, typeWindowSize);
        writer.writeField(3, uriWindowSize);
    }

    private static void write(final IWireOutputStream writer, final IValueFactory vf, Type type, final TrackLastWritten<Type> typeCache, final TrackLastWritten<IValue> valueCache, final TrackLastWritten<ISourceLocation> uriCache) throws IOException {
        type.accept(new ITypeVisitor<Void, IOException>(){

            private boolean writeFromCache(Type type) throws IOException {
                int lastSeen = typeCache.howLongAgo(type);
                if (lastSeen != -1) {
                    IValueWriter.writeSingleValueMessage(writer, 101, 1, lastSeen);
                    return true;
                }
                return false;
            }

            @Override
            public Void visitAbstractData(Type type) throws IOException {
                if (this.writeFromCache(type)) {
                    return null;
                }
                writer.startMessage(113);
                IValueWriter.writeCanBeBackReferenced(writer);
                writer.writeField(1, type.getName());
                writer.writeNestedField(2);
                type.getTypeParameters().accept(this);
                writer.endMessage();
                typeCache.write(type);
                return null;
            }

            @Override
            public Void visitAlias(Type type) throws IOException {
                if (this.writeFromCache(type)) {
                    return null;
                }
                writer.startMessage(121);
                IValueWriter.writeCanBeBackReferenced(writer);
                writer.writeField(1, type.getName());
                writer.writeNestedField(2);
                type.getAliased().accept(this);
                writer.writeNestedField(3);
                type.getTypeParameters().accept(this);
                writer.endMessage();
                typeCache.write(type);
                return null;
            }

            @Override
            public Void visitConstructor(Type type) throws IOException {
                if (this.writeFromCache(type)) {
                    return null;
                }
                writer.startMessage(114);
                IValueWriter.writeCanBeBackReferenced(writer);
                writer.writeField(1, type.getName());
                writer.writeNestedField(2);
                type.getAbstractDataType().accept(this);
                writer.writeNestedField(3);
                type.getFieldTypes().accept(this);
                writer.endMessage();
                typeCache.write(type);
                return null;
            }

            @Override
            public Void visitExternal(Type type) throws IOException {
                if (this.writeFromCache(type)) {
                    return null;
                }
                writer.startMessage(115);
                IValueWriter.writeCanBeBackReferenced(writer);
                writer.writeNestedField(1);
                IConstructor symbol = type.asSymbol(vf, new TypeStore(new TypeStore[0]), vf.setWriter(), new HashSet<IConstructor>());
                IValueWriter.write(writer, vf, symbol, (TrackLastWritten<Type>)typeCache, (TrackLastWritten<IValue>)valueCache, (TrackLastWritten<ISourceLocation>)uriCache);
                writer.endMessage();
                typeCache.write(type);
                return null;
            }

            @Override
            public Void visitList(Type type) throws IOException {
                if (this.writeFromCache(type)) {
                    return null;
                }
                writer.startMessage(117);
                IValueWriter.writeCanBeBackReferenced(writer);
                writer.writeNestedField(1);
                type.getElementType().accept(this);
                writer.endMessage();
                typeCache.write(type);
                return null;
            }

            @Override
            public Void visitMap(Type type) throws IOException {
                if (this.writeFromCache(type)) {
                    return null;
                }
                writer.startMessage(118);
                IValueWriter.writeCanBeBackReferenced(writer);
                writer.writeNestedField(1);
                type.getKeyType().accept(this);
                writer.writeNestedField(2);
                type.getValueType().accept(this);
                if (type.hasFieldNames()) {
                    writer.writeField(3, type.getKeyLabel());
                    writer.writeField(4, type.getValueLabel());
                }
                writer.endMessage();
                typeCache.write(type);
                return null;
            }

            @Override
            public Void visitParameter(Type type) throws IOException {
                if (this.writeFromCache(type)) {
                    return null;
                }
                writer.startMessage(120);
                IValueWriter.writeCanBeBackReferenced(writer);
                writer.writeField(1, type.getName());
                writer.writeNestedField(2);
                type.getBound().accept(this);
                writer.endMessage();
                typeCache.write(type);
                return null;
            }

            @Override
            public Void visitSet(Type type) throws IOException {
                if (this.writeFromCache(type)) {
                    return null;
                }
                writer.startMessage(119);
                IValueWriter.writeCanBeBackReferenced(writer);
                writer.writeNestedField(1);
                type.getElementType().accept(this);
                writer.endMessage();
                typeCache.write(type);
                return null;
            }

            @Override
            public Void visitTuple(Type type) throws IOException {
                if (this.writeFromCache(type)) {
                    return null;
                }
                writer.startMessage(116);
                IValueWriter.writeCanBeBackReferenced(writer);
                writer.writeRepeatedNestedField(2, type.getArity());
                for (int i = 0; i < type.getArity(); ++i) {
                    type.getFieldType(i).accept(this);
                }
                if (type.hasFieldNames()) {
                    writer.writeField(1, type.getFieldNames());
                }
                writer.endMessage();
                typeCache.write(type);
                return null;
            }

            @Override
            public Void visitFunction(Type type) throws IOException {
                return null;
            }

            @Override
            public Void visitBool(Type t) throws IOException {
                writer.writeEmptyMessage(102);
                return null;
            }

            @Override
            public Void visitDateTime(Type t) throws IOException {
                writer.writeEmptyMessage(104);
                return null;
            }

            @Override
            public Void visitInteger(Type t) throws IOException {
                writer.writeEmptyMessage(105);
                return null;
            }

            @Override
            public Void visitNode(Type t) throws IOException {
                writer.writeEmptyMessage(112);
                return null;
            }

            @Override
            public Void visitNumber(Type t) throws IOException {
                writer.writeEmptyMessage(106);
                return null;
            }

            @Override
            public Void visitRational(Type t) throws IOException {
                writer.writeEmptyMessage(107);
                return null;
            }

            @Override
            public Void visitReal(Type t) throws IOException {
                writer.writeEmptyMessage(108);
                return null;
            }

            @Override
            public Void visitSourceLocation(Type t) throws IOException {
                writer.writeEmptyMessage(103);
                return null;
            }

            @Override
            public Void visitString(Type t) throws IOException {
                writer.writeEmptyMessage(109);
                return null;
            }

            @Override
            public Void visitValue(Type t) throws IOException {
                writer.writeEmptyMessage(110);
                return null;
            }

            @Override
            public Void visitVoid(Type t) throws IOException {
                writer.writeEmptyMessage(111);
                return null;
            }
        });
    }

    private static void writeSingleValueMessage(IWireOutputStream writer, int messageID, int fieldId, int fieldValue) throws IOException {
        writer.startMessage(messageID);
        writer.writeField(fieldId, fieldValue);
        writer.endMessage();
    }

    private static void writeSingleValueMessage(IWireOutputStream writer, int messageID, int fieldId, String fieldValue) throws IOException {
        writer.startMessage(messageID);
        writer.writeField(fieldId, fieldValue);
        writer.endMessage();
    }

    private static void writeCanBeBackReferenced(IWireOutputStream writer) throws IOException {
        writer.writeField(31, 1);
    }

    private static void write(final IWireOutputStream writer, final IValueFactory vf, IValue value, final TrackLastWritten<Type> typeCache, final TrackLastWritten<IValue> valueCache, final TrackLastWritten<ISourceLocation> uriCache) throws IOException {
        final IInteger MININT = vf.integer(Integer.MIN_VALUE);
        final IInteger MAXINT = vf.integer(Integer.MAX_VALUE);
        StacklessStructuredVisitor.accept(value, new StructuredIValueVisitor<IOException>(){

            private boolean writeFromCache(IValue val) throws IOException {
                int lastSeen = valueCache.howLongAgo(val);
                if (lastSeen != -1) {
                    IValueWriter.writeSingleValueMessage(writer, 1, 1, lastSeen);
                    return true;
                }
                return false;
            }

            @Override
            public boolean enterConstructor(IConstructor cons, int children) throws IOException {
                if (this.writeFromCache(cons)) {
                    return false;
                }
                writer.startMessage(7);
                IValueWriter.writeCanBeBackReferenced(writer);
                writer.writeNestedField(4);
                IValueWriter.write(writer, vf, cons.getUninstantiatedConstructorType(), (TrackLastWritten<Type>)typeCache, (TrackLastWritten<IValue>)valueCache, (TrackLastWritten<ISourceLocation>)uriCache);
                if (children > 0) {
                    writer.writeRepeatedNestedField(1, children);
                }
                return true;
            }

            @Override
            public void enterConstructorKeywordParameters() throws IOException {
                writer.writeNestedField(2);
            }

            @Override
            public void leaveConstructor(IValue cons) throws IOException {
                writer.endMessage();
                valueCache.write(cons);
            }

            @Override
            public boolean enterNode(INode node, int children) throws IOException {
                if (this.writeFromCache(node)) {
                    return false;
                }
                writer.startMessage(8);
                IValueWriter.writeCanBeBackReferenced(writer);
                writer.writeField(1, node.getName());
                if (children > 0) {
                    writer.writeRepeatedNestedField(2, children);
                }
                return true;
            }

            @Override
            public void enterNodeKeywordParameters() throws IOException {
                writer.writeNestedField(3);
            }

            @Override
            public void leaveNode(IValue cons) throws IOException {
                writer.endMessage();
                valueCache.write(cons);
            }

            @Override
            public void enterNamedValues(String[] names, int numberOfNestedValues) throws IOException {
                writer.startMessage(13);
                writer.writeField(1, names);
                writer.writeRepeatedNestedField(2, numberOfNestedValues);
            }

            @Override
            public void leaveNamedValue() throws IOException {
                writer.endMessage();
            }

            @Override
            public boolean enterList(IList lst, int children) throws IOException {
                if (this.writeFromCache(lst)) {
                    return false;
                }
                writer.startMessage(10);
                IValueWriter.writeCanBeBackReferenced(writer);
                writer.writeRepeatedNestedField(1, children);
                return true;
            }

            @Override
            public void leaveList(IValue lst) throws IOException {
                writer.endMessage();
                valueCache.write(lst);
            }

            @Override
            public boolean enterSet(ISet lst, int elements) throws IOException {
                if (this.writeFromCache(lst)) {
                    return false;
                }
                writer.startMessage(12);
                IValueWriter.writeCanBeBackReferenced(writer);
                writer.writeRepeatedNestedField(1, elements);
                return true;
            }

            @Override
            public void leaveSet(IValue lst) throws IOException {
                writer.endMessage();
                valueCache.write(lst);
            }

            @Override
            public boolean enterMap(IMap map, int elements) throws IOException {
                if (this.writeFromCache(map)) {
                    return false;
                }
                writer.startMessage(11);
                IValueWriter.writeCanBeBackReferenced(writer);
                writer.writeRepeatedNestedField(1, elements * 2);
                return true;
            }

            @Override
            public void leaveMap(IValue map) throws IOException {
                writer.endMessage();
                valueCache.write(map);
            }

            @Override
            public boolean enterTuple(ITuple tuple, int arity) throws IOException {
                if (this.writeFromCache(tuple)) {
                    return false;
                }
                writer.startMessage(9);
                IValueWriter.writeCanBeBackReferenced(writer);
                writer.writeRepeatedNestedField(1, arity);
                return true;
            }

            @Override
            public void leaveTuple(IValue tuple) throws IOException {
                writer.endMessage();
                valueCache.write(tuple);
            }

            @Override
            public void visitBoolean(IBool boolValue) throws IOException {
                if (boolValue.getValue()) {
                    IValueWriter.writeSingleValueMessage(writer, 2, 1, 1);
                } else {
                    writer.writeEmptyMessage(2);
                }
            }

            @Override
            public void visitDateTime(IDateTime dateTime) throws IOException {
                writer.startMessage(32);
                if (dateTime.isDateTime() || dateTime.isDate()) {
                    writer.writeField(1, dateTime.getYear());
                    writer.writeField(2, dateTime.getMonthOfYear());
                    writer.writeField(3, dateTime.getDayOfMonth());
                }
                if (!dateTime.isDate()) {
                    writer.writeField(4, dateTime.getHourOfDay());
                    writer.writeField(5, dateTime.getMinuteOfHour());
                    writer.writeField(6, dateTime.getSecondOfMinute());
                    writer.writeField(7, dateTime.getMillisecondsOfSecond());
                    writer.writeField(8, dateTime.getTimezoneOffsetHours());
                    writer.writeField(9, dateTime.getTimezoneOffsetMinutes());
                }
                writer.endMessage();
            }

            @Override
            public void visitInteger(IInteger ii) throws IOException {
                writer.startMessage(3);
                if (ii.greaterEqual(MININT).getValue() && ii.lessEqual(MAXINT).getValue()) {
                    writer.writeField(1, ii.intValue());
                } else {
                    writer.writeField(2, ii.getTwosComplementRepresentation());
                }
                writer.endMessage();
            }

            @Override
            public void visitReal(IReal o) throws IOException {
                writer.startMessage(4);
                writer.writeField(1, o.unscaled().getTwosComplementRepresentation());
                writer.writeField(2, o.scale());
                writer.endMessage();
            }

            @Override
            public void visitSourceLocation(ISourceLocation loc) throws IOException {
                writer.startMessage(5);
                ISourceLocation uriPart = loc.top();
                int alreadyWritten = uriCache.howLongAgo(uriPart);
                if (alreadyWritten == -1) {
                    writer.writeField(8, uriPart.getScheme());
                    if (uriPart.hasAuthority()) {
                        writer.writeField(9, uriPart.getAuthority());
                    }
                    if (uriPart.hasPath()) {
                        writer.writeField(10, uriPart.getPath());
                    }
                    if (uriPart.hasQuery()) {
                        writer.writeField(11, uriPart.getQuery());
                    }
                    if (uriPart.hasFragment()) {
                        writer.writeField(12, uriPart.getFragment());
                    }
                    uriCache.write(uriPart);
                } else {
                    writer.writeField(1, alreadyWritten);
                }
                if (loc.hasOffsetLength()) {
                    writer.writeField(2, loc.getOffset());
                    writer.writeField(3, loc.getLength());
                }
                if (loc.hasLineColumn()) {
                    writer.writeField(4, loc.getBeginLine());
                    writer.writeField(5, loc.getEndLine());
                    writer.writeField(6, loc.getBeginColumn());
                    writer.writeField(7, loc.getEndColumn());
                }
                writer.endMessage();
            }

            @Override
            public void visitString(IString o) throws IOException {
                IValueWriter.writeSingleValueMessage(writer, 6, 1, o.getValue());
            }

            @Override
            public void visitRational(IRational val) throws IOException {
                writer.startMessage(33);
                writer.writeNestedField(1);
                this.visitInteger(val.numerator());
                writer.writeNestedField(2);
                this.visitInteger(val.denominator());
                writer.endMessage();
            }
        });
    }
}

