/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.io.binary.util;

import java.io.IOException;
import java.io.OutputStream;

public class DelayedCompressionOutputStream
extends OutputStream {
    private static final int COMPRESS_AFTER = 4096;
    private byte[] buffer;
    private int written;
    private OutputStream out;
    private WrappingCompressorFunction compress;
    private int compressHeader;

    public DelayedCompressionOutputStream(OutputStream out, int compressHeader, WrappingCompressorFunction compress) throws IOException {
        this.out = out;
        this.compressHeader = compressHeader;
        this.compress = compress;
        this.buffer = new byte[4096];
        this.written = 0;
    }

    @Override
    public void flush() throws IOException {
        if (this.written != -1) {
            this.out.write(0);
            this.out.write(this.buffer, 0, this.written);
            this.written = -1;
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        try (OutputStream out2 = this.out;){
            this.flush();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.written != -1) {
            if (this.written + len < 4096) {
                System.arraycopy(b, off, this.buffer, this.written, len);
                this.written += len;
                return;
            }
            this.out.write(this.compressHeader);
            this.out = this.compress.wrap(this.out);
            this.out.write(this.buffer, 0, this.written);
            this.written = -1;
        }
        this.out.write(b, off, len);
    }

    @FunctionalInterface
    public static interface WrappingCompressorFunction {
        public OutputStream wrap(OutputStream var1) throws IOException;
    }
}

