/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.io.binary.wire.xml;

import io.usethesource.vallang.io.binary.wire.IWireOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Base64;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XMLWireOutputStream
implements IWireOutputStream {
    private static final XMLOutputFactory fac = XMLOutputFactory.newFactory();
    private final XMLStreamWriter stream;

    public XMLWireOutputStream(OutputStream stream) {
        try {
            this.stream = fac.createXMLStreamWriter(stream);
            this.stream.writeStartDocument();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.stream.writeEndDocument();
            this.stream.close();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.stream.flush();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void startMessage(int messageId) throws IOException {
        try {
            this.stream.writeStartElement("Message");
            this.stream.writeAttribute("id", Integer.toString(messageId));
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void endMessage() throws IOException {
        try {
            this.stream.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeField(int fieldId, int value) throws IOException {
        this.writeField("Integer", fieldId, Integer.toString(value));
    }

    @Override
    public void writeField(int fieldId, String value) throws IOException {
        this.writeField("String", fieldId, value);
    }

    @Override
    public void writeField(int fieldId, byte[] value) throws IOException {
        this.writeField("Bytes", fieldId, Base64.getEncoder().encodeToString(value));
    }

    private void writeField(String name, int fieldId, String value) throws IOException {
        try {
            this.stream.writeStartElement(name);
            this.stream.writeAttribute("id", Integer.toString(fieldId));
            this.stream.writeCharacters(value);
            this.stream.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeField(int fieldId, int[] values) throws IOException {
        this.writeField("Integers", fieldId, (String[])Arrays.stream(values).mapToObj(Integer::toString).toArray(String[]::new));
    }

    @Override
    public void writeField(int fieldId, String[] values) throws IOException {
        this.writeField("Strings", fieldId, values);
    }

    private void writeField(String name, int fieldId, String[] values) throws IOException {
        try {
            this.stream.writeStartElement(name);
            this.stream.writeAttribute("id", Integer.toString(fieldId));
            this.stream.writeAttribute("length", Integer.toString(values.length));
            for (String v : values) {
                this.stream.writeStartElement("Value");
                this.stream.writeCharacters(v);
                this.stream.writeEndElement();
            }
            this.stream.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeNestedField(int fieldId) throws IOException {
        try {
            this.stream.writeStartElement("Nested");
            this.stream.writeAttribute("id", Integer.toString(fieldId));
            this.stream.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeRepeatedNestedField(int fieldId, int numberOfNestedElements) throws IOException {
        try {
            this.stream.writeStartElement("Nesteds");
            this.stream.writeAttribute("id", Integer.toString(fieldId));
            this.stream.writeAttribute("arity", Integer.toString(numberOfNestedElements));
            this.stream.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }
}

