/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.util;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.util.stream.CapsuleCollectors;
import io.usethesource.capsule.util.stream.DefaultCollector;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractTypeBag
implements Cloneable {
    public abstract AbstractTypeBag increase(Type var1, int var2);

    public abstract AbstractTypeBag increase(Type var1);

    public abstract AbstractTypeBag decrease(Type var1);

    public abstract Type lub();

    public abstract int sum();

    public abstract AbstractTypeBag clone();

    public static AbstractTypeBag of(Type ... ts) {
        return TypeBag.of(ts);
    }

    public static AbstractTypeBag of(Type type, int count) {
        return TypeBag.of(type, count);
    }

    public abstract int size();

    public static <M extends Map.Transient<Type, Integer>> Collector<Type, ?, ? extends AbstractTypeBag> toTypeBag() {
        BiConsumer<Map.Transient, Type> accumulator = (countMap, type0) -> countMap.compute(type0, (type1, count) -> count == null ? 1 : count + 1);
        BinaryOperator combiner = (countMap1, countMap2) -> {
            countMap2.forEach((type, count2) -> {
                Integer count1 = (Integer)countMap1.getOrDefault(type, (Object)0);
                countMap1.compute(type, (t, c) -> count1 + count2);
            });
            return countMap1;
        };
        Supplier<Map.Transient> supplier = Map.Transient::of;
        return new DefaultCollector(supplier, accumulator, combiner, countMap -> new TypeBag((Map.Immutable<Type, Integer>)countMap.freeze()), CapsuleCollectors.UNORDERED);
    }

    private static class TypeBag
    extends AbstractTypeBag {
        private final Map.Immutable<Type, Integer> countMap;
        private @MonotonicNonNull Type cachedLub;

        private TypeBag(Map.Immutable<Type, Integer> countMap) {
            this.countMap = countMap;
        }

        private TypeBag(Map.Immutable<Type, Integer> countMap, Type cachedLub) {
            this.countMap = countMap;
            this.cachedLub = cachedLub;
        }

        public static final AbstractTypeBag of(Type ... ts) {
            AbstractTypeBag result = new TypeBag((Map.Immutable<Type, Integer>)Map.Immutable.of());
            for (Type t : ts) {
                result = ((AbstractTypeBag)result).increase(t);
            }
            return result;
        }

        public static final AbstractTypeBag of(Type t, int count) {
            return new TypeBag((Map.Immutable<Type, Integer>)Map.Immutable.of()).increase(t, count);
        }

        @Override
        public AbstractTypeBag increase(Type t, int count) {
            Integer oldCount = (Integer)this.countMap.get((Object)t);
            if (oldCount == null) {
                Map.Immutable newCountMap = this.countMap.__put((Object)t, (Object)count);
                if (this.cachedLub == null) {
                    return new TypeBag((Map.Immutable<Type, Integer>)newCountMap);
                }
                Type newCachedLub = this.cachedLub.lub(t);
                return new TypeBag((Map.Immutable<Type, Integer>)newCountMap, newCachedLub);
            }
            Map.Immutable newCountMap = this.countMap.__put((Object)t, (Object)(oldCount + count));
            return new TypeBag((Map.Immutable<Type, Integer>)newCountMap);
        }

        @Override
        public AbstractTypeBag increase(Type t) {
            return this.increase(t, 1);
        }

        @Override
        public AbstractTypeBag decrease(Type t) {
            Integer oldCount = (Integer)this.countMap.get((Object)t);
            if (oldCount == null) {
                throw new IllegalStateException(String.format("Type '%s' was not present.", t));
            }
            if (oldCount > 1) {
                Map.Immutable newCountMap = this.countMap.__put((Object)t, (Object)(oldCount - 1));
                return this.cachedLub != null ? new TypeBag((Map.Immutable<Type, Integer>)newCountMap, this.cachedLub) : new TypeBag((Map.Immutable<Type, Integer>)newCountMap);
            }
            Map.Immutable newCountMap = this.countMap.__remove((Object)t);
            return new TypeBag((Map.Immutable<Type, Integer>)newCountMap);
        }

        @Override
        public int sum() {
            int total = 0;
            for (Map.Entry entry : this.countMap.entrySet()) {
                total += ((Integer)entry.getValue()).intValue();
            }
            return total;
        }

        @Override
        public Type lub() {
            if (this.cachedLub == null) {
                Type inferredLubType = TypeFactory.getInstance().voidType();
                for (Type t : this.countMap.keySet()) {
                    inferredLubType = inferredLubType.lub(t);
                }
                this.cachedLub = inferredLubType;
            }
            return this.cachedLub;
        }

        @Override
        public AbstractTypeBag clone() {
            return new TypeBag(this.countMap);
        }

        public String toString() {
            return String.format("PreciseType(members=%s)", this.countMap.toString());
        }

        @Override
        public int size() {
            return this.countMap.size();
        }

        public int hashCode() {
            return this.countMap.hashCode();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeBag typeBag = (TypeBag)o;
            return this.countMap.equals(typeBag.countMap);
        }
    }
}

