/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.util;

import io.usethesource.vallang.util.HashConsingMap;
import io.usethesource.vallang.util.SecondsTicker;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;

public class WeakReferenceHashConsingMap<T>
implements HashConsingMap<T> {
    private final HotEntry<T>[] hotEntries;
    private final int mask;
    private final ReferenceQueue<T> queue = new ReferenceQueue();
    private final Map<Object, WeakReferenceWrap<T>> coldEntries;

    public WeakReferenceHashConsingMap() {
        this(16, (int)TimeUnit.MINUTES.toSeconds(30L));
    }

    public WeakReferenceHashConsingMap(int size, int demoteAfterSeconds) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size should be a positive number");
        }
        size = Integer.highestOneBit(size - 1) << 1;
        this.hotEntries = new HotEntry[size];
        this.mask = size - 1;
        this.coldEntries = new ConcurrentHashMap<Object, WeakReferenceWrap<T>>(size);
        WeakReferenceHashConsingMap.cleanup(demoteAfterSeconds, this.hotEntries, this.coldEntries, this.queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void cleanup(int demoteAfterSeconds, @Nullable HotEntry<T>[] hotEntries, Map<Object, WeakReferenceWrap<T>> coldEntries, ReferenceQueue<T> queue) {
        try {
            int now = SecondsTicker.current();
            for (int i = 0; i < hotEntries.length; ++i) {
                HotEntry<T> entry = hotEntries[i];
                if (entry == null || now - entry.lastUsed < demoteAfterSeconds) continue;
                hotEntries[i] = null;
            }
            ArrayList<WeakReferenceWrap> toCleanup = new ArrayList<WeakReferenceWrap>();
            ReferenceQueue referenceQueue = queue;
            synchronized (referenceQueue) {
                Reference<T> cleared;
                while ((cleared = queue.poll()) != null) {
                    if (!(cleared instanceof WeakReferenceWrap)) continue;
                    toCleanup.add((WeakReferenceWrap)cleared);
                }
            }
            toCleanup.forEach(coldEntries::remove);
        }
        finally {
            CompletableFuture.delayedExecutor(Math.max(1, demoteAfterSeconds / 10), TimeUnit.SECONDS).execute(() -> WeakReferenceHashConsingMap.cleanup(demoteAfterSeconds, hotEntries, coldEntries, queue));
        }
    }

    private static int improve(int hash) {
        hash ^= hash >>> 15;
        hash *= -2048144777;
        hash ^= hash >>> 13;
        return (hash *= -1028477379) ^ hash >>> 16;
    }

    @Override
    public T get(T key) {
        T result;
        HotEntry<T>[] hotEntries = this.hotEntries;
        int hash = key.hashCode();
        int hotIndex = WeakReferenceHashConsingMap.improve(hash) & this.mask;
        HotEntry<T> hotEntry = hotEntries[hotIndex];
        if (hotEntry != null && hotEntry.hash == hash && hotEntry.value.equals(key)) {
            hotEntry.lastUsed = SecondsTicker.current();
            return hotEntry.value;
        }
        WeakReferenceWrap<T> fastGet = this.coldEntries.get(new LookupKey<T>(key, hash));
        T t = result = fastGet == null ? null : (T)fastGet.get();
        if (result == null) {
            WeakReferenceWrap<T> keyWrapped = new WeakReferenceWrap<T>(key, hash, this.queue);
            while (result == null) {
                WeakReferenceWrap<T> winRace = this.coldEntries.putIfAbsent(keyWrapped, keyWrapped);
                result = winRace == null ? key : winRace.get();
            }
        }
        hotEntries[hotIndex] = new HotEntry<Object>(result, hash);
        return result;
    }

    private static class LookupKey<T> {
        private final T value;
        private final int hash;

        LookupKey(T value, int hash) {
            this.value = value;
            this.hash = hash;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof WeakReferenceWrap) {
                WeakReferenceWrap actual = (WeakReferenceWrap)obj;
                return actual.hash == this.hash && this.value.equals(actual.get());
            }
            return false;
        }
    }

    private static class HotEntry<T> {
        private final T value;
        private final int hash;
        private volatile int lastUsed;

        HotEntry(T value, int hash) {
            this.value = value;
            this.hash = hash;
            this.lastUsed = SecondsTicker.current();
        }
    }

    private static class WeakReferenceWrap<T>
    extends WeakReference<T> {
        private final int hash;

        public WeakReferenceWrap(T referent, int hash, ReferenceQueue<? super T> cleared) {
            super(referent, cleared);
            this.hash = hash;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof WeakReferenceWrap) {
                WeakReferenceWrap wrappedObj = (WeakReferenceWrap)obj;
                if (wrappedObj.hash == this.hash) {
                    Object self = super.get();
                    if (self == null) {
                        return false;
                    }
                    Object other = wrappedObj.get();
                    return other != null && self.equals(other);
                }
            }
            return false;
        }
    }
}

