/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang;

import io.usethesource.vallang.IRelation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWriter;
import io.usethesource.vallang.type.Type;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface ICollection<T extends ICollection<T>>
extends IValue,
Iterable<IValue> {
    default public Type getElementType() {
        return this.getType().getElementType();
    }

    public boolean isEmpty();

    default public T empty() {
        return this.writer().done();
    }

    public IWriter<T> writer();

    public int size();

    public IRelation<T> asRelation();

    default public boolean isRelation() {
        return this.getElementType().isFixedWidth();
    }

    default public T product(T that) {
        IWriter<T> w = this.writer();
        if (that.isEmpty()) {
            return that;
        }
        for (IValue t1 : this) {
            for (IValue t2 : that) {
                w.appendTuple(t1, t2);
            }
        }
        return w.done();
    }

    default public T union(T that) {
        IWriter<T> w = this.writer().unique();
        w.appendAll(this);
        w.appendAll((Iterable<IValue>)that);
        return w.done();
    }

    default public Stream<IValue> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }
}

