/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang;

import io.usethesource.vallang.ICollection;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IRelation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWriter;
import io.usethesource.vallang.visitors.IValueVisitor;
import java.util.Iterator;
import java.util.Random;
import org.checkerframework.checker.interning.qual.EqualsMethod;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface IList
extends ICollection<IList> {
    @Override
    default public int getMatchFingerprint() {
        return 3322014;
    }

    @Override
    default public int size() {
        return this.length();
    }

    public int length();

    default public IList reverse() {
        IListWriter w = this.writer();
        for (IValue e : this) {
            w.insert(e);
        }
        return (IList)w.done();
    }

    default public IList shuffle(Random rand) {
        IListWriter w = this.writer();
        w.appendAll(this);
        for (int i = this.length() - 1; i >= 1; --i) {
            w.replaceAt(i, w.replaceAt(rand.nextInt(i + 1), w.get(i)));
        }
        return (IList)w.done();
    }

    public IListWriter writer();

    default public IList append(IValue e) {
        IListWriter w = this.writer();
        w.appendAll(this);
        w.append(e);
        return (IList)w.done();
    }

    default public IList insert(IValue e) {
        IListWriter w = this.writer();
        w.appendAll(this);
        w.insert(e);
        return (IList)w.done();
    }

    default public IList concat(IList o) {
        IListWriter w = this.writer();
        w.appendAll(this);
        w.appendAll(o);
        return (IList)w.done();
    }

    default public IList put(int i, IValue e) {
        IListWriter w = this.writer();
        w.appendAll(this);
        w.replaceAt(i, e);
        return (IList)w.done();
    }

    default public IList replace(int first, int second, int end, IList repl) {
        IListWriter result = this.writer();
        int rlen = repl.length();
        int increment = Math.abs(second - first);
        if (first < end) {
            int listIndex = 0;
            while (listIndex < first) {
                result.append(this.get(listIndex++));
            }
            int replIndex = 0;
            boolean wrapped = false;
            while (listIndex < end) {
                result.append(repl.get(replIndex++));
                if (replIndex == rlen) {
                    replIndex = 0;
                    wrapped = true;
                }
                ++listIndex;
                for (int j = 1; j < increment && listIndex < end; ++j) {
                    result.append(this.get(listIndex++));
                }
            }
            if (!wrapped) {
                while (replIndex < rlen) {
                    result.append(repl.get(replIndex++));
                }
            }
            int dlen = this.length();
            while (listIndex < dlen) {
                result.append(this.get(listIndex++));
            }
        } else {
            int listIndex = this.length() - 1;
            while (listIndex > first) {
                result.insert(this.get(listIndex--));
            }
            int replIndex = 0;
            boolean wrapped = false;
            while (listIndex > end) {
                result.insert(repl.get(replIndex++));
                if (replIndex == repl.length()) {
                    replIndex = 0;
                    wrapped = true;
                }
                --listIndex;
                for (int j = 1; j < increment && listIndex > end; ++j) {
                    result.insert(this.get(listIndex--));
                }
            }
            if (!wrapped) {
                while (replIndex < rlen) {
                    result.insert(repl.get(replIndex++));
                }
            }
            while (listIndex >= 0) {
                result.insert(this.get(listIndex--));
            }
        }
        return (IList)result.done();
    }

    public IValue get(int var1) throws IndexOutOfBoundsException;

    default public IList sublist(int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        IListWriter w = this.writer();
        for (int i = offset; i < offset + length; ++i) {
            w.append(this.get(i));
        }
        return (IList)w.done();
    }

    @Override
    public boolean isEmpty();

    default public boolean contains(IValue e) {
        for (IValue v : this) {
            if (!v.equals(e)) continue;
            return true;
        }
        return false;
    }

    default public IList delete(IValue v) {
        IListWriter w = this.writer();
        boolean deleted = false;
        for (IValue e : this) {
            if (!deleted && e.equals(v)) {
                deleted = true;
                continue;
            }
            w.append(e);
        }
        return (IList)w.done();
    }

    default public IList delete(int index) {
        IListWriter w = this.writer();
        int currentIndex = 0;
        boolean deleted = false;
        for (IValue e : this) {
            if (!deleted && index == currentIndex) {
                deleted = true;
            } else {
                w.append(e);
            }
            ++currentIndex;
        }
        return (IList)w.done();
    }

    @Override
    default public IList product(IList l) {
        IListWriter w = this.writer();
        for (IValue t1 : this) {
            for (IValue t2 : l) {
                w.appendTuple(t1, t2);
            }
        }
        return (IList)w.done();
    }

    default public IList intersect(IList l) {
        IListWriter w = this.writer();
        for (IValue v : this) {
            if (!l.contains(v)) continue;
            w.append(v);
        }
        return (IList)w.done();
    }

    default public IList subtract(IList l) {
        IListWriter w = this.writer();
        for (IValue v : this) {
            if (l.contains(v)) {
                l = l.delete(v);
                continue;
            }
            w.append(v);
        }
        return (IList)w.done();
    }

    @Override
    default public boolean match(IValue other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof IList) {
            IList list2 = (IList)other;
            if (this.length() == list2.length()) {
                Iterator it1 = this.iterator();
                Iterator it2 = list2.iterator();
                while (it1.hasNext() && it2.hasNext()) {
                    if (((IValue)it1.next()).match((IValue)it2.next())) continue;
                    return false;
                }
                if (!2.$assertionsDisabled && (it1.hasNext() || it2.hasNext())) {
                    throw new AssertionError();
                }
                return true;
            }
        }
        return false;
    }

    default public boolean isSubListOf(IList l) {
        int j = 0;
        block0: for (IValue elm : this) {
            while (j < l.length()) {
                if (elm.equals(l.get(j))) {
                    ++j;
                    continue block0;
                }
                ++j;
            }
            return false;
        }
        return true;
    }

    @EqualsMethod
    default public boolean defaultEquals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof IList) {
            IList list2 = (IList)other;
            if (this.isEmpty() && list2.isEmpty()) {
                return true;
            }
            if (this.getType() != list2.getType()) {
                return false;
            }
            if (this.hashCode() != list2.hashCode()) {
                return false;
            }
            if (this.length() == list2.length()) {
                Iterator it1 = this.iterator();
                Iterator it2 = list2.iterator();
                while (it1.hasNext() && it2.hasNext()) {
                    if (((IValue)it1.next()).equals(it2.next())) continue;
                    return false;
                }
                if (!2.$assertionsDisabled && (it1.hasNext() || it2.hasNext())) {
                    throw new AssertionError();
                }
                return true;
            }
        }
        return false;
    }

    default public int defaultHashCode() {
        int hash = 0;
        for (IValue element : this) {
            hash = hash << 1 ^ element.hashCode();
        }
        return hash;
    }

    @Override
    default public <T, E extends Throwable> T accept(IValueVisitor<T, E> v) throws E {
        return v.visitList(this);
    }

    @Override
    default public IRelation<IList> asRelation() {
        if (!this.getType().isListRelation()) {
            throw new UnsupportedOperationException(String.valueOf(this.getType()) + " is not a relation");
        }
        return new IRelation<IList>(){

            public String toString() {
                return IList.this.toString();
            }

            @Override
            public IList asContainer() {
                return IList.this;
            }

            @Override
            public IWriter<IList> writer() {
                return IList.this.writer();
            }
        };
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
    }
}

