/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.persistent;

import io.usethesource.capsule.Set;
import io.usethesource.capsule.SetMultimap;
import io.usethesource.capsule.core.PersistentTrieSetMultimap;
import io.usethesource.capsule.util.ArrayUtilsInt;
import io.usethesource.capsule.util.stream.CapsuleCollectors;
import io.usethesource.vallang.IRelation;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.impl.persistent.EmptySet;
import io.usethesource.vallang.impl.persistent.PersistentSetFactory;
import io.usethesource.vallang.impl.persistent.SetWriter;
import io.usethesource.vallang.impl.persistent.Tuple;
import io.usethesource.vallang.impl.persistent.ValueCollectors;
import io.usethesource.vallang.impl.persistent.ValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.util.AbstractTypeBag;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PersistentHashIndexedBinaryRelation
implements ISet,
IRelation<ISet> {
    private @MonotonicNonNull Type cachedRelationType;
    private final AbstractTypeBag keyTypeBag;
    private final AbstractTypeBag valTypeBag;
    private final SetMultimap.Immutable<IValue, IValue> content;

    PersistentHashIndexedBinaryRelation(AbstractTypeBag keyTypeBag, AbstractTypeBag valTypeBag, SetMultimap.Immutable<IValue, IValue> content) {
        this.keyTypeBag = Objects.requireNonNull(keyTypeBag);
        this.valTypeBag = Objects.requireNonNull(valTypeBag);
        this.content = Objects.requireNonNull(content);
        assert (SetWriter.isTupleOfArityTwo.test(TF.tupleType(keyTypeBag.lub(), valTypeBag.lub())));
        assert (!content.isEmpty());
        assert (PersistentHashIndexedBinaryRelation.checkDynamicType(keyTypeBag, valTypeBag, content));
    }

    @Override
    public IRelation<ISet> asRelation() {
        return this;
    }

    private static final boolean checkDynamicType(AbstractTypeBag keyTypeBag, AbstractTypeBag valTypeBag, SetMultimap.Immutable<IValue, IValue> content) {
        AbstractTypeBag expectedKeyTypeBag = PersistentHashIndexedBinaryRelation.calcTypeBag(content, Map.Entry::getKey);
        AbstractTypeBag expectedValTypeBag = PersistentHashIndexedBinaryRelation.calcTypeBag(content, Map.Entry::getValue);
        boolean keyTypesEqual = expectedKeyTypeBag.equals(keyTypeBag);
        boolean valTypesEqual = expectedValTypeBag.equals(valTypeBag);
        return keyTypesEqual && valTypesEqual;
    }

    public ISetWriter writer() {
        return ValueFactory.getInstance().setWriter();
    }

    @Override
    public Type getType() {
        if (this.cachedRelationType == null) {
            this.cachedRelationType = TF.relType(this.keyTypeBag.lub(), this.valTypeBag.lub());
        }
        return this.cachedRelationType;
    }

    private final <K extends IValue, V extends IValue> BiFunction<IValue, IValue, ITuple> tupleConverter() {
        return (first, second) -> Tuple.newTuple(first, second);
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    @Override
    public ISet insert(IValue value) {
        IValue val;
        if (!SetWriter.isTupleOfArityTwo.test(value.getType())) {
            Stream tupleStream = this.content.tupleStream(this.tupleConverter());
            return Stream.concat(tupleStream, Stream.of(value)).collect(ValueCollectors.toSet());
        }
        ITuple tuple = (ITuple)value;
        IValue key = tuple.get(0);
        SetMultimap.Immutable contentNew = this.content.__insert((Object)key, (Object)(val = tuple.get(1)));
        if (this.content == contentNew) {
            return this;
        }
        AbstractTypeBag keyTypeBagNew = this.keyTypeBag.increase(key.getType());
        AbstractTypeBag valTypeBagNew = this.valTypeBag.increase(val.getType());
        return PersistentSetFactory.from(keyTypeBagNew, valTypeBagNew, (SetMultimap.Immutable<IValue, IValue>)contentNew);
    }

    @Override
    public ISet delete(IValue value) {
        IValue val;
        if (!SetWriter.isTupleOfArityTwo.test(value.getType())) {
            return this;
        }
        ITuple tuple = (ITuple)value;
        IValue key = tuple.get(0);
        SetMultimap.Immutable contentNew = this.content.__remove((Object)key, (Object)(val = tuple.get(1)));
        if (this.content == contentNew) {
            return this;
        }
        AbstractTypeBag keyTypeBagNew = this.keyTypeBag.decrease(key.getType());
        AbstractTypeBag valTypeBagNew = this.valTypeBag.decrease(val.getType());
        return PersistentSetFactory.from(keyTypeBagNew, valTypeBagNew, (SetMultimap.Immutable<IValue, IValue>)contentNew);
    }

    @Override
    public int size() {
        return this.content.size();
    }

    @Override
    public boolean contains(IValue value) {
        if (!SetWriter.isTupleOfArityTwo.test(value.getType())) {
            return false;
        }
        ITuple tuple = (ITuple)value;
        IValue key = tuple.get(0);
        IValue val = tuple.get(1);
        return this.content.containsEntry((Object)key, (Object)val);
    }

    @Override
    public Iterator<IValue> iterator() {
        return this.content.tupleIterator((xva$0, xva$1) -> Tuple.newTuple(xva$0, xva$1));
    }

    public int hashCode() {
        int hashCode = StreamSupport.stream(this.spliterator(), false).mapToInt(tuple -> tuple.hashCode()).sum();
        return hashCode;
    }

    @Override
    public String toString() {
        return this.defaultToString();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof PersistentHashIndexedBinaryRelation) {
            PersistentHashIndexedBinaryRelation that = (PersistentHashIndexedBinaryRelation)other;
            if (this.getType() != that.getType()) {
                return false;
            }
            if (this.size() != that.size()) {
                return false;
            }
            return this.content.equals(that.content);
        }
        if (other instanceof ISet) {
            return this.defaultEquals(other);
        }
        return false;
    }

    @Override
    public ISet union(ISet other) {
        if (other == this) {
            return this;
        }
        if (other == null) {
            return this;
        }
        if (other instanceof PersistentHashIndexedBinaryRelation) {
            SetMultimap.Immutable<IValue, IValue> two;
            AbstractTypeBag valTypeBagNew;
            AbstractTypeBag keyTypeBagNew;
            SetMultimap.Immutable<IValue, IValue> one;
            PersistentHashIndexedBinaryRelation def;
            PersistentHashIndexedBinaryRelation that = (PersistentHashIndexedBinaryRelation)other;
            if (that.size() >= this.size()) {
                def = that;
                one = that.content;
                keyTypeBagNew = that.keyTypeBag;
                valTypeBagNew = that.valTypeBag;
                two = this.content;
            } else {
                def = this;
                one = this.content;
                keyTypeBagNew = this.keyTypeBag;
                valTypeBagNew = this.valTypeBag;
                two = that.content;
            }
            SetMultimap.Transient tmp = one.asTransient();
            boolean modified = false;
            for (Map.Entry entry : two.entrySet()) {
                IValue val;
                IValue key = (IValue)entry.getKey();
                if (!tmp.__insert((Object)key, (Object)(val = (IValue)entry.getValue()))) continue;
                modified = true;
                keyTypeBagNew = keyTypeBagNew.increase(key.getType());
                valTypeBagNew = valTypeBagNew.increase(val.getType());
            }
            if (modified) {
                return PersistentSetFactory.from(keyTypeBagNew, valTypeBagNew, (SetMultimap.Immutable<IValue, IValue>)tmp.freeze());
            }
            return def;
        }
        return ISet.super.union(other);
    }

    @Override
    public ISet intersect(ISet other) {
        if (other == this) {
            return this;
        }
        if (other == null) {
            return EmptySet.EMPTY_SET;
        }
        if (other instanceof PersistentHashIndexedBinaryRelation) {
            SetMultimap.Immutable<IValue, IValue> two;
            AbstractTypeBag valTypeBagNew;
            AbstractTypeBag keyTypeBagNew;
            SetMultimap.Immutable<IValue, IValue> one;
            PersistentHashIndexedBinaryRelation def;
            PersistentHashIndexedBinaryRelation that = (PersistentHashIndexedBinaryRelation)other;
            if (that.size() >= this.size()) {
                def = this;
                one = this.content;
                keyTypeBagNew = this.keyTypeBag;
                valTypeBagNew = this.valTypeBag;
                two = that.content;
            } else {
                def = that;
                one = that.content;
                keyTypeBagNew = that.keyTypeBag;
                valTypeBagNew = that.valTypeBag;
                two = this.content;
            }
            SetMultimap.Transient tmp = one.asTransient();
            boolean modified = false;
            Iterator it = tmp.entryIterator();
            while (it.hasNext()) {
                IValue val;
                Map.Entry tuple = (Map.Entry)it.next();
                IValue key = (IValue)tuple.getKey();
                if (two.containsEntry((Object)key, (Object)(val = (IValue)tuple.getValue()))) continue;
                it.remove();
                modified = true;
                keyTypeBagNew = keyTypeBagNew.decrease(key.getType());
                valTypeBagNew = valTypeBagNew.decrease(val.getType());
            }
            if (modified) {
                return PersistentSetFactory.from(keyTypeBagNew, valTypeBagNew, (SetMultimap.Immutable<IValue, IValue>)tmp.freeze());
            }
            return def;
        }
        return ISet.super.intersect(other);
    }

    @Override
    public ISet subtract(ISet other) {
        if (other == this) {
            return EmptySet.EMPTY_SET;
        }
        if (other == null) {
            return this;
        }
        if (other instanceof PersistentHashIndexedBinaryRelation) {
            PersistentHashIndexedBinaryRelation that = (PersistentHashIndexedBinaryRelation)other;
            PersistentHashIndexedBinaryRelation def = this;
            SetMultimap.Immutable<IValue, IValue> one = this.content;
            AbstractTypeBag keyTypeBagNew = this.keyTypeBag;
            AbstractTypeBag valTypeBagNew = this.valTypeBag;
            SetMultimap.Immutable<IValue, IValue> two = that.content;
            SetMultimap.Transient tmp = one.asTransient();
            boolean modified = false;
            for (Map.Entry tuple : two.entrySet()) {
                IValue val;
                IValue key = (IValue)tuple.getKey();
                if (!tmp.__remove((Object)key, (Object)(val = (IValue)tuple.getValue()))) continue;
                modified = true;
                keyTypeBagNew = keyTypeBagNew.decrease(key.getType());
                valTypeBagNew = valTypeBagNew.decrease(val.getType());
            }
            if (modified) {
                return PersistentSetFactory.from(keyTypeBagNew, valTypeBagNew, (SetMultimap.Immutable<IValue, IValue>)tmp.freeze());
            }
            return def;
        }
        return ISet.super.subtract(other);
    }

    @Override
    public ISet compose(IRelation<ISet> otherSetRelation) {
        if (otherSetRelation.getClass() != this.getClass()) {
            return IRelation.super.compose(otherSetRelation);
        }
        PersistentHashIndexedBinaryRelation thatSet = (PersistentHashIndexedBinaryRelation)otherSetRelation.asContainer();
        SetMultimap.Immutable<IValue, IValue> xy = this.content;
        SetMultimap.Immutable<IValue, IValue> yz = thatSet.content;
        SetMultimap.Transient xz = xy.asTransient();
        for (IValue x : xy.keySet()) {
            Set.Immutable ys = xy.get((Object)x);
            Set.Immutable zs = (Set.Immutable)ys.stream().flatMap(y -> Optional.ofNullable(yz.get(y)).orElseGet(Set.Immutable::of).stream()).collect(CapsuleCollectors.toSet());
            if (zs == null) {
                xz.__remove((Object)x);
                continue;
            }
            xz.__remove((Object)x);
            zs.forEach(z -> xz.__insert((Object)x, z));
        }
        SetMultimap.Immutable data = xz.freeze();
        AbstractTypeBag keyTypeBag = PersistentHashIndexedBinaryRelation.calcTypeBag((SetMultimap<IValue, IValue>)data, Map.Entry::getKey);
        AbstractTypeBag valTypeBag = PersistentHashIndexedBinaryRelation.calcTypeBag((SetMultimap<IValue, IValue>)data, Map.Entry::getValue);
        return PersistentSetFactory.from(keyTypeBag, valTypeBag, (SetMultimap.Immutable<IValue, IValue>)data);
    }

    @Override
    public int arity() {
        return 2;
    }

    @Override
    public ISet project(int ... fieldIndexes) {
        if (Arrays.equals(fieldIndexes, ArrayUtilsInt.arrayOfInt((int[])new int[]{0}))) {
            return this.domain();
        }
        if (Arrays.equals(fieldIndexes, ArrayUtilsInt.arrayOfInt((int[])new int[]{1}))) {
            return this.range();
        }
        if (Arrays.equals(fieldIndexes, ArrayUtilsInt.arrayOfInt((int[])new int[]{0, 1}))) {
            return this;
        }
        if (Arrays.equals(fieldIndexes, ArrayUtilsInt.arrayOfInt((int[])new int[]{1, 0}))) {
            return PersistentSetFactory.from(this.valTypeBag, this.keyTypeBag, (SetMultimap.Immutable<IValue, IValue>)this.content.inverseMap());
        }
        throw new IllegalStateException("Binary relation patterns exhausted.");
    }

    @Override
    public ISet domain() {
        Type fieldType0 = this.getType().getFieldType(0);
        if (SetWriter.isTupleOfArityTwo.test(fieldType0)) {
            return this.content.keySet().stream().map(SetWriter.asInstanceOf(ITuple.class)).collect(ValueCollectors.toSetMultimap(tuple -> tuple.get(0), tuple -> tuple.get(1)));
        }
        return this.content.keySet().stream().collect(ValueCollectors.toSet());
    }

    @Override
    public ISet range() {
        return this.content.values().stream().collect(ValueCollectors.toSet());
    }

    @Override
    public ISet index(IValue key) {
        Set.Immutable values = this.content.get((Object)key);
        if (values == null) {
            return EmptySet.EMPTY_SET;
        }
        return PersistentSetFactory.from((Set.Immutable<IValue>)values);
    }

    @Override
    public ISet asContainer() {
        return this;
    }

    @Override
    public Type getElementType() {
        return ISet.super.getElementType();
    }

    @Override
    public ISet empty() {
        return (ISet)ISet.super.empty();
    }

    private static AbstractTypeBag calcTypeBag(SetMultimap<IValue, IValue> contents, Function<Map.Entry<IValue, IValue>, IValue> mapper) {
        return contents.entrySet().stream().map(mapper).map(IValue::getType).collect(AbstractTypeBag.toTypeBag());
    }

    @Override
    public ISet closure() {
        AbstractTypeBag valTypeBag;
        AbstractTypeBag keyTypeBag;
        Type valueType;
        Type tupleType = this.getElementType();
        assert (tupleType.getArity() == 2);
        Type keyType = tupleType.getFieldType(0);
        if (!keyType.comparable(valueType = tupleType.getFieldType(1))) {
            return this;
        }
        SetMultimap.Transient<IValue, IValue> result = PersistentHashIndexedBinaryRelation.computeClosure(this.content);
        if (keyType == valueType && this.isConcreteValueType(keyType)) {
            valTypeBag = keyTypeBag = AbstractTypeBag.of(keyType, result.size());
        } else {
            keyTypeBag = PersistentHashIndexedBinaryRelation.calcTypeBag(result, Map.Entry::getKey);
            valTypeBag = PersistentHashIndexedBinaryRelation.calcTypeBag(result, Map.Entry::getValue);
        }
        return PersistentSetFactory.from(keyTypeBag, valTypeBag, (SetMultimap.Immutable<IValue, IValue>)result.freeze());
    }

    private boolean isConcreteValueType(Type keyType) {
        return keyType.isSourceLocation() || keyType.isInteger() || keyType.isRational() || keyType.isReal() || keyType.isDateTime() || keyType.isAbstractData() && !keyType.isParameterized() || keyType.isString() || keyType.isBool();
    }

    @Override
    public ISet closureStar() {
        AbstractTypeBag valTypeBag;
        AbstractTypeBag keyTypeBag;
        Type tupleType = this.getElementType();
        assert (tupleType.getArity() == 2);
        Type keyType = tupleType.getFieldType(0);
        Type valueType = tupleType.getFieldType(1);
        SetMultimap.Transient<IValue, IValue> result = PersistentHashIndexedBinaryRelation.computeClosure(this.content);
        for (Map.Entry carrier : this.content.entrySet()) {
            result.__insert((Object)((IValue)carrier.getKey()), (Object)((IValue)carrier.getKey()));
            result.__insert((Object)((IValue)carrier.getValue()), (Object)((IValue)carrier.getValue()));
        }
        if (keyType == valueType && this.isConcreteValueType(keyType)) {
            valTypeBag = keyTypeBag = AbstractTypeBag.of(keyType, result.size());
        } else {
            keyTypeBag = PersistentHashIndexedBinaryRelation.calcTypeBag(result, Map.Entry::getKey);
            valTypeBag = PersistentHashIndexedBinaryRelation.calcTypeBag(result, Map.Entry::getValue);
        }
        return PersistentSetFactory.from(keyTypeBag, valTypeBag, (SetMultimap.Immutable<IValue, IValue>)result.freeze());
    }

    private static SetMultimap.Transient<IValue, IValue> computeClosure(SetMultimap.Immutable<IValue, IValue> content) {
        return content.size() > 256 ? PersistentHashIndexedBinaryRelation.computeClosureDepthFirst(content) : PersistentHashIndexedBinaryRelation.computeClosureBreadthFirst(content);
    }

    private static SetMultimap.Transient<IValue, IValue> computeClosureDepthFirst(SetMultimap.Immutable<IValue, IValue> content) {
        SetMultimap.Transient result = content.asTransient();
        ArrayDeque<IValue> todo = new ArrayDeque<IValue>();
        HashSet<IValue> done = new HashSet<IValue>();
        Iterator mainIt = content.nativeEntryIterator();
        while (mainIt.hasNext()) {
            IValue rhs;
            Map.Entry focus = (Map.Entry)mainIt.next();
            IValue lhs = (IValue)focus.getKey();
            Object values = focus.getValue();
            assert (todo.isEmpty());
            if (values instanceof IValue) {
                todo.push((IValue)values);
            } else if (values instanceof Set) {
                todo.addAll((Collection<IValue>)((Set)values));
            } else {
                throw new IllegalArgumentException("Unexpected map entry");
            }
            done.add(lhs);
            while ((rhs = (IValue)todo.poll()) != null) {
                if (lhs == rhs) continue;
                boolean rhsDone = done.contains(rhs);
                for (IValue composed : result.get((Object)rhs)) {
                    if (!result.__insert((Object)lhs, (Object)composed) || rhsDone) continue;
                    todo.push(composed);
                }
            }
        }
        return result;
    }

    private static SetMultimap.Transient<IValue, IValue> computeClosureBreadthFirst(SetMultimap.Immutable<IValue, IValue> content) {
        SetMultimap.Transient result = content.asTransient();
        SetMultimap.Immutable todo = content.inverseMap();
        while (!todo.isEmpty()) {
            SetMultimap.Transient nextTodo = PersistentTrieSetMultimap.transientOf();
            Iterator todoIt = todo.nativeEntryIterator();
            while (todoIt.hasNext()) {
                Map.Entry next = (Map.Entry)todoIt.next();
                IValue lhs = (IValue)next.getKey();
                Set.Immutable values = content.get((Object)lhs);
                if (values.isEmpty()) continue;
                Object keys = next.getValue();
                if (keys instanceof IValue) {
                    PersistentHashIndexedBinaryRelation.singleCompose((SetMultimap.Transient<IValue, IValue>)result, (SetMultimap.Transient<IValue, IValue>)nextTodo, (Set.Immutable<IValue>)values, (IValue)keys);
                    continue;
                }
                if (keys instanceof Set) {
                    for (IValue key : (Set)keys) {
                        PersistentHashIndexedBinaryRelation.singleCompose((SetMultimap.Transient<IValue, IValue>)result, (SetMultimap.Transient<IValue, IValue>)nextTodo, (Set.Immutable<IValue>)values, key);
                    }
                    continue;
                }
                throw new IllegalArgumentException("Unexpected map entry");
            }
            todo = nextTodo;
        }
        return result;
    }

    private static void singleCompose(SetMultimap.Transient<IValue, IValue> result, SetMultimap.Transient<IValue, IValue> nextTodo, Set.Immutable<IValue> values, IValue key) {
        for (IValue val : values) {
            if (!result.__insert((Object)key, (Object)val)) continue;
            nextTodo.__insert((Object)val, (Object)key);
        }
    }
}

