/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.primitive;

import com.github.benmanes.caffeine.cache.Interner;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;

class SourceLocationURIValues {
    private static final Pattern doubleSlashes = Pattern.compile("//+");
    private static final Interner<String> INTERNED_SCHEMES = Interner.newStrongInterner();
    private static final Pattern squareBrackets = Pattern.compile("(\\[|\\])");
    private static final Pattern squareBracketOpenPlaceholder = Pattern.compile("%00%00%EF%BF%B0%00%00");
    private static final Pattern squareBracketClosePlaceholder = Pattern.compile("%00%00%EF%BF%B1%00%00");
    private static final Pattern squareBracketOpen = Pattern.compile("\\[");
    private static final Pattern squareBracketClose = Pattern.compile("\\]");
    private static final Interner<String> INTERNED_AUTHORIES = Interner.newStrongInterner();

    SourceLocationURIValues() {
    }

    static ISourceLocation newURI(@Nullable String scheme, @Nullable String authority, @Nullable String path, @Nullable String query, @Nullable String fragment) throws URISyntaxException {
        scheme = SourceLocationURIValues.nullifyIfEmpty(scheme);
        authority = SourceLocationURIValues.nullifyIfEmpty(authority);
        if (path != null) {
            if (((String)path).isEmpty() || ((String)path).equals("/")) {
                path = null;
            } else if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            if (path != null && ((String)(path = doubleSlashes.matcher((CharSequence)path).replaceAll("/"))).equals("/")) {
                path = null;
            }
        }
        query = SourceLocationURIValues.nullifyIfEmpty(query);
        fragment = SourceLocationURIValues.nullifyIfEmpty(fragment);
        if (scheme == null || scheme.equals("")) {
            throw new URISyntaxException("null or empty", "scheme cannot be empty or null");
        }
        if (!SourceLocationURIValues.validScheme(scheme)) {
            throw new URISyntaxException(scheme, "Scheme is not a valid scheme");
        }
        if (authority == null) {
            if (path == null) {
                if (query == null) {
                    if (fragment == null) {
                        return new BaseURI(scheme);
                    }
                    return new FragmentURI(scheme, fragment);
                }
                if (fragment == null) {
                    return new QueryURI(scheme, query);
                }
                return new FragmentQueryURI(scheme, query, fragment);
            }
            if (query == null) {
                if (fragment == null) {
                    return new PathURI(scheme, (String)path);
                }
                return new FragmentPathURI(scheme, (String)path, fragment);
            }
            if (fragment == null) {
                return new QueryPathURI(scheme, (String)path, query);
            }
            return new FragmentQueryPathURI(scheme, (String)path, query, fragment);
        }
        if (path == null) {
            if (query == null) {
                if (fragment == null) {
                    return new AuthorityURI(scheme, authority);
                }
                return new FragmentAuthorityURI(scheme, authority, fragment);
            }
            if (fragment == null) {
                return new QueryAuthorityURI(scheme, authority, query);
            }
            return new FragmentQueryAuthorityURI(scheme, authority, query, fragment);
        }
        if (query == null) {
            if (fragment == null) {
                return new PathAuthorityURI(scheme, authority, (String)path);
            }
            return new FragmentPathAuthorityURI(scheme, authority, (String)path, fragment);
        }
        if (fragment == null) {
            return new QueryPathAuthorityURI(scheme, authority, (String)path, query);
        }
        return new FragmentQueryPathAuthorityURI(scheme, authority, (String)path, query, fragment);
    }

    private static boolean validScheme(@Nullable String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        char current = s.charAt(0);
        if ('A' <= current && current <= 'Z' || 'a' <= current && current <= 'z') {
            for (int i = 1; i < s.length(); ++i) {
                current = s.charAt(i);
                if (current >= '+' && current <= 'z' && current != ',' && current != '/' && ('9' >= current || current >= 'A') && ('Z' >= current || current >= 'a')) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static @Nullable String nullifyIfEmpty(@Nullable String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        return str;
    }

    private static URI buildURIWithAuthority(String scheme, String authority, String path, String query, String fragment) {
        try {
            URI result = new URI(scheme, authority, path, query, fragment);
            return new URI(result.toASCIIString());
        }
        catch (URISyntaxException e) {
            if (authority != null && squareBrackets.matcher(authority).find()) {
                authority = SourceLocationURIValues.hideBrackets(authority);
                URI temp = SourceLocationURIValues.buildURIWithAuthority(scheme, authority, path, query, fragment);
                return SourceLocationURIValues.unhideBrackets(temp);
            }
            throw new RuntimeException("Internal state corrupted?", e);
        }
    }

    private static URI unhideBrackets(URI temp) {
        String newURI = temp.toASCIIString();
        newURI = squareBracketOpenPlaceholder.matcher(newURI).replaceAll("%5B");
        newURI = squareBracketClosePlaceholder.matcher(newURI).replaceAll("%5D");
        try {
            return new URI(newURI);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Internal state corrupted?", e);
        }
    }

    private static String hideBrackets(String authority) {
        authority = squareBracketOpen.matcher(authority).replaceAll("\u0000\u0000\ufff0\u0000\u0000");
        return squareBracketClose.matcher(authority).replaceAll("\u0000\u0000\ufff1\u0000\u0000");
    }

    private static class FragmentQueryPathAuthorityURI
    extends QueryPathAuthorityURI {
        protected final String fragment;

        public FragmentQueryPathAuthorityURI(String scheme, String authority, String path, String query, String fragment) {
            super(scheme, authority, path, query);
            this.fragment = fragment;
        }

        @Override
        public URI getURI() {
            return SourceLocationURIValues.buildURIWithAuthority(this.scheme, this.authority, this.path, this.query, this.fragment);
        }

        @Override
        public boolean hasFragment() {
            return true;
        }

        @Override
        public String getFragment() {
            return this.fragment;
        }

        @Override
        public int hashCode() {
            return this.scheme.hashCode() + this.authority.hashCode() + this.path.hashCode() + this.query.hashCode() + this.fragment.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj.getClass() == this.getClass()) {
                FragmentQueryPathAuthorityURI u = (FragmentQueryPathAuthorityURI)obj;
                return this.scheme == u.scheme && this.authority == u.authority && this.path.equals(u.path) && this.query.equals(u.query) && this.fragment.equals(u.fragment);
            }
            return false;
        }
    }

    private static class FragmentQueryPathURI
    extends QueryPathURI {
        protected final String fragment;

        public FragmentQueryPathURI(String scheme, String path, String query, String fragment) {
            super(scheme, path, query);
            this.fragment = fragment;
        }

        @Override
        public URI getURI() {
            try {
                URI result = new URI(this.scheme, "", this.path, this.query, this.fragment);
                return new URI(result.toASCIIString());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Internal state corrupted?", e);
            }
        }

        @Override
        public boolean hasFragment() {
            return true;
        }

        @Override
        public String getFragment() {
            return this.fragment;
        }

        @Override
        public int hashCode() {
            return this.scheme.hashCode() + this.path.hashCode() + this.query.hashCode() + this.fragment.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj.getClass() == this.getClass()) {
                FragmentQueryPathURI u = (FragmentQueryPathURI)obj;
                return this.scheme == u.scheme && this.path.equals(u.path) && this.query.equals(u.query) && this.fragment.equals(u.fragment);
            }
            return false;
        }
    }

    private static class FragmentQueryAuthorityURI
    extends QueryAuthorityURI {
        protected final String fragment;

        public FragmentQueryAuthorityURI(String scheme, String authority, String query, String fragment) {
            super(scheme, authority, query);
            this.fragment = fragment;
        }

        @Override
        public URI getURI() {
            return SourceLocationURIValues.buildURIWithAuthority(this.scheme, this.authority, null, this.query, this.fragment);
        }

        @Override
        public boolean hasFragment() {
            return true;
        }

        @Override
        public String getFragment() {
            return this.fragment;
        }

        @Override
        public int hashCode() {
            return this.scheme.hashCode() + this.authority.hashCode() + this.query.hashCode() + this.fragment.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj.getClass() == this.getClass()) {
                FragmentQueryAuthorityURI u = (FragmentQueryAuthorityURI)obj;
                return this.scheme == u.scheme && this.authority == u.authority && this.query.equals(u.query) && this.fragment.equals(u.fragment);
            }
            return false;
        }
    }

    private static class FragmentQueryURI
    extends QueryURI {
        protected final String fragment;

        public FragmentQueryURI(String scheme, String query, String fragment) {
            super(scheme, query);
            this.fragment = fragment;
        }

        @Override
        public URI getURI() {
            try {
                URI result = new URI(this.scheme, "", "/", this.query, this.fragment);
                return new URI(result.toASCIIString());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Internal state corrupted?", e);
            }
        }

        @Override
        public boolean hasFragment() {
            return true;
        }

        @Override
        public String getFragment() {
            return this.fragment;
        }

        @Override
        public int hashCode() {
            return this.scheme.hashCode() + this.query.hashCode() + this.fragment.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj.getClass() == this.getClass()) {
                FragmentQueryURI u = (FragmentQueryURI)obj;
                return this.scheme == u.scheme && this.query.equals(u.query) && this.fragment.equals(u.fragment);
            }
            return false;
        }
    }

    private static class FragmentPathAuthorityURI
    extends PathAuthorityURI {
        protected final String fragment;

        public FragmentPathAuthorityURI(String scheme, String authority, String path, String fragment) {
            super(scheme, authority, path);
            this.fragment = fragment;
        }

        @Override
        public URI getURI() {
            return SourceLocationURIValues.buildURIWithAuthority(this.scheme, this.authority, this.path, null, this.fragment);
        }

        @Override
        public boolean hasFragment() {
            return true;
        }

        @Override
        public String getFragment() {
            return this.fragment;
        }

        @Override
        public int hashCode() {
            return this.scheme.hashCode() + this.authority.hashCode() + this.path.hashCode() + this.fragment.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj.getClass() == this.getClass()) {
                FragmentPathAuthorityURI u = (FragmentPathAuthorityURI)obj;
                return this.scheme == u.scheme && this.authority == u.authority && this.path.equals(u.path) && this.fragment.equals(u.fragment);
            }
            return false;
        }
    }

    private static class FragmentPathURI
    extends PathURI {
        protected final String fragment;

        public FragmentPathURI(String scheme, String path, String fragment) {
            super(scheme, path);
            this.fragment = fragment;
        }

        @Override
        public URI getURI() {
            try {
                URI result = new URI(this.scheme, "", this.path, null, this.fragment);
                return new URI(result.toASCIIString());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Internal state corrupted?", e);
            }
        }

        @Override
        public boolean hasFragment() {
            return true;
        }

        @Override
        public String getFragment() {
            return this.fragment;
        }

        @Override
        public int hashCode() {
            return this.scheme.hashCode() + this.path.hashCode() + this.fragment.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj.getClass() == this.getClass()) {
                FragmentPathURI u = (FragmentPathURI)obj;
                return this.scheme == u.scheme && this.path.equals(u.path) && this.fragment.equals(u.fragment);
            }
            return false;
        }
    }

    private static class FragmentAuthorityURI
    extends AuthorityURI {
        protected final String fragment;

        public FragmentAuthorityURI(String scheme, String authority, String fragment) {
            super(scheme, authority);
            this.fragment = fragment;
        }

        @Override
        public URI getURI() {
            return SourceLocationURIValues.buildURIWithAuthority(this.scheme, this.authority, null, null, this.fragment);
        }

        @Override
        public boolean hasFragment() {
            return true;
        }

        @Override
        public String getFragment() {
            return this.fragment;
        }

        @Override
        public int hashCode() {
            return this.scheme.hashCode() + this.authority.hashCode() + this.fragment.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj.getClass() == this.getClass()) {
                FragmentAuthorityURI u = (FragmentAuthorityURI)obj;
                return this.scheme == u.scheme && this.authority == u.authority && this.fragment.equals(u.fragment);
            }
            return false;
        }
    }

    private static class FragmentURI
    extends BaseURI {
        protected final String fragment;

        public FragmentURI(String scheme, String fragment) {
            super(scheme);
            this.fragment = fragment;
        }

        @Override
        public URI getURI() {
            try {
                URI result = new URI(this.scheme, "", "/", null, this.fragment);
                return new URI(result.toASCIIString());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Internal state corrupted?", e);
            }
        }

        @Override
        public boolean hasFragment() {
            return true;
        }

        @Override
        public String getFragment() {
            return this.fragment;
        }

        @Override
        public int hashCode() {
            return this.scheme.hashCode() + this.fragment.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj.getClass() == this.getClass()) {
                FragmentURI u = (FragmentURI)obj;
                return this.scheme == u.scheme && this.fragment.equals(u.fragment);
            }
            return false;
        }
    }

    private static class QueryPathAuthorityURI
    extends PathAuthorityURI {
        protected final String query;

        public QueryPathAuthorityURI(String scheme, String authority, String path, String query) {
            super(scheme, authority, path);
            this.query = query;
        }

        @Override
        public URI getURI() {
            return SourceLocationURIValues.buildURIWithAuthority(this.scheme, this.authority, this.path, this.query, null);
        }

        @Override
        public boolean hasQuery() {
            return true;
        }

        @Override
        public String getQuery() {
            return this.query;
        }

        @Override
        public int hashCode() {
            return this.scheme.hashCode() + this.authority.hashCode() + this.path.hashCode() + this.query.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj.getClass() == this.getClass()) {
                QueryPathAuthorityURI u = (QueryPathAuthorityURI)obj;
                return this.scheme == u.scheme && this.authority == u.authority && this.path.equals(u.path) && this.query.equals(u.query);
            }
            return false;
        }
    }

    private static class QueryPathURI
    extends PathURI {
        protected final String query;

        public QueryPathURI(String scheme, String path, String query) {
            super(scheme, path);
            this.query = query;
        }

        @Override
        public URI getURI() {
            try {
                URI result = new URI(this.scheme, "", this.path, this.query, null);
                return new URI(result.toASCIIString());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Internal state corrupted?", e);
            }
        }

        @Override
        public boolean hasQuery() {
            return true;
        }

        @Override
        public String getQuery() {
            return this.query;
        }

        @Override
        public int hashCode() {
            return this.scheme.hashCode() + this.path.hashCode() + this.query.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj.getClass() == this.getClass()) {
                QueryPathURI u = (QueryPathURI)obj;
                return this.scheme == u.scheme && this.path.equals(u.path) && this.query.equals(u.query);
            }
            return false;
        }
    }

    private static class QueryAuthorityURI
    extends AuthorityURI {
        protected final String query;

        public QueryAuthorityURI(String scheme, String authority, String query) {
            super(scheme, authority);
            this.query = query;
        }

        @Override
        public URI getURI() {
            return SourceLocationURIValues.buildURIWithAuthority(this.scheme, this.authority, null, this.query, null);
        }

        @Override
        public boolean hasQuery() {
            return true;
        }

        @Override
        public String getQuery() {
            return this.query;
        }

        @Override
        public int hashCode() {
            return this.scheme.hashCode() + this.authority.hashCode() + this.query.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj.getClass() == this.getClass()) {
                QueryAuthorityURI u = (QueryAuthorityURI)obj;
                return this.scheme == u.scheme && this.authority == u.authority && this.query.equals(u.query);
            }
            return false;
        }
    }

    private static class QueryURI
    extends BaseURI {
        protected final String query;

        public QueryURI(String scheme, String query) {
            super(scheme);
            this.query = query;
        }

        @Override
        public URI getURI() {
            try {
                URI result = new URI(this.scheme, "", "/", this.query, null);
                return new URI(result.toASCIIString());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Internal state corrupted?", e);
            }
        }

        @Override
        public boolean hasQuery() {
            return true;
        }

        @Override
        public String getQuery() {
            return this.query;
        }

        @Override
        public int hashCode() {
            return this.scheme.hashCode() + this.query.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj.getClass() == this.getClass()) {
                QueryURI u = (QueryURI)obj;
                return this.scheme == u.scheme && this.query.equals(u.query);
            }
            return false;
        }
    }

    private static class PathAuthorityURI
    extends AuthorityURI {
        protected final String path;

        public PathAuthorityURI(String scheme, String authority, String path) {
            super(scheme, authority);
            this.path = path;
        }

        @Override
        public URI getURI() {
            return SourceLocationURIValues.buildURIWithAuthority(this.scheme, this.authority, this.path, null, null);
        }

        @Override
        public boolean hasPath() {
            return true;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public int hashCode() {
            return this.scheme.hashCode() + this.authority.hashCode() + this.path.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj.getClass() == this.getClass()) {
                PathAuthorityURI u = (PathAuthorityURI)obj;
                return this.scheme == u.scheme && this.authority == u.authority && this.path.equals(u.path);
            }
            return false;
        }
    }

    private static class PathURI
    extends BaseURI {
        protected final String path;
        private int hash = 0;

        public PathURI(String scheme, String path) {
            super(scheme);
            this.path = path;
        }

        @Override
        public URI getURI() {
            try {
                URI result = new URI(this.scheme, "", this.path, null, null);
                return new URI(result.toASCIIString());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Internal state corrupted?", e);
            }
        }

        @Override
        public boolean hasPath() {
            return true;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public int hashCode() {
            if (this.hash == 0) {
                this.hash = this.scheme.hashCode() + this.path.hashCode();
            }
            return this.hash;
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj.getClass() == this.getClass()) {
                PathURI u = (PathURI)obj;
                if (this.hash != 0 && u.hash != 0 && this.hash != u.hash) {
                    return false;
                }
                return this.scheme == u.scheme && this.path.equals(u.path);
            }
            return false;
        }
    }

    private static class AuthorityURI
    extends BaseURI {
        protected final String authority;

        public AuthorityURI(String scheme, String authority) {
            super(scheme);
            this.authority = (String)INTERNED_AUTHORIES.intern((Object)authority);
        }

        @Override
        public URI getURI() {
            return SourceLocationURIValues.buildURIWithAuthority(this.scheme, this.authority, null, null, null);
        }

        @Override
        public boolean hasPath() {
            return false;
        }

        @Override
        public boolean hasAuthority() {
            return true;
        }

        @Override
        public String getAuthority() {
            return this.authority;
        }

        @Override
        public int hashCode() {
            return this.scheme.hashCode() + this.authority.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj.getClass() == this.getClass()) {
                AuthorityURI u = (AuthorityURI)obj;
                return this.scheme == u.scheme && this.authority == u.authority;
            }
            return false;
        }
    }

    private static class BaseURI
    implements ISourceLocation {
        protected final String scheme;

        public BaseURI(String scheme) {
            this.scheme = (String)INTERNED_SCHEMES.intern((Object)scheme);
        }

        @Override
        public URI getURI() {
            try {
                return new URI(this.scheme, "", "/", null, null);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Internal state corrupted?", e);
            }
        }

        @Override
        public String toString() {
            return this.defaultToString();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj.getClass() == this.getClass()) {
                return this.scheme == ((BaseURI)obj).scheme;
            }
            return false;
        }

        public int hashCode() {
            return this.scheme.hashCode();
        }

        @Override
        public String getScheme() {
            return this.scheme;
        }

        @Override
        public String getAuthority() {
            return "";
        }

        @Override
        public String getPath() {
            return "/";
        }

        @Override
        public String getFragment() {
            return "";
        }

        @Override
        public String getQuery() {
            return "";
        }

        @Override
        public boolean hasAuthority() {
            return false;
        }

        @Override
        public boolean hasPath() {
            return true;
        }

        @Override
        public boolean hasFragment() {
            return false;
        }

        @Override
        public boolean hasQuery() {
            return false;
        }

        @Override
        public Type getType() {
            return TypeFactory.getInstance().sourceLocationType();
        }

        @Override
        public boolean mayHaveKeywordParameters() {
            return false;
        }

        @Override
        public int getBeginColumn() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getBeginLine() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getEndColumn() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getEndLine() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLength() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getOffset() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasLineColumn() {
            return false;
        }

        @Override
        public boolean hasOffsetLength() {
            return false;
        }

        @Override
        public ISourceLocation top() {
            return this;
        }
    }
}

