/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.reference;

import io.usethesource.capsule.util.iterator.ArrayIterator;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.Iterator;
import org.checkerframework.checker.nullness.qual.Nullable;

class Node
implements INode {
    protected static final Type VALUE_TYPE = TypeFactory.getInstance().valueType();
    protected final Type fType;
    protected final IValue[] fChildren;
    protected final String fName;
    protected int fHash = -1;

    @Override
    public Type getType() {
        return this.fType;
    }

    Node(String name, IValue[] children) {
        this.fType = TypeFactory.getInstance().nodeType();
        this.fName = name;
        this.fChildren = (IValue[])children.clone();
    }

    protected Node(String name, Type type, IValue[] children) {
        this.fType = type;
        this.fName = name;
        this.fChildren = (IValue[])children.clone();
    }

    Node(String name) {
        this(name, new IValue[0]);
    }

    protected Node(Node other, int index, IValue newChild) {
        this.fType = other.fType;
        this.fName = other.fName;
        this.fChildren = (IValue[])other.fChildren.clone();
        this.fChildren[index] = newChild;
    }

    @Override
    public INode setChildren(IValue[] childArray) {
        return new Node(this.fName, childArray);
    }

    @Override
    public int arity() {
        return this.fChildren.length;
    }

    @Override
    public IValue get(int i) throws IndexOutOfBoundsException {
        try {
            return this.fChildren[i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("Node node does not have child at pos " + i);
        }
    }

    @Override
    public Iterable<IValue> getChildren() {
        return this;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public INode set(int i, IValue newChild) throws IndexOutOfBoundsException {
        try {
            return new Node(this, i, newChild);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("Node node does not have child at pos " + i);
        }
    }

    @Override
    public Iterator<IValue> iterator() {
        return ArrayIterator.of((Object[])this.fChildren);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            Node other = (Node)obj;
            if (this.fType != other.fType) {
                return false;
            }
            if (this.fChildren.length != other.fChildren.length) {
                return false;
            }
            if (this.fName == other.fName || this.fName != null && this.fName.equals(other.fName)) {
                for (int i = 0; i < this.fChildren.length; ++i) {
                    if (this.fChildren[i].equals(other.fChildren[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return this.defaultToString();
    }

    public int computeHashCode() {
        int hash = this.fName.hashCode();
        for (int i = 0; i < this.fChildren.length; ++i) {
            hash = hash << 1 ^ hash >> 1 ^ this.fChildren[i].hashCode();
        }
        return hash;
    }

    public int hashCode() {
        if (this.fHash == -1) {
            this.fHash = this.computeHashCode();
        }
        return this.fHash;
    }
}

