/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.reference;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.impl.primitive.AbstractPrimitiveValueFactory;
import io.usethesource.vallang.impl.reference.Constructor;
import io.usethesource.vallang.impl.reference.ListWriter;
import io.usethesource.vallang.impl.reference.MapWriter;
import io.usethesource.vallang.impl.reference.Node;
import io.usethesource.vallang.impl.reference.SetWriter;
import io.usethesource.vallang.impl.reference.Tuple;
import io.usethesource.vallang.type.Type;
import java.util.Map;
import java.util.Objects;

public class ValueFactory
extends AbstractPrimitiveValueFactory {
    private static final ValueFactory sInstance = new ValueFactory();

    public static ValueFactory getInstance() {
        return sInstance;
    }

    protected ValueFactory() {
    }

    protected static void checkNull(Object ... args) {
        for (Object a : args) {
            Objects.requireNonNull(a);
        }
    }

    protected static void checkNull(Map<Object, Object> args) {
        for (Map.Entry<Object, Object> entry : args.entrySet()) {
            if (entry != null && entry.getKey() != null && entry.getValue() != null) continue;
            throw new NullPointerException();
        }
    }

    @Override
    public ISetWriter setWriter() {
        return new SetWriter();
    }

    @Override
    public ISet set(IValue ... elems) throws FactTypeUseException {
        ValueFactory.checkNull(elems);
        ISetWriter sw = this.setWriter();
        sw.insert(elems);
        return (ISet)sw.done();
    }

    @Override
    public IListWriter listWriter() {
        return new ListWriter();
    }

    @Override
    public IList list(IValue ... rest) {
        ValueFactory.checkNull(rest);
        IListWriter lw = this.listWriter();
        lw.append(rest);
        return (IList)lw.done();
    }

    @Override
    public ITuple tuple() {
        return new Tuple(new IValue[0]);
    }

    @Override
    public ITuple tuple(IValue ... args) {
        ValueFactory.checkNull(args);
        return new Tuple((IValue[])args.clone());
    }

    @Override
    public INode node(String name) {
        ValueFactory.checkNull(name);
        return new Node(name);
    }

    @Override
    public INode node(String name, IValue ... children) {
        ValueFactory.checkNull(name);
        ValueFactory.checkNull(children);
        return new Node(name, children);
    }

    @Override
    public INode node(String name, IValue[] children, Map<String, IValue> keyArgValues) throws FactTypeUseException {
        ValueFactory.checkNull(name);
        ValueFactory.checkNull(children);
        return new Node(name, (IValue[])children.clone()).asWithKeywordParameters().setParameters(keyArgValues);
    }

    @Override
    public IConstructor constructor(Type constructorType, IValue ... children) {
        ValueFactory.checkNull(constructorType);
        ValueFactory.checkNull(children);
        assert (IConstructor.assertTypeCorrectConstructorApplication(constructorType, children));
        return new Constructor(constructorType, children);
    }

    @Override
    public IConstructor constructor(Type constructorType, IValue[] children, Map<String, IValue> kwParams) {
        ValueFactory.checkNull(constructorType);
        ValueFactory.checkNull(new Object[]{kwParams});
        ValueFactory.checkNull(children);
        assert (IConstructor.assertTypeCorrectConstructorApplication(constructorType, children));
        return new Constructor(constructorType, children).asWithKeywordParameters().setParameters(kwParams);
    }

    @Override
    public IConstructor constructor(Type constructorType) {
        ValueFactory.checkNull(constructorType);
        assert (IConstructor.assertTypeCorrectConstructorApplication(constructorType, new IValue[0]));
        return new Constructor(constructorType);
    }

    @Override
    public IMapWriter mapWriter() {
        return new MapWriter();
    }

    public String toString() {
        return "VALLANG_REFERENCE_FACTORY";
    }
}

