/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.io;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IDateTime;
import io.usethesource.vallang.IExternalValue;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.IRational;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.io.IValueTextWriter;
import io.usethesource.vallang.type.TypeStore;
import io.usethesource.vallang.visitors.IValueVisitor;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class ATermWriter
implements IValueTextWriter {
    @Override
    public void write(IValue value, java.io.Writer stream) throws IOException {
        value.accept(new Writer(stream));
    }

    @Override
    public void write(IValue value, java.io.Writer stream, TypeStore typeStore) throws IOException {
        this.write(value, stream);
    }

    private static class Writer
    implements IValueVisitor<IValue, IOException> {
        private java.io.Writer stream;

        public Writer(java.io.Writer stream) {
            this.stream = stream;
        }

        private void append(String string) throws IOException {
            this.stream.write(string);
        }

        private void append(char c) throws IOException {
            this.stream.write(c);
        }

        @Override
        public IValue visitBoolean(IBool boolValue) throws IOException {
            this.append(boolValue.getStringRepresentation());
            return boolValue;
        }

        @Override
        public IValue visitConstructor(IConstructor o) throws IOException {
            return this.visitNode(o);
        }

        @Override
        public IValue visitReal(IReal o) throws IOException {
            this.append(o.getStringRepresentation());
            return o;
        }

        @Override
        public IValue visitInteger(IInteger o) throws IOException {
            this.append(o.getStringRepresentation());
            return o;
        }

        @Override
        public IValue visitRational(IRational o) throws IOException {
            this.append("rat");
            this.append('(');
            this.append(o.numerator().getStringRepresentation());
            this.append(',');
            this.append(o.denominator().getStringRepresentation());
            this.append(')');
            return o;
        }

        @Override
        public IValue visitList(IList o) throws IOException {
            this.append('[');
            Iterator listIterator = o.iterator();
            if (listIterator.hasNext()) {
                this.append(((IValue)listIterator.next()).toString());
                while (listIterator.hasNext()) {
                    this.append(',');
                    ((IValue)listIterator.next()).accept(this);
                }
            }
            this.append(']');
            return o;
        }

        @Override
        public IValue visitMap(IMap o) throws IOException {
            this.append('[');
            Iterator<Map.Entry<IValue, IValue>> mapIterator = o.entryIterator();
            if (mapIterator.hasNext()) {
                Map.Entry<IValue, IValue> entry = mapIterator.next();
                this.append('(');
                IValue key = entry.getKey();
                key.accept(this);
                this.append(',');
                entry.getValue().accept(this);
                this.append(')');
                while (mapIterator.hasNext()) {
                    entry = mapIterator.next();
                    this.append(',');
                    this.append('(');
                    key = entry.getKey();
                    this.append(',');
                    entry.getValue().accept(this);
                    this.append(')');
                }
            }
            this.append(']');
            return o;
        }

        @Override
        public IValue visitNode(INode o) throws IOException {
            String name = o.getName();
            this.append(name);
            this.append('(');
            Iterator<IValue> it = o.iterator();
            while (it.hasNext()) {
                it.next().accept(this);
                if (!it.hasNext()) continue;
                this.append(',');
            }
            this.append(')');
            if (o.asWithKeywordParameters().hasParameters()) {
                this.append("{[");
                int i = 0;
                Map<String, IValue> kwFields = o.asWithKeywordParameters().getParameters();
                for (Map.Entry<String, IValue> entry : kwFields.entrySet()) {
                    this.append("[" + entry.getKey() + ",");
                    entry.getValue().accept(this);
                    this.append("]");
                    if (++i >= kwFields.size()) continue;
                    this.append(",");
                }
                this.append("]}");
            }
            return o;
        }

        @Override
        public IValue visitSet(ISet o) throws IOException {
            this.append('[');
            Iterator setIterator = o.iterator();
            if (setIterator.hasNext()) {
                ((IValue)setIterator.next()).accept(this);
                while (setIterator.hasNext()) {
                    this.append(",");
                    ((IValue)setIterator.next()).accept(this);
                }
            }
            this.append(']');
            return o;
        }

        @Override
        public IValue visitSourceLocation(ISourceLocation o) throws IOException {
            this.append("loc(");
            this.append('\"');
            this.append(o.getURI().toString());
            this.append('\"');
            this.append("," + o.getOffset());
            this.append("," + o.getLength());
            this.append("," + o.getBeginLine());
            this.append("," + o.getBeginColumn());
            this.append("," + o.getEndLine());
            this.append("," + o.getEndColumn());
            this.append(')');
            return o;
        }

        @Override
        public IValue visitString(IString o) throws IOException {
            this.append('\"');
            this.append(o.getValue().replaceAll("\"", "\\\"").replaceAll("\n", "\\\\n"));
            this.append('\"');
            return o;
        }

        @Override
        public IValue visitTuple(ITuple o) throws IOException {
            this.append('(');
            Iterator it = o.iterator();
            if (it.hasNext()) {
                ((IValue)it.next()).accept(this);
            }
            while (it.hasNext()) {
                this.append(',');
                ((IValue)it.next()).accept(this);
            }
            this.append(')');
            return o;
        }

        @Override
        public IValue visitExternal(IExternalValue externalValue) {
            return externalValue;
        }

        @Override
        public IValue visitDateTime(IDateTime o) throws IOException {
            this.append("$");
            if (o.isDate()) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                this.append(df.format(new Date(o.getInstant())));
            } else if (o.isTime()) {
                SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSSZZZ");
                this.append("T");
                this.append(df.format(new Date(o.getInstant())));
            } else {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZZ");
                this.append(df.format(new Date(o.getInstant())));
            }
            return o;
        }
    }
}

