/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.io;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IDateTime;
import io.usethesource.vallang.IExternalValue;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.IRational;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.impl.primitive.StringValue;
import io.usethesource.vallang.io.IValueTextWriter;
import io.usethesource.vallang.type.ITypeVisitor;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeStore;
import io.usethesource.vallang.visitors.IValueVisitor;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.PrimitiveIterator;

public class StandardTextWriter
implements IValueTextWriter {
    protected final boolean indent;
    protected final int tabSize;

    public StandardTextWriter() {
        this(false);
    }

    public StandardTextWriter(boolean indent) {
        this(indent, 2);
    }

    public StandardTextWriter(boolean indent, int tabSize) {
        this.indent = indent;
        this.tabSize = tabSize;
    }

    public static String valueToString(IValue value) {
        String string;
        StringWriter stream = new StringWriter();
        try {
            new StandardTextWriter().write(value, stream);
            string = stream.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioex) {
                throw new RuntimeException("Should have never happened.", ioex);
            }
        }
        stream.close();
        return string;
    }

    @Override
    public void write(IValue value, java.io.Writer stream) throws IOException {
        try {
            value.accept(new Writer(stream, this.indent, this.tabSize));
        }
        finally {
            stream.flush();
        }
    }

    @Override
    public void write(IValue value, java.io.Writer stream, TypeStore typeStore) throws IOException {
        this.write(value, stream);
    }

    protected static class Writer
    implements IValueVisitor<IValue, IOException> {
        private final java.io.Writer stream;
        private final int tabSize;
        private final boolean indent;
        private int tab = 0;

        public Writer(java.io.Writer stream, boolean indent, int tabSize) {
            this.stream = stream;
            this.indent = indent;
            this.tabSize = tabSize;
        }

        private void append(String string) throws IOException {
            this.stream.write(string);
        }

        private void append(int cp) throws IOException {
            if (Character.isBmpCodePoint(cp)) {
                this.stream.write(cp);
            } else {
                this.stream.write(Character.highSurrogate(cp));
                this.stream.write(Character.lowSurrogate(cp));
            }
        }

        private void append(char c) throws IOException {
            this.stream.write(c);
        }

        private void tab() {
            ++this.tab;
        }

        private void untab() {
            --this.tab;
        }

        @Override
        public IValue visitBoolean(IBool boolValue) throws IOException {
            this.append(boolValue.getValue() ? "true" : "false");
            return boolValue;
        }

        @Override
        public IValue visitReal(IReal o) throws IOException {
            this.append(o.getStringRepresentation());
            return o;
        }

        @Override
        public IValue visitInteger(IInteger o) throws IOException {
            this.append(o.getStringRepresentation());
            return o;
        }

        @Override
        public IValue visitRational(IRational o) throws IOException {
            this.append(o.getStringRepresentation());
            return o;
        }

        @Override
        public IValue visitList(IList o) throws IOException {
            this.append('[');
            boolean indent = this.checkIndent(o);
            Iterator listIterator = o.iterator();
            this.tab();
            this.indent(indent);
            if (listIterator.hasNext()) {
                ((IValue)listIterator.next()).accept(this);
                while (listIterator.hasNext()) {
                    this.append(',');
                    if (indent) {
                        this.indent();
                    }
                    ((IValue)listIterator.next()).accept(this);
                }
            }
            this.untab();
            this.indent(indent);
            this.append(']');
            return o;
        }

        @Override
        public IValue visitMap(IMap o) throws IOException {
            this.append('(');
            this.tab();
            boolean indent = this.checkIndent(o);
            this.indent(indent);
            Iterator<Map.Entry<IValue, IValue>> mapIterator = o.entryIterator();
            if (mapIterator.hasNext()) {
                Map.Entry<IValue, IValue> entry = mapIterator.next();
                IValue key = entry.getKey();
                key.accept(this);
                this.append(':');
                entry.getValue().accept(this);
                while (mapIterator.hasNext()) {
                    this.append(',');
                    this.indent(indent);
                    entry = mapIterator.next();
                    key = entry.getKey();
                    key.accept(this);
                    this.append(':');
                    entry.getValue().accept(this);
                }
            }
            this.untab();
            this.indent(indent);
            this.append(')');
            return o;
        }

        @Override
        public IValue visitConstructor(IConstructor o) throws IOException {
            IWithKeywordParameters<? extends IConstructor> wkw;
            String name = o.getName();
            if (name.equals("loc")) {
                this.append('\\');
            }
            if (name.indexOf(45) != -1) {
                this.append('\\');
            }
            this.append(name);
            boolean indent = this.checkIndent(o);
            this.append('(');
            this.tab();
            this.indent(indent);
            Iterator<IValue> it = o.iterator();
            int k = 0;
            while (it.hasNext()) {
                it.next().accept(this);
                if (it.hasNext()) {
                    this.append(',');
                    this.indent(indent);
                }
                ++k;
            }
            if (o.mayHaveKeywordParameters() && (wkw = o.asWithKeywordParameters()).hasParameters()) {
                if (k > 0) {
                    this.append(',');
                    this.indent(indent);
                }
                Iterator<Map.Entry<String, IValue>> iterator = wkw.getParameters().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, IValue> e = iterator.next();
                    this.append(e.getKey());
                    this.append('=');
                    e.getValue().accept(this);
                    if (!iterator.hasNext()) continue;
                    this.append(',');
                    this.indent(indent);
                }
            }
            this.append(')');
            this.untab();
            try {
                this.stream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return o;
        }

        private void indent() throws IOException {
            this.indent(this.indent);
        }

        private void indent(boolean indent) throws IOException {
            if (indent) {
                this.append('\n');
                for (int i = 0; i < this.tabSize * this.tab; ++i) {
                    this.append(' ');
                }
            }
        }

        @Override
        public IValue visitSet(ISet o) throws IOException {
            this.append('{');
            boolean indent = this.checkIndent(o);
            this.tab();
            this.indent(indent);
            Iterator setIterator = o.iterator();
            if (setIterator.hasNext()) {
                ((IValue)setIterator.next()).accept(this);
                while (setIterator.hasNext()) {
                    this.append(",");
                    this.indent(indent);
                    ((IValue)setIterator.next()).accept(this);
                }
            }
            this.untab();
            this.indent(indent);
            this.append('}');
            return o;
        }

        private boolean checkIndent(ISet o) {
            Iterator iterator;
            if (this.indent && o.size() > 1 && (iterator = o.iterator()).hasNext()) {
                IValue x = (IValue)iterator.next();
                Type type = x.getType();
                return this.indented(type);
            }
            return false;
        }

        private boolean indented(Type type) {
            return type.accept(new ITypeVisitor<Boolean, RuntimeException>(){

                @Override
                public Boolean visitReal(Type type) {
                    return false;
                }

                @Override
                public Boolean visitInteger(Type type) {
                    return false;
                }

                @Override
                public Boolean visitRational(Type type) {
                    return false;
                }

                @Override
                public Boolean visitList(Type type) {
                    return true;
                }

                @Override
                public Boolean visitMap(Type type) {
                    return true;
                }

                @Override
                public Boolean visitNumber(Type type) {
                    return false;
                }

                @Override
                public Boolean visitAlias(Type type) {
                    return type.getAliased().accept(this);
                }

                @Override
                public Boolean visitSet(Type type) {
                    return true;
                }

                @Override
                public Boolean visitSourceLocation(Type type) {
                    return true;
                }

                @Override
                public Boolean visitString(Type type) {
                    return false;
                }

                @Override
                public Boolean visitNode(Type type) {
                    return true;
                }

                @Override
                public Boolean visitConstructor(Type type) {
                    return true;
                }

                @Override
                public Boolean visitAbstractData(Type type) {
                    return true;
                }

                @Override
                public Boolean visitTuple(Type type) {
                    return true;
                }

                @Override
                public Boolean visitValue(Type type) {
                    return false;
                }

                @Override
                public Boolean visitFunction(Type type) {
                    return false;
                }

                @Override
                public Boolean visitVoid(Type type) {
                    return false;
                }

                @Override
                public Boolean visitBool(Type type) {
                    return false;
                }

                @Override
                public Boolean visitParameter(Type type) {
                    return type.getBound().accept(this);
                }

                @Override
                public Boolean visitExternal(Type type) {
                    return false;
                }

                @Override
                public Boolean visitDateTime(Type type) {
                    return false;
                }
            });
        }

        private boolean checkIndent(IList o) {
            if (this.indent && o.length() > 1) {
                for (IValue x : o) {
                    Type type = x.getType();
                    if (!this.indented(type)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean checkIndent(INode o) {
            int kwArity;
            int n = kwArity = o.mayHaveKeywordParameters() ? o.asWithKeywordParameters().getParameters().size() : 0;
            if (this.indent && o.arity() + kwArity > 1) {
                Type type;
                for (IValue x : o) {
                    type = x.getType();
                    if (!this.indented(type)) continue;
                    return true;
                }
                if (o.mayHaveKeywordParameters()) {
                    for (IValue x : o.asWithKeywordParameters().getParameters().values()) {
                        type = x.getType();
                        if (!this.indented(type)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private boolean checkIndent(IMap o) {
            if (this.indent && o.size() > 1) {
                for (Map.Entry entry : () -> o.entryIterator()) {
                    IValue x = (IValue)entry.getKey();
                    Type type = x.getType();
                    Type vType = ((IValue)entry.getValue()).getType();
                    if (this.indented(type)) {
                        return true;
                    }
                    if (!this.indented(vType)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public IValue visitSourceLocation(ISourceLocation o) throws IOException {
            this.append('|');
            this.append(o.getURI().toString());
            this.append('|');
            if (o.hasOffsetLength()) {
                this.append('(');
                this.append(Integer.toString(o.getOffset()));
                this.append(',');
                this.append(Integer.toString(o.getLength()));
                if (o.hasLineColumn()) {
                    this.append(',');
                    this.append('<');
                    this.append(Integer.toString(o.getBeginLine()));
                    this.append(',');
                    this.append(Integer.toString(o.getBeginColumn()));
                    this.append('>');
                    this.append(',');
                    this.append('<');
                    this.append(Integer.toString(o.getEndLine()));
                    this.append(',');
                    this.append(Integer.toString(o.getEndColumn()));
                    this.append('>');
                }
                this.append(')');
            }
            return o;
        }

        @Override
        public IValue visitString(IString o) throws IOException {
            this.append('\"');
            PrimitiveIterator.OfInt it = o.iterator();
            block13: while (it.hasNext()) {
                int ch = it.nextInt();
                switch (ch) {
                    case 34: {
                        this.append('\\');
                        this.append('\"');
                        continue block13;
                    }
                    case 62: {
                        this.append('\\');
                        this.append('>');
                        continue block13;
                    }
                    case 60: {
                        this.append('\\');
                        this.append('<');
                        continue block13;
                    }
                    case 39: {
                        this.append('\\');
                        this.append('\'');
                        continue block13;
                    }
                    case 92: {
                        this.append('\\');
                        this.append('\\');
                        continue block13;
                    }
                    case 10: {
                        this.append('\\');
                        this.append('n');
                        continue block13;
                    }
                    case 13: {
                        this.append('\\');
                        this.append('r');
                        continue block13;
                    }
                    case 9: {
                        this.append('\\');
                        this.append('t');
                        continue block13;
                    }
                    case 12: {
                        this.append('\\');
                        this.append('f');
                        continue block13;
                    }
                    case 8: {
                        this.append('\\');
                        this.append('b');
                        continue block13;
                    }
                    case 32: {
                        this.append(' ');
                        continue block13;
                    }
                }
                if (Character.isSpaceChar(ch) || Character.isISOControl(ch) || Character.UnicodeBlock.SPECIALS.equals(Character.UnicodeBlock.of(ch))) {
                    if (ch <= 127) {
                        this.append("\\a" + String.format("%02x", ch));
                        continue;
                    }
                    if (ch <= 65535) {
                        this.append("\\u" + String.format("%04x", ch));
                        continue;
                    }
                    this.append("\\U" + String.format("%06x", ch));
                    continue;
                }
                this.append(ch);
            }
            this.append('\"');
            return o;
        }

        @Override
        public IValue visitTuple(ITuple o) throws IOException {
            this.append('<');
            Iterator it = o.iterator();
            if (it.hasNext()) {
                ((IValue)it.next()).accept(this);
            }
            while (it.hasNext()) {
                this.append(',');
                ((IValue)it.next()).accept(this);
            }
            this.append('>');
            return o;
        }

        @Override
        public IValue visitExternal(IExternalValue externalValue) throws IOException {
            return this.visitConstructor(externalValue.encodeAsConstructor());
        }

        @Override
        public IValue visitDateTime(IDateTime o) throws IOException {
            this.append("$");
            if (o.isDate()) {
                this.append(String.format("%04d", o.getYear()));
                this.append("-");
                this.append(String.format("%02d", o.getMonthOfYear()));
                this.append("-");
                this.append(String.format("%02d", o.getDayOfMonth()));
            } else if (o.isTime()) {
                this.append("T");
                this.append(String.format("%02d", o.getHourOfDay()));
                this.append(":");
                this.append(String.format("%02d", o.getMinuteOfHour()));
                this.append(":");
                this.append(String.format("%02d", o.getSecondOfMinute()));
                this.append(".");
                this.append(String.format("%03d", o.getMillisecondsOfSecond()));
                if (o.getTimezoneOffsetHours() < 0 || o.getTimezoneOffsetHours() == 0 && o.getTimezoneOffsetMinutes() < 0) {
                    this.append("-");
                } else {
                    this.append("+");
                }
                this.append(String.format("%02d", Math.abs(o.getTimezoneOffsetHours())));
                this.append(":");
                this.append(String.format("%02d", Math.abs(o.getTimezoneOffsetMinutes())));
            } else {
                this.append(String.format("%04d", o.getYear()));
                this.append("-");
                this.append(String.format("%02d", o.getMonthOfYear()));
                this.append("-");
                this.append(String.format("%02d", o.getDayOfMonth()));
                this.append("T");
                this.append(String.format("%02d", o.getHourOfDay()));
                this.append(":");
                this.append(String.format("%02d", o.getMinuteOfHour()));
                this.append(":");
                this.append(String.format("%02d", o.getSecondOfMinute()));
                this.append(".");
                this.append(String.format("%03d", o.getMillisecondsOfSecond()));
                if (o.getTimezoneOffsetHours() < 0 || o.getTimezoneOffsetHours() == 0 && o.getTimezoneOffsetMinutes() < 0) {
                    this.append("-");
                } else {
                    this.append("+");
                }
                this.append(String.format("%02d", Math.abs(o.getTimezoneOffsetHours())));
                this.append(":");
                this.append(String.format("%02d", Math.abs(o.getTimezoneOffsetMinutes())));
            }
            this.append("$");
            return o;
        }

        @Override
        public IValue visitNode(INode o) throws IOException {
            IWithKeywordParameters<? extends INode> wkw;
            this.visitString(StringValue.newString(o.getName()));
            boolean indent = this.checkIndent(o);
            this.append('(');
            this.tab();
            this.indent(indent);
            Iterator<IValue> it = o.iterator();
            int k = 0;
            while (it.hasNext()) {
                it.next().accept(this);
                if (it.hasNext()) {
                    this.append(',');
                    this.indent(indent);
                }
                ++k;
            }
            if (o.mayHaveKeywordParameters() && (wkw = o.asWithKeywordParameters()).hasParameters()) {
                if (k > 0) {
                    this.append(',');
                }
                Iterator<Map.Entry<String, IValue>> kwIt = wkw.getParameters().entrySet().iterator();
                while (kwIt.hasNext()) {
                    Map.Entry<String, IValue> e = kwIt.next();
                    this.indent();
                    this.append(e.getKey());
                    this.append('=');
                    e.getValue().accept(this);
                    if (!kwIt.hasNext()) continue;
                    this.append(',');
                }
            }
            this.append(')');
            this.untab();
            return o;
        }
    }
}

