/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.io.binary.util;

import com.github.luben.zstd.ZstdDirectBufferCompressingStream;
import io.usethesource.vallang.io.binary.util.ByteBufferOutputStream;
import io.usethesource.vallang.io.binary.util.DirectByteBufferCache;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class DelayedZstdOutputStream
extends ByteBufferOutputStream {
    private static final int COMPRESS_AFTER = 4096;
    private ByteBufferOutputStream out;
    private int compressHeader;
    private final int level;
    private boolean firstFlush = true;
    private @MonotonicNonNull ZstdDirectBufferCompressingStream compressor = null;

    public DelayedZstdOutputStream(ByteBufferOutputStream out, int compressHeader, int level) throws IOException {
        super(DirectByteBufferCache.getInstance().get(4096));
        if (out.target == this.target) {
            throw new RuntimeException("That shouldn't happen");
        }
        this.out = out;
        this.compressHeader = compressHeader;
        this.level = level;
    }

    @Override
    protected ByteBuffer flush(ByteBuffer toflush) throws IOException {
        if (this.out.target == this.target) {
            throw new RuntimeException("That shouldn't happen");
        }
        boolean increaseBufferForCompressor = false;
        if (this.firstFlush) {
            this.firstFlush = false;
            if (toflush.remaining() >= 4096) {
                this.out.write(this.compressHeader);
                this.compressor = new ZstdDirectBufferCompressingStream(this.out.target, this.level){

                    protected ByteBuffer flushBuffer(ByteBuffer toFlush) throws IOException {
                        DelayedZstdOutputStream.this.out.flush();
                        return DelayedZstdOutputStream.this.out.target;
                    }
                };
                increaseBufferForCompressor = true;
            } else {
                this.out.write(0);
            }
        }
        if (this.compressor != null) {
            this.compressor.compress(toflush);
        } else {
            this.out.write(toflush);
        }
        toflush.clear();
        if (increaseBufferForCompressor) {
            DirectByteBufferCache.getInstance().put(toflush);
            return DirectByteBufferCache.getInstance().getExact(ZstdDirectBufferCompressingStream.recommendedOutputBufferSize());
        }
        return toflush;
    }

    @Override
    public void close() throws IOException {
        if (this.out.target == this.target) {
            throw new RuntimeException("That shouldn't happen");
        }
        if (!this.closed) {
            try {
                try {
                    this.flush();
                    if (this.compressor != null) {
                        this.compressor.close();
                    }
                    super.close();
                }
                finally {
                    this.out.close();
                }
            }
            finally {
                DirectByteBufferCache.getInstance().put(this.target);
            }
        }
    }
}

