/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.io.binary.util;

import io.usethesource.vallang.io.binary.util.CacheFactory;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;

public class DirectByteBufferCache {
    private final CacheFactory<ByteBuffer> buffers = new CacheFactory<ByteBuffer>(3, TimeUnit.SECONDS, DirectByteBufferCache::clear);

    public static DirectByteBufferCache getInstance() {
        return InstanceHolder.sInstance;
    }

    private DirectByteBufferCache() {
    }

    private static ByteBuffer clear(ByteBuffer b) {
        b.clear();
        return b;
    }

    private static int roundSize(int size) {
        return (int)(Math.ceil((double)size / 8192.0) * 8192.0);
    }

    public ByteBuffer get(int size) {
        return this.getExact(DirectByteBufferCache.roundSize(size));
    }

    public void put(ByteBuffer returned) {
        if (returned.capacity() > 8192) {
            this.buffers.put(returned.capacity(), returned);
        }
    }

    public ByteBuffer getExact(int size) {
        return this.buffers.get(size, ByteBuffer::allocateDirect);
    }

    private static class InstanceHolder {
        static final DirectByteBufferCache sInstance = new DirectByteBufferCache();

        private InstanceHolder() {
        }
    }
}

