/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.type;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.type.AbstractDataType;
import io.usethesource.vallang.type.ITypeVisitor;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ConstructorType
extends AbstractDataType {
    private final Type fChildrenTypes;
    private final Type fADT;
    private final String fName;

    ConstructorType(String name, Type childrenTypes, Type adt) {
        super(adt.getName(), adt.getTypeParameters());
        this.fName = name.intern();
        this.fChildrenTypes = childrenTypes;
        this.fADT = adt;
    }

    @Override
    public TypeFactory.TypeReifier getTypeReifier(TypeFactory.TypeValues symbols) {
        return new Info(symbols);
    }

    @Override
    public Type carrier() {
        return this.fChildrenTypes.carrier();
    }

    @Override
    public int hashCode() {
        return 21 + 44927 * (this.fName != null ? this.fName.hashCode() : 1) + 181 * this.fChildrenTypes.hashCode() + 354767453 * this.fADT.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass().equals(this.getClass())) {
            ConstructorType other = (ConstructorType)o;
            if (this.fName != other.fName) {
                return false;
            }
            if (this.fChildrenTypes != other.fChildrenTypes) {
                return false;
            }
            return this.fADT == other.fADT;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        boolean hasNames = this.hasFieldNames();
        builder.append(this.fADT);
        builder.append(" = ");
        builder.append(this.fName);
        builder.append("(");
        for (int i = 0; i < this.getArity(); ++i) {
            Type argType = this.fChildrenTypes.getFieldType(i);
            builder.append(argType);
            if (hasNames) {
                builder.append(' ');
                builder.append(this.fChildrenTypes.getFieldName(i));
            }
            if (i >= this.getArity() - 1) continue;
            builder.append(',');
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public int getArity() {
        return this.fChildrenTypes.getArity();
    }

    @Override
    public int getFieldIndex(String fieldName) throws FactTypeUseException {
        return this.fChildrenTypes.getFieldIndex(fieldName);
    }

    @Override
    public boolean hasField(String fieldName) {
        return this.fChildrenTypes.hasField(fieldName);
    }

    @Override
    public boolean hasField(String fieldName, TypeStore store) {
        return this.hasField(fieldName);
    }

    @Override
    public boolean hasKeywordField(String fieldName, TypeStore store) {
        return store.hasKeywordParameter(this, fieldName);
    }

    @Override
    public Type getFieldTypes() {
        return this.fChildrenTypes;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public Type getAbstractDataType() {
        return this.fADT;
    }

    @Override
    public Type getFieldType(int i) {
        return this.fChildrenTypes.getFieldType(i);
    }

    @Override
    public Type getFieldType(String fieldName) throws FactTypeUseException {
        return this.fChildrenTypes.getFieldType(fieldName);
    }

    @Override
    public String getFieldName(int i) {
        return this.fChildrenTypes.getFieldName(i);
    }

    @Override
    public String[] getFieldNames() {
        return this.fChildrenTypes.getFieldNames();
    }

    @Override
    public boolean hasFieldNames() {
        return this.fChildrenTypes.hasFieldNames();
    }

    @Override
    public <T, E extends Throwable> T accept(ITypeVisitor<T, E> visitor) throws E {
        return visitor.visitConstructor(this);
    }

    @Override
    protected boolean isSupertypeOf(Type type) {
        return type.isSubtypeOfConstructor(this);
    }

    @Override
    public Type lub(Type type) {
        return type.lubWithConstructor(this);
    }

    @Override
    public Type glb(Type type) {
        return type.glbWithConstructor(this);
    }

    @Override
    protected boolean isSubtypeOfConstructor(Type type) {
        if (type.getName().equals(this.getName())) {
            return this.getAbstractDataType().isSubtypeOf(type.getAbstractDataType()) && this.getFieldTypes().isSubtypeOf(type.getFieldTypes());
        }
        return false;
    }

    @Override
    protected boolean isSubtypeOfAbstractData(Type type) {
        return this.getAbstractDataType().isSubtypeOfAbstractData(type);
    }

    @Override
    protected Type lubWithConstructor(Type type) {
        if (this == type) {
            return this;
        }
        return this.getAbstractDataType().lubWithAbstractData(type.getAbstractDataType());
    }

    @Override
    protected Type glbWithConstructor(Type type) {
        if (type.isSubtypeOf(this)) {
            return type;
        }
        if (this.isSubtypeOf(type)) {
            return this;
        }
        return TF.voidType();
    }

    @Override
    protected Type glbWithAbstractData(Type type) {
        if (this.isSubtypeOf(type)) {
            return this;
        }
        return TF.voidType();
    }

    @Override
    protected Type glbWithNode(Type type) {
        return this;
    }

    @Override
    public boolean match(Type matched, Map<Type, Type> bindings) throws FactTypeUseException {
        return super.match(matched, bindings) && this.fADT.match(matched.getAbstractDataType(), bindings) && this.getFieldTypes().match(matched.getFieldTypes(), bindings);
    }

    @Override
    public Type instantiate(Map<Type, Type> bindings) {
        if (bindings.isEmpty()) {
            return this;
        }
        Type adt = this.fADT.instantiate(bindings);
        Type fields = this.getFieldTypes().instantiate(bindings);
        TypeStore store = new TypeStore(new TypeStore[0]);
        store.declareAbstractDataType(this.fADT);
        store.declareConstructor(this);
        return TypeFactory.getInstance().constructorFromTuple(store, adt, this.getName(), fields);
    }

    @Override
    public boolean isParameterized() {
        return this.fADT.isParameterized();
    }

    @Override
    public boolean isConstructor() {
        return true;
    }

    public static class Info
    extends TypeFactory.TypeReifier {
        public Info(TypeFactory.TypeValues symbols) {
            super(symbols);
        }

        @Override
        public Type getSymbolConstructorType() {
            return this.symbols().typeSymbolConstructor("cons", this.symbols().symbolADT(), "adt", this.tf().stringType(), "name", this.tf().listType(this.symbols().symbolADT()), "parameters");
        }

        public Type getProductionConstructorType() {
            return this.symbols().typeProductionConstructor("cons", this.symbols().symbolADT(), "def", Type.TF.listType(this.symbols().symbolADT()), "symbols", Type.TF.listType(this.symbols().symbolADT()), "kwTypes", this.tf().setType(this.symbols().attrADT()), "attributes");
        }

        @Override
        public IConstructor toSymbol(Type type, IValueFactory vf, TypeStore store, ISetWriter grammar, Set<IConstructor> done) {
            IListWriter w = vf.listWriter();
            if (type.hasFieldNames()) {
                for (int i = 0; i < type.getArity(); ++i) {
                    w.append(this.symbols().labelSymbol(vf, type.getFieldType(i).asSymbol(vf, store, grammar, done), type.getFieldName(i)));
                }
            } else {
                for (Type field : type.getFieldTypes()) {
                    w.append(field.asSymbol(vf, store, grammar, done));
                }
            }
            IConstructor adt = type.getAbstractDataType().asSymbol(vf, store, grammar, done);
            IConstructor cons = vf.constructor(this.getSymbolConstructorType(), new IValue[]{adt, vf.string(type.getName()), w.done()});
            return cons;
        }

        @Override
        public Type fromSymbol(IConstructor symbol, TypeStore store, Function<IConstructor, Set<IConstructor>> grammar) {
            Type adt = this.symbols().fromSymbol((IConstructor)symbol.get("adt"), store, grammar);
            IList parameters = (IList)symbol.get("parameters");
            String name = ((IString)symbol.get("name")).getValue();
            return Type.TF.constructorFromTuple(store, adt, name, this.symbols().fromSymbols(parameters, store, grammar));
        }

        Type fromProduction(IConstructor prod, TypeStore store, Function<IConstructor, Set<IConstructor>> grammar) {
            if (prod.getConstructorType() == this.getSymbolConstructorType()) {
                return this.fromAlternativeProduction(prod, store, grammar);
            }
            IConstructor adt = (IConstructor)(prod.has("def") ? prod.get("def") : prod.get("adt"));
            String name = this.symbols().getLabel(adt);
            IConstructor sym = this.symbols().getLabeledSymbol(adt);
            IList parameters = (IList)prod.get("symbols");
            IList kwtypes = (IList)prod.get("kwTypes");
            Type cons = Type.TF.constructorFromTuple(store, this.symbols().fromSymbol(sym, store, grammar), name, this.symbols().fromSymbols(parameters, store, grammar));
            for (IValue kwType : kwtypes) {
                store.declareKeywordParameter(cons, this.symbols().getLabel(kwType), this.symbols().fromSymbol(this.symbols().getLabeledSymbol(kwType), store, grammar));
            }
            return cons;
        }

        private Type fromAlternativeProduction(IConstructor prod, TypeStore store, Function<IConstructor, Set<IConstructor>> grammar) {
            IConstructor adt = (IConstructor)prod.get("adt");
            String name = ((IString)prod.get("name")).getValue();
            IList parameters = (IList)prod.get("parameters");
            return Type.TF.constructorFromTuple(store, this.symbols().fromSymbol(adt, store, grammar), name, this.symbols().fromSymbols(parameters, store, grammar));
        }

        @Override
        public void asProductions(Type type, IValueFactory vf, TypeStore store, ISetWriter grammar, Set<IConstructor> done) {
            IConstructor adt = type.getAbstractDataType().asSymbol(vf, store, grammar, done);
            IListWriter w = vf.listWriter();
            if (type.hasFieldNames()) {
                for (int i = 0; i < type.getArity(); ++i) {
                    w.append(this.symbols().labelSymbol(vf, type.getFieldType(i).asSymbol(vf, store, grammar, done), type.getFieldName(i)));
                }
            } else {
                for (Type field : type.getFieldTypes()) {
                    w.append(field.asSymbol(vf, store, grammar, done));
                }
            }
            IListWriter kwTypes = vf.listWriter();
            Map<String, Type> keywordParameters = store.getKeywordParameters(type);
            for (String label : keywordParameters.keySet()) {
                kwTypes.insert(this.symbols().labelSymbol(vf, keywordParameters.get(label).asSymbol(vf, store, grammar, done), label));
            }
            IConstructor cons = vf.constructor(this.getProductionConstructorType(), new IValue[]{this.symbols().labelSymbol(vf, adt, type.getName()), w.done(), kwTypes.done(), vf.set(new IValue[0])});
            grammar.insert(vf.tuple(adt, cons));
        }

        @Override
        public boolean isRecursive() {
            return true;
        }

        @Override
        public Type randomInstance(BiFunction<TypeStore, TypeFactory.RandomTypesConfig, Type> next, TypeStore store, TypeFactory.RandomTypesConfig rnd) {
            return new AbstractDataType.Info(this.symbols()).randomInstance(next, store, rnd);
        }
    }
}

