/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.type;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.FactTypeDeclarationException;
import io.usethesource.vallang.exceptions.IllegalFieldNameException;
import io.usethesource.vallang.exceptions.IllegalFieldTypeException;
import io.usethesource.vallang.exceptions.IllegalIdentifierException;
import io.usethesource.vallang.exceptions.NullTypeException;
import io.usethesource.vallang.type.AbstractDataType;
import io.usethesource.vallang.type.AliasType;
import io.usethesource.vallang.type.BoolType;
import io.usethesource.vallang.type.ConstructorType;
import io.usethesource.vallang.type.DateTimeType;
import io.usethesource.vallang.type.FunctionType;
import io.usethesource.vallang.type.IntegerType;
import io.usethesource.vallang.type.ListType;
import io.usethesource.vallang.type.MapType;
import io.usethesource.vallang.type.MapTypeWithFieldNames;
import io.usethesource.vallang.type.NodeType;
import io.usethesource.vallang.type.NumberType;
import io.usethesource.vallang.type.ParameterType;
import io.usethesource.vallang.type.RationalType;
import io.usethesource.vallang.type.RealType;
import io.usethesource.vallang.type.SetType;
import io.usethesource.vallang.type.SourceLocationType;
import io.usethesource.vallang.type.StringType;
import io.usethesource.vallang.type.TupleType;
import io.usethesource.vallang.type.TupleTypeWithFieldNames;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeReader;
import io.usethesource.vallang.type.TypeStore;
import io.usethesource.vallang.type.ValueType;
import io.usethesource.vallang.type.VoidType;
import io.usethesource.vallang.util.HashConsingMap;
import io.usethesource.vallang.util.WeakReferenceHashConsingMap;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TypeFactory {
    private final HashConsingMap<Type> fCache = new WeakReferenceHashConsingMap<Type>(32768, (int)TimeUnit.MINUTES.toSeconds(30L));
    private volatile @MonotonicNonNull TypeValues typeValues;

    private TypeFactory() {
    }

    public static TypeFactory getInstance() {
        return InstanceHolder.sInstance;
    }

    public String toString() {
        return "TF";
    }

    public Type randomType(TypeStore store, RandomTypesConfig config) {
        return this.cachedTypeValues().randomType(store, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type randomADTType(TypeStore store, RandomTypesConfig config) {
        assert (config.isWithRandomAbstractDatatypes());
        TypeFactory typeFactory = this;
        synchronized (typeFactory) {
            TypeValues tv = this.cachedTypeValues();
            return tv.getRandomADTType(store, config);
        }
    }

    public Type randomType(TypeStore typeStore) {
        return this.cachedTypeValues().randomType(typeStore, RandomTypesConfig.defaultConfig(new Random()));
    }

    public Type randomType(TypeStore typeStore, int depth) {
        return this.cachedTypeValues().randomType(typeStore, RandomTypesConfig.defaultConfig(new Random()).maxDepth(depth));
    }

    public Type randomType(TypeStore typeStore, Random r, int depth) {
        return this.cachedTypeValues().randomType(typeStore, RandomTypesConfig.defaultConfig(r).maxDepth(depth));
    }

    public Type valueType() {
        return ValueType.getInstance();
    }

    public Type voidType() {
        return VoidType.getInstance();
    }

    Type getFromCache(Type t) {
        return this.fCache.get(t);
    }

    public Type integerType() {
        return IntegerType.getInstance();
    }

    public Type numberType() {
        return NumberType.getInstance();
    }

    public Type realType() {
        return RealType.getInstance();
    }

    public Type rationalType() {
        return RationalType.getInstance();
    }

    public Type boolType() {
        return BoolType.getInstance();
    }

    public Type externalType(Type externalType) {
        assert (!this.isNull(externalType)) : "external type cannot be null";
        return this.getFromCache(externalType);
    }

    public Type stringType() {
        return StringType.getInstance();
    }

    public Type sourceLocationType() {
        return SourceLocationType.getInstance();
    }

    public Type dateTimeType() {
        return DateTimeType.getInstance();
    }

    private TupleType getOrCreateTuple(Type[] fieldTypes) {
        return (TupleType)this.getFromCache(new TupleType(fieldTypes));
    }

    public Type tupleEmpty() {
        return this.getFromCache(new TupleType(new Type[0]));
    }

    public Type tupleType(Type ... fieldTypes) {
        assert (!this.anyNull(fieldTypes)) : "tuple field types should not be null";
        for (Type elem : fieldTypes) {
            if (!elem.isBottom()) continue;
            return elem;
        }
        return this.getFromCache(new TupleType(fieldTypes));
    }

    @Deprecated
    public Type tupleType(Object ... fieldTypesAndLabels) throws FactTypeDeclarationException {
        if (fieldTypesAndLabels.length == 0) {
            return this.tupleEmpty();
        }
        int N = fieldTypesAndLabels.length;
        int arity = N / 2;
        Type[] protoFieldTypes = new Type[arity];
        String[] protoFieldNames = new String[arity];
        for (int i = 0; i < N; i += 2) {
            int pos = i / 2;
            if (fieldTypesAndLabels[i] == null || fieldTypesAndLabels[i + 1] == null) {
                throw new NullPointerException();
            }
            try {
                protoFieldTypes[pos] = (Type)fieldTypesAndLabels[i];
                if (protoFieldTypes[pos].isBottom()) {
                    return this.voidType();
                }
            }
            catch (ClassCastException e) {
                throw new IllegalFieldTypeException(pos, fieldTypesAndLabels[i], e);
            }
            try {
                String name = (String)fieldTypesAndLabels[i + 1];
                if (!this.isIdentifier(name)) {
                    throw new IllegalIdentifierException(name);
                }
                protoFieldNames[pos] = name;
                continue;
            }
            catch (ClassCastException e) {
                throw new IllegalFieldNameException(pos, fieldTypesAndLabels[i + 1], e);
            }
        }
        return this.getFromCache(new TupleTypeWithFieldNames(protoFieldTypes, protoFieldNames));
    }

    @Deprecated
    public Type tupleType(Type[] types, String[] labels) {
        assert (!this.anyNull(types)) : "tuples types should not contain nulls";
        assert (!this.anyNull(labels)) : "label types should not contain nulls";
        assert (types.length == labels.length);
        if (types.length == 0) {
            return this.tupleEmpty();
        }
        for (Type elem : types) {
            if (!elem.isBottom()) continue;
            return this.voidType();
        }
        return this.getFromCache(new TupleTypeWithFieldNames(types, labels));
    }

    public Type tupleType(IValue ... elements) {
        assert (!this.anyNull(elements)) : "tuple type elements should not contain any nulls";
        int N = elements.length;
        Type[] fieldTypes = new Type[N];
        for (int i = N - 1; i >= 0; --i) {
            fieldTypes[i] = elements[i].getType();
        }
        return this.getOrCreateTuple(fieldTypes);
    }

    public Type functionType(Type returnType, Type argumentTypesTuple, Type keywordParameterTypesTuple) {
        if (argumentTypesTuple.isBottom()) {
            throw new IllegalArgumentException("argumentTypes must be a proper tuple type (without any void fields)");
        }
        if (keywordParameterTypesTuple.isBottom()) {
            throw new IllegalArgumentException("keywordParameterTypes must be a tuple type (without any void fields)");
        }
        return this.getFromCache(new FunctionType(returnType, (TupleType)argumentTypesTuple, (TupleType)keywordParameterTypesTuple));
    }

    public Type functionType(Type returnType, Type[] argumentTypes, String[] argumentLabels, Type[] keywordParameterTypes, String[] keywordParameterLabels) {
        assert (!this.anyNull(argumentTypes)) : "argument types should not be null";
        assert (!this.anyNull(argumentLabels)) : "argument labels should not contain nulls";
        assert (!this.anyNull(keywordParameterTypes)) : "keyword parameter types should not contain nulls";
        assert (!this.anyNull(keywordParameterLabels)) : "keyword parameter types should not contain nulls";
        return this.getFromCache(new FunctionType(returnType, (TupleType)this.getFromCache(new TupleTypeWithFieldNames(argumentTypes, argumentLabels)), (TupleType)this.getFromCache(new TupleTypeWithFieldNames(keywordParameterTypes, keywordParameterLabels))));
    }

    public Type functionType(Type returnType, Type[] argumentTypes, Type[] keywordParameterTypes) {
        assert (!this.anyNull(argumentTypes)) : "argument types should not be null";
        assert (!this.anyNull(keywordParameterTypes)) : "keyword parameter types should not contain nulls";
        return this.getFromCache(new FunctionType(returnType, (TupleType)this.getFromCache(new TupleType(argumentTypes)), (TupleType)this.getFromCache(new TupleType(keywordParameterTypes))));
    }

    public Type setType(Type eltType) {
        assert (!this.isNull(eltType)) : "set type should not be null";
        return this.getFromCache(new SetType(eltType));
    }

    public Type relTypeFromTuple(Type tupleType) {
        assert (!this.isNull(tupleType)) : "rel type should not be null";
        return this.setType(tupleType);
    }

    public Type lrelTypeFromTuple(Type tupleType) {
        assert (!this.isNull(tupleType)) : "lrel type should not be null";
        return this.listType(tupleType);
    }

    public Type relType(Type ... fieldTypes) {
        assert (!this.anyNull(fieldTypes)) : "rel types should not contain nulls";
        return this.setType(this.tupleType(fieldTypes));
    }

    @Deprecated
    public Type relType(Object ... fieldTypesAndLabels) {
        return this.setType(this.tupleType(fieldTypesAndLabels));
    }

    public Type lrelType(Type ... fieldTypes) {
        assert (!this.anyNull(fieldTypes)) : "lrel types should not contain nulls";
        return this.listType(this.tupleType(fieldTypes));
    }

    @Deprecated
    public Type lrelType(Object ... fieldTypesAndLabels) {
        return this.lrelTypeFromTuple(this.tupleType(fieldTypesAndLabels));
    }

    public Type aliasType(TypeStore store, String name, Type aliased, Type ... parameters) throws FactTypeDeclarationException {
        assert (!this.isNull(store)) : "alias store should not be null";
        assert (!this.isNull(name)) : "alias name should not be null";
        assert (!this.isNull(aliased)) : "alias aliased should not be null";
        assert (!this.anyNull(parameters)) : "alias parameters should not be null";
        Type paramType = parameters.length == 0 ? this.voidType() : this.tupleType(parameters);
        return this.aliasTypeFromTuple(store, name, aliased, paramType);
    }

    public Type aliasTypeFromTuple(TypeStore store, String name, Type aliased, Type params) throws FactTypeDeclarationException {
        assert (!this.isNull(store)) : "alias store should not be null";
        assert (!this.isNull(name)) : "alias name should not be null";
        assert (!this.isNull(aliased)) : "alias aliased should not be null";
        assert (!this.isNull(params)) : "alias params should not be null";
        if (!this.isIdentifier(name)) {
            throw new IllegalIdentifierException(name);
        }
        if (aliased == null) {
            throw new NullTypeException();
        }
        Type result = this.getFromCache(new AliasType(name, aliased, params));
        store.declareAlias(result);
        return result;
    }

    public Type nodeType() {
        return NodeType.getInstance();
    }

    public Type abstractDataType(TypeStore store, String name, Type ... parameters) throws FactTypeDeclarationException {
        assert (!this.isNull(store)) : "adt store should not be null";
        assert (!this.isNull(name)) : "adt name should not be null";
        assert (!this.anyNull(parameters)) : "adt parameters should not contain a null";
        Type paramType = this.voidType();
        if (parameters.length != 0) {
            paramType = this.tupleType(parameters);
        }
        return this.abstractDataTypeFromTuple(store, name, paramType);
    }

    public Type abstractDataTypeFromTuple(TypeStore store, String name, Type params) throws FactTypeDeclarationException {
        assert (!this.isNull(store)) : "adt store should not be null";
        assert (!this.isNull(name)) : "adt name should not be null";
        assert (!this.isNull(params)) : "adt params should not be null";
        if (!this.isIdentifier(name)) {
            throw new IllegalIdentifierException(name);
        }
        Type result = this.getFromCache(new AbstractDataType(name, params));
        if (!params.equivalent(this.voidType()) && params.getArity() > 0) {
            if (params.getFieldType(0).isOpen()) {
                store.declareAbstractDataType(result);
            }
        } else {
            store.declareAbstractDataType(result);
        }
        return result;
    }

    public Type constructorFromTuple(TypeStore store, Type adt, String name, Type tupleType) throws FactTypeDeclarationException {
        assert (!this.isNull(store)) : "constructor store should not be null";
        assert (!this.isNull(adt)) : "constructor adt should not be null";
        assert (!this.isNull(name)) : "constructor name should not be null";
        assert (!this.isNull(tupleType)) : "constructor type should not be null";
        if (!this.isIdentifier(name)) {
            throw new IllegalIdentifierException(name);
        }
        Type result = this.getFromCache(new ConstructorType(name, tupleType, adt));
        Type params = adt.getTypeParameters();
        if (!params.equivalent(this.voidType())) {
            if (params.isOpen()) {
                store.declareConstructor(result);
            }
        } else {
            store.declareConstructor(result);
        }
        return result;
    }

    public Type constructor(TypeStore store, Type adt, String name, Type ... children) throws FactTypeDeclarationException {
        return this.constructorFromTuple(store, adt, name, this.tupleType(children));
    }

    public Type constructor(TypeStore store, Type nodeType, String name, Object ... childrenAndLabels) throws FactTypeDeclarationException {
        return this.constructorFromTuple(store, nodeType, name, this.tupleType(childrenAndLabels));
    }

    public Type listType(Type elementType) {
        assert (!this.isNull(elementType)) : "list type should not be null";
        return this.getFromCache(new ListType(elementType));
    }

    public Type mapType(Type key, Type value) {
        assert (!this.isNull(key)) : "map key type should not be null";
        assert (!this.isNull(value)) : "map key type should not be null";
        return this.getFromCache(new MapType(key, value));
    }

    public Type mapTypeFromTuple(Type fields) {
        assert (!this.isNull(fields)) : "map tuple type should not be null";
        if (fields.isBottom()) {
            return this.mapType(this.voidType(), this.voidType());
        }
        if (!fields.isFixedWidth()) {
            throw new UnsupportedOperationException("fields argument should be a tuple. not " + String.valueOf(fields));
        }
        if (fields.getArity() < 2) {
            throw new IndexOutOfBoundsException();
        }
        if (fields.hasFieldNames()) {
            return this.mapType(fields.getFieldType(0), Objects.requireNonNull(fields.getFieldName(0)), fields.getFieldType(1), Objects.requireNonNull(fields.getFieldName(1)));
        }
        return this.mapType(fields.getFieldType(0), fields.getFieldType(1));
    }

    public Type mapType(Type key, String keyLabel, Type value, String valueLabel) {
        assert (!this.isNull(key)) : "map key type should not be null";
        assert (!this.isNull(value)) : "map key type should not be null";
        if (keyLabel != null && valueLabel == null || valueLabel != null && keyLabel == null) {
            throw new IllegalArgumentException("Key and value labels must both be non-null or null: " + keyLabel + ", " + valueLabel);
        }
        return this.getFromCache(new MapTypeWithFieldNames(key, keyLabel, value, valueLabel));
    }

    public Type parameterType(String name, Type bound) {
        assert (!this.isNull(name)) : "parameter name should not be null";
        assert (!this.isNull(bound)) : "parameter type should not be null";
        return this.getFromCache(new ParameterType(name, bound));
    }

    public Type fromSymbol(IConstructor symbol, TypeStore store, Function<IConstructor, Set<IConstructor>> grammar) {
        return this.cachedTypeValues().fromSymbol(symbol, store, grammar);
    }

    public IConstructor asSymbol(Type type, IValueFactory vf, TypeStore store, ISetWriter grammar) {
        return type.asSymbol(vf, store, grammar, new HashSet<IConstructor>());
    }

    public Type fromString(TypeStore store, Reader reader) throws IOException {
        return new TypeReader().read(store, reader);
    }

    public Type parameterType(String name) {
        assert (!this.isNull(name)) : "parameter name should not be null";
        return this.getFromCache(new ParameterType(name));
    }

    private boolean anyNull(@Nullable Object[] os) {
        for (Object o : os) {
            if (!this.isNull(o)) continue;
            return true;
        }
        return false;
    }

    private boolean isNull(@Nullable Object os) {
        return Objects.isNull(os);
    }

    public boolean isIdentifier(String str) {
        assert (!this.isNull(str)) : "str should not be null";
        int len = str.length();
        if (len == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(str.charAt(0))) {
            return false;
        }
        for (int i = len - 1; i > 0; --i) {
            char c = str.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '.' || c == '-') continue;
            return false;
        }
        return true;
    }

    public Type fromSymbol(IConstructor symbol) {
        return this.cachedTypeValues().fromSymbol(symbol, new TypeStore(new TypeStore[0]), x -> Collections.emptySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeValues cachedTypeValues() {
        TypeValues result = this.typeValues;
        if (result == null) {
            TypeFactory typeFactory = this;
            synchronized (typeFactory) {
                result = this.typeValues;
                if (result == null) {
                    result = new TypeValues();
                    result.initialize();
                    this.typeValues = result;
                }
            }
        }
        return result;
    }

    public class TypeValues {
        private static final String TYPES_CONFIG = "io/usethesource/vallang/type/types.config";
        private final TypeStore symbolStore = new TypeStore(new TypeStore[0]);
        private final Type Symbol = TypeFactory.this.abstractDataType(this.symbolStore, "Symbol", new Type[0]);
        private final Type Symbol_Label = TypeFactory.this.constructor(this.symbolStore, this.Symbol, "label", TypeFactory.this.stringType(), "name", this.Symbol, "symbol");
        private final Map<Type, TypeReifier> symbolConstructorTypes = new ConcurrentHashMap<Type, TypeReifier>();

        private TypeValues() {
        }

        public Type randomType(TypeStore store, final RandomTypesConfig config) {
            BiFunction<TypeStore, RandomTypesConfig, Type> next = new BiFunction<TypeStore, RandomTypesConfig, Type>(){
                int maxTries;
                {
                    this.maxTries = config.getMaxDepth();
                }

                @Override
                public Type apply(TypeStore store, RandomTypesConfig rnd) {
                    if (this.maxTries-- > 0) {
                        return TypeValues.this.getRandomType(this, store, rnd);
                    }
                    return TypeValues.this.getRandomNonRecursiveType(this, store, rnd);
                }
            };
            return config.getMaxDepth() > 0 ? this.getRandomType(next, store, config) : this.getRandomNonRecursiveType(next, store, config);
        }

        private Type getRandomNonRecursiveType(BiFunction<TypeStore, RandomTypesConfig, Type> next, TypeStore store, RandomTypesConfig rnd) {
            Iterator<TypeReifier> it = this.symbolConstructorTypes.values().iterator();
            TypeReifier reifier = it.next();
            while (it.hasNext() && (reifier = it.next()).isRecursive()) {
            }
            assert (!reifier.isRecursive()) : "a recursive type could only happen here if no non-recursive types has been registered at all.";
            return reifier.randomInstance(next, store, rnd);
        }

        private Type getRandomType(BiFunction<TypeStore, RandomTypesConfig, Type> next, TypeStore store, RandomTypesConfig rnd) {
            TypeReifier[] alts;
            TypeReifier selected = alts[Math.max(0, (alts = this.symbolConstructorTypes.values().toArray(new TypeReifier[0])).length > 0 ? rnd.nextInt(alts.length) - 1 : 0)];
            while (rnd.nextBoolean() && !selected.isRecursive()) {
                selected = alts[Math.max(0, rnd.nextInt(alts.length))];
            }
            return selected.randomInstance(next, store, rnd);
        }

        public Type getRandomADTType(TypeStore store, final RandomTypesConfig rnd) {
            BiFunction<TypeStore, RandomTypesConfig, Type> next = new BiFunction<TypeStore, RandomTypesConfig, Type>(){
                int maxTries;
                {
                    this.maxTries = rnd.getMaxDepth();
                }

                @Override
                public Type apply(TypeStore store, RandomTypesConfig rnd2) {
                    if (this.maxTries-- > 0) {
                        return TypeValues.this.getRandomType(this, store, rnd2);
                    }
                    return TypeValues.this.getRandomNonRecursiveType(this, store, rnd2);
                }
            };
            return this.symbolConstructorTypes.values().stream().filter(p -> p instanceof AbstractDataType.Info).findFirst().get().randomInstance(next, store, rnd);
        }

        public boolean isLabel(IConstructor symbol) {
            return symbol.getConstructorType() == this.Symbol_Label;
        }

        public String getLabel(IValue symbol) {
            assert (symbol instanceof IConstructor && this.isLabel((IConstructor)symbol));
            return ((IString)((IConstructor)symbol).get("name")).getValue();
        }

        public IConstructor labelSymbol(IValueFactory vf, IConstructor symbol, String label) {
            return vf.constructor(this.Symbol_Label, vf.string(label), symbol);
        }

        public IConstructor getLabeledSymbol(IValue symbol) {
            assert (symbol instanceof IConstructor && this.isLabel((IConstructor)symbol));
            return (IConstructor)((IConstructor)symbol).get("symbol");
        }

        public Type typeSymbolConstructor(String name, Object ... args) {
            return TypeFactory.this.constructor(this.symbolStore, this.symbolADT(), name, args);
        }

        public Type typeProductionConstructor(String name, Object ... args) {
            return TypeFactory.this.constructor(this.symbolStore, this.productionADT(), name, args);
        }

        public Type symbolADT() {
            return TypeFactory.this.abstractDataType(this.symbolStore, "Symbol", new Type[0]);
        }

        public Type attrADT() {
            return TypeFactory.this.abstractDataType(this.symbolStore, "Attr", new Type[0]);
        }

        public Type productionADT() {
            return TypeFactory.this.abstractDataType(this.symbolStore, "Production", new Type[0]);
        }

        public void initialize() {
            try {
                Enumeration<URL> resources = this.checkValidClassLoader(this.getClass().getClassLoader()).getResources(TYPES_CONFIG);
                Collections.list(resources).forEach(f -> this.loadServices((URL)f));
            }
            catch (IOException e) {
                throw new Error("WARNING: Could not load type kind definitions from io/usethesource/vallang/type/types.config", e);
            }
        }

        private ClassLoader checkValidClassLoader(@Nullable ClassLoader cl) {
            if (cl == null) {
                throw new Error("Could not find class loader due to bootloader loading of this class");
            }
            return cl;
        }

        private void loadServices(URL nextElement) {
            try {
                for (String name : this.readConfigFile(nextElement)) {
                    if ((name = name.trim()).startsWith("#") || name.isEmpty()) continue;
                    Class<?> clazz = this.checkValidClassLoader(Thread.currentThread().getContextClassLoader()).loadClass(name);
                    Object instance = clazz.getConstructor(TypeValues.class).newInstance(this);
                    if (instance instanceof TypeReifier) {
                        this.registerTypeInfo((TypeReifier)instance);
                        continue;
                    }
                    throw new IllegalArgumentException("WARNING: could not load type info " + name + " because it does not implement TypeFactory.TypeInfo");
                }
            }
            catch (IOException | ClassCastException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalArgumentException("WARNING: could not load type info " + String.valueOf(nextElement) + " due to " + e.getMessage());
            }
        }

        private void registerTypeInfo(TypeReifier instance) {
            instance.getSymbolConstructorTypes().forEach(x -> this.symbolConstructorTypes.put((Type)x, instance));
        }

        private String[] readConfigFile(URL nextElement) throws IOException {
            try (InputStreamReader in = new InputStreamReader(nextElement.openStream());){
                int read;
                StringBuilder res = new StringBuilder();
                char[] chunk = new char[1024];
                while ((read = ((Reader)in).read(chunk, 0, chunk.length)) != -1) {
                    res.append(chunk, 0, read);
                }
                String[] stringArray = res.toString().split("\n");
                return stringArray;
            }
        }

        public Type fromSymbol(IConstructor symbol, TypeStore store, Function<IConstructor, Set<IConstructor>> grammar) {
            TypeReifier reifier = this.symbolConstructorTypes.get(symbol.getConstructorType());
            if (reifier != null) {
                return reifier.fromSymbol(symbol, store, grammar);
            }
            throw new IllegalArgumentException("trying to construct a type from an unsupported type symbol: " + String.valueOf(symbol) + ", with this representation: " + String.valueOf(symbol.getConstructorType()));
        }

        public Type fromSymbols(IList symbols, TypeStore store, Function<IConstructor, Set<IConstructor>> grammar) {
            boolean allLabels = true;
            Type[] types = new Type[symbols.length()];
            String[] labels = new String[symbols.length()];
            for (int i = 0; i < symbols.length(); ++i) {
                IConstructor elem = (IConstructor)symbols.get(i);
                if (elem.getConstructorType() == this.Symbol_Label) {
                    labels[i] = ((IString)elem.get("name")).getValue();
                    elem = (IConstructor)elem.get("symbol");
                } else {
                    allLabels = false;
                }
                types[i] = this.fromSymbol(elem, store, grammar);
            }
            if (allLabels) {
                return TypeFactory.this.tupleType(types, labels);
            }
            return TypeFactory.this.tupleType(types);
        }
    }

    public static class RandomTypesConfig {
        private final Random random;
        private final int maxDepth;
        private final boolean withTypeParameters;
        private final boolean withAliases;
        private final boolean withTupleFieldNames;
        private final boolean withMapFieldNames;
        private final boolean withRandomAbstractDatatypes;

        private RandomTypesConfig(Random random) {
            this.random = random;
            this.maxDepth = 5;
            this.withAliases = false;
            this.withTupleFieldNames = false;
            this.withTypeParameters = false;
            this.withMapFieldNames = false;
            this.withRandomAbstractDatatypes = true;
        }

        private RandomTypesConfig(Random random, int maxDepth, boolean withTypeParameters, boolean withAliases, boolean withTupleFieldNames, boolean withRandomAbstractDatatypes, boolean withMapFieldNames) {
            this.random = random;
            this.maxDepth = maxDepth;
            this.withAliases = withAliases;
            this.withTupleFieldNames = withTupleFieldNames;
            this.withTypeParameters = withTypeParameters;
            this.withRandomAbstractDatatypes = withRandomAbstractDatatypes;
            this.withMapFieldNames = withMapFieldNames;
        }

        public static RandomTypesConfig defaultConfig(Random random) {
            return new RandomTypesConfig(random);
        }

        public Random getRandom() {
            return this.random;
        }

        public boolean nextBoolean() {
            return this.random.nextBoolean();
        }

        public int nextInt(int bound) {
            return this.random.nextInt(bound);
        }

        public boolean isWithAliases() {
            return this.withAliases;
        }

        public boolean isWithTupleFieldNames() {
            return this.withTupleFieldNames;
        }

        public boolean isWithMapFieldNames() {
            return this.withMapFieldNames;
        }

        public boolean isWithTypeParameters() {
            return this.withTypeParameters;
        }

        public boolean isWithRandomAbstractDatatypes() {
            return this.withRandomAbstractDatatypes;
        }

        public int getMaxDepth() {
            return this.maxDepth;
        }

        public RandomTypesConfig maxDepth(int newMaxDepth) {
            return new RandomTypesConfig(this.random, newMaxDepth, this.withTypeParameters, this.withAliases, this.withTupleFieldNames, this.withRandomAbstractDatatypes, this.withMapFieldNames);
        }

        public RandomTypesConfig withAliases() {
            return new RandomTypesConfig(this.random, this.maxDepth, this.withTypeParameters, true, this.withTupleFieldNames, this.withRandomAbstractDatatypes, this.withMapFieldNames);
        }

        public RandomTypesConfig withTypeParameters() {
            return new RandomTypesConfig(this.random, this.maxDepth, true, this.withAliases, this.withTupleFieldNames, this.withRandomAbstractDatatypes, this.withMapFieldNames);
        }

        public RandomTypesConfig withTupleFieldNames() {
            return new RandomTypesConfig(this.random, this.maxDepth, this.withTypeParameters, this.withAliases, true, this.withRandomAbstractDatatypes, this.withMapFieldNames);
        }

        public RandomTypesConfig withoutRandomAbstractDatatypes() {
            return new RandomTypesConfig(this.random, this.maxDepth, this.withTypeParameters, this.withAliases, this.withTupleFieldNames, false, this.withMapFieldNames);
        }

        public RandomTypesConfig withMapFieldNames() {
            return new RandomTypesConfig(this.random, this.maxDepth, this.withTypeParameters, this.withAliases, this.withTupleFieldNames, this.withRandomAbstractDatatypes, true);
        }
    }

    public static abstract class TypeReifier {
        private final TypeValues cachedSymbols;

        public TypeReifier(TypeValues symbols) {
            this.cachedSymbols = symbols;
        }

        public TypeValues symbols() {
            return this.cachedSymbols;
        }

        public TypeFactory tf() {
            return TypeFactory.getInstance();
        }

        public Set<Type> getSymbolConstructorTypes() {
            return Collections.singleton(this.getSymbolConstructorType());
        }

        public abstract Type getSymbolConstructorType();

        public boolean isRecursive() {
            return false;
        }

        public abstract Type randomInstance(BiFunction<TypeStore, RandomTypesConfig, Type> var1, TypeStore var2, RandomTypesConfig var3);

        public IConstructor toSymbol(Type type, IValueFactory vf, TypeStore store, ISetWriter grammar, Set<IConstructor> done) {
            return vf.constructor(this.getSymbolConstructorType());
        }

        public void asProductions(Type type, IValueFactory vf, TypeStore store, ISetWriter grammar, Set<IConstructor> done) {
        }

        public abstract Type fromSymbol(IConstructor var1, TypeStore var2, Function<IConstructor, Set<IConstructor>> var3);

        public String randomLabel(RandomTypesConfig rnd) {
            return "x" + new BigInteger(32, rnd.getRandom()).toString(32);
        }

        public Type randomTuple(BiFunction<TypeStore, RandomTypesConfig, Type> next, TypeStore store, RandomTypesConfig rnd) {
            return new TupleType.Info(this.cachedSymbols).randomInstance(next, store, rnd);
        }

        public Type randomTuple(BiFunction<TypeStore, RandomTypesConfig, Type> next, TypeStore store, RandomTypesConfig rnd, int arity) {
            return new TupleType.Info(this.cachedSymbols).randomInstance(next, store, rnd, arity);
        }
    }

    private static class InstanceHolder {
        public static final TypeFactory sInstance = new TypeFactory();

        private InstanceHolder() {
        }
    }
}

