/*
 * Decompiled with CFR 0.152.
 */
package lang.cpp.internal;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValueFactory;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.gnu.c.GCCLanguage;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.core.dom.IIncludeFileResolutionHeuristics;
import org.eclipse.cdt.internal.core.index.CIndex;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.parser.IMacroDictionary;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContent;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContentProvider;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.library.Prelude;
import org.rascalmpl.uri.URIResolverRegistry;

public class CDTParser {
    private final IValueFactory vf;
    private final PrintWriter stdErr;
    private final IScannerInfo scannerInfo;
    private final InternalFileContentProvider ifcp;
    private final IIndex idx;
    private final int options;
    private final IParserLogService log;
    private final List<String> path;

    public CDTParser(IValueFactory vf, PrintWriter stdOut, PrintWriter stdErr, IList stdLib, IList includePath, IMap standardMacros, IMap additionalMacros, boolean includeStdLib) {
        this.vf = vf;
        this.stdErr = stdErr;
        HashMap macros = new HashMap();
        additionalMacros.stream().map(ITuple.class::cast).forEach(tuple -> macros.put(((IString)tuple.get(0)).getValue(), ((IString)tuple.get(1)).getValue()));
        standardMacros.stream().map(ITuple.class::cast).forEach(tuple -> macros.put(((IString)tuple.get(0)).getValue(), ((IString)tuple.get(1)).getValue()));
        this.scannerInfo = new ScannerInfo(macros, null);
        this.ifcp = new InternalFileContentProvider(){

            public InternalFileContent getContentForInclusion(String filePath, IMacroDictionary macroDictionary) {
                return (InternalFileContent)FileContent.createForExternalFileLocation((String)filePath);
            }

            public InternalFileContent getContentForInclusion(IIndexFileLocation ifl, String astPath) {
                return (InternalFileContent)FileContent.create((IIndexFileLocation)ifl);
            }
        };
        this.path = new ArrayList<String>();
        try {
            this.path.add(ResourcesPlugin.getWorkspace().getRoot().getProject("clair").getLocation().toString() + "/includes");
        }
        catch (Throwable t) {
            stdOut.println("WARNING: ResourcesPlugin was null, can't get workspace; not overriding include files");
        }
        includePath.stream().forEach(it -> this.path.add(this.locToPath((ISourceLocation)it)));
        stdLib.stream().forEach(it -> this.path.add(this.locToPath((ISourceLocation)it)));
        IIncludeFileResolutionHeuristics ifrh = new IIncludeFileResolutionHeuristics(){

            public String findInclusion(String include, String currentFile) {
                return CDTParser.this.findIncludeInPath(include, currentFile);
            }
        };
        this.ifcp.setIncludeResolutionHeuristics(ifrh);
        this.idx = new CIndex(new IIndexFragment[0]);
        this.options = 32;
        this.log = new IParserLogService(){

            public void traceLog(String message) {
            }

            public boolean isTracing() {
                return true;
            }
        };
    }

    public IASTTranslationUnit parseFileAsC(ISourceLocation file, IString charset, IBool inferCharset) {
        FileContent fc = FileContent.create((String)file.toString(), (char[])Prelude.readFile((IValueFactory)this.vf, (boolean)false, (ISourceLocation)file, (String)charset.getValue(), (boolean)inferCharset.getValue()).getValue().toCharArray());
        try {
            return GCCLanguage.getDefault().getASTTranslationUnit(fc, this.scannerInfo, (IncludeFileContentProvider)this.ifcp, this.idx, this.options, this.log);
        }
        catch (CoreException e) {
            throw RuntimeExceptionFactory.io((IString)this.vf.string(e.getMessage()));
        }
    }

    public IASTTranslationUnit parseFileAsCpp(ISourceLocation file, IString charset, IBool inferCharset) {
        FileContent fc = FileContent.create((String)file.toString(), (char[])Prelude.readFile((IValueFactory)this.vf, (boolean)false, (ISourceLocation)file, (String)charset.getValue(), (boolean)inferCharset.getValue()).getValue().toCharArray());
        try {
            return GPPLanguage.getDefault().getASTTranslationUnit(fc, this.scannerInfo, (IncludeFileContentProvider)this.ifcp, this.idx, this.options, this.log);
        }
        catch (CoreException e) {
            throw RuntimeExceptionFactory.io((IString)this.vf.string(e.getMessage()));
        }
    }

    private String locToPath(ISourceLocation loc) {
        try {
            loc = URIResolverRegistry.getInstance().logicalToPhysical(loc);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!loc.getScheme().equals("file")) {
            throw new IllegalArgumentException("Will not convert non-file loc");
        }
        return loc.getAuthority() + loc.getPath();
    }

    private boolean isRightFile(String include, String toMatch) {
        if (System.getProperty("os.name").contains("Win")) {
            return include.equalsIgnoreCase(toMatch);
        }
        return include.equals(toMatch);
    }

    private String checkDirectory(File dir, String fileName) {
        if (!dir.isDirectory()) {
            return null;
        }
        for (File f : dir.listFiles()) {
            if (!this.isRightFile(f.getName(), fileName)) continue;
            return f.getAbsolutePath();
        }
        return null;
    }

    public String findIncludeInPath(String include, String currentFile) {
        include = include.trim().replace("\\", "/");
        String includeFilePath = include.substring(0, include.lastIndexOf(47) + 1);
        String includeFileName = include.substring(include.lastIndexOf(47) + 1);
        File currentFileDirectory = currentFile.startsWith("|file://") ? new File(new File(currentFile.substring("|file://".length())).getParent(), includeFilePath) : new File(new File(currentFile).getParentFile(), includeFilePath);
        String found = this.checkDirectory(currentFileDirectory, includeFileName);
        if (found != null) {
            return found;
        }
        for (String path : this.path) {
            found = this.checkDirectory(new File(path, includeFilePath), includeFileName);
            if (found == null) continue;
            return found;
        }
        this.stdErr.println("Include " + include + " for " + currentFile + " not found");
        this.stdErr.flush();
        return null;
    }
}

