/*
 * Decompiled with CFR 0.152.
 */
package lang.cpp.internal;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import java.io.PrintWriter;
import java.util.stream.Stream;
import lang.cpp.internal.AST;
import lang.cpp.internal.BindingsResolver;
import lang.cpp.internal.Locations;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IProblemType;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICBasicType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTAliasDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplatedTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPAliasTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPAliasTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBasicType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumerationSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTypeSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUnaryTypeTransformation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.c.CStructure;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitTemplateTypeParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateNonTypeArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTypeArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTypeParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownMemberClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionSet;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.FunctionSetType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfUnknownMember;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPClassType;

public class TypeResolver {
    private final AST builder;
    private final BindingsResolver br;
    private final IValueFactory vf;
    private final PrintWriter stdOut;
    private final Locations locs;
    private int prefix = 0;

    public TypeResolver(AST builder, BindingsResolver br, Locations locs, IValueFactory vf, PrintWriter stdOut) {
        this.builder = builder;
        this.br = br;
        this.vf = vf;
        this.stdOut = stdOut;
        this.locs = locs;
    }

    private String spaces() {
        return StringUtils.repeat((String)" ", (int)this.prefix);
    }

    private void out(String msg) {
        this.stdOut.println(this.spaces() + msg.replace("\n", "\n" + this.spaces()));
    }

    private ISourceLocation getDecl(IBinding binding, ISourceLocation origin) {
        return this.br.resolveBinding(null, binding, origin);
    }

    private IList handleTemplateParameters(ICPPASTTemplateDeclaration declaration) {
        return this.handleTemplateParameters(declaration.getTemplateParameters());
    }

    private IList handleTemplateParameters(ICPPASTTemplateParameter[] params) {
        return (IList)Stream.of(params).map(it -> {
            if (it instanceof ICPPASTSimpleTypeTemplateParameter) {
                return this.br.resolveBinding((IASTNameOwner)((ICPPASTSimpleTypeTemplateParameter)it), this.locs.forNode((IASTNode)it));
            }
            if (it instanceof ICPPASTTemplatedTypeTemplateParameter) {
                return this.br.resolveBinding((IASTNameOwner)((ICPPASTTemplatedTypeTemplateParameter)it), this.locs.forNode((IASTNode)it));
            }
            if (it instanceof ICPPASTParameterDeclaration) {
                return this.getDecl(((ICPPASTParameterDeclaration)it).getDeclarator().getName().resolveBinding(), this.locs.forNode((IASTNode)it));
            }
            throw new RuntimeException("Encountered unknown template parameter type " + it.getClass().getSimpleName() + " @ " + String.valueOf(this.locs.forNode((IASTNode)it)));
        }).collect(this.vf.listWriter());
    }

    private IList handleTemplateParameters(ICPPTemplateParameter[] params, ISourceLocation origin) {
        return (IList)Stream.of(params).map(it -> this.br.resolveBinding((ICPPBinding)it, origin)).collect(this.vf.listWriter());
    }

    public IConstructor resolveType(IASTNode node) {
        if (node instanceof IASTExpression) {
            return this.resolveIASTExpression((IASTExpression)node);
        }
        if (node instanceof ICPPASTTemplateDeclaration) {
            return this.resolveICPPASTTemplateDeclaration((ICPPASTTemplateDeclaration)node);
        }
        if (node instanceof ICPPASTTemplateId) {
            return this.resolveICPPASTTemplateId((ICPPASTTemplateId)node);
        }
        if (node instanceof ICPPASTDeclarator) {
            return this.resolveICPPASTDeclarator((ICPPASTDeclarator)node);
        }
        if (node instanceof IASTStandardFunctionDeclarator) {
            return this.resolveIASTStandardFunctionDeclarator((IASTStandardFunctionDeclarator)node);
        }
        return this.builder.TypeSymbol_any();
    }

    private IConstructor resolveIASTStandardFunctionDeclarator(IASTStandardFunctionDeclarator node) {
        IBinding binding = node.getName().resolveBinding();
        ISourceLocation origin = this.locs.forNode((IASTNode)node.getName());
        if (binding instanceof IFunction) {
            return this.resolveType((IType)((IFunction)binding).getType(), origin);
        }
        return this.builder.TypeSymbol_any();
    }

    private IConstructor resolveICPPASTDeclarator(ICPPASTDeclarator node) {
        IBinding binding = node.getName().resolveBinding();
        ISourceLocation origin = this.locs.forNode((IASTNode)node.getName());
        if (binding instanceof IVariable) {
            return this.resolveType(((IVariable)binding).getType(), origin);
        }
        if (binding instanceof IFunction) {
            return this.resolveType((IType)((IFunction)binding).getType(), origin);
        }
        if (binding instanceof ITypedef) {
            return this.resolveType(((ITypedef)binding).getType(), origin);
        }
        return this.builder.TypeSymbol_any();
    }

    private IConstructor resolveIASTExpression(IASTExpression node) {
        return this.resolveType(node.getExpressionType(), this.locs.forNode((IASTNode)node));
    }

    private IConstructor resolveICPPASTTemplateId(ICPPASTTemplateId node) {
        this.out("Parent " + node.getParent().getParent().getClass().getSimpleName());
        IListWriter templateArguments = this.vf.listWriter();
        Stream.of(node.getTemplateArguments()).forEach(it -> {
            this.out(it.getRawSignature());
            templateArguments.append(new IValue[]{this.resolveType((IASTNode)it)});
        });
        IConstructor ret = this.builder.TypeSymbol_classSpecialization(this.br.resolveBinding((IASTNameOwner)node, this.locs.forNode((IASTNode)node)), (IList)templateArguments.done());
        this.out(ret.toString());
        return ret;
    }

    private IConstructor resolveICPPASTTemplateDeclaration(ICPPASTTemplateDeclaration node) {
        IASTDeclaration declaration = node.getDeclaration();
        if (declaration instanceof IASTSimpleDeclaration) {
            IASTDeclSpecifier declSpec = ((IASTSimpleDeclaration)node.getDeclaration()).getDeclSpecifier();
            ISourceLocation origin = this.locs.forNode((IASTNode)declSpec);
            if (declSpec instanceof ICPPASTCompositeTypeSpecifier) {
                switch (((ICPPASTCompositeTypeSpecifier)declSpec).getKey()) {
                    case 3: {
                        IBinding binding = ((ICPPASTCompositeTypeSpecifier)declSpec).getName().resolveBinding();
                        return this.builder.TypeSymbol_cClassTemplate(this.getDecl(binding, origin), this.handleTemplateParameters(node));
                    }
                    case 1: {
                        IBinding binding = ((ICPPASTCompositeTypeSpecifier)declSpec).getName().resolveBinding();
                        return this.builder.TypeSymbol_cStructTemplate(this.getDecl(binding, origin), this.handleTemplateParameters(node));
                    }
                    case 2: {
                        IBinding binding = ((ICPPASTCompositeTypeSpecifier)declSpec).getName().resolveBinding();
                        return this.builder.TypeSymbol_cUnionTemplate(this.getDecl(binding, origin), this.handleTemplateParameters(node));
                    }
                }
                this.out(this.locs.forNode((IASTNode)node).toString());
                throw new RuntimeException("ICPPASTCompositeTypeSpecifier not implemented: " + String.valueOf(origin));
            }
            if (declSpec instanceof ICPPASTSimpleDeclSpecifier || declSpec instanceof ICPPASTNamedTypeSpecifier) {
                IASTDeclarator[] declarators = ((IASTSimpleDeclaration)declaration).getDeclarators();
                if (declarators.length != 1) {
                    this.out("Variable template with unexpected #declarators at " + String.valueOf(this.locs.forNode((IASTNode)node)));
                }
                return this.builder.TypeSymbol_variableTemplate(this.getDecl(declarators[0].getName().resolveBinding(), origin), this.handleTemplateParameters(node));
            }
            if (declSpec instanceof ICPPASTElaboratedTypeSpecifier) {
                IBinding binding = ((ICPPASTElaboratedTypeSpecifier)declSpec).getName().resolveBinding();
                switch (((ICPPASTElaboratedTypeSpecifier)declSpec).getKind()) {
                    case 3: {
                        return this.builder.TypeSymbol_eClassTemplate(this.getDecl(binding, origin), this.handleTemplateParameters(node));
                    }
                    case 1: {
                        return this.builder.TypeSymbol_eStructTemplate(this.getDecl(binding, origin), this.handleTemplateParameters(node));
                    }
                    case 0: {
                        return this.builder.TypeSymbol_eStructTemplate(this.getDecl(binding, origin), this.handleTemplateParameters(node));
                    }
                    case 2: {
                        return this.builder.TypeSymbol_eStructTemplate(this.getDecl(binding, origin), this.handleTemplateParameters(node));
                    }
                }
                int kind = ((ICPPASTElaboratedTypeSpecifier)declSpec).getKind();
                throw new RuntimeException("Encountered template declaration with unknown ElaboratedTypeSpecifier kind " + kind + " at " + String.valueOf(this.locs.forNode((IASTNode)node)));
            }
            throw new RuntimeException("Unknown template declaree " + declaration.getClass().getSimpleName() + " @ " + String.valueOf(origin));
        }
        if (declaration instanceof ICPPASTFunctionDefinition) {
            IBinding binding = ((ICPPASTFunctionDefinition)declaration).getDeclarator().getName().resolveBinding();
            return this.builder.TypeSymbol_functionTemplate(this.getDecl(binding, this.locs.forNode((IASTNode)declaration)), this.handleTemplateParameters(node));
        }
        if (declaration instanceof ICPPASTTemplateDeclaration) {
            IConstructor templatedTemplate = this.resolveICPPASTTemplateDeclaration((ICPPASTTemplateDeclaration)declaration);
            return this.builder.TypeSymbol_templateTemplate(templatedTemplate, this.handleTemplateParameters(node));
        }
        if (declaration instanceof ICPPASTAliasDeclaration) {
            IBinding binding = ((ICPPASTAliasDeclaration)declaration).getAlias().resolveBinding();
            return this.builder.TypeSymbol_aliasTemplate(this.getDecl(binding, this.locs.forNode((IASTNode)declaration)), this.handleTemplateParameters(node), this.resolveType((IASTNode)((ICPPASTAliasDeclaration)declaration).getMappingTypeId()));
        }
        throw new RuntimeException("Unknown template declaree at " + String.valueOf(this.locs.forNode((IASTNode)node)));
    }

    public IConstructor resolveType(IType type, ISourceLocation origin) {
        if (type instanceof IArrayType) {
            return this.resolveIArrayType((IArrayType)type, origin);
        }
        if (type instanceof IBasicType) {
            return this.resolveIBasicType((IBasicType)type, origin);
        }
        if (type instanceof ICompositeType) {
            return this.resolveICompositeType((ICompositeType)type, origin);
        }
        if (type instanceof ICPPAliasTemplate) {
            return this.resolveICPPAliasTemplate((ICPPAliasTemplate)type, origin);
        }
        if (type instanceof ICPPParameterPackType) {
            return this.resolveICPPParameterPackType((ICPPParameterPackType)type, origin);
        }
        if (type instanceof ICPPReferenceType) {
            return this.resolveICPPReferenceType((ICPPReferenceType)type, origin);
        }
        if (type instanceof ICPPTemplateTypeParameter) {
            return this.resolveICPPTemplateTypeParameter((ICPPTemplateTypeParameter)type, origin);
        }
        if (type instanceof ICPPTypeSpecialization) {
            return this.resolveICPPTypeSpecialization((ICPPTypeSpecialization)type, origin);
        }
        if (type instanceof ICPPUnaryTypeTransformation) {
            return this.resolveICPPUnaryTypeTransformation((ICPPUnaryTypeTransformation)type, origin);
        }
        if (type instanceof ICPPUnknownType) {
            return this.resolveICPPUnknownType((ICPPUnknownType)type, origin);
        }
        if (type instanceof IEnumeration) {
            return this.resolveIEnumeration((IEnumeration)type, origin);
        }
        if (type instanceof IFunctionType) {
            return this.resolveIFunctionType((IFunctionType)type, origin);
        }
        if (type instanceof IIndexType) {
            return this.resolveIIndexType((IIndexType)type, origin);
        }
        if (type instanceof IPointerType) {
            return this.resolveIPointerType((IPointerType)type, origin);
        }
        if (type instanceof IProblemBinding) {
            return this.resolveIProblemBinding((IProblemBinding)type, origin);
        }
        if (type instanceof IProblemType) {
            return this.resolveIProblemType((IProblemType)type);
        }
        if (type instanceof IQualifierType) {
            return this.resolveIQualifierType((IQualifierType)type, origin);
        }
        if (type instanceof ITypedef) {
            return this.resolveITypedef((ITypedef)type, origin);
        }
        if (type instanceof ITypeContainer) {
            return this.resolveITypeContainer((ITypeContainer)type, origin);
        }
        if (type instanceof FunctionSetType) {
            return this.resolveFunctionSetType((FunctionSetType)type, origin);
        }
        if (type == null) {
            this.out("resolveType has null type");
        }
        throw new RuntimeException("TypeResolver encountered unknown type " + type.getClass().getSimpleName() + " @ " + String.valueOf(origin));
    }

    private IConstructor resolveIArrayType(IArrayType type, ISourceLocation origin) {
        IConstructor baseType = this.resolveType(type.getType(), origin);
        org.eclipse.cdt.core.dom.ast.IValue size = type.getSize();
        if (size == null || size.numberValue() == null) {
            return this.builder.TypeSymbol_array(baseType);
        }
        return this.builder.TypeSymbol_array(baseType, (IValue)this.vf.integer(size.numberValue().intValue()));
    }

    private IConstructor resolveIBasicType(IBasicType type, ISourceLocation origin) {
        if (type instanceof ICBasicType) {
            return this.resolveICBasicType((ICBasicType)type, origin);
        }
        if (type instanceof ICPPBasicType) {
            return this.resolveICPPBasicType((ICPPBasicType)type, origin);
        }
        throw new RuntimeException("Unknown IBasicType subtype " + type.getClass().getSimpleName() + " @ " + String.valueOf(origin));
    }

    private IConstructor resolveICBasicType(ICBasicType type, ISourceLocation origin) {
        IListWriter modifiers = this.vf.listWriter();
        if (type.isSigned()) {
            modifiers.append(new IValue[]{this.builder.TypeModifier_signed()});
        }
        if (type.isUnsigned()) {
            modifiers.append(new IValue[]{this.builder.TypeModifier_unsigned()});
        }
        if (type.isShort()) {
            modifiers.append(new IValue[]{this.builder.TypeModifier_short()});
        }
        if (type.isLong()) {
            modifiers.append(new IValue[]{this.builder.TypeModifier_long()});
        }
        if (type.isLongLong()) {
            modifiers.append(new IValue[]{this.builder.TypeModifier_longlong()});
        }
        if (type.isComplex()) {
            modifiers.append(new IValue[]{this.builder.TypeModifier_complex()});
        }
        if (type.isImaginary()) {
            modifiers.append(new IValue[]{this.builder.TypeModifier_imaginary()});
        }
        this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_unspecified());
        switch (type.getKind()) {
            case eUnspecified: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_unspecified());
            }
            case eVoid: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_void());
            }
            case eChar: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_char());
            }
            case eWChar: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_wchar());
            }
            case eInt: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_int());
            }
            case eFloat: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_float());
            }
            case eDouble: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_double());
            }
            case eBoolean: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_boolean());
            }
            case eChar16: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_boolean());
            }
            case eChar32: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_char32());
            }
            case eNullPtr: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_nullPtr());
            }
            case eInt128: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_int128());
            }
            case eFloat128: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_float128());
            }
            case eDecimal32: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_decimal32());
            }
            case eDecimal64: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_decimal64());
            }
            case eDecimal128: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_decimal128());
            }
        }
        throw new RuntimeException("Unknown ICBasicType kind " + type.getKind().name() + " @ " + String.valueOf(origin));
    }

    private IConstructor resolveICPPBasicType(ICPPBasicType type, ISourceLocation origin) {
        IListWriter modifiers = this.vf.listWriter();
        if (type.isSigned()) {
            modifiers.append(new IValue[]{this.builder.TypeModifier_signed()});
        }
        if (type.isUnsigned()) {
            modifiers.append(new IValue[]{this.builder.TypeModifier_unsigned()});
        }
        if (type.isShort()) {
            modifiers.append(new IValue[]{this.builder.TypeModifier_short()});
        }
        if (type.isLong()) {
            modifiers.append(new IValue[]{this.builder.TypeModifier_long()});
        }
        if (type.isLongLong()) {
            modifiers.append(new IValue[]{this.builder.TypeModifier_longlong()});
        }
        if (type.isComplex()) {
            modifiers.append(new IValue[]{this.builder.TypeModifier_complex()});
        }
        if (type.isImaginary()) {
            modifiers.append(new IValue[]{this.builder.TypeModifier_imaginary()});
        }
        this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_unspecified());
        switch (type.getKind()) {
            case eUnspecified: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_unspecified());
            }
            case eVoid: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_void());
            }
            case eChar: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_char());
            }
            case eWChar: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_wchar());
            }
            case eInt: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_int());
            }
            case eFloat: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_float());
            }
            case eDouble: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_double());
            }
            case eBoolean: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_boolean());
            }
            case eChar16: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_boolean());
            }
            case eChar32: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_char32());
            }
            case eNullPtr: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_nullPtr());
            }
            case eInt128: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_int128());
            }
            case eFloat128: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_float128());
            }
            case eDecimal32: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_decimal32());
            }
            case eDecimal64: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_decimal64());
            }
            case eDecimal128: {
                return this.builder.TypeSymbol_basicType((IList)modifiers.done(), this.builder.TypeSymbol_decimal128());
            }
        }
        throw new RuntimeException("Unknown ICPPBasicType kind " + type.getKind().name() + " @ " + String.valueOf(origin));
    }

    private IConstructor resolveICompositeType(ICompositeType type, ISourceLocation origin) {
        if (type instanceof ICPPClassSpecialization) {
            return this.resolveICPPClassSpecialization((ICPPClassSpecialization)type, origin);
        }
        if (type instanceof ICPPClassTemplate) {
            return this.resolveICPPClassTemplate((ICPPClassTemplate)type, origin);
        }
        if (type instanceof ICPPDeferredClassInstance) {
            return this.resolveICPPDeferredClassInstance((ICPPDeferredClassInstance)type, origin);
        }
        if (type instanceof ICPPUnknownMemberClass) {
            return this.resolveICPPUnknownMemberClass((ICPPUnknownMemberClass)type, origin);
        }
        if (type instanceof IPDOMCPPClassType) {
            return this.resolveICPPClassType((ICPPClassType)type, origin);
        }
        if (type instanceof ICPPClassType) {
            return this.resolveICPPClassType((ICPPClassType)type, origin);
        }
        if (type instanceof CStructure) {
            return this.resolveCStructure((CStructure)type, origin);
        }
        throw new RuntimeException("NYI: resolveICompositeType " + String.valueOf(type) + " @ " + String.valueOf(origin));
    }

    private IConstructor resolveCStructure(CStructure type, ISourceLocation origin) {
        return this.builder.TypeSymbol_struct(this.getDecl((IBinding)type, origin));
    }

    private IConstructor resolveICPPClassType(ICPPClassType type, ISourceLocation origin) {
        switch (type.getKey()) {
            case 1: {
                return this.builder.TypeSymbol_struct(this.getDecl((IBinding)type, origin));
            }
            case 2: {
                return this.builder.TypeSymbol_union(this.getDecl((IBinding)type, origin));
            }
            case 3: {
                return this.builder.TypeSymbol_class(this.getDecl((IBinding)type, origin));
            }
        }
        throw new RuntimeException("Unknown ICompositeType key " + type.getKey() + " @ " + String.valueOf(origin));
    }

    private IConstructor resolveICPPClassSpecialization(ICPPClassSpecialization type, ISourceLocation origin) {
        ISourceLocation decl = this.getDecl((IBinding)type.getSpecializedBinding(), origin);
        ICPPTemplateParameterMap parameterMap = type.getTemplateParameterMap();
        IList templateParameters = (IList)this.resolveArguments(this.streamArguments(parameterMap), origin).collect(this.vf.listWriter());
        return this.builder.TypeSymbol_classSpecialization(decl, templateParameters);
    }

    private IConstructor resolveICPPClassTemplate(ICPPClassTemplate type, ISourceLocation origin) {
        IListWriter baseClassTypes = this.vf.listWriter();
        Stream.of(type.getBases()).forEach(it -> baseClassTypes.append(new IValue[]{this.resolveType(it.getBaseClassType(), origin)}));
        switch (type.getKey()) {
            case 1: {
                return this.resolveICPPClassType((ICPPClassType)type, origin);
            }
            case 2: {
                break;
            }
            case 3: {
                ICPPClassTemplatePartialSpecialization[] specs = type.getPartialSpecializations();
                if (specs.length > 0) {
                    throw new RuntimeException("ICPPClassTemplate has partial specializations!");
                }
                return this.resolveICPPClassType((ICPPClassType)type, origin);
            }
            default: {
                throw new RuntimeException("Unknown ICompositeType key " + type.getKey());
            }
        }
        throw new RuntimeException("NYI: resolveICPPClassTemplate");
    }

    private IConstructor resolveICPPDeferredClassInstance(ICPPDeferredClassInstance type, ISourceLocation origin) {
        return this.builder.TypeSymbol_deferredClassInstance(type.toString());
    }

    private IConstructor resolveICPPUnknownMemberClass(ICPPUnknownMemberClass type, ISourceLocation origin) {
        return this.builder.TypeSymbol_unknownMemberClass(this.getDecl(type.getOwner(), origin), type.getName());
    }

    private IConstructor resolveICPPAliasTemplate(ICPPAliasTemplate type, ISourceLocation origin) {
        IList params = this.handleTemplateParameters(type.getTemplateParameters(), origin);
        ISourceLocation decl = this.br.resolveBinding((ICPPBinding)type, origin);
        IConstructor definedType = this.resolveType(type.getType(), origin);
        return this.builder.TypeSymbol_aliasTemplate(decl, params, definedType);
    }

    private IConstructor resolveICPPParameterPackType(ICPPParameterPackType type, ISourceLocation origin) {
        return this.builder.TypeSymbol_parameterPackType(this.resolveType(type.getType(), origin));
    }

    private IConstructor resolveICPPReferenceType(ICPPReferenceType type, ISourceLocation origin) {
        return this.builder.TypeSymbol_referenceType(this.resolveType(type.getType(), origin));
    }

    private IConstructor resolveICPPTemplateTypeParameter(ICPPTemplateTypeParameter type, ISourceLocation origin) {
        if (type instanceof CPPTemplateTypeParameter) {
            return this.builder.TypeSymbol_templateTypeParameter(this.getDecl(type.getOwner(), origin), this.getDecl((IBinding)type, origin));
        }
        if (type instanceof CPPImplicitTemplateTypeParameter) {
            return this.builder.TypeSymbol_implicitTemplateTypeParameter(this.getDecl(type.getOwner(), origin), (IValue)this.vf.integer((int)type.getParameterPosition()));
        }
        throw new RuntimeException("NYI: resolveICPPTemplateTypeParameter " + type.getClass().getSimpleName() + ": " + String.valueOf(type));
    }

    private IConstructor resolveICPPTypeSpecialization(ICPPTypeSpecialization type, ISourceLocation origin) {
        if (type instanceof ICPPClassSpecialization) {
            return this.resolveICPPClassSpecialization((ICPPClassSpecialization)type, origin);
        }
        if (type instanceof ICPPEnumerationSpecialization) {
            return this.resolveICPPEnumerationSpecialization((ICPPEnumerationSpecialization)type, origin);
        }
        throw new RuntimeException("resolveICPPTypeSpecialization encountered unknown subtype @ " + String.valueOf(origin));
    }

    private IConstructor resolveICPPEnumerationSpecialization(ICPPEnumerationSpecialization type, ISourceLocation origin) {
        ISourceLocation specializedBinding = this.getDecl((IBinding)type.getSpecializedBinding(), origin);
        ICPPTemplateParameterMap templateParameterMap = type.getTemplateParameterMap();
        IList templateArguments = (IList)this.resolveArguments(this.streamArguments(templateParameterMap), origin).collect(this.vf.listWriter());
        return this.builder.TypeSymbol_enumerationSpecialization(specializedBinding, templateArguments);
    }

    private IConstructor resolveICPPUnaryTypeTransformation(ICPPUnaryTypeTransformation type, ISourceLocation origin) {
        assert (type.getOperator().equals((Object)ICPPUnaryTypeTransformation.Operator.underlying_type));
        IConstructor operand = this.resolveType(type.getOperand(), origin);
        return this.builder.TypeSymbol_transformToUnderlyingType(operand);
    }

    private IConstructor resolveICPPUnknownType(ICPPUnknownType type, ISourceLocation origin) {
        if (type instanceof TypeOfDependentExpression) {
            return this.builder.TypeSymbol_typeOfDependentExpression(String.join((CharSequence)".", ((TypeOfDependentExpression)type).getQualifiedName()));
        }
        if (type instanceof TypeOfUnknownMember) {
            return this.builder.TypeSymbol_typeOfUnknownMember(String.join((CharSequence)".", ((TypeOfUnknownMember)type).getQualifiedName()));
        }
        throw new RuntimeException("NYI: resolveICPPUnknownType (" + type.getClass().getSimpleName() + ") @ " + String.valueOf(origin));
    }

    private IConstructor resolveIEnumeration(IEnumeration type, ISourceLocation origin) {
        ISourceLocation decl = this.br.resolveBinding(null, (IBinding)type, origin);
        return this.builder.TypeSymbol_enumeration(decl);
    }

    private IConstructor resolveIFunctionType(IFunctionType type, ISourceLocation origin) {
        IConstructor returnType = this.resolveType(type.getReturnType(), origin);
        IListWriter parameterTypes = this.vf.listWriter();
        Stream.of(type.getParameterTypes()).forEach(it -> {
            if (it == null) {
                parameterTypes.append(new IValue[]{this.builder.TypeSymbol___nullType()});
            } else {
                parameterTypes.append(new IValue[]{this.resolveType((IType)it, origin)});
            }
        });
        if (type.takesVarArgs()) {
            return this.builder.TypeSymbol_functionTypeVarArgs(returnType, (IList)parameterTypes.done());
        }
        return this.builder.TypeSymbol_functionType(returnType, (IList)parameterTypes.done());
    }

    private IConstructor resolveIIndexType(IIndexType type, ISourceLocation origin) {
        throw new RuntimeException("NYI: resolveIIndexType " + String.valueOf(type) + " @ " + String.valueOf(origin));
    }

    private IConstructor resolveIPointerType(IPointerType type, ISourceLocation origin) {
        IListWriter modifiers = this.vf.listWriter();
        if (type.isConst()) {
            modifiers.append(new IValue[]{this.builder.TypeModifier_const()});
        }
        if (type.isVolatile()) {
            modifiers.append(new IValue[]{this.builder.TypeModifier_volatile()});
        }
        if (type.isRestrict()) {
            modifiers.append(new IValue[]{this.builder.TypeModifier_restrict()});
        }
        return this.builder.TypeSymbol_pointerType((IList)modifiers.done(), this.resolveType(type.getType(), origin));
    }

    private IConstructor resolveIProblemBinding(IProblemBinding type, ISourceLocation origin) {
        return (IConstructor)this.builder.TypeSymbol_problemBinding().asWithKeywordParameters().setParameter("src", (IValue)origin);
    }

    private IConstructor resolveIProblemType(IProblemType type) {
        return this.builder.TypeSymbol_problemType(type.getMessage());
    }

    private IConstructor resolveIQualifierType(IQualifierType type, ISourceLocation origin) {
        IConstructor baseType = this.resolveType(type.getType(), origin);
        IListWriter modifiers = this.vf.listWriter();
        if (type.isConst()) {
            modifiers.append(new IValue[]{this.builder.TypeModifier_const()});
        }
        if (type.isVolatile()) {
            modifiers.append(new IValue[]{this.builder.TypeModifier_volatile()});
        }
        return this.builder.TypeSymbol_qualifierType((IList)modifiers.done(), baseType);
    }

    private IConstructor resolveITypeContainer(ITypeContainer type, ISourceLocation origin) {
        return this.builder.TypeSymbol_typeContainer(this.resolveType(type.getType(), origin));
    }

    private Stream<IConstructor> resolveArguments(Stream<ICPPTemplateArgument> stream, ISourceLocation origin) {
        return stream.filter(arg -> arg != null).map(arg -> {
            if (arg.isTypeValue()) {
                return this.resolveType(arg.getTypeValue(), origin);
            }
            return this.resolveType(arg.getNonTypeEvaluation().getType(), origin);
        });
    }

    private Stream<ICPPTemplateArgument> streamArguments(ICPPTemplateParameterMap parameterMap) {
        return Stream.of(parameterMap.getAllParameterPositions()).map(it -> parameterMap.getArgument(it.intValue()));
    }

    private IConstructor resolveITypedef(ITypedef type, ISourceLocation origin) {
        if (type instanceof ICPPAliasTemplateInstance) {
            ICPPAliasTemplateInstance ati = (ICPPAliasTemplateInstance)type;
            IList templateParameters = (IList)this.resolveArguments(this.streamArguments(ati.getTemplateParameterMap()), origin).collect(this.vf.listWriter());
            return this.builder.TypeSymbol_aliasTemplateInstance(this.getDecl(ati.getSpecializedBinding(), origin), templateParameters);
        }
        return this.builder.TypeSymbol_typedef(this.resolveType(type.getType(), origin));
    }

    private IConstructor resolveFunctionSetType(FunctionSetType type, ISourceLocation origin) {
        CPPFunctionSet functionSet = type.getFunctionSet();
        ISourceLocation binding = this.getDecl((IBinding)functionSet.getBindings()[0], origin);
        IListWriter templateArguments = this.vf.listWriter();
        if (functionSet.getTemplateArguments() != null) {
            Stream.of(functionSet.getTemplateArguments()).forEach(it -> {
                if (it instanceof CPPTemplateTypeArgument) {
                    templateArguments.append(new IValue[]{this.resolveType(it.getTypeValue(), origin)});
                } else if (it instanceof CPPTemplateNonTypeArgument) {
                    templateArguments.append(new IValue[]{this.resolveType(it.getTypeOfNonTypeValue(), origin)});
                } else {
                    throw new RuntimeException("Unknown template argument type " + String.valueOf(it.getClass()) + " @ " + String.valueOf(origin));
                }
            });
        }
        if (IASTExpression.ValueCategory.LVALUE.equals((Object)type.getValueCategory())) {
            return this.builder.TypeSymbol_functionSetType(binding, (IList)templateArguments.done());
        }
        return this.builder.TypeSymbol_functionSetTypePointer(binding, (IList)templateArguments.done());
    }
}

