---
title: "module lang::cpp::ASTgen"
id: ASTgen
slug: /Packages/org.rascalmpl.clair/API/lang/cpp/ASTgen
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.clair-0.13.2</div>

Java code generator used to bootstrap the mapping from CDT to Rascal data types.
#### Usage

```rascal
import lang::cpp::ASTgen;
```

#### Dependencies
```rascal
import lang::cpp::AST;
import lang::cpp::M3;
import lang::cpp::TypeSymbol;
import Type;
import List;
import String;
import IO;
```


## function generate {#lang-cpp-ASTgen-generate}

```rascal
void generate()

str generate(str apiName, list[type[value]] types)
```

## function declareType {#lang-cpp-ASTgen-declareType}

```rascal
str declareType(adt(str name, list[Symbol] _), Production choice)
```

## function declareConstructor {#lang-cpp-ASTgen-declareConstructor}

```rascal
str declareConstructor(Production::cons(label(str cname, Symbol _), list[Symbol] args, list[Symbol] _ /*kwTypes*/, set[Attr] _), str typeName)
```

## function type2FactoryCall {#lang-cpp-ASTgen-type2FactoryCall}

```rascal
str type2FactoryCall(Symbol t)
```

## function typeList2FactoryVarArgs {#lang-cpp-ASTgen-typeList2FactoryVarArgs}

```rascal
str typeList2FactoryVarArgs(list[Symbol] tss)
```

## function typeList2FactoryVarArgsFirstPos {#lang-cpp-ASTgen-typeList2FactoryVarArgsFirstPos}

```rascal
str typeList2FactoryVarArgsFirstPos(list[Symbol] tss)
```

## function toExtraArgs {#lang-cpp-ASTgen-toExtraArgs}

```rascal
str toExtraArgs(list[str] strs)
```

## function typeNameTuples2FactoryCallArgs {#lang-cpp-ASTgen-typeNameTuples2FactoryCallArgs}

```rascal
str typeNameTuples2FactoryCallArgs(list[Symbol] args)
```

## function declareMakers {#lang-cpp-ASTgen-declareMakers}

```rascal
str declareMakers(adt(str _, list[Symbol] _), set[Production] cs)
```

## function hasDecl {#lang-cpp-ASTgen-hasDecl}

```rascal
bool hasDecl("Declarator", str _)

bool hasDecl("DeclSpecifier", "declSpecifier")

bool hasDecl("DeclSpecifier", str _)

bool hasDecl("Declaration", str cname)

bool hasDecl("Expression", str cname)

bool hasDecl("Statement", str cname)

bool hasDecl("Name", "qualifiedName")

bool hasDecl("Name", "templateId")

bool hasDecl(str _, str _)
```

## function hasTyp {#lang-cpp-ASTgen-hasTyp}

```rascal
bool hasTyp("Expression", str cname)

bool hasTyp("Name", "conversionName")

default bool hasTyp(str _, str _)
```

## function hasAttrs {#lang-cpp-ASTgen-hasAttrs}

```rascal
bool hasAttrs("Declarator", str cname)

bool hasAttrs("DeclSpecifier", str cname)

bool hasAttrs("Declaration", str cname)

bool hasAttrs("Expression", "arrayModifier")

bool hasAttrs("Statement", str cname)

default bool hasAttrs(_, _)
```

## function declareMaker {#lang-cpp-ASTgen-declareMaker}

```rascal
str declareMaker(Production::cons(label(str cname, Symbol typ:adt(str typeName, list[Symbol] _)), list[Symbol] args, list[Symbol] _ /*kwTypes*/,set[Attr] _))
```

## function declareConsArgs {#lang-cpp-ASTgen-declareConsArgs}

```rascal
str declareConsArgs(list[Symbol] args)
```

## function callConsArgs {#lang-cpp-ASTgen-callConsArgs}

```rascal
str callConsArgs( list[Symbol] args)
```

## function argToSimpleJavaArg {#lang-cpp-ASTgen-argToSimpleJavaArg}

```rascal
str argToSimpleJavaArg(str l, Symbol t)
```

## function typeToSimpleJavaType {#lang-cpp-ASTgen-typeToSimpleJavaType}

```rascal
str typeToSimpleJavaType(Symbol t)
```

## function javaResult {#lang-cpp-ASTgen-javaResult}

```rascal
str javaResult(Symbol t, str access)
```

## function typeToJavaType {#lang-cpp-ASTgen-typeToJavaType}

```rascal
str typeToJavaType(Symbol t)
```

