---
title: "module lang::cpp::M3"
id: M3
slug: /Packages/org.rascalmpl.clair/API/lang/cpp/M3
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.clair-0.13.2</div>

#### Usage

```rascal
import lang::cpp::M3;
```

#### Dependencies
```rascal
extend analysis::m3::Core;
import IO;
import Node;
import String;
import lang::cpp::AST;
import lang::cpp::TypeSymbol;
import Relation;
import analysis::graphs::Graph;
import analysis::m3::Registry;
```


## data M3 {#lang-cpp-M3-M3}
Language specific extensions to M3 for the C and C++ languages.

```rascal
data M3 (
  set[loc] implicitDeclarations = {},
  rel[loc base, loc derived] extends = {},
  rel[loc caller, loc callee] methodInvocations = {},
  rel[loc field, loc accesser] fieldAccess = {},
  rel[loc caller, loc typeName] typeDependency = {},
  rel[loc base, loc override] methodOverrides = {},
  rel[loc file, loc macro] macroExpansions = {},		//not in included files
  rel[loc macro, loc src] macroDefinitions = {},
  rel[loc directive, loc occurrence] includeDirectives = {},
  rel[loc directive, loc occurrence] inactiveIncludes = {},
  rel[loc directive, loc resolved] includeResolution = {},
  rel[loc decl, TypeSymbol typ] declaredType = {},
  rel[loc decl, loc visiblity] memberAccessModifiers = {},
  rel[loc decl, loc src] functionDefinitions = {},
  rel[loc decl, loc src] cFunctionsToNoArgs = {},
  rel[loc decl, loc impl] declarationToDefinition = {},
  rel[loc directive, loc file] unresolvedIncludes = {},
  list[loc] comments = [],
  
  rel[loc includer, loc includee] requires = {},
  rel[loc provider, loc providee] provides = {},
  rel[loc decl, loc file] partOf = {},
  rel[loc caller, loc callee] callGraph = {}
)
```

## function cppASTToM3 {#lang-cpp-M3-cppASTToM3}

Enriches the initial M3 model with everything we can learn from the AST.

```rascal
M3 cppASTToM3(Declaration tu, M3 model = m3(tu.src.top))
```


This function is used by:
* [Create M3 And Ast From Cpp File](../../../../..//Packages/org.rascalmpl.clair/API/lang/cpp/M3.md#lang-cpp-M3-createM3AndAstFromCppFile)
* [Create M3 And Ast From C File](../../../../..//Packages/org.rascalmpl.clair/API/lang/cpp/M3.md#lang-cpp-M3-createM3AndAstFromCFile)
* [Create M3 From Cpp File](../../../../..//Packages/org.rascalmpl.clair/API/lang/cpp/M3.md#lang-cpp-M3-createM3FromCppFile)
* [Create M3 From C File](../../../../..//Packages/org.rascalmpl.clair/API/lang/cpp/M3.md#lang-cpp-M3-createM3FromCFile)

It enriches an initial M3 model with additional information by extracting facts 
from the tu (translation unit) that is passed as a parameter. The resulting M3
model is more complete, and ready to be comined with others using [Compose Cpp M3](../../../../..//Packages/org.rascalmpl.clair/API/lang/cpp/M3.md#lang-cpp-M3-composeCppM3).

## function extractCallGraph {#lang-cpp-M3-extractCallGraph}

extracts dependencies between every declaration and every name that is used in it, that is not-not a "call"

```rascal
rel[loc caller, loc callee] extractCallGraph(Declaration ast)
```

## function extractCallGraph {#lang-cpp-M3-extractCallGraph}

extracts dependencies between every declaration and every name that is used in it, that is not-not a "call"

```rascal
rel[loc caller, loc callee] extractCallGraph(set[Declaration] asts)
```

## function pretty {#lang-cpp-M3-pretty}

```rascal
loc pretty(loc subject)

str pretty(str path)
```

## function loseCArgs {#lang-cpp-M3-loseCArgs}

```rascal
loc loseCArgs(loc subject)
```

## function dropCArgs {#lang-cpp-M3-dropCArgs}

```rascal
str dropCArgs(str path)
```

## function deriveAccessModifiers {#lang-cpp-M3-deriveAccessModifiers}

```rascal
rel[loc, loc] deriveAccessModifiers(Declaration tu)

rel[loc, loc] deriveAccessModifiers(list[Declaration] declarations, bool isStruct)
```

## function makeEntry {#lang-cpp-M3-makeEntry}

```rascal
rel[loc, loc] makeEntry(Declaration declaration, loc current)
```

## function createM3FromCFile {#lang-cpp-M3-createM3FromCFile}

Parse C files and produce an pre-filled M3 modelConsistencyAddressBook.

```rascal
M3 createM3FromCFile(loc file, str charset=DEFAULT_CHARSET, bool inferCharset=!(charset?), list[loc] stdLib = [], list[loc] includeDirs = [], map[str,str] standardMacros = provideStandardMacros(), map[str,str] additionalMacros = (), bool includeStdLib = false)
```


This starts from the output of [Parse C To M3 And Ast](../../../../..//Packages/org.rascalmpl.clair/API/lang/cpp/M3.md#lang-cpp-M3-parseCToM3AndAst) and completes the M3 model with 
a number of useful relations. 

#### Pitfalls


* this represents only the information for one file. For whole program analysis see [Compose Cpp M3](../../../../..//Packages/org.rascalmpl.clair/API/lang/cpp/M3.md#lang-cpp-M3-composeCppM3). 

## function createM3FromCppFile {#lang-cpp-M3-createM3FromCppFile}

Parse C++ files and produce an pre-filled M3 model.

```rascal
M3 createM3FromCppFile(loc file, str charset=DEFAULT_CHARSET, bool inferCharset=!(charset?), list[loc] stdLib = classPaths["vs12"], list[loc] includeDirs = [], map[str,str] standardMacros = provideStandardMacros(), map[str,str] additionalMacros = (), bool includeStdLib = false)
```


This starts from the output of [Parse Cpp To M3 And Ast](../../../../..//Packages/org.rascalmpl.clair/API/lang/cpp/M3.md#lang-cpp-M3-parseCppToM3AndAst) and completes the M3 model with 
a number of useful relations.

#### Pitfalls


* this represents only the information for one file. For whole program analysis see [Compose Cpp M3](../../../../..//Packages/org.rascalmpl.clair/API/lang/cpp/M3.md#lang-cpp-M3-composeCppM3). 

## function createM3AndAstFromCFile {#lang-cpp-M3-createM3AndAstFromCFile}

Parse C files and produce an pre-filled M3 model with a fully annotated AST.

```rascal
tuple[M3, Declaration] createM3AndAstFromCFile(loc file, str charset=DEFAULT_CHARSET, bool inferCharset=!(charset?), list[loc] stdLib = [], list[loc] includeDirs = [], map[str,str] standardMacros = provideStandardMacros(), map[str,str] additionalMacros = (), bool includeStdLib = false)
```


This starts from the output of [Parse C To M3 And Ast](../../../../..//Packages/org.rascalmpl.clair/API/lang/cpp/M3.md#lang-cpp-M3-parseCToM3AndAst) and completes the M3 model with 
a number of useful relations. 

#### Pitfalls


* this represents only the information for one file. For whole program analysis see [Compose Cpp M3](../../../../..//Packages/org.rascalmpl.clair/API/lang/cpp/M3.md#lang-cpp-M3-composeCppM3). 

## function createM3AndAstFromCppFile {#lang-cpp-M3-createM3AndAstFromCppFile}

Parse C++ files and produce an pre-filled M3 model with a fully annotated AST.

```rascal
tuple[M3, Declaration] createM3AndAstFromCppFile(loc file, str charset=DEFAULT_CHARSET, bool inferCharset=!(charset?), list[loc] stdLib = classPaths["vs12"], list[loc] includeDirs = [], map[str,str] standardMacros = provideStandardMacros(), map[str,str] additionalMacros = (), bool includeStdLib = false)
```


This starts from the output of [Parse Cpp To M3 And Ast](../../../../..//Packages/org.rascalmpl.clair/API/lang/cpp/M3.md#lang-cpp-M3-parseCppToM3AndAst) and completes the M3 model with 
a number of useful relations. 

#### Pitfalls


* this represents only the information for one file. For whole program analysis see [Compose Cpp M3](../../../../..//Packages/org.rascalmpl.clair/API/lang/cpp/M3.md#lang-cpp-M3-composeCppM3). 

## function parseCppToM3AndAst {#lang-cpp-M3-parseCppToM3AndAst}

Parse C++ files and produce an initial M3 model with a fully annotated AST

```rascal
tuple[M3, Declaration] parseCppToM3AndAst(loc file, str charset=DEFAULT_CHARSET, bool inferCharset=!(charset?), list[loc] stdLib = classPaths["vs12"], list[loc] includeDirs = [], map[str,str] standardMacros = provideStandardMacros(), map[str,str] additionalMacros = (), bool includeStdLib = false)
```


This is the main workhorse of Clair. For every C++ file an accurate syntax tree is produced.
Next to this an **initial** M3 model is prepared, which contains information which could readily
be collected during the construction of the syntax tree.

See [Create M3 And Ast From Cpp File](../../../../..//Packages/org.rascalmpl.clair/API/lang/cpp/M3.md#lang-cpp-M3-createM3AndAstFromCppFile) for a more comprehensive (better filled) M3 model. That
function uses the current one. 

#### Benefits


* This reuses the CDT parser which has great coverage of many C++ dialects.
* This is accurately representing C++ syntax and static semantics

#### Pitfalls


* Accuracy of the AST and the M3 model depend greatly on the `stdLib` and `includeDirs` parameters.
If those are not fitting the current project and its files, then this function will produce lots of
`problems` and also possibly have the wrong resolutions for names and types.
* These models are just for one file. For whole program analysis see [Compose Cpp M3](../../../../..//Packages/org.rascalmpl.clair/API/lang/cpp/M3.md#lang-cpp-M3-composeCppM3).
* It's probably better to use [Create M3 And Ast From Cpp File](../../../../..//Packages/org.rascalmpl.clair/API/lang/cpp/M3.md#lang-cpp-M3-createM3AndAstFromCppFile), since that has a more complete M3 model.

## function parseCToM3AndAst {#lang-cpp-M3-parseCToM3AndAst}

Parse C files and produce an initial M3 model with a fully annotated AST

```rascal
tuple[M3, Declaration] parseCToM3AndAst(loc file, str charset=DEFAULT_CHARSET, bool inferCharset=!(charset?), list[loc] stdLib = [], list[loc] includeDirs = [], map[str,str] standardMacros = provideStandardMacros(), map[str,str] additionalMacros = (), bool includeStdLib = false)
```


This is the main workhorse of Clair. For every C file an accurate syntax tree is produced.
Next to this an **initial** M3 model is prepared, which contains information which could readily
be collected during the construction of the syntax tree.

See [Create M3 And Ast From Cpp File](../../../../..//Packages/org.rascalmpl.clair/API/lang/cpp/M3.md#lang-cpp-M3-createM3AndAstFromCppFile) for a more comprehensive (better filled) M3 model. That
function uses the current one. 

#### Benefits


* This reuses the CDT parser which has great coverage of many C dialects.
* This is accurately representing C syntax and static semantics

#### Pitfalls


* Accuracy of the AST and the M3 model depend greatly on the `stdLib` and `includeDirs` parameters.
If those are not fitting the current project and its files, then this function will produce lots of
`problems` and also possibly have the wrong resolutions for names and types.
* These models are just for one file. For whole program analysis see [Compose Cpp M3](../../../../..//Packages/org.rascalmpl.clair/API/lang/cpp/M3.md#lang-cpp-M3-composeCppM3).
* It's probably better to use [Create M3 And Ast From C File](../../../../..//Packages/org.rascalmpl.clair/API/lang/cpp/M3.md#lang-cpp-M3-createM3AndAstFromCFile), since that has a more complete M3 model.

## function composeCppM3 {#lang-cpp-M3-composeCppM3}

```rascal
M3 composeCppM3(loc id, set[M3] models)
```

## function closeOverriddenVirtualCalls {#lang-cpp-M3-closeOverriddenVirtualCalls}

fills out the call graph by adding the tuples for possible actual methods and constructors, and removing the corresponding calls to virtual methods and constructors.

```rascal
rel[loc caller, loc callee] closeOverriddenVirtualCalls(M3 comp)
```

