---
title: "module lang::cpp::TypeSymbol"
id: TypeSymbol
slug: /Packages/org.rascalmpl.clair/API/lang/cpp/TypeSymbol
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.clair-0.13.2</div>

Defines symbolic representations for C and C++ types
#### Usage

```rascal
import lang::cpp::TypeSymbol;
```

#### Dependencies
```rascal
import lang::cpp::AST;
```


## data TypeSymbol {#lang-cpp-TypeSymbol-TypeSymbol}

```rascal
data TypeSymbol  
     = \unspecified()
     | \void()
     | \char()
     | \wchar()
     | \int()
     | \float()
     | \double()
     | \boolean()
     | \char16()
     | \char32()
     | \nullPtr()
     | \int128()
     | \float128()
     | \decimal32()
     | \decimal64()
     | \decimal128()
     | \array(TypeSymbol baseType)
     | \array(TypeSymbol baseType, int size)
     | \basicType(list[TypeModifier] modifiers, TypeSymbol baseType)
     | \class(loc decl)
     | \union(loc decl)
     | \struct(loc decl)
     | \qualifierType(list[TypeModifier] modifiers, TypeSymbol \type)
     | \pointerType(list[TypeModifier] modifiers, TypeSymbol \type)
     | \functionType(TypeSymbol returnType, list[TypeSymbol] parameterTypes)
     | \functionTypeVarArgs(TypeSymbol returnType, list[TypeSymbol] parameterTypes)
     | \typeContainer(TypeSymbol \type)
     | \typedef(TypeSymbol \type)
     | \enumeration(loc decl)
     | \referenceType(TypeSymbol \type)
     | \parameterPackType(TypeSymbol \type)
     | \classSpecialization(loc decl, list[TypeSymbol] templateArguments)
     | \enumerationSpecialization(loc specializedBinding, list[TypeSymbol] templateArguments)
     | \aliasTemplateInstance(loc instantiatedTemplate, list[TypeSymbol] templateArguments)
     | \templateTypeParameter(loc owner, loc decl)
     | \implicitTemplateTypeParameter(loc owner, int position)
     | \deferredClassInstance(str name)
     | \unknownMemberClass(loc owner, str name)
     | \typeOfDependentExpression(str name)
     | \typeOfUnknownMember(str name)
     | \problemBinding()
     | \problemType(str msg)
     | \noType()
     | \cStructTemplate(loc decl, list[loc] templateParameters)
     | \cUnionTemplate(loc decl, list[loc] templateParameters)
     | \cClassTemplate(loc decl, list[loc] templateParameters)
     | \eStructTemplate(loc decl, list[loc] templateParameters)
     | \eUnionTemplate(loc decl, list[loc] templateParameters)
     | \eClassTemplate(loc decl, list[loc] templateParameters)
     | \eEnumTemplate(loc decl, list[loc] templateParameters)
     | \templateTemplate(TypeSymbol child, list[loc] templateParameters)
     | \functionTemplate(loc decl, list[loc] templateParameters)
     | \variableTemplate(loc decl, list[loc] templateParameters)
     | \aliasTemplate(loc decl, list[loc] templateParameters, TypeSymbol \type)
     | \functionSetType(loc decl, list[TypeSymbol] templateArguments)
     | \functionSetTypePointer(loc decl, list[TypeSymbol] templateArguments)
     | \transformToUnderlyingType(TypeSymbol operand)
     | \unresolved()
     | \any()
     | \__nullType()
     ;
```

## data TypeModifier {#lang-cpp-TypeSymbol-TypeModifier}

```rascal
data TypeModifier  
     = \signed()
     | \unsigned()
     | \short()
     | \long()
     | \longlong()
     | \complex()
     | \imaginary()
     | \static()
     | \const()
     | \volatile()
     | \restrict()
     ;
```

