/*
 * Decompiled with CFR 0.152.
 */
package lang.cpp.internal;

import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.FactParseError;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.io.StandardTextReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.util.UUID;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTGotoStatement;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.ILabel;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IProblemType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICExternalBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTAliasDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCapture;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceAlias;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTPointerToMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplatedTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPAliasTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPAliasTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecializationSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructorSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDeferredFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumerationSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFieldTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethodSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceAlias;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPartiallySpecializable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariableInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariableTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariableTemplatePartialSpecialization;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.internal.core.dom.parser.c.CEnumeration;
import org.eclipse.cdt.internal.core.dom.parser.c.CFunction;
import org.eclipse.cdt.internal.core.dom.parser.c.CVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPTwoPhaseBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownMemberClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownMemberClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionSet;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPClassType;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPEnumType;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPTemplateParameter;
import org.rascalmpl.uri.URIUtil;

public class BindingsResolver {
    private final IValueFactory vf;
    private final PrintWriter stdErr;
    public final ISourceLocation NYI;
    public final ISourceLocation FIXME;
    public ISetWriter containment;
    private ISourceLocation translationUnit;
    private ISourceLocation translationUnitRoot = URIUtil.rootLocation((String)"cpp+translationUnit");

    private void out(String msg) {
    }

    private void err(String msg) {
    }

    public ISet getContainmentRelation() {
        ISet result = (ISet)this.containment.done();
        this.containment = this.vf.setWriter();
        return result;
    }

    public void setTranslationUnit(ISourceLocation tu) {
        this.translationUnit = tu;
        this.containment = this.vf.setWriter();
    }

    public BindingsResolver(IValueFactory vf, PrintWriter stdOut, PrintWriter stdErr) {
        this.vf = vf;
        this.stdErr = stdErr;
        this.containment = vf.setWriter();
        this.translationUnit = URIUtil.rootLocation((String)"cpp+translationUnit");
        this.NYI = this.makeBinding("NYI", null, null);
        this.FIXME = this.makeBinding("FIXME", null, null);
    }

    private ISourceLocation ownedBinding(IBinding binding, String scheme, ISourceLocation origin) throws URISyntaxException {
        return this.ownedBinding(binding, scheme, "", origin, false);
    }

    private ISourceLocation ownedBinding(IBinding binding, String scheme, String postfix, ISourceLocation origin, boolean isStatic) throws URISyntaxException {
        String name = this.renameOperators(binding.getName()) + postfix;
        ISourceLocation ownerLocation = this.resolveOwner(binding, origin);
        ISourceLocation location = null;
        boolean isAtRoot = "cpp+translationUnit".equals(ownerLocation.getScheme());
        if (isStatic) {
            if (isAtRoot) {
                location = URIUtil.changeScheme((ISourceLocation)URIUtil.getChildLocation((ISourceLocation)this.translationUnit, (String)name), (String)scheme);
                ownerLocation = this.translationUnit;
            } else {
                location = URIUtil.changeScheme((ISourceLocation)URIUtil.getChildLocation((ISourceLocation)ownerLocation, (String)name), (String)scheme);
            }
        } else if (isAtRoot) {
            location = URIUtil.correctLocation((String)scheme, (String)"", (String)name);
            ownerLocation = this.translationUnit;
        } else {
            location = URIUtil.changeScheme((ISourceLocation)URIUtil.getChildLocation((ISourceLocation)ownerLocation, (String)name), (String)scheme);
        }
        this.containment.append(new IValue[]{this.vf.tuple(new IValue[]{ownerLocation, location})});
        return location;
    }

    private String renameOperators(String name) {
        if (this.isOperatorName((String)name)) {
            name = "operator(" + ((String)name).substring("operator ".length()) + ")";
        }
        return name;
    }

    private ISourceLocation resolveOwner(IBinding binding, ISourceLocation origin) throws URISyntaxException {
        if (binding == null) {
            return this.translationUnitRoot;
        }
        IBinding owner = binding.getOwner();
        if (binding.equals(owner)) {
            return URIUtil.correctLocation((String)"circular", (String)"", (String)UUID.randomUUID().toString());
        }
        if (owner == null) {
            return this.translationUnitRoot;
        }
        return this.resolveBinding(null, owner, origin);
    }

    public static ISourceLocation failedBinding(String scheme) {
        return URIUtil.correctLocation((String)scheme, (String)"", (String)UUID.randomUUID().toString());
    }

    public ISourceLocation resolveBinding(IASTNameOwner owner, IBinding binding, ISourceLocation origin) {
        try {
            if (binding == null) {
                return BindingsResolver.failedBinding("unresolved");
            }
            if (binding instanceof ICExternalBinding) {
                return this.resolveICExternalBinding((ICExternalBinding)binding, origin);
            }
            if (binding instanceof ICompositeType) {
                return this.resolveICompositeType((ICompositeType)binding, origin);
            }
            if (binding instanceof IEnumeration) {
                return this.resolveIEnumeration((IEnumeration)binding, origin);
            }
            if (binding instanceof IEnumerator) {
                return this.resolveIEnumerator((IEnumerator)binding, origin);
            }
            if (binding instanceof IFunction) {
                return this.resolveIFunction((IFunction)binding, origin);
            }
            if (binding instanceof IIndexBinding) {
                return this.resolveIIndexBinding((IIndexBinding)binding, origin);
            }
            if (binding instanceof ILabel) {
                return this.resolveILabel((ILabel)binding, origin);
            }
            if (binding instanceof IMacroBinding) {
                return this.resolveIMacroBinding((IMacroBinding)binding, origin);
            }
            if (binding instanceof IProblemBinding) {
                return this.resolveIProblemBinding((IProblemBinding)binding, origin);
            }
            if (binding instanceof ITypedef) {
                return this.resolveITypedef((ITypedef)binding, origin);
            }
            if (binding instanceof IVariable) {
                return this.resolveIVariable((IVariable)binding, origin);
            }
            if (binding instanceof ICPPBinding) {
                return this.resolveICPPBinding((ICPPBinding)binding, origin);
            }
            if (binding instanceof ICPPTwoPhaseBinding) {
                return this.resolveICPPTwoPhaseBinding(owner, (ICPPTwoPhaseBinding)binding, origin);
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unexpected error in URI syntax", e);
        }
        throw new RuntimeException("Encountered unknown Binding: " + binding.getName());
    }

    private ISourceLocation resolveICPPTwoPhaseBinding(IASTNameOwner owner, ICPPTwoPhaseBinding binding, ISourceLocation origin) throws URISyntaxException {
        if (binding instanceof CPPFunctionSet) {
            return this.resolveCPPFunctionSet(owner, (CPPFunctionSet)binding, origin);
        }
        throw new RuntimeException("Trying to resolve ICPPTwoPhaseBinding " + binding.getClass().getSimpleName());
    }

    private ISourceLocation resolveCPPFunctionSet(IASTNameOwner owner, CPPFunctionSet binding, ISourceLocation origin) throws URISyntaxException {
        return this.ownedBinding((IBinding)binding, "cpp+functionSet", origin);
    }

    private ISourceLocation resolveIVariable(IVariable binding, ISourceLocation origin) throws URISyntaxException {
        if (binding instanceof ICPPVariable) {
            return this.resolveICPPVariable((ICPPVariable)binding, origin);
        }
        if (binding instanceof IField) {
            return this.resolveIField((IField)binding, origin);
        }
        if (binding instanceof IParameter) {
            return this.resolveIParameter((IParameter)binding, origin);
        }
        if (binding instanceof CVariable) {
            return this.resolveCVariable((CVariable)binding, origin);
        }
        throw new RuntimeException("NYI: IVariable");
    }

    private ISourceLocation resolveITypedef(ITypedef binding, ISourceLocation origin) throws URISyntaxException {
        String scheme = binding instanceof ICPPAliasTemplateInstance ? "cpp+aliasTemplateInstance" : "cpp+typedef";
        return this.ownedBinding((IBinding)binding, scheme, origin);
    }

    private ISourceLocation resolveIProblemBinding(IProblemBinding binding, ISourceLocation origin) {
        this.err("IProblemBinding: " + binding.toString() + " @ " + String.valueOf(origin));
        try {
            return URIUtil.changeQuery((ISourceLocation)BindingsResolver.failedBinding("problem"), (String)("message=" + binding.getMessage()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("could not create problem binding URI", e);
        }
    }

    private ISourceLocation resolveIMacroBinding(IMacroBinding binding, ISourceLocation origin) throws URISyntaxException {
        if (binding.isDynamic()) {
            String className = binding.getClass().getSimpleName();
            if ("CounterMacro".equals(className)) {
                return this.makeBinding("cpp+dynamicMacro", null, "counter");
            }
            if ("DateMacro".equals(className)) {
                return this.makeBinding("cpp+dynamicMacro", null, "date");
            }
            if ("FileMacro".equals(className)) {
                return this.makeBinding("cpp+dynamicMacro", null, "file");
            }
            if ("LineMacro".equals(className)) {
                return this.makeBinding("cpp+dynamicMacro", null, "line");
            }
            if ("TimeMacro".equals(className)) {
                return this.makeBinding("cpp+dynamicMacro", null, "time");
            }
            this.err("Trying to resolve " + binding.getClass().getSimpleName() + ": " + String.valueOf(binding));
            throw new RuntimeException("Encountered unknown dynamic MacroBinding " + className + " @ " + String.valueOf(origin));
        }
        return this.ownedBinding((IBinding)binding, "cpp+macro", origin);
    }

    private ISourceLocation resolveILabel(ILabel binding, ISourceLocation origin) throws URISyntaxException {
        return this.ownedBinding((IBinding)binding, "cpp+label", origin);
    }

    private ISourceLocation resolveIIndexBinding(IIndexBinding binding, ISourceLocation origin) {
        this.err("Trying to resolve " + binding.getClass().getSimpleName() + ": " + String.valueOf(binding));
        throw new RuntimeException("NYI " + binding.getClass().getSimpleName() + " @ " + String.valueOf(origin));
    }

    private ISourceLocation resolveIFunction(IFunction binding, ISourceLocation origin) throws URISyntaxException {
        if (binding instanceof ICPPFunction) {
            return this.resolveICPPFunction((ICPPFunction)binding, origin);
        }
        if (binding instanceof CFunction) {
            return this.resolveCFunction((CFunction)binding, origin);
        }
        throw new RuntimeException("NYI: unknown IFunction");
    }

    private ISourceLocation resolveIEnumerator(IEnumerator binding, ISourceLocation origin) throws URISyntaxException {
        return this.ownedBinding((IBinding)binding, "cpp+enumerator", origin);
    }

    private ISourceLocation resolveIEnumeration(IEnumeration binding, ISourceLocation origin) throws URISyntaxException {
        if (binding instanceof ICPPEnumeration) {
            return this.resolveICPPEnumeration((ICPPEnumeration)binding, origin);
        }
        if (binding instanceof CEnumeration) {
            return this.resolveCEnumeration((CEnumeration)binding, origin);
        }
        this.err("Trying to resolve " + binding.getClass().getSimpleName() + ": " + String.valueOf(binding) + " @ " + String.valueOf(origin));
        throw new RuntimeException("NYI" + binding.getClass().getSimpleName() + ": " + String.valueOf(binding) + " @ " + String.valueOf(origin));
    }

    public ISourceLocation resolveICPPBinding(ICPPBinding binding, ISourceLocation origin) throws URISyntaxException {
        if (binding instanceof ICPPAliasTemplateInstance) {
            return this.resolveICPPAliasTemplateInstance((ICPPAliasTemplateInstance)binding, origin);
        }
        if (binding instanceof ICPPClassType) {
            return this.resolveICPPClassType((ICPPClassType)binding, origin);
        }
        if (binding instanceof ICPPEnumeration) {
            return this.resolveICPPEnumeration((ICPPEnumeration)binding, origin);
        }
        if (binding instanceof ICPPFunction) {
            return this.resolveICPPFunction((ICPPFunction)binding, origin);
        }
        if (binding instanceof ICPPMember) {
            return this.resolveICPPMember((ICPPMember)binding, origin);
        }
        if (binding instanceof ICPPNamespace) {
            return this.resolveICPPNamespace((ICPPNamespace)binding, origin);
        }
        if (binding instanceof ICPPSpecialization) {
            return this.resolveICPPSpecialization((ICPPSpecialization)binding, origin);
        }
        if (binding instanceof ICPPTemplateDefinition) {
            return this.resolveICPPTemplateDefinition((ICPPTemplateDefinition)binding, origin);
        }
        if (binding instanceof ICPPTemplateParameter) {
            return this.resolveICPPTemplateParameter((ICPPTemplateParameter)binding, origin);
        }
        if (binding instanceof ICPPUsingDeclaration) {
            return this.resolveICPPUsingDeclaration((ICPPUsingDeclaration)binding, origin);
        }
        if (binding instanceof ICPPVariable) {
            return this.resolveICPPVariable((ICPPVariable)binding, origin);
        }
        if (binding instanceof ICPPInternalBinding) {
            return this.resolveICPPInternalBinding((ICPPInternalBinding)binding, origin);
        }
        if (binding instanceof ICPPUnknownBinding) {
            return this.resolveICPPUnknownBinding((ICPPUnknownBinding)binding, origin);
        }
        return this.unknown();
    }

    private ISourceLocation unknown() {
        return URIUtil.correctLocation((String)"unknown", (String)"", (String)UUID.randomUUID().toString());
    }

    private ISourceLocation resolveICPPInternalBinding(ICPPInternalBinding binding, ISourceLocation origin) throws URISyntaxException {
        return this.ownedBinding((IBinding)binding, "cpp+internal", origin);
    }

    private ISourceLocation resolveICPPUnknownBinding(ICPPUnknownBinding binding, ISourceLocation origin) {
        throw new RuntimeException("Trying to resolve ICPPUnknownBinding " + String.valueOf(origin));
    }

    private ISourceLocation resolveIField(IField binding, ISourceLocation origin) throws URISyntaxException {
        return this.ownedBinding((IBinding)binding, "cpp+field", origin);
    }

    private ISourceLocation resolveIParameter(IParameter binding, ISourceLocation origin) throws URISyntaxException {
        return this.ownedBinding((IBinding)binding, "cpp+parameter", origin);
    }

    private ISourceLocation resolveCVariable(CVariable binding, ISourceLocation origin) throws URISyntaxException {
        return this.ownedBinding((IBinding)binding, "c+variable", "", origin, binding.isStatic());
    }

    private ISourceLocation resolveICPPVariable(ICPPVariable binding, ISourceLocation origin) throws URISyntaxException {
        String scheme = binding instanceof ICPPField ? (binding instanceof ICPPFieldTemplate ? "cpp+fieldTemplate" : "cpp+field") : (binding instanceof ICPPParameter ? "cpp+parameter" : (binding instanceof ICPPTemplateNonTypeParameter ? "cpp+templateNonTypeParameter" : (binding instanceof ICPPVariableInstance ? "cpp+variableInstance" : (binding instanceof ICPPVariableTemplate ? (binding instanceof ICPPFieldTemplate ? "cpp+fieldTemplate" : (binding instanceof ICPPVariableTemplatePartialSpecialization ? "cpp+variableTemplatePartialSpec" : "cpp+variableTemplate")) : "cpp+variable"))));
        return this.ownedBinding((IBinding)binding, scheme, "", origin, binding.isStatic());
    }

    private ISourceLocation resolveICPPUsingDeclaration(ICPPUsingDeclaration binding, ISourceLocation origin) throws URISyntaxException {
        return this.ownedBinding((IBinding)binding, "cpp+usingDeclaration", origin);
    }

    private ISourceLocation resolveICPPTemplateParameter(ICPPTemplateParameter binding, ISourceLocation origin) throws URISyntaxException {
        String scheme;
        if (binding instanceof ICPPTemplateNonTypeParameter) {
            return this.resolveICPPVariable((ICPPVariable)((ICPPTemplateNonTypeParameter)binding), origin);
        }
        if (binding instanceof ICPPTemplateTemplateParameter) {
            return this.resolveICPPClassType((ICPPClassType)((ICPPTemplateTemplateParameter)binding), origin);
        }
        if (binding instanceof ICPPTemplateTypeParameter) {
            scheme = "cpp+templateTypeParameter";
        } else {
            if (binding instanceof IPDOMCPPTemplateParameter) {
                throw new RuntimeException("resolveICPPTemplateParameter encountered IPDOMCPPTemplateParameter");
            }
            scheme = "cpp+templateParameter";
        }
        return this.ownedBinding((IBinding)binding, scheme, origin);
    }

    private ISourceLocation resolveICPPTemplateDefinition(ICPPTemplateDefinition binding, ISourceLocation origin) throws URISyntaxException {
        String scheme;
        if (binding instanceof ICPPAliasTemplate) {
            scheme = "cpp+aliasTemplate";
        } else if (binding instanceof ICPPFunctionTemplate) {
            scheme = "cpp+functionTemplate";
        } else {
            if (binding instanceof ICPPPartiallySpecializable) {
                if (binding instanceof ICPPClassTemplate) {
                    return this.resolveICPPClassType((ICPPClassType)((ICPPClassTemplate)binding), origin);
                }
                if (binding instanceof ICPPVariableTemplate) {
                    return this.resolveICPPVariable((ICPPVariable)((ICPPVariableTemplate)binding), origin);
                }
                throw new RuntimeException("resolveICPPTemplateDefinition encountered unknown type");
            }
            if (binding instanceof ICPPPartialSpecialization) {
                if (binding instanceof ICPPClassTemplatePartialSpecialization) {
                    return this.resolveICPPClassType((ICPPClassType)((ICPPClassTemplatePartialSpecialization)binding), origin);
                }
                if (binding instanceof ICPPVariableTemplatePartialSpecialization) {
                    return this.resolveICPPVariable((ICPPVariable)((ICPPVariableTemplatePartialSpecialization)binding), origin);
                }
                throw new RuntimeException("resolveICPPTemplateDefinition encountered unknown type");
            }
            scheme = "cpp+templateDefinition";
        }
        return this.ownedBinding((IBinding)binding, scheme, origin);
    }

    private ISourceLocation resolveICPPSpecialization(ICPPSpecialization binding, ISourceLocation origin) {
        this.err("Trying to resolve " + binding.getClass().getSimpleName() + ": " + String.valueOf(binding) + " @ " + String.valueOf(origin));
        throw new RuntimeException("NYI" + binding.getClass().getSimpleName() + ": " + String.valueOf(binding) + " @ " + String.valueOf(origin));
    }

    private ISourceLocation resolveICPPNamespace(ICPPNamespace binding, ISourceLocation origin) throws URISyntaxException {
        String scheme = binding instanceof ICPPNamespaceAlias ? "cpp+namespaceAlias" : "cpp+namespace";
        return this.ownedBinding((IBinding)binding, scheme, origin);
    }

    private ISourceLocation resolveICPPMember(ICPPMember binding, ISourceLocation origin) {
        this.err("Trying to resolve " + binding.getClass().getSimpleName() + ": " + String.valueOf(binding) + " @ " + String.valueOf(origin));
        throw new RuntimeException("NYI" + binding.getClass().getSimpleName() + ": " + String.valueOf(binding) + " @ " + String.valueOf(origin));
    }

    private String printType(IType type) {
        if (type instanceof ICPPBinding) {
            return ASTTypeUtil.getQualifiedName((ICPPBinding)((ICPPBinding)type)).replaceAll("/", "%2F");
        }
        if (type instanceof IProblemType && ((IProblemType)type).getID() == 8) {
            return "$undeclaredKnRParameter";
        }
        return type.toString().replace(" ", ".");
    }

    public ISourceLocation getSourceLocation(IASTNode node) {
        IASTFileLocation astFileLocation = node.getFileLocation();
        if (astFileLocation != null) {
            Object fileName = astFileLocation.getFileName();
            fileName = ((String)fileName).replace('\\', '/');
            try {
                return this.vf.sourceLocation((ISourceLocation)new StandardTextReader().read(this.vf, (Reader)new StringReader((String)fileName)), astFileLocation.getNodeOffset(), astFileLocation.getNodeLength());
            }
            catch (FactParseError | FactTypeUseException | IOException throwable) {
                if (!((String)fileName).startsWith("/")) {
                    fileName = "/" + (String)fileName;
                }
                try {
                    return this.vf.sourceLocation((ISourceLocation)new StandardTextReader().read(this.vf, (Reader)new StringReader((String)fileName)), astFileLocation.getNodeOffset(), astFileLocation.getNodeLength());
                }
                catch (FactParseError | FactTypeUseException | IOException throwable2) {
                    return this.vf.sourceLocation(this.vf.sourceLocation((String)fileName), astFileLocation.getNodeOffset(), astFileLocation.getNodeLength());
                }
            }
        }
        return this.vf.sourceLocation(URIUtil.rootLocation((String)"unknown"), 0, 0);
    }

    private ISourceLocation resolveCFunction(CFunction binding, ISourceLocation origin) throws URISyntaxException {
        String scheme = "c+function";
        StringBuilder parameters = new StringBuilder("(");
        try {
            for (IParameter parameter : binding.getParameters()) {
                if (parameters.length() > 1) {
                    parameters.append(',');
                }
                parameters.append(this.printType(parameter.getType()));
            }
            parameters.append(')');
        }
        catch (ClassCastException e) {
            this.stdErr.println("Encountered ClassCastException in CDT for binding " + binding.getName() + " in " + String.valueOf(this.getSourceLocation((IASTNode)binding.getDeclarations()[0])));
            parameters = new StringBuilder("($$internalError)");
        }
        return this.ownedBinding((IBinding)binding, scheme, parameters.toString(), origin, binding.isStatic());
    }

    private ISourceLocation resolveICPPFunction(ICPPFunction binding, ISourceLocation origin) throws URISyntaxException {
        String scheme = binding instanceof ICPPDeferredFunction ? "cpp+deferredFunction" : (binding instanceof ICPPFunctionInstance ? "cpp+functionInstance" : (binding instanceof ICPPFunctionSpecialization ? "cpp+functionSpecialization" : (binding instanceof ICPPFunctionTemplate ? "cpp+functionTemplate" : (binding instanceof ICPPMethod ? (binding instanceof ICPPConstructor ? (binding instanceof ICPPConstructorSpecialization ? "cpp+constructorSpecialization" : "cpp+constructor") : (binding instanceof ICPPMethodSpecialization ? "cpp+methodSpecialization" : (binding.getName().startsWith("~") ? "cpp+destructor" : "cpp+method"))) : "cpp+function"))));
        StringBuilder parameters = new StringBuilder("(");
        for (ICPPParameter parameter : binding.getParameters()) {
            if (parameters.length() > 1) {
                parameters.append(',');
            }
            parameters.append(this.printType(parameter.getType()));
        }
        parameters.append(')');
        return this.ownedBinding((IBinding)binding, scheme, parameters.toString(), origin, binding.isStatic());
    }

    private boolean isOperatorName(String name) {
        return name.startsWith("operator ");
    }

    private ISourceLocation resolveCEnumeration(CEnumeration binding, ISourceLocation origin) throws URISyntaxException {
        return this.ownedBinding((IBinding)binding, "c+enum", origin);
    }

    private ISourceLocation resolveICPPEnumeration(ICPPEnumeration binding, ISourceLocation origin) throws URISyntaxException {
        String scheme;
        if (binding instanceof ICPPEnumerationSpecialization) {
            scheme = "cpp+enumSpecialization";
        } else {
            if (binding instanceof IPDOMCPPEnumType) {
                throw new RuntimeException("resolveICPPEnumeration encountered IPDOMCPPEnumType");
            }
            scheme = "cpp+enum";
        }
        return this.ownedBinding((IBinding)binding, scheme, origin);
    }

    private ISourceLocation resolveICPPClassType(ICPPClassType binding, ISourceLocation origin) throws URISyntaxException {
        String scheme;
        if (binding instanceof ICPPClassSpecialization) {
            scheme = binding instanceof ICPPClassTemplatePartialSpecializationSpecialization ? "cpp+classTemplatePartialSpecSpec" : "cpp+classSpecialization";
        } else if (binding instanceof ICPPClassTemplate) {
            scheme = binding instanceof ICPPClassTemplatePartialSpecialization ? "cpp+classTemplatePartialSpec" : (binding instanceof ICPPTemplateTemplateParameter ? "cpp+templateTemplateParameter" : "cpp+classTemplate");
        } else if (binding instanceof ICPPDeferredClassInstance) {
            scheme = "cpp+deferredClassInstance";
        } else if (binding instanceof ICPPUnknownMemberClass) {
            scheme = binding instanceof ICPPUnknownMemberClassInstance ? "cpp+unknownMemberClassInstance" : "cpp+unknownMemberClass";
        } else {
            if (binding instanceof IPDOMCPPClassType) {
                throw new RuntimeException("resolveICPPClassType encountered IPDOMCPPClassType");
            }
            scheme = "cpp+class";
        }
        return this.ownedBinding((IBinding)binding, scheme, origin);
    }

    private ISourceLocation resolveICPPAliasTemplateInstance(ICPPAliasTemplateInstance binding, ISourceLocation origin) {
        this.err("Trying to resolve " + binding.getClass().getSimpleName() + ": " + String.valueOf(binding));
        throw new RuntimeException("NYI");
    }

    private ISourceLocation resolveICompositeType(ICompositeType binding, ISourceLocation origin) throws URISyntaxException {
        if (binding instanceof ICPPClassType) {
            return this.resolveICPPClassType((ICPPClassType)binding, origin);
        }
        return this.ownedBinding((IBinding)binding, "c+struct", origin);
    }

    private ISourceLocation resolveICExternalBinding(ICExternalBinding binding, ISourceLocation origin) throws URISyntaxException {
        return URIUtil.changePath((ISourceLocation)URIUtil.rootLocation((String)"c+externalBinding"), (String)binding.getName());
    }

    public ISourceLocation resolveBinding(IASTNameOwner node, ISourceLocation origin) {
        try {
            if (node instanceof IASTCompositeTypeSpecifier) {
                return this.resolveCompositeTypeSpecifier((IASTCompositeTypeSpecifier)node);
            }
            if (node instanceof IASTDeclarator) {
                return this.resolveDeclarator((IASTDeclarator)node);
            }
            if (node instanceof IASTElaboratedTypeSpecifier) {
                return this.resolveElaboratedTypeSpecifier((IASTElaboratedTypeSpecifier)node);
            }
            if (node instanceof IASTEnumerationSpecifier) {
                return this.resolveEnumerationSpecifier((IASTEnumerationSpecifier)node);
            }
            if (node instanceof IASTEnumerationSpecifier.IASTEnumerator) {
                return this.resolveEnumerator((IASTEnumerationSpecifier.IASTEnumerator)node);
            }
            if (node instanceof IASTFieldReference) {
                return this.resolveFieldReference((IASTFieldReference)node);
            }
            if (node instanceof IASTGotoStatement) {
                return this.resolveGotoStatement((IASTGotoStatement)node);
            }
            if (node instanceof IASTIdExpression) {
                return this.resolveIdExpression((IASTIdExpression)node);
            }
            if (node instanceof IASTLabelStatement) {
                return this.resolveLabelStatement((IASTLabelStatement)node);
            }
            if (node instanceof IASTNamedTypeSpecifier) {
                return this.resolveNamedTypeSpecifier((IASTNamedTypeSpecifier)node);
            }
            if (node instanceof IASTPreprocessorMacroDefinition) {
                return this.resolvePreprocessorMacroDefinition((IASTPreprocessorMacroDefinition)node);
            }
            if (node instanceof ICPPASTAliasDeclaration) {
                return this.resolveAliasDeclaration((ICPPASTAliasDeclaration)node);
            }
            if (node instanceof ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier) {
                return this.resolveBaseSpecifier((ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier)node);
            }
            if (node instanceof ICPPASTCapture) {
                return this.resolveCapture((ICPPASTCapture)node);
            }
            if (node instanceof ICPPASTConstructorChainInitializer) {
                return this.resolveConstructorChainInitializer((ICPPASTConstructorChainInitializer)node);
            }
            if (node instanceof ICPPASTNamespaceAlias) {
                return this.resolveNamespaceAlias((ICPPASTNamespaceAlias)node);
            }
            if (node instanceof ICPPASTNamespaceDefinition) {
                return this.resolveNamespaceDefinition((ICPPASTNamespaceDefinition)node);
            }
            if (node instanceof ICPPASTPointerToMember) {
                return this.resolvePointerToMember((ICPPASTPointerToMember)node);
            }
            if (node instanceof ICPPASTQualifiedName) {
                return this.resolveQualifiedName((ICPPASTQualifiedName)node);
            }
            if (node instanceof ICPPASTSimpleTypeTemplateParameter) {
                return this.resolveSimpleTypeTemplateParameter((ICPPASTSimpleTypeTemplateParameter)node);
            }
            if (node instanceof ICPPASTTemplatedTypeTemplateParameter) {
                return this.resolveTemplatedTypeTemplateParameter((ICPPASTTemplatedTypeTemplateParameter)node);
            }
            if (node instanceof ICPPASTTemplateId) {
                return this.resolveTemplateId((ICPPASTTemplateId)node);
            }
            if (node instanceof ICPPASTUsingDeclaration) {
                return this.resolveUsingDeclaration((ICPPASTUsingDeclaration)node);
            }
            if (node instanceof ICPPASTUsingDirective) {
                return this.resolveUsingDirective((ICPPASTUsingDirective)node);
            }
        }
        catch (URISyntaxException e) {
            this.err(e.getMessage());
        }
        return BindingsResolver.failedBinding("unknown");
    }

    public ISourceLocation resolveBinding(ICPPBinding binding, ISourceLocation origin) {
        try {
            return this.resolveICPPBinding(binding, origin);
        }
        catch (URISyntaxException e) {
            this.err(e.getMessage());
            return BindingsResolver.failedBinding("unknown");
        }
    }

    private ISourceLocation resolveUsingDeclaration(ICPPASTUsingDeclaration node) throws URISyntaxException {
        return this.resolveBinding((IASTNameOwner)node, node.getName().resolveBinding(), this.getSourceLocation((IASTNode)node));
    }

    private ISourceLocation resolveUsingDirective(ICPPASTUsingDirective node) throws URISyntaxException {
        return this.resolveBinding((IASTNameOwner)node, node.getQualifiedName().resolveBinding(), this.getSourceLocation((IASTNode)node));
    }

    private ISourceLocation resolveTemplateId(ICPPASTTemplateId node) throws URISyntaxException {
        return this.resolveBinding((IASTNameOwner)node, node.resolveBinding(), this.getSourceLocation((IASTNode)node));
    }

    private ISourceLocation resolveTemplatedTypeTemplateParameter(ICPPASTTemplatedTypeTemplateParameter node) throws URISyntaxException {
        return this.resolveBinding((IASTNameOwner)node, node.getName().resolveBinding(), this.getSourceLocation((IASTNode)node));
    }

    private ISourceLocation resolveSimpleTypeTemplateParameter(ICPPASTSimpleTypeTemplateParameter node) throws URISyntaxException {
        return this.resolveBinding((IASTNameOwner)node, node.getName().resolveBinding(), this.getSourceLocation((IASTNode)node));
    }

    private ISourceLocation resolveQualifiedName(ICPPASTQualifiedName node) throws URISyntaxException {
        return this.resolveBinding((IASTNameOwner)node, node.resolveBinding(), this.getSourceLocation((IASTNode)node));
    }

    private ISourceLocation resolvePointerToMember(ICPPASTPointerToMember node) throws URISyntaxException {
        return this.resolveBinding((IASTNameOwner)node, node.getName().resolveBinding(), this.getSourceLocation((IASTNode)node));
    }

    private ISourceLocation resolveNamespaceDefinition(ICPPASTNamespaceDefinition node) throws URISyntaxException {
        return this.resolveBinding((IASTNameOwner)node, node.getName().resolveBinding(), this.getSourceLocation((IASTNode)node));
    }

    private ISourceLocation resolveNamespaceAlias(ICPPASTNamespaceAlias node) throws URISyntaxException {
        return this.resolveBinding((IASTNameOwner)node, node.getAlias().resolveBinding(), this.getSourceLocation((IASTNode)node));
    }

    private ISourceLocation resolveConstructorChainInitializer(ICPPASTConstructorChainInitializer node) throws URISyntaxException {
        return this.resolveBinding((IASTNameOwner)node, node.getMemberInitializerId().resolveBinding(), this.getSourceLocation((IASTNode)node));
    }

    private ISourceLocation resolveCapture(ICPPASTCapture node) throws URISyntaxException {
        IASTName name = node.getIdentifier();
        if (name == null) {
            this.out("Resolving this capture; returning dummy value");
            return this.FIXME;
        }
        return this.resolveBinding((IASTNameOwner)node, name.resolveBinding(), this.getSourceLocation((IASTNode)node));
    }

    private ISourceLocation resolveBaseSpecifier(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier node) throws URISyntaxException {
        return this.resolveBinding((IASTNameOwner)node, node.getNameSpecifier().resolveBinding(), this.getSourceLocation((IASTNode)node));
    }

    private ISourceLocation resolveAliasDeclaration(ICPPASTAliasDeclaration node) throws URISyntaxException {
        return this.resolveBinding((IASTNameOwner)node, node.getAlias().resolveBinding(), this.getSourceLocation((IASTNode)node));
    }

    private ISourceLocation resolvePreprocessorMacroDefinition(IASTPreprocessorMacroDefinition node) {
        throw new RuntimeException("NYI");
    }

    private ISourceLocation resolveNamedTypeSpecifier(IASTNamedTypeSpecifier node) throws URISyntaxException {
        IBinding binding = node.getName().resolveBinding();
        return this.resolveBinding((IASTNameOwner)node, binding, this.getSourceLocation((IASTNode)node));
    }

    private ISourceLocation resolveLabelStatement(IASTLabelStatement node) throws URISyntaxException {
        return this.resolveBinding((IASTNameOwner)node, node.getName().resolveBinding(), this.getSourceLocation((IASTNode)node));
    }

    private ISourceLocation resolveIdExpression(IASTIdExpression node) throws URISyntaxException {
        return this.resolveBinding((IASTNameOwner)node, node.getName().resolveBinding(), this.getSourceLocation((IASTNode)node));
    }

    private ISourceLocation resolveGotoStatement(IASTGotoStatement node) throws URISyntaxException {
        return this.resolveBinding((IASTNameOwner)node, node.getName().resolveBinding(), this.getSourceLocation((IASTNode)node));
    }

    private ISourceLocation resolveFieldReference(IASTFieldReference node) throws URISyntaxException {
        return this.resolveBinding((IASTNameOwner)node, node.getFieldName().resolveBinding(), this.getSourceLocation((IASTNode)node));
    }

    private ISourceLocation resolveEnumerator(IASTEnumerationSpecifier.IASTEnumerator node) throws URISyntaxException {
        return this.resolveBinding((IASTNameOwner)node, node.getName().resolveBinding(), this.getSourceLocation((IASTNode)node));
    }

    private ISourceLocation resolveEnumerationSpecifier(IASTEnumerationSpecifier node) throws URISyntaxException {
        return this.resolveBinding((IASTNameOwner)node, node.getName().resolveBinding(), this.getSourceLocation((IASTNode)node));
    }

    private ISourceLocation resolveElaboratedTypeSpecifier(IASTElaboratedTypeSpecifier node) throws URISyntaxException {
        return this.resolveBinding((IASTNameOwner)node, node.getName().resolveBinding(), this.getSourceLocation((IASTNode)node));
    }

    private ISourceLocation resolveDeclarator(IASTDeclarator node) throws URISyntaxException {
        if (node.getName() == null) {
            this.out("resolveDeclarator has null name. " + node.getClass().getSimpleName() + ": " + node.getRawSignature());
            return this.FIXME;
        }
        return this.resolveBinding((IASTNameOwner)node, node.getName().resolveBinding(), this.getSourceLocation((IASTNode)node));
    }

    private ISourceLocation resolveCompositeTypeSpecifier(IASTCompositeTypeSpecifier node) throws URISyntaxException {
        return this.resolveBinding((IASTNameOwner)node, node.getName().resolveBinding(), this.getSourceLocation((IASTNode)node));
    }

    public ISourceLocation makeBinding(String scheme, String authority, String path) {
        try {
            return this.vf.sourceLocation(scheme, authority, path);
        }
        catch (URISyntaxException e) {
            assert (false);
            throw new RuntimeException("Should not happen", e);
        }
    }
}

