/*
 * Decompiled with CFR 0.152.
 */
package lang.cpp.internal;

import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.FactParseError;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.io.StandardTextReader;
import io.usethesource.vallang.type.TypeFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.util.UUID;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.rascalmpl.uri.URIUtil;

public class Locations {
    private final IValueFactory vf;
    private final StandardTextReader locParser = new StandardTextReader();

    public Locations(IValueFactory vf, PrintWriter stdErr) {
        this.vf = vf;
    }

    public ISourceLocation forNode(IASTNode node) {
        try {
            IASTFileLocation astFileLocation = node.getFileLocation();
            if (astFileLocation != null) {
                String fileName = astFileLocation.getFileName();
                if (fileName.trim().startsWith("|")) {
                    try {
                        ISourceLocation tmp = (ISourceLocation)this.locParser.read(this.vf, TypeFactory.getInstance().sourceLocationType(), (Reader)new StringReader(fileName));
                        assert (!tmp.hasOffsetLength());
                        return this.vf.sourceLocation(tmp, astFileLocation.getNodeOffset(), astFileLocation.getNodeLength());
                    }
                    catch (FactParseError | FactTypeUseException | IOException e) {
                        return this.unknownPreciseLoc();
                    }
                }
                ISourceLocation loc = URIUtil.createFileLocation((String)fileName.trim());
                return this.vf.sourceLocation(loc, astFileLocation.getNodeOffset(), astFileLocation.getNodeLength());
            }
            return this.unknownPreciseLoc();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("getting location for node " + String.valueOf(node) + " failed", e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("location for not " + String.valueOf(node) + " has URISyntaxException: " + String.valueOf(e), e);
        }
    }

    private ISourceLocation unknownPreciseLoc() {
        return this.vf.sourceLocation(URIUtil.correctLocation((String)"unknown", (String)"", (String)UUID.randomUUID().toString()), 0, 0);
    }
}

