/*
 * Decompiled with CFR 0.152.
 */
package lang.cpp.internal;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Stack;
import java.util.stream.Stream;
import lang.cpp.internal.AST;
import lang.cpp.internal.BindingsResolver;
import lang.cpp.internal.CDTParser;
import lang.cpp.internal.Locations;
import lang.cpp.internal.TypeResolver;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.ExpansionOverlapsBoundaryException;
import org.eclipse.cdt.core.dom.ast.IASTASMDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTAttribute;
import org.eclipse.cdt.core.dom.ast.IASTAttributeList;
import org.eclipse.cdt.core.dom.ast.IASTAttributeOwner;
import org.eclipse.cdt.core.dom.ast.IASTAttributeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTGotoStatement;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointer;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTProblemDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTProblemExpression;
import org.eclipse.cdt.core.dom.ast.IASTProblemStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblemTypeId;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTToken;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignatedInitializer;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTFieldDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTAliasDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTAlignmentSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTArrayDesignator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCapture;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCastExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTClassVirtSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConversionName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDecltypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeleteExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDesignatedInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDesignator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExplicitTemplateInstantiation;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpressionList;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFieldDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFieldDesignator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFieldReference;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTForStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionWithTryBlock;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTIfStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLambdaExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLinkageSpecification;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNameSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceAlias;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNaryTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTOperatorName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTPackExpansionExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTPointerToMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTRangeBasedForStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTReferenceOperator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeConstructorExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTStaticAssertDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplatedTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTryBlockStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTypeTransformationSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVirtSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.gnu.IGCCASTAttributeList;
import org.eclipse.cdt.core.dom.ast.gnu.IGNUASTGotoStatement;
import org.eclipse.cdt.core.dom.ast.gnu.c.ICASTKnRFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.gnu.c.IGCCASTArrayRangeDesignator;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.IGPPASTArrayRangeDesignator;
import org.eclipse.cdt.core.dom.ast.ms.IMSASTDeclspecList;
import org.eclipse.cdt.core.parser.DefaultLogService;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.core.dom.parser.ASTAmbiguousNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousStatement;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTArraySubscriptExpression;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTCompoundStatementExpression;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTFieldReference;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTFunctionDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTName;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTParameterDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompoundStatementExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionSet;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.core.runtime.CoreException;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.IRascalValueFactory;

public class Parser
extends ASTVisitor {
    private final IValueFactory vf;
    private final PrintWriter stdOut;
    private final PrintWriter stdErr;
    private final IRascalMonitor monitor;
    private final AST builder;
    private final Stack<IConstructor> stack = new Stack();
    private final BindingsResolver br;
    private final TypeResolver tr;
    private final Locations locs;
    private boolean doProblemLogging = false;
    private boolean toM3 = false;
    private boolean includeStdLib = false;
    private IList stdLib;
    private ISetWriter declaredType;
    private ISetWriter functionDefinitions;
    private ISetWriter newResolutions;
    private ISetWriter implicitDeclarations;
    private IASTNode currentNode;
    private int prefix = 0;

    private void at(IASTNode it) {
        this.currentNode = it;
    }

    public Parser(IValueFactory vf, IRascalValueFactory rvf, PrintWriter stdOut, PrintWriter stdErr, IRascalMonitor monitor) {
        super(true);
        this.shouldVisitAmbiguousNodes = true;
        this.shouldVisitImplicitNames = true;
        this.includeInactiveNodes = true;
        this.shouldVisitTokens = true;
        this.vf = vf;
        this.stdOut = stdOut;
        this.stdErr = stdErr;
        this.monitor = monitor;
        this.builder = new AST(vf);
        this.br = new BindingsResolver(vf, stdOut, stdErr);
        this.locs = new Locations(vf, stdErr);
        this.tr = new TypeResolver(this.builder, this.br, this.locs, vf, stdOut);
        this.reset();
    }

    private void reset() {
        this.toM3 = false;
        this.includeStdLib = false;
        this.stdLib = (IList)this.vf.listWriter().done();
        this.declaredType = this.vf.setWriter();
        this.functionDefinitions = this.vf.setWriter();
        this.implicitDeclarations = this.vf.setWriter();
        this.newResolutions = this.vf.setWriter();
        this.currentNode = null;
    }

    public IList parseFiles(IList files, IString charset, IBool inferCharset, IList stdLib, IList includeDirs, IMap standardMacros, IMap additionalMacros, IBool includeStdLib) {
        this.includeStdLib = includeStdLib.getValue() || stdLib.isEmpty();
        this.stdLib = stdLib;
        CDTParser parser = new CDTParser(this.vf, this.stdOut, this.stdErr, stdLib, includeDirs, standardMacros, additionalMacros, includeStdLib.getValue());
        this.monitor.jobStart("ClaiR parseFiles");
        IListWriter asts = this.vf.listWriter();
        for (IValue v : files) {
            if (this.monitor.jobIsCanceled("ClaiR parseFiles")) {
                this.monitor.jobEnd("ClaiR parseFiles", false);
                break;
            }
            ISourceLocation file = (ISourceLocation)v;
            IASTTranslationUnit tu = parser.parseFileAsCpp(file, charset, inferCharset);
            try {
                IValue result = this.convertCdtToRascal(tu, false);
                ISourceLocation tuDecl = URIUtil.correctLocation((String)"cpp+translationUnit", (String)"", (String)file.getPath());
                result = ((IConstructor)result).asWithKeywordParameters().setParameter("decl", (IValue)tuDecl);
                asts.append(new IValue[]{result});
            }
            catch (NullPointerException e) {
                throw new UnsupportedOperationException("Conversion to AST did not work for " + this.currentNode.getClass().getCanonicalName() + " at " + String.valueOf(this.locs.forNode(this.currentNode)), e);
            }
        }
        this.reset();
        this.monitor.jobEnd("ClaiR parseFiles", true);
        return (IList)asts.done();
    }

    public IValue parseC(ISourceLocation file, IString charset, IBool inferCharset, IList stdLib, IList includeDirs, IMap standardMacros, IMap additionalMacros, IBool includeStdLib) {
        this.includeStdLib = includeStdLib.getValue() || stdLib.isEmpty();
        this.stdLib = stdLib;
        CDTParser parser = new CDTParser(this.vf, this.stdOut, this.stdErr, stdLib, includeDirs, standardMacros, additionalMacros, includeStdLib.getValue());
        IASTTranslationUnit tu = parser.parseFileAsC(file, charset, inferCharset);
        try {
            IValue result = this.convertCdtToRascal(tu, false);
            ISourceLocation tuDecl = URIUtil.correctLocation((String)"cpp+translationUnit", (String)"", (String)file.getPath());
            result = ((IConstructor)result).asWithKeywordParameters().setParameter("decl", (IValue)tuDecl);
            if (result == null) {
                throw RuntimeExceptionFactory.parseError((ISourceLocation)file, null, null);
            }
            IValue iValue = result;
            return iValue;
        }
        catch (NullPointerException e) {
            throw new UnsupportedOperationException("Conversion to AST did not work for " + this.currentNode.getClass().getCanonicalName() + " at " + String.valueOf(this.locs.forNode(this.currentNode)), e);
        }
        finally {
            this.reset();
        }
    }

    public IValue parseCpp(ISourceLocation file, IString charset, IBool inferCharset, IList stdLib, IList includeDirs, IMap standardMacros, IMap additionalMacros, IBool includeStdLib) {
        this.includeStdLib = includeStdLib.getValue() || stdLib.isEmpty();
        this.stdLib = stdLib;
        CDTParser parser = new CDTParser(this.vf, this.stdOut, this.stdErr, stdLib, includeDirs, standardMacros, additionalMacros, includeStdLib.getValue());
        IASTTranslationUnit tu = parser.parseFileAsCpp(file, charset, inferCharset);
        try {
            IValue result = this.convertCdtToRascal(tu, false);
            ISourceLocation tuDecl = URIUtil.correctLocation((String)"cpp+translationUnit", (String)"", (String)file.getPath());
            result = ((IConstructor)result).asWithKeywordParameters().setParameter("decl", (IValue)tuDecl);
            if (result == null) {
                throw RuntimeExceptionFactory.parseError((ISourceLocation)file, null, null);
            }
            IValue iValue = result;
            return iValue;
        }
        catch (NullPointerException e) {
            throw new UnsupportedOperationException("Conversion to AST did not work for " + this.currentNode.getClass().getCanonicalName() + " at " + String.valueOf(this.locs.forNode(this.currentNode)), e);
        }
        finally {
            this.reset();
        }
    }

    public ITuple parseCToM3AndAst(ISourceLocation file, IString charset, IBool inferCharset, IList stdLib, IList includeDirs, IMap standardMacros, IMap additionalMacros, IBool includeStdLib) {
        this.includeStdLib = includeStdLib.getValue() || stdLib.isEmpty();
        this.stdLib = stdLib;
        IConstructor m3 = this.builder.M3_m3(file);
        ISourceLocation tuDecl = URIUtil.correctLocation((String)"cpp+translationUnit", (String)"", (String)file.getPath());
        this.br.setTranslationUnit(tuDecl);
        CDTParser parser = new CDTParser(this.vf, this.stdOut, this.stdErr, stdLib, includeDirs, standardMacros, additionalMacros, includeStdLib.getValue());
        IASTTranslationUnit tu = null;
        try {
            tu = parser.parseFileAsC(file, charset, inferCharset);
        }
        catch (ClassCastException e) {
            IListWriter error = this.vf.listWriter();
            error.append(new IValue[]{this.builder.Declaration_problemDeclaration(file, false)});
            return this.vf.tuple(new IValue[]{m3, this.builder.Declaration_translationUnit((IList)error.done(), file, false)});
        }
        IList comments = this.getCommentsFromTranslationUnit(tu);
        ISet macroExpansions = this.getMacroExpansionsFromTranslationUnit(tu);
        ISet macroDefinitions = this.getMacroDefinitionsFromTranslationUnit(tu);
        m3 = m3.asWithKeywordParameters().setParameter("comments", (IValue)comments);
        m3 = m3.asWithKeywordParameters().setParameter("macroExpansions", (IValue)macroExpansions);
        m3 = m3.asWithKeywordParameters().setParameter("macroDefinitions", (IValue)macroDefinitions);
        m3 = this.setM3IncludeInformationFromTranslationUnit(tu, (IValue)m3);
        this.declaredType = this.vf.setWriter();
        this.functionDefinitions = this.vf.setWriter();
        this.implicitDeclarations = this.vf.setWriter();
        this.newResolutions = this.vf.setWriter();
        try {
            IValue result = this.convertCdtToRascal(tu, true);
            ISet methodOverrides = this.getMethodOverrides(tu, (ISet)this.newResolutions.done());
            m3 = m3.asWithKeywordParameters().setParameter("methodOverrides", (IValue)methodOverrides);
            result = ((IConstructor)result).asWithKeywordParameters().setParameter("decl", (IValue)tuDecl);
            m3 = m3.asWithKeywordParameters().setParameter("declaredType", (IValue)this.declaredType.done());
            m3 = m3.asWithKeywordParameters().setParameter("functionDefinitions", (IValue)this.functionDefinitions.done());
            m3 = m3.asWithKeywordParameters().setParameter("containment", (IValue)this.br.getContainmentRelation());
            m3 = m3.asWithKeywordParameters().setParameter("implicitDeclarations", (IValue)this.implicitDeclarations.done());
            ITuple iTuple = this.vf.tuple(new IValue[]{m3, result});
            return iTuple;
        }
        catch (NullPointerException e) {
            throw new UnsupportedOperationException("Conversion to AST did not work for " + this.currentNode.getClass().getCanonicalName() + " at " + String.valueOf(this.locs.forNode(this.currentNode)), e);
        }
        finally {
            this.reset();
        }
    }

    public ITuple parseCppToM3AndAst(ISourceLocation file, IString charset, IBool inferCharset, IList stdLib, IList includeDirs, IMap standardMacros, IMap additionalMacros, IBool includeStdLib) {
        this.includeStdLib = includeStdLib.getValue() || stdLib.isEmpty();
        this.stdLib = stdLib;
        IConstructor m3 = this.builder.M3_m3(file);
        ISourceLocation tuDecl = URIUtil.correctLocation((String)"cpp+translationUnit", (String)"", (String)file.getPath());
        this.br.setTranslationUnit(tuDecl);
        CDTParser parser = new CDTParser(this.vf, this.stdOut, this.stdErr, stdLib, includeDirs, standardMacros, additionalMacros, includeStdLib.getValue());
        IASTTranslationUnit tu = parser.parseFileAsCpp(file, charset, inferCharset);
        IList comments = this.getCommentsFromTranslationUnit(tu);
        ISet macroExpansions = this.getMacroExpansionsFromTranslationUnit(tu);
        ISet macroDefinitions = this.getMacroDefinitionsFromTranslationUnit(tu);
        m3 = m3.asWithKeywordParameters().setParameter("comments", (IValue)comments);
        m3 = m3.asWithKeywordParameters().setParameter("macroExpansions", (IValue)macroExpansions);
        m3 = m3.asWithKeywordParameters().setParameter("macroDefinitions", (IValue)macroDefinitions);
        m3 = this.setM3IncludeInformationFromTranslationUnit(tu, (IValue)m3);
        this.declaredType = this.vf.setWriter();
        this.functionDefinitions = this.vf.setWriter();
        this.newResolutions = this.vf.setWriter();
        try {
            IValue result = this.convertCdtToRascal(tu, true);
            ISet methodOverrides = this.getMethodOverrides(tu, (ISet)this.newResolutions.done());
            m3 = m3.asWithKeywordParameters().setParameter("methodOverrides", (IValue)methodOverrides);
            result = ((IConstructor)result).asWithKeywordParameters().setParameter("decl", (IValue)tuDecl);
            m3 = m3.asWithKeywordParameters().setParameter("declaredType", (IValue)this.declaredType.done());
            m3 = m3.asWithKeywordParameters().setParameter("functionDefinitions", (IValue)this.functionDefinitions.done());
            m3 = m3.asWithKeywordParameters().setParameter("containment", (IValue)this.br.getContainmentRelation());
            m3 = m3.asWithKeywordParameters().setParameter("implicitDeclarations", (IValue)this.implicitDeclarations.done());
            ITuple iTuple = this.vf.tuple(new IValue[]{m3, result});
            return iTuple;
        }
        catch (NullPointerException e) {
            throw new UnsupportedOperationException("Conversion to AST did not work for " + this.currentNode.getClass().getCanonicalName() + " at " + String.valueOf(this.locs.forNode(this.currentNode)), e);
        }
        finally {
            this.reset();
        }
    }

    public ISet getMethodOverrides(IASTTranslationUnit tu, ISet newResolutions) {
        ASTAmbiguousNode.NameCollector anc = new ASTAmbiguousNode.NameCollector();
        tu.accept((ASTVisitor)anc);
        HashSet bindings = new HashSet();
        Stream.of(anc.getNames()).forEach(it -> bindings.add(it.resolveBinding()));
        ISetWriter methodOverrides = this.vf.setWriter();
        bindings.stream().filter(ICPPMethod.class::isInstance).forEach(override -> Stream.of(ClassTypeHelper.findOverridden((ICPPMethod)((ICPPMethod)override))).forEach(base -> {
            try {
                methodOverrides.insert(new IValue[]{this.vf.tuple(new IValue[]{this.br.resolveBinding(null, (IBinding)base, this.locs.forNode((IASTNode)tu)), this.br.resolveBinding(null, (IBinding)override, this.locs.forNode((IASTNode)tu))})});
            }
            catch (FactTypeUseException e) {
                this.err("Got FactTypeUseException\n" + e.getMessage());
            }
        }));
        bindings.stream().filter(CPPFunctionSet.class::isInstance).map(CPPFunctionSet.class::cast).forEach(binding -> {
            ISourceLocation base = this.br.resolveBinding(null, (IBinding)binding, this.locs.forNode((IASTNode)tu));
            for (ICPPFunction override : binding.getBindings()) {
                methodOverrides.insert(new IValue[]{this.vf.tuple(new IValue[]{base, this.br.resolveBinding(null, (IBinding)override, this.locs.forNode((IASTNode)tu))})});
            }
        });
        methodOverrides.appendAll((Iterable)newResolutions);
        return (ISet)methodOverrides.done();
    }

    public ISet getMacroDefinitionsFromTranslationUnit(IASTTranslationUnit tu) {
        return (ISet)Stream.of(tu.getMacroDefinitions()).map(it -> this.vf.tuple(new IValue[]{this.br.resolveBinding((IASTNameOwner)it, it.getName().resolveBinding(), this.locs.forNode((IASTNode)it)), this.locs.forNode((IASTNode)it)})).collect(this.vf.setWriter());
    }

    public IList getCommentsFromTranslationUnit(IASTTranslationUnit tu) {
        return (IList)Stream.of(tu.getComments()).map(this.locs::forNode).collect(this.vf.listWriter());
    }

    public IList parseForComments(ISourceLocation file, IString charset, IBool inferCharset, IList includePath, IMap standardMacros, IMap additionalMacros) {
        CDTParser parser = new CDTParser(this.vf, this.stdOut, this.stdErr, (IList)this.vf.listWriter().done(), includePath, standardMacros, additionalMacros, true);
        IASTTranslationUnit tu = parser.parseFileAsCpp(file, charset, inferCharset);
        this.reset();
        return this.getCommentsFromTranslationUnit(tu);
    }

    public IValue setM3IncludeInformationFromTranslationUnit(IASTTranslationUnit tu, IValue m3) {
        ISetWriter includeDirectives = this.vf.setWriter();
        ISetWriter inactiveIncludes = this.vf.setWriter();
        ISetWriter includeResolution = this.vf.setWriter();
        ISetWriter unresolvedIncludes = this.vf.setWriter();
        Stream.of(tu.getIncludeDirectives()).forEach(it -> {
            ISourceLocation include = BindingsResolver.failedBinding("unknown");
            try {
                include = this.vf.sourceLocation(it.isSystemInclude() ? "cpp+systemInclude" : "cpp+include", null, it.getName().toString());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (it.isActive()) {
                if (!it.isResolved()) {
                    unresolvedIncludes.insert(new IValue[]{this.vf.tuple(new IValue[]{include, this.locs.forNode((IASTNode)it)})});
                }
                includeDirectives.insert(new IValue[]{this.vf.tuple(new IValue[]{include, this.locs.forNode((IASTNode)it)})});
                ISourceLocation path = "" == it.getPath() ? this.vf.sourceLocation(URIUtil.rootScheme((String)"unresolved")) : this.vf.sourceLocation(it.getPath());
                includeResolution.insert(new IValue[]{this.vf.tuple(new IValue[]{include, path})});
            } else {
                inactiveIncludes.insert(new IValue[]{this.vf.tuple(new IValue[]{include, this.locs.forNode((IASTNode)it)})});
            }
        });
        m3 = m3.asWithKeywordParameters().setParameter("includeDirectives", (IValue)includeDirectives.done());
        m3 = m3.asWithKeywordParameters().setParameter("inactiveIncludes", (IValue)inactiveIncludes.done());
        m3 = m3.asWithKeywordParameters().setParameter("includeResolution", (IValue)includeResolution.done());
        m3 = m3.asWithKeywordParameters().setParameter("unresolvedIncludes", (IValue)unresolvedIncludes.done());
        return m3;
    }

    public ISet getMacroExpansionsFromTranslationUnit(IASTTranslationUnit tu) {
        ISetWriter macros = this.vf.setWriter();
        Stream.of(tu.getMacroExpansions()).forEach(it -> {
            ISourceLocation decl = this.br.resolveBinding(null, it.getMacroReference().resolveBinding(), this.locs.forNode((IASTNode)it));
            macros.insert(new IValue[]{this.vf.tuple(new IValue[]{this.locs.forNode((IASTNode)it), decl})});
        });
        return (ISet)macros.done();
    }

    private void addDeclaredType(ISourceLocation decl, IConstructor typ) {
        if (this.toM3) {
            this.declaredType.insert(new IValue[]{this.vf.tuple(new IValue[]{decl, typ})});
        }
    }

    private void addFunctionDefinition(ISourceLocation decl, ISourceLocation loc) {
        if (this.toM3) {
            this.functionDefinitions.insert(new IValue[]{this.vf.tuple(new IValue[]{decl, loc})});
        }
    }

    public ISet parseForMacros(ISourceLocation file, IString charset, IBool inferCharset, IList includePath, IMap standardMacros, IMap additionalMacros) {
        CDTParser parser = new CDTParser(this.vf, this.stdOut, this.stdErr, (IList)this.vf.listWriter().done(), includePath, standardMacros, additionalMacros, true);
        IASTTranslationUnit tu = parser.parseFileAsCpp(file, charset, inferCharset);
        this.reset();
        return this.getMacroExpansionsFromTranslationUnit(tu);
    }

    public IValue parseString(IString code) throws CoreException {
        return this.parseString(code, null);
    }

    public IValue parseString(IString code, ISourceLocation loc) throws CoreException {
        this.stdLib = (IList)this.vf.listWriter().done();
        FileContent fc = FileContent.create((String)(loc == null ? "" : loc.toString()), (char[])code.getValue().toCharArray());
        ScannerInfo si = new ScannerInfo();
        IncludeFileContentProvider ifcp = IncludeFileContentProvider.getEmptyFilesProvider();
        int options = 32;
        DefaultLogService log = new DefaultLogService();
        IASTTranslationUnit tu = GPPLanguage.getDefault().getASTTranslationUnit(fc, (IScannerInfo)si, ifcp, null, options, (IParserLogService)log);
        try {
            IValue result = this.convertCdtToRascal(tu, false);
            ISourceLocation tuDecl = URIUtil.correctLocation((String)"cpp+translationUnit", (String)"", (String)(loc == null ? "" : loc.getPath()));
            IValue iValue = ((IConstructor)result).asWithKeywordParameters().setParameter("decl", (IValue)tuDecl);
            return iValue;
        }
        catch (NullPointerException e) {
            throw new UnsupportedOperationException("Conversion to AST did not work for " + this.currentNode.getClass().getCanonicalName() + " at " + String.valueOf(this.locs.forNode(this.currentNode)), e);
        }
        finally {
            this.reset();
        }
    }

    public IValue convertCdtToRascal(IASTTranslationUnit translationUnit, boolean toM3) {
        this.toM3 = toM3;
        translationUnit.accept((ASTVisitor)this);
        if (this.stack.size() == 1) {
            return (IValue)this.stack.pop();
        }
        if (this.stack.size() == 0) {
            throw new RuntimeException("Stack empty after converting, error");
        }
        IConstructor ast = this.stack.pop();
        this.err("Superfluous nodes on the stack after converting:");
        this.stack.iterator().forEachRemaining(it -> this.err(it.toString()));
        ISourceLocation file = this.locs.forNode((IASTNode)translationUnit);
        ISourceLocation tuDecl = URIUtil.correctLocation((String)"cpp+translationUnit", (String)"", (String)file.getPath());
        return ast.asWithKeywordParameters().setParameter("decl", (IValue)tuDecl);
    }

    private String spaces() {
        return StringUtils.repeat((String)" ", (int)this.prefix);
    }

    private void out(String msg) {
        this.stdOut.println(this.spaces() + msg.replace("\n", "\n" + this.spaces()));
    }

    private void err(String msg) {
        this.stdErr.println(this.spaces() + msg.replace("\n", "\n" + this.spaces()));
    }

    public ISourceLocation getTokenSourceLocation(IASTNode node, String literal) {
        ISourceLocation loc = this.locs.forNode(node);
        try {
            for (IToken tokens = node.getSyntax(); tokens != null; tokens = tokens.getNext()) {
                if (!literal.equals(tokens.getImage())) continue;
                return this.vf.sourceLocation(loc, loc.getOffset() + tokens.getOffset(), literal.length());
            }
        }
        catch (ExpansionOverlapsBoundaryException expansionOverlapsBoundaryException) {
            // empty catch block
        }
        return loc;
    }

    public boolean isMacroExpansion(IASTNode node) {
        IASTNodeLocation[] nodeLocations = node.getNodeLocations();
        return nodeLocations.length > 1 || nodeLocations.length == 1 && nodeLocations[0] instanceof IASTMacroExpansionLocation;
    }

    IList getAttributes(IASTAttributeOwner node) {
        IListWriter attributeSpecifiers = this.vf.listWriter();
        Stream.of(node.getAttributeSpecifiers()).forEach(it -> {
            this.visit((IASTAttributeSpecifier)it);
            attributeSpecifiers.append(new IValue[]{(IValue)this.stack.pop()});
        });
        return (IList)attributeSpecifiers.done();
    }

    IList getModifiers(IASTNode node) {
        boolean isMacroExpansion = this.isMacroExpansion(node);
        IListWriter modifiers = this.vf.listWriter();
        if (node instanceof ICPPASTDeclSpecifier) {
            if (((ICPPASTDeclSpecifier)node).isFriend()) {
                modifiers.append(new IValue[]{this.builder.Modifier_friend(this.getTokenSourceLocation(node, "friend"), isMacroExpansion)});
            }
            if (((ICPPASTDeclSpecifier)node).isVirtual()) {
                modifiers.append(new IValue[]{this.builder.Modifier_virtual(this.getTokenSourceLocation(node, "virtual"), isMacroExpansion)});
            }
            if (((ICPPASTDeclSpecifier)node).isExplicit()) {
                modifiers.append(new IValue[]{this.builder.Modifier_explicit(this.getTokenSourceLocation(node, "explicit"), isMacroExpansion)});
            }
            if (((ICPPASTDeclSpecifier)node).isConstexpr()) {
                modifiers.append(new IValue[]{this.builder.Modifier_constexpr(this.getTokenSourceLocation(node, "constexpr"), isMacroExpansion)});
            }
            if (((ICPPASTDeclSpecifier)node).isThreadLocal()) {
                modifiers.append(new IValue[]{this.builder.Modifier_threadLocal(this.getTokenSourceLocation(node, "thread_local"), isMacroExpansion)});
            }
        }
        if (node instanceof ICPPASTFunctionDeclarator) {
            if (((ICPPASTFunctionDeclarator)node).isMutable()) {
                modifiers.append(new IValue[]{this.builder.Modifier_mutable(this.getTokenSourceLocation(node, "mutable"), isMacroExpansion)});
            }
            if (((ICPPASTFunctionDeclarator)node).isPureVirtual()) {
                modifiers.append(new IValue[]{this.builder.Modifier_pureVirtual(this.getTokenSourceLocation(node, "virtual"), isMacroExpansion)});
            }
        }
        if (node instanceof IASTDeclSpecifier) {
            switch (((IASTDeclSpecifier)node).getStorageClass()) {
                case 1: {
                    modifiers.append(new IValue[]{this.builder.Modifier_typedef(this.getTokenSourceLocation(node, "typedef"), isMacroExpansion)});
                    break;
                }
                case 2: {
                    modifiers.append(new IValue[]{this.builder.Modifier_extern(this.getTokenSourceLocation(node, "extern"), isMacroExpansion)});
                    break;
                }
                case 3: {
                    modifiers.append(new IValue[]{this.builder.Modifier_static(this.getTokenSourceLocation(node, "static"), isMacroExpansion)});
                    break;
                }
                case 4: {
                    modifiers.append(new IValue[]{this.builder.Modifier_modAuto(this.getTokenSourceLocation(node, "auto"), isMacroExpansion)});
                    break;
                }
                case 5: {
                    modifiers.append(new IValue[]{this.builder.Modifier_register(this.getTokenSourceLocation(node, "register"), isMacroExpansion)});
                    break;
                }
                case 6: {
                    modifiers.append(new IValue[]{this.builder.Modifier_mutable(this.getTokenSourceLocation(node, "mutable"), isMacroExpansion)});
                }
            }
        }
        if (node instanceof IASTSimpleDeclSpecifier) {
            if (((IASTSimpleDeclSpecifier)node).isSigned()) {
                modifiers.append(new IValue[]{this.builder.Modifier_signed(this.getTokenSourceLocation(node, "signed"), isMacroExpansion)});
            }
            if (((IASTSimpleDeclSpecifier)node).isUnsigned()) {
                modifiers.append(new IValue[]{this.builder.Modifier_unsigned(this.getTokenSourceLocation(node, "unsigned"), isMacroExpansion)});
            }
            if (((IASTSimpleDeclSpecifier)node).isShort()) {
                modifiers.append(new IValue[]{this.builder.Modifier_short(this.getTokenSourceLocation(node, "short"), isMacroExpansion)});
            }
            if (((IASTSimpleDeclSpecifier)node).isLong()) {
                modifiers.append(new IValue[]{this.builder.Modifier_long(this.getTokenSourceLocation(node, "long"), isMacroExpansion)});
            }
            if (((IASTSimpleDeclSpecifier)node).isLongLong()) {
                modifiers.append(new IValue[]{this.builder.Modifier_longlong(this.getTokenSourceLocation(node, "long long"), isMacroExpansion)});
            }
            if (((IASTSimpleDeclSpecifier)node).isComplex()) {
                modifiers.append(new IValue[]{this.builder.Modifier_complex(this.getTokenSourceLocation(node, "_Complex"), isMacroExpansion)});
            }
            if (((IASTSimpleDeclSpecifier)node).isImaginary()) {
                modifiers.append(new IValue[]{this.builder.Modifier_imaginary(this.getTokenSourceLocation(node, "_Imaginary"), isMacroExpansion)});
            }
        }
        if (node instanceof ICASTArrayModifier) {
            if (((ICASTArrayModifier)node).isConst()) {
                modifiers.append(new IValue[]{this.builder.Modifier_const(this.getTokenSourceLocation(node, "const"), isMacroExpansion)});
            }
            if (((ICASTArrayModifier)node).isVolatile()) {
                modifiers.append(new IValue[]{this.builder.Modifier_volatile(this.getTokenSourceLocation(node, "volatile"), isMacroExpansion)});
            }
            if (((ICASTArrayModifier)node).isRestrict()) {
                modifiers.append(new IValue[]{this.builder.Modifier_restrict(this.getTokenSourceLocation(node, "restrict"), isMacroExpansion)});
            }
            if (((ICASTArrayModifier)node).isConst()) {
                modifiers.append(new IValue[]{this.builder.Modifier_const(this.getTokenSourceLocation(node, "const"), isMacroExpansion)});
            }
        } else if (node instanceof ICPPASTFunctionDeclarator) {
            if (((ICPPASTFunctionDeclarator)node).isConst()) {
                modifiers.append(new IValue[]{this.builder.Modifier_const(this.getTokenSourceLocation(node, "const"), isMacroExpansion)});
            }
            if (((ICPPASTFunctionDeclarator)node).isVolatile()) {
                modifiers.append(new IValue[]{this.builder.Modifier_volatile(this.getTokenSourceLocation(node, "volatile"), isMacroExpansion)});
            }
        } else if (node instanceof IASTDeclSpecifier) {
            if (((IASTDeclSpecifier)node).isConst()) {
                modifiers.append(new IValue[]{this.builder.Modifier_const(this.getTokenSourceLocation(node, "const"), isMacroExpansion)});
            }
            if (((IASTDeclSpecifier)node).isVolatile()) {
                modifiers.append(new IValue[]{this.builder.Modifier_volatile(this.getTokenSourceLocation(node, "volatile"), isMacroExpansion)});
            }
            if (((IASTDeclSpecifier)node).isRestrict()) {
                modifiers.append(new IValue[]{this.builder.Modifier_restrict(this.getTokenSourceLocation(node, "restrict"), isMacroExpansion)});
            }
            if (((IASTDeclSpecifier)node).isInline()) {
                modifiers.append(new IValue[]{this.builder.Modifier_inline(this.getTokenSourceLocation(node, "inline"), isMacroExpansion)});
            }
        } else if (node instanceof IASTPointer) {
            if (((IASTPointer)node).isConst()) {
                modifiers.append(new IValue[]{this.builder.Modifier_const(this.getTokenSourceLocation(node, "const"), isMacroExpansion)});
            }
            if (((IASTPointer)node).isVolatile()) {
                modifiers.append(new IValue[]{this.builder.Modifier_volatile(this.getTokenSourceLocation(node, "volatile"), isMacroExpansion)});
            }
            if (((IASTPointer)node).isRestrict()) {
                modifiers.append(new IValue[]{this.builder.Modifier_restrict(this.getTokenSourceLocation(node, "restrict"), isMacroExpansion)});
            }
        } else if (node instanceof ICPPASTNamespaceDefinition && ((ICPPASTNamespaceDefinition)node).isInline()) {
            modifiers.append(new IValue[]{this.builder.Modifier_inline(this.getTokenSourceLocation(node, "inline"), isMacroExpansion)});
        }
        if (node instanceof ICPPASTNamedTypeSpecifier) {
            if (((ICPPASTNamedTypeSpecifier)node).isTypename()) {
                modifiers.append(new IValue[]{this.builder.Modifier_typename(this.getTokenSourceLocation(node, "typename"), isMacroExpansion)});
            }
        } else if (node instanceof ICPPASTUsingDeclaration && ((ICPPASTUsingDeclaration)node).isTypename()) {
            modifiers.append(new IValue[]{this.builder.Modifier_typename(this.getTokenSourceLocation(node, "typename"), isMacroExpansion)});
        }
        return (IList)((IList)modifiers.done()).stream().sorted((v1, v2) -> ((ISourceLocation)v1.asWithKeywordParameters().getParameter("src")).getOffset() - ((ISourceLocation)v2.asWithKeywordParameters().getParameter("src")).getOffset()).collect(this.vf.listWriter());
    }

    public int visit(IASTTranslationUnit tu) {
        this.at((IASTNode)tu);
        ISourceLocation loc = this.locs.forNode((IASTNode)tu);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)tu);
        IListWriter declarations = this.vf.listWriter();
        ISourceLocation tuLoc = this.locs.forNode((IASTNode)tu);
        ISourceLocation tuDecl = URIUtil.correctLocation((String)"cpp+translationUnit", (String)"", (String)tuLoc.getPath());
        this.monitor.jobStart("ClaiR AST marshalling");
        block0: for (IASTDeclaration declaration : tu.getDeclarations()) {
            if (this.monitor.jobIsCanceled("ClaiR AST marshalling") || this.monitor instanceof Evaluator && ((Evaluator)this.monitor).isInterrupted()) {
                declarations.append(new IValue[]{this.builder.Declaration_problemDeclaration(URIUtil.rootLocation((String)"interrupted"), isMacroExpansion)});
                this.monitor.jobEnd("ClaiR AST marshalling", false);
                break;
            }
            ISourceLocation declLoc = this.locs.forNode((IASTNode)declaration);
            if (!this.includeStdLib) {
                for (IValue it : this.stdLib) {
                    ISourceLocation l = (ISourceLocation)it;
                    if (!l.getScheme().equals(declLoc.getScheme()) || !declLoc.getPath().startsWith(l.getPath())) continue;
                    continue block0;
                }
            }
            declaration.accept((ASTVisitor)this);
            declarations.append(new IValue[]{(IValue)this.stack.pop()});
        }
        IConstructor translationUnit = this.builder.Declaration_translationUnit((IList)declarations.done(), loc, isMacroExpansion);
        translationUnit = (IConstructor)translationUnit.asWithKeywordParameters().setParameter("decl", (IValue)tuDecl);
        this.stack.push(translationUnit);
        this.monitor.jobEnd("ClaiR AST marshalling", true);
        return 2;
    }

    public int visit(IASTName name) {
        block5: {
            this.at((IASTNode)name);
            try {
                if (name instanceof IASTImplicitName) {
                    this.visit((IASTImplicitName)name);
                    break block5;
                }
                if (name instanceof ICPPASTName) {
                    this.visit((ICPPASTName)name);
                    break block5;
                }
                if (name instanceof CASTName) {
                    ISourceLocation loc = this.locs.forNode((IASTNode)name);
                    boolean isMacroExpansion = this.isMacroExpansion((IASTNode)name);
                    this.stack.push(this.builder.Name_name(name.toString(), loc, isMacroExpansion));
                    return 2;
                }
                this.err("No sub-interfaced IASTName? " + name.getClass().getName() + ": " + name.getRawSignature());
                throw new RuntimeException("NYI at " + String.valueOf(this.locs.forNode((IASTNode)name)));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return 2;
    }

    private int visit(IASTImplicitName name) {
        this.err("IASTImplicitName " + name.getRawSignature());
        throw new RuntimeException("NYI at " + String.valueOf(this.locs.forNode((IASTNode)name)));
    }

    private int visit(ICPPASTName name) throws URISyntaxException {
        this.at((IASTNode)name);
        ISourceLocation loc = this.locs.forNode((IASTNode)name);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)name);
        if (name instanceof ICPPASTConversionName) {
            this.visit((ICPPASTConversionName)name);
        } else if (name instanceof ICPPASTOperatorName) {
            this.visit((ICPPASTOperatorName)name);
        } else if (name instanceof ICPPASTQualifiedName) {
            this.visit((ICPPASTQualifiedName)name);
        } else if (name instanceof ICPPASTTemplateId) {
            this.visit((ICPPASTTemplateId)name);
        } else {
            this.stack.push(this.builder.Name_name(new String(name.toCharArray()), loc, isMacroExpansion));
        }
        return 2;
    }

    private int visit(ICPPASTConversionName name) {
        ISourceLocation loc = this.locs.forNode((IASTNode)name);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)name);
        IConstructor typ = this.tr.resolveType((IASTNode)name);
        name.getTypeId().accept((ASTVisitor)this);
        this.stack.push(this.builder.Name_conversionName(name.toString(), this.stack.pop(), loc, typ, isMacroExpansion));
        return 2;
    }

    private int visit(ICPPASTOperatorName name) {
        this.at((IASTNode)name);
        ISourceLocation loc = this.locs.forNode((IASTNode)name);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)name);
        this.stack.push(this.builder.Name_operatorName(name.toString(), loc, isMacroExpansion));
        return 2;
    }

    private int visit(ICPPASTQualifiedName name) throws URISyntaxException {
        this.at((IASTNode)name);
        ISourceLocation loc = this.locs.forNode((IASTNode)name);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)name);
        ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)name, loc);
        IListWriter qualifierWriter = this.vf.listWriter();
        Stream.of(name.getQualifier()).forEach(it -> {
            it.accept((ASTVisitor)this);
            qualifierWriter.append(new IValue[]{(IValue)this.stack.pop()});
        });
        IList qualifiers = (IList)qualifierWriter.done();
        name.getLastName().accept((ASTVisitor)this);
        IConstructor lastName = this.stack.pop();
        if (name.isFullyQualified()) {
            // empty if block
        }
        this.stack.push(this.builder.Name_qualifiedName(qualifiers, lastName, loc, decl, isMacroExpansion));
        return 2;
    }

    private int visit(ICPPASTTemplateId name) throws URISyntaxException {
        this.at((IASTNode)name);
        ISourceLocation loc = this.locs.forNode((IASTNode)name);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)name);
        ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)name, loc);
        name.getTemplateName().accept((ASTVisitor)this);
        IConstructor templateName = this.stack.pop();
        IListWriter templateArguments = this.vf.listWriter();
        Stream.of(name.getTemplateArguments()).forEach(it -> {
            it.accept((ASTVisitor)this);
            templateArguments.append(new IValue[]{(IValue)this.stack.pop()});
        });
        this.stack.push(this.builder.Name_templateId(templateName, (IList)templateArguments.done(), loc, decl, isMacroExpansion));
        return 2;
    }

    public int visit(IASTDeclaration declaration) {
        this.at((IASTNode)declaration);
        if (declaration instanceof IASTASMDeclaration) {
            this.visit((IASTASMDeclaration)declaration);
        } else if (declaration instanceof IASTFunctionDefinition) {
            this.visit((IASTFunctionDefinition)declaration);
        } else if (declaration instanceof IASTSimpleDeclaration) {
            this.visit((IASTSimpleDeclaration)declaration);
        } else if (declaration instanceof ICPPASTAliasDeclaration) {
            this.visit((ICPPASTAliasDeclaration)declaration);
        } else if (declaration instanceof ICPPASTExplicitTemplateInstantiation) {
            this.visit((ICPPASTExplicitTemplateInstantiation)declaration);
        } else if (declaration instanceof ICPPASTLinkageSpecification) {
            this.visit((ICPPASTLinkageSpecification)declaration);
        } else if (declaration instanceof ICPPASTNamespaceAlias) {
            this.visit((ICPPASTNamespaceAlias)declaration);
        } else if (declaration instanceof ICPPASTStaticAssertDeclaration) {
            this.visit((ICPPASTStaticAssertDeclaration)declaration);
        } else if (declaration instanceof ICPPASTTemplateSpecialization) {
            this.visit((ICPPASTTemplateSpecialization)declaration);
        } else if (declaration instanceof ICPPASTTemplateDeclaration) {
            this.visit((ICPPASTTemplateDeclaration)declaration);
        } else if (declaration instanceof ICPPASTUsingDeclaration) {
            this.visit((ICPPASTUsingDeclaration)declaration);
        } else if (declaration instanceof ICPPASTUsingDirective) {
            this.visit((ICPPASTUsingDirective)declaration);
        } else if (declaration instanceof ICPPASTVisibilityLabel) {
            this.visit((ICPPASTVisibilityLabel)declaration);
        } else if (declaration instanceof IASTProblemDeclaration) {
            this.visit((IASTProblemDeclaration)declaration);
        } else {
            throw new RuntimeException("Declaration: encountered non-implemented subtype " + declaration.getClass().getName() + " at " + String.valueOf(this.locs.forNode((IASTNode)declaration)));
        }
        return 2;
    }

    private int visit(ICPPASTAliasDeclaration declaration) {
        this.at((IASTNode)declaration);
        ISourceLocation loc = this.locs.forNode((IASTNode)declaration);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declaration);
        ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)declaration, loc);
        IList attributes = this.getAttributes((IASTAttributeOwner)declaration);
        declaration.getAlias().accept((ASTVisitor)this);
        IConstructor alias = this.stack.pop();
        declaration.getMappingTypeId().accept((ASTVisitor)this);
        IConstructor mappingTypeId = this.stack.pop();
        this.stack.push(this.builder.Declaration_alias(alias, mappingTypeId, attributes, loc, decl, isMacroExpansion));
        return 2;
    }

    private int visit(ICPPASTExplicitTemplateInstantiation declaration) {
        this.at((IASTNode)declaration);
        ISourceLocation loc = this.locs.forNode((IASTNode)declaration);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declaration);
        declaration.getDeclaration().accept((ASTVisitor)this);
        switch (declaration.getModifier()) {
            case 0: {
                this.stack.push(this.builder.Declaration_explicitTemplateInstantiation(this.stack.pop(), loc, isMacroExpansion));
                break;
            }
            case 1: {
                this.stack.push(this.builder.Declaration_explicitTemplateInstantiation(this.builder.Modifier_static(this.getTokenSourceLocation((IASTNode)declaration, "static"), isMacroExpansion), this.stack.pop(), loc, isMacroExpansion));
                break;
            }
            case 2: {
                this.stack.push(this.builder.Declaration_explicitTemplateInstantiation(this.builder.Modifier_inline(this.getTokenSourceLocation((IASTNode)declaration, "inline"), isMacroExpansion), this.stack.pop(), loc, isMacroExpansion));
                break;
            }
            case 3: {
                this.stack.push(this.builder.Declaration_explicitTemplateInstantiation(this.builder.Modifier_extern(this.getTokenSourceLocation((IASTNode)declaration, "extern"), isMacroExpansion), this.stack.pop(), loc, isMacroExpansion));
                break;
            }
            default: {
                throw new RuntimeException("ICPPASTExplicitTemplateInstantiation encountered unknown modifier " + declaration.getModifier() + " at " + String.valueOf(this.locs.forNode((IASTNode)declaration)));
            }
        }
        return 2;
    }

    private int visit(ICPPASTLinkageSpecification declaration) {
        this.at((IASTNode)declaration);
        ISourceLocation loc = this.locs.forNode((IASTNode)declaration);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declaration);
        IListWriter declarations = this.vf.listWriter();
        Stream.of(declaration.getDeclarations()).forEach(it -> {
            it.accept((ASTVisitor)this);
            declarations.append(new IValue[]{(IValue)this.stack.pop()});
        });
        this.stack.push(this.builder.Declaration_linkageSpecification(declaration.getLiteral(), (IList)declarations.done(), loc, isMacroExpansion));
        return 2;
    }

    private int visit(ICPPASTNamespaceAlias declaration) {
        this.at((IASTNode)declaration);
        ISourceLocation loc = this.locs.forNode((IASTNode)declaration);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declaration);
        ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)declaration, loc);
        declaration.getAlias().accept((ASTVisitor)this);
        IConstructor alias = this.stack.pop();
        declaration.getMappingName().accept((ASTVisitor)this);
        IConstructor mappingName = this.stack.pop();
        this.stack.push(this.builder.Declaration_namespaceAlias(alias, mappingName, loc, decl, isMacroExpansion));
        return 2;
    }

    private int visit(ICPPASTStaticAssertDeclaration declaration) {
        this.at((IASTNode)declaration);
        ISourceLocation loc = this.locs.forNode((IASTNode)declaration);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declaration);
        declaration.getCondition().accept((ASTVisitor)this);
        IConstructor condition = this.stack.pop();
        ICPPASTLiteralExpression msg = declaration.getMessage();
        if (msg != null) {
            msg.accept((ASTVisitor)this);
            this.stack.push(this.builder.Declaration_staticAssert(condition, this.stack.pop(), loc, isMacroExpansion));
        } else {
            this.stack.push(this.builder.Declaration_staticAssert(condition, loc, isMacroExpansion));
        }
        return 2;
    }

    private int visit(ICPPASTTemplateDeclaration declaration) {
        this.at((IASTNode)declaration);
        ISourceLocation loc = this.locs.forNode((IASTNode)declaration);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declaration);
        IConstructor typ = this.tr.resolveType((IASTNode)declaration);
        IListWriter templateParameters = this.vf.listWriter();
        Stream.of(declaration.getTemplateParameters()).forEach(it -> {
            it.accept((ASTVisitor)this);
            templateParameters.append(new IValue[]{(IValue)this.stack.pop()});
        });
        declaration.getDeclaration().accept((ASTVisitor)this);
        this.stack.push(this.builder.Declaration_template((IList)templateParameters.done(), this.stack.pop(), typ, loc, isMacroExpansion));
        return 2;
    }

    private int visit(ICPPASTTemplateSpecialization declaration) {
        this.at((IASTNode)declaration);
        ISourceLocation loc = this.locs.forNode((IASTNode)declaration);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declaration);
        declaration.getDeclaration().accept((ASTVisitor)this);
        this.stack.push(this.builder.Declaration_explicitTemplateSpecialization(this.stack.pop(), loc, isMacroExpansion));
        return 2;
    }

    private int visit(ICPPASTUsingDeclaration declaration) {
        this.at((IASTNode)declaration);
        ISourceLocation loc = this.locs.forNode((IASTNode)declaration);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declaration);
        ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)declaration, loc);
        IList attributes = this.getAttributes((IASTAttributeOwner)declaration);
        IList modifiers = this.getModifiers((IASTNode)declaration);
        declaration.getName().accept((ASTVisitor)this);
        this.stack.push(this.builder.Declaration_usingDeclaration(modifiers, this.stack.pop(), attributes, loc, decl, isMacroExpansion));
        return 2;
    }

    private int visit(ICPPASTUsingDirective declaration) {
        this.at((IASTNode)declaration);
        ISourceLocation loc = this.locs.forNode((IASTNode)declaration);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declaration);
        ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)declaration, loc);
        IList attributes = this.getAttributes((IASTAttributeOwner)declaration);
        IASTName qualifiedName = declaration.getQualifiedName();
        qualifiedName.accept((ASTVisitor)this);
        this.stack.push(this.builder.Declaration_usingDirective(this.stack.pop(), attributes, loc, decl, isMacroExpansion));
        return 2;
    }

    private int visit(ICPPASTVisibilityLabel declaration) {
        this.at((IASTNode)declaration);
        ISourceLocation loc = this.locs.forNode((IASTNode)declaration);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declaration);
        switch (declaration.getVisibility()) {
            case 1: {
                this.stack.push(this.builder.Declaration_visibilityLabel(this.builder.Modifier_public(this.getTokenSourceLocation((IASTNode)declaration, "public"), isMacroExpansion), loc, isMacroExpansion));
                break;
            }
            case 2: {
                this.stack.push(this.builder.Declaration_visibilityLabel(this.builder.Modifier_protected(this.getTokenSourceLocation((IASTNode)declaration, "protected"), isMacroExpansion), loc, isMacroExpansion));
                break;
            }
            case 3: {
                this.stack.push(this.builder.Declaration_visibilityLabel(this.builder.Modifier_private(this.getTokenSourceLocation((IASTNode)declaration, "private"), isMacroExpansion), loc, isMacroExpansion));
                break;
            }
            default: {
                throw new RuntimeException("Unknown CPPVisibilityLabel code " + declaration.getVisibility() + " at " + String.valueOf(this.locs.forNode((IASTNode)declaration)) + ". Exiting");
            }
        }
        return 2;
    }

    private int visit(IASTASMDeclaration declaration) {
        this.at((IASTNode)declaration);
        ISourceLocation loc = this.locs.forNode((IASTNode)declaration);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declaration);
        this.stack.push(this.builder.Declaration_asmDeclaration(declaration.getAssembly(), loc, isMacroExpansion));
        return 2;
    }

    private int visit(IASTFunctionDefinition definition) {
        this.at((IASTNode)definition);
        ISourceLocation loc = this.locs.forNode((IASTNode)definition);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)definition);
        if (definition instanceof ICPPASTFunctionDefinition) {
            IList attributes = this.getAttributes((IASTAttributeOwner)((ICPPASTFunctionDefinition)definition));
            boolean isDefaulted = ((ICPPASTFunctionDefinition)definition).isDefaulted();
            boolean isDeleted = ((ICPPASTFunctionDefinition)definition).isDeleted();
            definition.getDeclSpecifier().accept((ASTVisitor)this);
            IConstructor declSpecifier = this.stack.pop();
            definition.getDeclarator().accept((ASTVisitor)this);
            IConstructor declarator = this.stack.pop();
            IListWriter memberInitializers = this.vf.listWriter();
            Stream.of(((ICPPASTFunctionDefinition)definition).getMemberInitializers()).forEach(it -> {
                it.accept((ASTVisitor)this);
                memberInitializers.append(new IValue[]{(IValue)this.stack.pop()});
            });
            if (isDefaulted && isDeleted) {
                this.err("WARNING: IASTFunctionDefinition both deleted and defaulted");
            }
            if ((isDefaulted || isDeleted) && definition instanceof ICPPASTFunctionWithTryBlock) {
                throw new RuntimeException("IASTFunctionDefinition defaulted/deleted and with try? at " + String.valueOf(loc));
            }
            if (isDefaulted) {
                this.stack.push(this.builder.Declaration_defaultedFunctionDefinition(declSpecifier, (IList)memberInitializers.done(), declarator, attributes, loc, isMacroExpansion));
            } else if (isDeleted) {
                this.stack.push(this.builder.Declaration_deletedFunctionDefinition(declSpecifier, (IList)memberInitializers.done(), declarator, attributes, loc, isMacroExpansion));
            } else if (definition instanceof ICPPASTFunctionWithTryBlock) {
                IListWriter catchHandlers = this.vf.listWriter();
                Stream.of(((ICPPASTFunctionWithTryBlock)definition).getCatchHandlers()).forEach(it -> {
                    it.accept((ASTVisitor)this);
                    catchHandlers.append(new IValue[]{(IValue)this.stack.pop()});
                });
                definition.getBody().accept((ASTVisitor)this);
                this.stack.push(this.builder.Declaration_functionWithTryBlockDefinition(declSpecifier, declarator, (IList)memberInitializers.done(), this.stack.pop(), (IList)catchHandlers.done(), attributes, loc, isMacroExpansion));
            } else {
                definition.getBody().accept((ASTVisitor)this);
                this.stack.push(this.builder.Declaration_functionDefinition(declSpecifier, declarator, (IList)memberInitializers.done(), this.stack.pop(), attributes, loc, isMacroExpansion));
            }
        } else {
            definition.getDeclSpecifier().accept((ASTVisitor)this);
            IConstructor declSpecifier = this.stack.pop();
            definition.getDeclarator().accept((ASTVisitor)this);
            IConstructor declarator = this.stack.pop();
            definition.getBody().accept((ASTVisitor)this);
            this.stack.push(this.builder.Declaration_functionDefinition(declSpecifier, declarator, (IList)this.vf.listWriter().done(), this.stack.pop(), (IList)this.vf.listWriter().done(), loc, isMacroExpansion));
        }
        this.addDeclaredType(this.br.resolveBinding((IASTNameOwner)definition.getDeclarator(), this.locs.forNode((IASTNode)definition.getDeclarator())), this.tr.resolveType((IASTNode)definition.getDeclarator()));
        this.addFunctionDefinition(this.br.resolveBinding((IASTNameOwner)definition.getDeclarator(), loc), loc);
        return 2;
    }

    public int visit(IASTParameterDeclaration parameterDeclaration) {
        this.at((IASTNode)parameterDeclaration);
        ISourceLocation loc = this.locs.forNode((IASTNode)parameterDeclaration);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)parameterDeclaration);
        if (parameterDeclaration instanceof ICPPASTParameterDeclaration || parameterDeclaration instanceof CASTParameterDeclaration) {
            parameterDeclaration.getDeclSpecifier().accept((ASTVisitor)this);
            IConstructor declSpecifier = this.stack.pop();
            if (parameterDeclaration.getDeclarator() == null) {
                this.stack.push(this.builder.Declaration_parameter(declSpecifier, loc, isMacroExpansion));
            } else {
                parameterDeclaration.getDeclarator().accept((ASTVisitor)this);
                this.stack.push(this.builder.Declaration_parameter(declSpecifier, this.stack.pop(), loc, isMacroExpansion));
            }
        } else {
            throw new RuntimeException("NYI: ParameterDeclaration at " + String.valueOf(loc));
        }
        return 2;
    }

    private int visit(IASTProblemDeclaration declaration) {
        this.at((IASTNode)declaration);
        ISourceLocation loc = this.locs.forNode((IASTNode)declaration);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declaration);
        IASTProblem problem = declaration.getProblem();
        String raw = declaration.getRawSignature();
        if (!(!this.doProblemLogging || raw.contains("$fail$") || raw.contains("\ufffd") || raw.contains("__int64(24)") || raw.contains("CString default"))) {
            this.err("ProblemDeclaration: ");
            this.prefix += 4;
            this.err(Integer.toHexString(problem.getID()) + ": " + problem.getMessageWithLocation() + ", " + String.valueOf(loc));
            this.err(raw);
            this.prefix -= 4;
        }
        this.stack.push(this.builder.Declaration_problemDeclaration(loc, isMacroExpansion));
        return 2;
    }

    private int visit(IASTSimpleDeclaration declaration) {
        this.at((IASTNode)declaration);
        ISourceLocation loc = this.locs.forNode((IASTNode)declaration);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declaration);
        IList attributes = this.getAttributes((IASTAttributeOwner)declaration);
        declaration.getDeclSpecifier().accept((ASTVisitor)this);
        IConstructor declSpecifier = this.stack.pop();
        IListWriter declarators = this.vf.listWriter();
        Stream.of(declaration.getDeclarators()).forEach(it -> {
            it.accept((ASTVisitor)this);
            declarators.append(new IValue[]{(IValue)this.stack.pop()});
            this.addDeclaredType(this.br.resolveBinding((IASTNameOwner)it, this.locs.forNode((IASTNode)it)), this.tr.resolveType((IASTNode)it));
        });
        this.stack.push(this.builder.Declaration_simpleDeclaration(declSpecifier, (IList)declarators.done(), attributes, loc, isMacroExpansion));
        return 2;
    }

    public int visit(IASTInitializer initializer) {
        this.at((IASTNode)initializer);
        if (initializer instanceof IASTEqualsInitializer) {
            this.visit((IASTEqualsInitializer)initializer);
        } else if (initializer instanceof IASTInitializerList) {
            this.visit((IASTInitializerList)initializer);
        } else if (initializer instanceof ICASTDesignatedInitializer) {
            this.visit((ICASTDesignatedInitializer)initializer);
        } else if (initializer instanceof ICPPASTConstructorChainInitializer) {
            this.visit((ICPPASTConstructorChainInitializer)initializer);
        } else if (initializer instanceof ICPPASTConstructorInitializer) {
            this.visit((ICPPASTConstructorInitializer)initializer);
        } else if (initializer instanceof ICPPASTDesignatedInitializer) {
            this.visit((ICPPASTDesignatedInitializer)initializer);
        } else {
            throw new RuntimeException("Initializer: encountered unknown subtype " + initializer.getClass().getSimpleName() + " at " + String.valueOf(this.locs.forNode((IASTNode)initializer)));
        }
        return 2;
    }

    private int visit(IASTEqualsInitializer initializer) {
        this.at((IASTNode)initializer);
        ISourceLocation loc = this.locs.forNode((IASTNode)initializer);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)initializer);
        initializer.getInitializerClause().accept((ASTVisitor)this);
        this.stack.push(this.builder.Expression_equalsInitializer(this.stack.pop(), loc, isMacroExpansion));
        return 2;
    }

    private int visit(IASTInitializerList initializer) {
        this.at((IASTNode)initializer);
        ISourceLocation loc = this.locs.forNode((IASTNode)initializer);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)initializer);
        IListWriter clauses = this.vf.listWriter();
        Stream.of(initializer.getClauses()).forEach(it -> {
            it.accept((ASTVisitor)this);
            clauses.append(new IValue[]{(IValue)this.stack.pop()});
        });
        this.stack.push(this.builder.Expression_initializerList((IList)clauses.done(), loc, isMacroExpansion));
        return 2;
    }

    private int visit(ICASTDesignatedInitializer initializer) {
        this.at((IASTNode)initializer);
        ISourceLocation loc = this.locs.forNode((IASTNode)initializer);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)initializer);
        IListWriter designators = this.vf.listWriter();
        Stream.of(initializer.getDesignators()).forEach(it -> {
            it.accept((ASTVisitor)this);
            designators.append(new IValue[]{(IValue)this.stack.pop()});
        });
        initializer.getOperand().accept((ASTVisitor)this);
        this.stack.push(this.builder.Expression_designatedInitializer((IList)designators.done(), this.stack.pop(), loc, isMacroExpansion));
        return 2;
    }

    private int visit(ICPPASTConstructorChainInitializer initializer) {
        this.at((IASTNode)initializer);
        ISourceLocation loc = this.locs.forNode((IASTNode)initializer);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)initializer);
        ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)initializer, loc);
        initializer.getMemberInitializerId().accept((ASTVisitor)this);
        IConstructor memberInitializerId = this.stack.pop();
        initializer.getInitializer().accept((ASTVisitor)this);
        IConstructor memberInitializer = this.stack.pop();
        this.stack.push(this.builder.Expression_constructorChainInitializer(memberInitializerId, memberInitializer, loc, decl, isMacroExpansion));
        return 2;
    }

    private int visit(ICPPASTConstructorInitializer initializer) {
        this.at((IASTNode)initializer);
        ISourceLocation loc = this.locs.forNode((IASTNode)initializer);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)initializer);
        IListWriter arguments = this.vf.listWriter();
        Stream.of(initializer.getArguments()).forEach(it -> {
            it.accept((ASTVisitor)this);
            arguments.append(new IValue[]{(IValue)this.stack.pop()});
        });
        this.stack.push(this.builder.Expression_constructorInitializer((IList)arguments.done(), loc, isMacroExpansion));
        return 2;
    }

    private int visit(ICPPASTDesignatedInitializer initializer) {
        this.at((IASTNode)initializer);
        ISourceLocation loc = this.locs.forNode((IASTNode)initializer);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)initializer);
        IListWriter designators = this.vf.listWriter();
        Stream.of(initializer.getDesignators()).forEach(it -> {
            it.accept((ASTVisitor)this);
            designators.append(new IValue[]{(IValue)this.stack.pop()});
        });
        initializer.getOperand().accept((ASTVisitor)this);
        this.stack.push(this.builder.Expression_designatedInitializer((IList)designators.done(), this.stack.pop(), loc, isMacroExpansion));
        return 2;
    }

    public int visit(IASTDeclarator declarator) {
        this.at((IASTNode)declarator);
        if (declarator instanceof IASTArrayDeclarator) {
            this.visit((IASTArrayDeclarator)declarator);
        } else if (declarator instanceof IASTFunctionDeclarator) {
            this.visit((IASTFunctionDeclarator)declarator);
        } else if (declarator instanceof ICPPASTDeclarator) {
            this.visit((ICPPASTDeclarator)declarator);
        } else if (declarator instanceof CASTDeclarator) {
            this.visit((CASTDeclarator)declarator);
        } else {
            throw new RuntimeException("Unknown IASTDeclarator subclass " + declarator.getClass().getName() + " at " + String.valueOf(this.locs.forNode((IASTNode)declarator)));
        }
        return 2;
    }

    private int visit(IASTArrayDeclarator declarator) {
        this.at((IASTNode)declarator);
        ISourceLocation loc = this.locs.forNode((IASTNode)declarator);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declarator);
        ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)declarator, loc);
        IList attributes = this.getAttributes((IASTAttributeOwner)declarator);
        IListWriter arrayModifiers = this.vf.listWriter();
        Stream.of(declarator.getArrayModifiers()).forEach(it -> {
            it.accept((ASTVisitor)this);
            arrayModifiers.append(new IValue[]{(IValue)this.stack.pop()});
        });
        IListWriter pointerOperators = this.vf.listWriter();
        Stream.of(declarator.getPointerOperators()).forEach(it -> {
            it.accept((ASTVisitor)this);
            pointerOperators.append(new IValue[]{(IValue)this.stack.pop()});
        });
        declarator.getName().accept((ASTVisitor)this);
        IConstructor name = this.stack.pop();
        if (declarator instanceof ICPPASTArrayDeclarator && ((ICPPASTArrayDeclarator)declarator).declaresParameterPack()) {
            this.out("WARNING: IASTArrayDeclarator has declaresParameterPack=true");
        }
        if (declarator.getNestedDeclarator() == null) {
            if (declarator.getInitializer() == null) {
                this.stack.push(this.builder.Declarator_arrayDeclarator((IList)pointerOperators.done(), name, (IList)arrayModifiers.done(), attributes, loc, decl, isMacroExpansion));
            } else {
                declarator.getInitializer().accept((ASTVisitor)this);
                this.stack.push(this.builder.Declarator_arrayDeclarator((IList)pointerOperators.done(), name, (IList)arrayModifiers.done(), this.stack.pop(), attributes, loc, decl, isMacroExpansion));
            }
        } else {
            declarator.getNestedDeclarator().accept((ASTVisitor)this);
            IConstructor nestedDeclarator = this.stack.pop();
            if (declarator.getInitializer() == null) {
                this.stack.push(this.builder.Declarator_arrayDeclaratorNested((IList)pointerOperators.done(), nestedDeclarator, (IList)arrayModifiers.done(), attributes, loc, decl, isMacroExpansion));
            } else {
                declarator.getInitializer().accept((ASTVisitor)this);
                this.stack.push(this.builder.Declarator_arrayDeclaratorNested((IList)pointerOperators.done(), nestedDeclarator, (IList)arrayModifiers.done(), this.stack.pop(), attributes, loc, decl, isMacroExpansion));
            }
        }
        return 2;
    }

    private int visit(IASTFunctionDeclarator declarator) {
        this.at((IASTNode)declarator);
        if (declarator instanceof IASTStandardFunctionDeclarator) {
            this.visit((IASTStandardFunctionDeclarator)declarator);
        } else if (declarator instanceof ICASTKnRFunctionDeclarator) {
            this.visit((ICASTKnRFunctionDeclarator)declarator);
        } else {
            throw new RuntimeException("Unknown FunctionDeclarator subtype " + declarator.getClass().getName() + " at " + String.valueOf(this.locs.forNode((IASTNode)declarator)) + ". Exiting");
        }
        return 2;
    }

    private int visit(IASTStandardFunctionDeclarator declarator) {
        this.at((IASTNode)declarator);
        if (declarator instanceof ICPPASTFunctionDeclarator) {
            this.visit((ICPPASTFunctionDeclarator)declarator);
        } else if (declarator instanceof CASTFunctionDeclarator) {
            this.visit((CASTFunctionDeclarator)declarator);
        } else {
            throw new RuntimeException("Unknown StandardFunctionDeclarator subtype " + declarator.getClass().getName() + " at " + String.valueOf(this.locs.forNode((IASTNode)declarator)) + ". Exiting");
        }
        return 2;
    }

    private int visit(ICASTKnRFunctionDeclarator declarator) {
        this.at((IASTNode)declarator);
        ISourceLocation loc = this.locs.forNode((IASTNode)declarator);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declarator);
        ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)declarator, loc);
        IList modifiers = this.getModifiers((IASTNode)declarator);
        IListWriter parameterNames = this.vf.listWriter();
        Stream.of(declarator.getParameterNames()).forEach(it -> {
            it.accept((ASTVisitor)this);
            parameterNames.append(new IValue[]{(IValue)this.stack.pop()});
        });
        IListWriter parameterDeclarations = this.vf.listWriter();
        Stream.of(declarator.getParameterDeclarations()).forEach(it -> {
            it.accept((ASTVisitor)this);
            parameterDeclarations.append(new IValue[]{(IValue)this.stack.pop()});
        });
        IListWriter pointerOperators = this.vf.listWriter();
        Stream.of(declarator.getPointerOperators()).forEach(it -> {
            it.accept((ASTVisitor)this);
            pointerOperators.append(new IValue[]{(IValue)this.stack.pop()});
        });
        this.stack.push(this.builder.Declarator_knrFunctionDeclarator((IList)pointerOperators.done(), modifiers, (IList)parameterNames.done(), (IList)parameterDeclarations.done(), loc, decl, isMacroExpansion));
        return 2;
    }

    private int visit(CASTDeclarator declarator) {
        this.at((IASTNode)declarator);
        ISourceLocation loc = this.locs.forNode((IASTNode)declarator);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declarator);
        ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)declarator, loc);
        IList attributes = this.getAttributes((IASTAttributeOwner)declarator);
        declarator.getName().accept((ASTVisitor)this);
        IConstructor name = this.stack.pop();
        IListWriter pointerOperators = this.vf.listWriter();
        Stream.of(declarator.getPointerOperators()).forEach(it -> {
            it.accept((ASTVisitor)this);
            pointerOperators.append(new IValue[]{(IValue)this.stack.pop()});
        });
        IASTInitializer initializer = declarator.getInitializer();
        if (initializer == null) {
            this.stack.push(this.builder.Declarator_declarator((IList)pointerOperators.done(), name, attributes, loc, decl, isMacroExpansion));
        } else {
            initializer.accept((ASTVisitor)this);
            this.stack.push(this.builder.Declarator_declarator((IList)pointerOperators.done(), name, this.stack.pop(), attributes, loc, decl, isMacroExpansion));
        }
        return 2;
    }

    private int visit(ICPPASTDeclarator declarator) {
        this.at((IASTNode)declarator);
        if (declarator instanceof ICPPASTArrayDeclarator) {
            this.visit((ICPPASTArrayDeclarator)declarator);
        } else if (declarator instanceof ICPPASTFieldDeclarator) {
            this.visit((ICPPASTFieldDeclarator)declarator);
        } else if (declarator instanceof ICPPASTFunctionDeclarator) {
            this.visit((ICPPASTFunctionDeclarator)declarator);
        } else {
            ISourceLocation loc = this.locs.forNode((IASTNode)declarator);
            boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declarator);
            ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)declarator, loc);
            IList attributes = this.getAttributes((IASTAttributeOwner)declarator);
            declarator.getName().accept((ASTVisitor)this);
            IConstructor name = this.stack.pop();
            IListWriter pointerOperators = this.vf.listWriter();
            Stream.of(declarator.getPointerOperators()).forEach(it -> {
                it.accept((ASTVisitor)this);
                pointerOperators.append(new IValue[]{(IValue)this.stack.pop()});
            });
            IASTInitializer initializer = declarator.getInitializer();
            if (initializer == null) {
                this.stack.push(this.builder.Declarator_declarator((IList)pointerOperators.done(), name, attributes, loc, decl, isMacroExpansion));
            } else {
                initializer.accept((ASTVisitor)this);
                this.stack.push(this.builder.Declarator_declarator((IList)pointerOperators.done(), name, this.stack.pop(), attributes, loc, decl, isMacroExpansion));
            }
        }
        return 2;
    }

    private int visit(ICPPASTArrayDeclarator declarator) {
        this.at((IASTNode)declarator);
        this.visit((IASTArrayDeclarator)declarator);
        return 2;
    }

    private int visit(ICPPASTFieldDeclarator declarator) {
        IASTInitializer initializer;
        this.at((IASTNode)declarator);
        ISourceLocation loc = this.locs.forNode((IASTNode)declarator);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declarator);
        ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)declarator, loc);
        IList attributes = this.getAttributes((IASTAttributeOwner)declarator);
        IListWriter pointerOperators = this.vf.listWriter();
        Stream.of(declarator.getPointerOperators()).forEach(it -> {
            it.accept((ASTVisitor)this);
            pointerOperators.append(new IValue[]{(IValue)this.stack.pop()});
        });
        declarator.getBitFieldSize().accept((ASTVisitor)this);
        IConstructor bitFieldSize = this.stack.pop();
        declarator.getName().accept((ASTVisitor)this);
        IConstructor name = this.stack.pop();
        IASTDeclarator nestedDeclarator = declarator.getNestedDeclarator();
        if (nestedDeclarator != null) {
            this.err("WARNING: ICPPASTDeclarator has nestedDeclarator " + nestedDeclarator.getRawSignature());
        }
        if ((initializer = declarator.getInitializer()) == null) {
            this.stack.push(this.builder.Declarator_fieldDeclarator((IList)pointerOperators.done(), name, bitFieldSize, attributes, loc, decl, isMacroExpansion));
        } else {
            initializer.accept((ASTVisitor)this);
            this.stack.push(this.builder.Declarator_fieldDeclarator((IList)pointerOperators.done(), name, bitFieldSize, this.stack.pop(), attributes, loc, decl, isMacroExpansion));
        }
        return 2;
    }

    private int visit(CASTFunctionDeclarator declarator) {
        this.at((IASTNode)declarator);
        ISourceLocation loc = this.locs.forNode((IASTNode)declarator);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declarator);
        ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)declarator, loc);
        IList attributes = this.getAttributes((IASTAttributeOwner)declarator);
        IList modifiers = this.getModifiers((IASTNode)declarator);
        IConstructor name = this.builder.Name_name("", this.vf.sourceLocation(loc, loc.getOffset(), 0), isMacroExpansion);
        IASTName _name = declarator.getName();
        if (_name != null) {
            _name.accept((ASTVisitor)this);
            name = this.stack.pop();
        }
        IListWriter parameters = this.vf.listWriter();
        Stream.of(declarator.getParameters()).forEach(it -> {
            it.accept((ASTVisitor)this);
            parameters.append(new IValue[]{(IValue)this.stack.pop()});
        });
        if (declarator.takesVarArgs()) {
            parameters.append(new IValue[]{this.builder.Declaration_varArgs(this.getTokenSourceLocation((IASTNode)declarator, "..."), isMacroExpansion)});
        }
        IListWriter pointerOperators = this.vf.listWriter();
        Stream.of(declarator.getPointerOperators()).forEach(it -> {
            it.accept((ASTVisitor)this);
            pointerOperators.append(new IValue[]{(IValue)this.stack.pop()});
        });
        this.stack.push(this.builder.Declarator_functionDeclarator((IList)pointerOperators.done(), modifiers, name, (IList)parameters.done(), (IList)this.vf.listWriter().done(), attributes, loc, decl, isMacroExpansion));
        return 2;
    }

    private int visit(ICPPASTFunctionDeclarator declarator) {
        this.at((IASTNode)declarator);
        ISourceLocation loc = this.locs.forNode((IASTNode)declarator);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declarator);
        ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)declarator, loc);
        IList attributes = this.getAttributes((IASTAttributeOwner)declarator);
        IList modifiers = this.getModifiers((IASTNode)declarator);
        IASTDeclarator _nestedDeclarator = declarator.getNestedDeclarator();
        IASTInitializer _initializer = declarator.getInitializer();
        IASTTypeId _trailingReturnType = declarator.getTrailingReturnType();
        IASTTypeId[] _exceptionSpecification = declarator.getExceptionSpecification();
        ICPPASTExpression _noexceptExpression = declarator.getNoexceptExpression();
        IConstructor name = this.builder.Name_name("", this.vf.sourceLocation(loc, loc.getOffset(), 0), isMacroExpansion);
        IASTName _name = declarator.getName();
        if (_name != null) {
            _name.accept((ASTVisitor)this);
            name = this.stack.pop();
        }
        IListWriter parameters = this.vf.listWriter();
        Stream.of(declarator.getParameters()).forEach(it -> {
            it.accept((ASTVisitor)this);
            parameters.append(new IValue[]{(IValue)this.stack.pop()});
        });
        if (declarator.takesVarArgs()) {
            parameters.append(new IValue[]{this.builder.Declaration_varArgs(this.getTokenSourceLocation((IASTNode)declarator, "..."), isMacroExpansion)});
        }
        IListWriter virtSpecifiers = this.vf.listWriter();
        Stream.of(declarator.getVirtSpecifiers()).forEach(it -> {
            it.accept((ASTVisitor)this);
            virtSpecifiers.append(new IValue[]{(IValue)this.stack.pop()});
        });
        IListWriter pointerOperators = this.vf.listWriter();
        Stream.of(declarator.getPointerOperators()).forEach(it -> {
            it.accept((ASTVisitor)this);
            pointerOperators.append(new IValue[]{(IValue)this.stack.pop()});
        });
        if (_nestedDeclarator != null) {
            if (_trailingReturnType != null) {
                throw new RuntimeException("FunctionDeclarator: Trailing return type and nested declarator? at " + String.valueOf(loc));
            }
            _nestedDeclarator.accept((ASTVisitor)this);
            IConstructor nestedDeclarator = this.stack.pop();
            if (_initializer == null) {
                this.stack.push(this.builder.Declarator_functionDeclaratorNested((IList)pointerOperators.done(), modifiers, nestedDeclarator, (IList)parameters.done(), (IList)virtSpecifiers.done(), attributes, loc, decl, isMacroExpansion));
            } else {
                _initializer.accept((ASTVisitor)this);
                this.stack.push(this.builder.Declarator_functionDeclaratorNested((IList)pointerOperators.done(), modifiers, nestedDeclarator, (IList)parameters.done(), (IList)virtSpecifiers.done(), this.stack.pop(), attributes, loc, decl, isMacroExpansion));
            }
        } else if (_exceptionSpecification.equals(ICPPASTFunctionDeclarator.NO_EXCEPTION_SPECIFICATION)) {
            if (_trailingReturnType == null) {
                this.stack.push(this.builder.Declarator_functionDeclarator((IList)pointerOperators.done(), modifiers, name, (IList)parameters.done(), (IList)virtSpecifiers.done(), attributes, loc, decl, isMacroExpansion));
            } else {
                _trailingReturnType.accept((ASTVisitor)this);
                this.stack.push(this.builder.Declarator_functionDeclarator((IList)pointerOperators.done(), modifiers, name, (IList)parameters.done(), (IList)virtSpecifiers.done(), this.stack.pop(), attributes, loc, decl, isMacroExpansion));
            }
        } else if (_exceptionSpecification.equals(IASTTypeId.EMPTY_TYPEID_ARRAY)) {
            if (_trailingReturnType != null) {
                throw new RuntimeException("FunctionDeclarator: Trailing return type and exception specification? at " + String.valueOf(loc));
            }
            this.stack.push(this.builder.Declarator_functionDeclaratorWithES((IList)pointerOperators.done(), modifiers, name, (IList)parameters.done(), (IList)virtSpecifiers.done(), attributes, loc, decl, isMacroExpansion));
        } else if (_noexceptExpression != null) {
            if (_trailingReturnType != null) {
                throw new RuntimeException("FunctionDeclarator: Trailing return type and noexceptExpression? at " + String.valueOf(loc));
            }
            if (_initializer != null) {
                throw new RuntimeException("FunctionDeclarator: Initializer and noexceptExpression? at " + String.valueOf(loc));
            }
            _noexceptExpression.accept((ASTVisitor)this);
            this.stack.push(this.builder.Declarator_functionDeclaratorNoexcept((IList)pointerOperators.done(), modifiers, name, (IList)parameters.done(), (IList)virtSpecifiers.done(), this.stack.pop(), attributes, loc, decl, isMacroExpansion));
        } else {
            if (_trailingReturnType != null) {
                throw new RuntimeException("FunctionDeclarator: Trailing return type and exception specification? at " + String.valueOf(loc));
            }
            IListWriter exceptionSpecification = this.vf.listWriter();
            Stream.of(_exceptionSpecification).forEach(it -> {
                it.accept((ASTVisitor)this);
                exceptionSpecification.append(new IValue[]{(IValue)this.stack.pop()});
            });
            this.stack.push(this.builder.Declarator_functionDeclaratorWithES((IList)pointerOperators.done(), modifiers, name, (IList)parameters.done(), (IList)virtSpecifiers.done(), (IList)exceptionSpecification.done(), attributes, loc, decl, isMacroExpansion));
        }
        return 2;
    }

    public int visit(IASTDeclSpecifier declSpec) {
        this.at((IASTNode)declSpec);
        if (declSpec instanceof IASTCompositeTypeSpecifier) {
            this.visit((IASTCompositeTypeSpecifier)declSpec);
        } else if (declSpec instanceof IASTElaboratedTypeSpecifier) {
            this.visit((IASTElaboratedTypeSpecifier)declSpec);
        } else if (declSpec instanceof IASTEnumerationSpecifier) {
            this.visit((IASTEnumerationSpecifier)declSpec);
        } else if (declSpec instanceof IASTNamedTypeSpecifier) {
            this.visit((IASTNamedTypeSpecifier)declSpec);
        } else if (declSpec instanceof IASTSimpleDeclSpecifier) {
            this.visit((IASTSimpleDeclSpecifier)declSpec);
        } else if (declSpec instanceof ICASTDeclSpecifier) {
            this.visit((ICASTDeclSpecifier)declSpec);
        } else if (declSpec instanceof ICPPASTDeclSpecifier) {
            this.visit((ICPPASTDeclSpecifier)declSpec);
        } else {
            throw new RuntimeException("Unknown sub-class encountered: " + declSpec.getClass().getName() + " at " + String.valueOf(this.locs.forNode((IASTNode)declSpec)) + ". Exiting");
        }
        return 2;
    }

    private int visit(IASTCompositeTypeSpecifier declSpec) {
        this.at((IASTNode)declSpec);
        if (declSpec instanceof ICASTCompositeTypeSpecifier) {
            this.visit((ICASTCompositeTypeSpecifier)declSpec);
        } else if (declSpec instanceof ICPPASTCompositeTypeSpecifier) {
            this.visit((ICPPASTCompositeTypeSpecifier)declSpec);
        } else {
            throw new RuntimeException("Unknown IASTCompositeTypeSpecifier subinterface " + declSpec.getClass().getName() + " at " + String.valueOf(this.locs.forNode((IASTNode)declSpec)));
        }
        return 2;
    }

    private int visit(ICASTCompositeTypeSpecifier declSpec) {
        this.at((IASTNode)declSpec);
        ISourceLocation loc = this.locs.forNode((IASTNode)declSpec);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declSpec);
        ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)declSpec, loc);
        IList attributes = this.getAttributes((IASTAttributeOwner)declSpec);
        IList modifiers = this.getModifiers((IASTNode)declSpec);
        declSpec.getName().accept((ASTVisitor)this);
        IConstructor name = this.stack.pop();
        IListWriter members = this.vf.listWriter();
        Stream.of(declSpec.getMembers()).forEach(it -> {
            it.accept((ASTVisitor)this);
            members.append(new IValue[]{(IValue)this.stack.pop()});
        });
        switch (declSpec.getKey()) {
            case 1: {
                this.stack.push(this.builder.DeclSpecifier_structFinal(modifiers, name, (IList)this.vf.listWriter().done(), (IList)members.done(), attributes, loc, decl, isMacroExpansion));
                break;
            }
            case 2: {
                this.stack.push(this.builder.DeclSpecifier_unionFinal(modifiers, name, (IList)this.vf.listWriter().done(), (IList)members.done(), attributes, loc, decl, isMacroExpansion));
                break;
            }
            case 3: {
                this.stack.push(this.builder.DeclSpecifier_classFinal(modifiers, name, (IList)this.vf.listWriter().done(), (IList)members.done(), attributes, loc, decl, isMacroExpansion));
                break;
            }
            default: {
                throw new RuntimeException("Unknown IASTCompositeTypeSpecifier code " + declSpec.getKey() + "at" + String.valueOf(loc) + ". Exiting");
            }
        }
        return 2;
    }

    private int visit(ICPPASTCompositeTypeSpecifier declSpec) {
        this.at((IASTNode)declSpec);
        ISourceLocation loc = this.locs.forNode((IASTNode)declSpec);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declSpec);
        ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)declSpec, loc);
        IList attributes = this.getAttributes((IASTAttributeOwner)declSpec);
        IList modifiers = this.getModifiers((IASTNode)declSpec);
        ICPPASTClassVirtSpecifier virtSpecifier = declSpec.getVirtSpecifier();
        if (virtSpecifier != null && !virtSpecifier.getKind().equals((Object)ICPPASTClassVirtSpecifier.SpecifierKind.Final)) {
            throw new RuntimeException("ICPPASTCompositeTypeSpecifier encountered unknown classVirtSpecifier type at " + String.valueOf(loc));
        }
        declSpec.getName().accept((ASTVisitor)this);
        IConstructor name = this.stack.pop();
        IListWriter members = this.vf.listWriter();
        Stream.of(declSpec.getMembers()).forEach(it -> {
            it.accept((ASTVisitor)this);
            members.append(new IValue[]{(IValue)this.stack.pop()});
        });
        IListWriter baseSpecifiers = this.vf.listWriter();
        Stream.of(declSpec.getBaseSpecifiers()).forEach(it -> {
            it.accept((ASTVisitor)this);
            baseSpecifiers.append(new IValue[]{(IValue)this.stack.pop()});
        });
        switch (declSpec.getKey()) {
            case 1: {
                if (virtSpecifier == null) {
                    this.stack.push(this.builder.DeclSpecifier_struct(modifiers, name, (IList)baseSpecifiers.done(), (IList)members.done(), attributes, loc, decl, isMacroExpansion));
                    break;
                }
                this.stack.push(this.builder.DeclSpecifier_structFinal(modifiers, name, (IList)baseSpecifiers.done(), (IList)members.done(), attributes, loc, decl, isMacroExpansion));
                break;
            }
            case 2: {
                if (virtSpecifier == null) {
                    this.stack.push(this.builder.DeclSpecifier_union(modifiers, name, (IList)baseSpecifiers.done(), (IList)members.done(), attributes, loc, decl, isMacroExpansion));
                    break;
                }
                this.stack.push(this.builder.DeclSpecifier_unionFinal(modifiers, name, (IList)baseSpecifiers.done(), (IList)members.done(), attributes, loc, decl, isMacroExpansion));
                break;
            }
            case 3: {
                if (virtSpecifier == null) {
                    this.stack.push(this.builder.DeclSpecifier_class(modifiers, name, (IList)baseSpecifiers.done(), (IList)members.done(), attributes, loc, decl, isMacroExpansion));
                    break;
                }
                this.stack.push(this.builder.DeclSpecifier_classFinal(modifiers, name, (IList)baseSpecifiers.done(), (IList)members.done(), attributes, loc, decl, isMacroExpansion));
                break;
            }
            default: {
                throw new RuntimeException("Unknown IASTCompositeTypeSpecifier code " + declSpec.getKey() + "at" + String.valueOf(loc) + ". Exiting");
            }
        }
        return 2;
    }

    private int visit(ICASTElaboratedTypeSpecifier declSpec) {
        this.at((IASTNode)declSpec);
        ISourceLocation loc = this.locs.forNode((IASTNode)declSpec);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declSpec);
        ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)declSpec, loc);
        IList modifiers = this.getModifiers((IASTNode)declSpec);
        declSpec.getName().accept((ASTVisitor)this);
        switch (declSpec.getKind()) {
            case 0: {
                this.stack.push(this.builder.DeclSpecifier_etsEnum(modifiers, this.stack.pop(), loc, decl, isMacroExpansion));
                break;
            }
            case 1: {
                this.stack.push(this.builder.DeclSpecifier_etsStruct(modifiers, this.stack.pop(), loc, decl, isMacroExpansion));
                break;
            }
            case 2: {
                this.stack.push(this.builder.DeclSpecifier_etsUnion(modifiers, this.stack.pop(), loc, decl, isMacroExpansion));
                break;
            }
            default: {
                throw new RuntimeException("ICASTElaboratedTypeSpecifier encountered unknown kind " + declSpec.getKind() + " at " + String.valueOf(loc));
            }
        }
        return 2;
    }

    private int visit(IASTElaboratedTypeSpecifier declSpec) {
        this.at((IASTNode)declSpec);
        ISourceLocation loc = this.locs.forNode((IASTNode)declSpec);
        if (declSpec instanceof ICASTElaboratedTypeSpecifier) {
            this.visit((ICASTElaboratedTypeSpecifier)declSpec);
        } else if (declSpec instanceof ICPPASTElaboratedTypeSpecifier) {
            boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declSpec);
            ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)declSpec, loc);
            IList modifiers = this.getModifiers((IASTNode)declSpec);
            declSpec.getName().accept((ASTVisitor)this);
            switch (declSpec.getKind()) {
                case 0: {
                    this.stack.push(this.builder.DeclSpecifier_etsEnum(modifiers, this.stack.pop(), loc, decl, isMacroExpansion));
                    break;
                }
                case 1: {
                    this.stack.push(this.builder.DeclSpecifier_etsStruct(modifiers, this.stack.pop(), loc, decl, isMacroExpansion));
                    break;
                }
                case 2: {
                    this.stack.push(this.builder.DeclSpecifier_etsUnion(modifiers, this.stack.pop(), loc, decl, isMacroExpansion));
                    break;
                }
                case 3: {
                    this.stack.push(this.builder.DeclSpecifier_etsClass(modifiers, this.stack.pop(), loc, decl, isMacroExpansion));
                    break;
                }
                default: {
                    throw new RuntimeException("IASTElaboratedTypeSpecifier encountered unknown kind " + declSpec.getKind() + " at " + String.valueOf(loc));
                }
            }
        } else {
            throw new RuntimeException("Unknown IASTElaboratedTypeSpecifier subclass " + declSpec.getClass().getSimpleName() + " at " + String.valueOf(loc));
        }
        return 2;
    }

    private int visit(IASTEnumerationSpecifier declSpec) {
        this.at((IASTNode)declSpec);
        if (declSpec instanceof ICPPASTEnumerationSpecifier) {
            this.visit((ICPPASTEnumerationSpecifier)declSpec);
        } else if (declSpec instanceof ICASTEnumerationSpecifier) {
            this.visit((ICASTEnumerationSpecifier)declSpec);
        } else {
            throw new RuntimeException("NYI at " + String.valueOf(this.locs.forNode((IASTNode)declSpec)));
        }
        return 2;
    }

    private int visit(IASTNamedTypeSpecifier declSpec) {
        this.at((IASTNode)declSpec);
        ISourceLocation loc = this.locs.forNode((IASTNode)declSpec);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declSpec);
        ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)declSpec, loc);
        IList modifiers = this.getModifiers((IASTNode)declSpec);
        declSpec.getName().accept((ASTVisitor)this);
        this.stack.push(this.builder.DeclSpecifier_namedTypeSpecifier(modifiers, this.stack.pop(), loc, decl, isMacroExpansion));
        return 2;
    }

    private int visit(IASTSimpleDeclSpecifier declSpec) {
        this.at((IASTNode)declSpec);
        if (declSpec instanceof ICPPASTSimpleDeclSpecifier) {
            this.visit((ICPPASTSimpleDeclSpecifier)declSpec);
            return 2;
        }
        if (declSpec instanceof ICASTSimpleDeclSpecifier) {
            this.visit((ICASTSimpleDeclSpecifier)declSpec);
            return 2;
        }
        throw new RuntimeException("NYI: C SimpleDeclSpecifier");
    }

    private int visit(ICASTDeclSpecifier declSpec) {
        this.at((IASTNode)declSpec);
        if (declSpec instanceof ICASTCompositeTypeSpecifier) {
            this.visit((ICASTCompositeTypeSpecifier)declSpec);
        }
        if (declSpec instanceof ICASTElaboratedTypeSpecifier) {
            this.visit((ICASTElaboratedTypeSpecifier)declSpec);
        }
        if (declSpec instanceof ICASTEnumerationSpecifier) {
            this.visit((ICASTEnumerationSpecifier)declSpec);
        }
        if (!(declSpec instanceof ICASTSimpleDeclSpecifier)) {
            this.out("CDeclSpecifier: " + declSpec.getRawSignature());
            throw new RuntimeException("NYI at " + String.valueOf(this.locs.forNode((IASTNode)declSpec)));
        }
        this.visit((ICASTSimpleDeclSpecifier)declSpec);
        return 2;
    }

    private int visit(ICPPASTDeclSpecifier declSpec) {
        this.at((IASTNode)declSpec);
        if (declSpec instanceof ICPPASTCompositeTypeSpecifier) {
            this.visit((ICPPASTCompositeTypeSpecifier)declSpec);
        } else if (declSpec instanceof ICPPASTElaboratedTypeSpecifier) {
            this.visit((ICPPASTElaboratedTypeSpecifier)declSpec);
        } else if (declSpec instanceof ICPPASTEnumerationSpecifier) {
            this.visit((ICPPASTEnumerationSpecifier)declSpec);
        } else if (declSpec instanceof ICPPASTNamedTypeSpecifier) {
            this.visit((ICPPASTNamedTypeSpecifier)declSpec);
        } else if (declSpec instanceof ICPPASTSimpleDeclSpecifier) {
            this.visit((ICPPASTSimpleDeclSpecifier)declSpec);
        } else if (declSpec instanceof ICPPASTTypeTransformationSpecifier) {
            this.visit((ICPPASTTypeTransformationSpecifier)declSpec);
        } else {
            throw new RuntimeException("NYI at " + String.valueOf(this.locs.forNode((IASTNode)declSpec)));
        }
        return 2;
    }

    private int visit(ICPPASTElaboratedTypeSpecifier declSpec) {
        this.at((IASTNode)declSpec);
        this.out("CPPElaboratedTypeSpecifier: " + declSpec.getRawSignature());
        throw new RuntimeException("NYI at " + String.valueOf(this.locs.forNode((IASTNode)declSpec)));
    }

    private int visit(ICASTEnumerationSpecifier declSpec) {
        this.at((IASTNode)declSpec);
        ISourceLocation loc = this.locs.forNode((IASTNode)declSpec);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declSpec);
        ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)declSpec, loc);
        IList attributes = this.getAttributes((IASTAttributeOwner)declSpec);
        IList modifiers = this.getModifiers((IASTNode)declSpec);
        declSpec.getName().accept((ASTVisitor)this);
        IConstructor name = this.stack.pop();
        IListWriter enumerators = this.vf.listWriter();
        Stream.of(declSpec.getEnumerators()).forEach(it -> {
            it.accept((ASTVisitor)this);
            enumerators.append(new IValue[]{(IValue)this.stack.pop()});
        });
        this.stack.push(this.builder.DeclSpecifier_enum(modifiers, name, (IList)enumerators.done(), attributes, loc, decl, isMacroExpansion));
        return 2;
    }

    private int visit(ICPPASTEnumerationSpecifier declSpec) {
        this.at((IASTNode)declSpec);
        ISourceLocation loc = this.locs.forNode((IASTNode)declSpec);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declSpec);
        ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)declSpec, loc);
        IList attributes = this.getAttributes((IASTAttributeOwner)declSpec);
        IList modifiers = this.getModifiers((IASTNode)declSpec);
        declSpec.getName().accept((ASTVisitor)this);
        IConstructor name = this.stack.pop();
        IListWriter enumerators = this.vf.listWriter();
        Stream.of(declSpec.getEnumerators()).forEach(it -> {
            it.accept((ASTVisitor)this);
            enumerators.append(new IValue[]{(IValue)this.stack.pop()});
        });
        ICPPASTDeclSpecifier baseType = declSpec.getBaseType();
        if (baseType == null) {
            if (declSpec.isScoped()) {
                if (declSpec.isOpaque()) {
                    this.stack.push(this.builder.DeclSpecifier_enumScopedOpaque(modifiers, name, attributes, loc, decl, isMacroExpansion));
                } else {
                    this.stack.push(this.builder.DeclSpecifier_enumScoped(modifiers, name, (IList)enumerators.done(), attributes, loc, decl, isMacroExpansion));
                }
            } else {
                this.stack.push(this.builder.DeclSpecifier_enum(modifiers, name, (IList)enumerators.done(), attributes, loc, decl, isMacroExpansion));
            }
        } else {
            baseType.accept((ASTVisitor)this);
            if (declSpec.isScoped()) {
                if (declSpec.isOpaque()) {
                    this.stack.push(this.builder.DeclSpecifier_enumScopedOpaque(modifiers, this.stack.pop(), name, attributes, loc, decl, isMacroExpansion));
                } else {
                    this.stack.push(this.builder.DeclSpecifier_enumScoped(modifiers, this.stack.pop(), name, (IList)enumerators.done(), attributes, loc, decl, isMacroExpansion));
                }
            } else if (declSpec.isOpaque()) {
                this.stack.push(this.builder.DeclSpecifier_enumOpaque(modifiers, this.stack.pop(), name, attributes, loc, decl, isMacroExpansion));
            } else {
                this.stack.push(this.builder.DeclSpecifier_enum(modifiers, this.stack.pop(), name, (IList)enumerators.done(), attributes, loc, decl, isMacroExpansion));
            }
        }
        return 2;
    }

    private int visit(ICPPASTNamedTypeSpecifier declSpec) {
        this.at((IASTNode)declSpec);
        this.out("CPPNamedTypeSpecifier: " + declSpec.getRawSignature());
        throw new RuntimeException("NYI at " + String.valueOf(this.locs.forNode((IASTNode)declSpec)));
    }

    private int visit(ICASTSimpleDeclSpecifier declSpec) {
        this.at((IASTNode)declSpec);
        ISourceLocation loc = this.locs.forNode((IASTNode)declSpec);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declSpec);
        IList attributes = this.getAttributes((IASTAttributeOwner)declSpec);
        IList modifiers = this.getModifiers((IASTNode)declSpec);
        switch (declSpec.getType()) {
            case 0: {
                ISourceLocation location = null;
                if (modifiers.isEmpty()) {
                    location = this.vf.sourceLocation(loc, loc.getOffset(), 0);
                } else {
                    ISourceLocation before = (ISourceLocation)modifiers.get(modifiers.size() - 1).asWithKeywordParameters().getParameter("src");
                    location = this.vf.sourceLocation(before, before.getOffset() + before.getLength(), 0);
                }
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_unspecified(location, isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 1: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_void(this.getTokenSourceLocation((IASTNode)declSpec, "void"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 2: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_char(this.getTokenSourceLocation((IASTNode)declSpec, "char"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 3: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_integer(this.getTokenSourceLocation((IASTNode)declSpec, "int"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 4: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_float(this.getTokenSourceLocation((IASTNode)declSpec, "float"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 5: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_double(this.getTokenSourceLocation((IASTNode)declSpec, "double"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 6: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_bool(this.getTokenSourceLocation((IASTNode)declSpec, "bool"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 7: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_wchar_t(this.getTokenSourceLocation((IASTNode)declSpec, "wchar_t"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 8: {
                declSpec.getDeclTypeExpression().accept((ASTVisitor)this);
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_typeof(this.stack.pop(), this.getTokenSourceLocation((IASTNode)declSpec, "typeof"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 9: {
                declSpec.getDeclTypeExpression().accept((ASTVisitor)this);
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_decltype(this.stack.pop(), this.getTokenSourceLocation((IASTNode)declSpec, "decltype"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 10: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_auto(this.getTokenSourceLocation((IASTNode)declSpec, "auto"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 11: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_char16_t(this.getTokenSourceLocation((IASTNode)declSpec, "char16_t"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 12: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_char32_t(this.getTokenSourceLocation((IASTNode)declSpec, "char32_t"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 13: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_int128(this.getTokenSourceLocation((IASTNode)declSpec, "__int128"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 14: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_float128(this.getTokenSourceLocation((IASTNode)declSpec, "__float128"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 15: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_decimal128(this.getTokenSourceLocation((IASTNode)declSpec, "_Decimal32"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 16: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_decimal64(this.getTokenSourceLocation((IASTNode)declSpec, "_Decimal64"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 17: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_decimal128(this.getTokenSourceLocation((IASTNode)declSpec, "_Decimal128"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 18: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_declTypeAuto(loc, isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            default: {
                throw new RuntimeException("Unknown IASTSimpleDeclSpecifier kind " + declSpec.getType() + " at " + String.valueOf(loc) + ". Exiting");
            }
        }
        return 2;
    }

    private int visit(ICPPASTSimpleDeclSpecifier declSpec) {
        this.at((IASTNode)declSpec);
        ISourceLocation loc = this.locs.forNode((IASTNode)declSpec);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)declSpec);
        IList attributes = this.getAttributes((IASTAttributeOwner)declSpec);
        IList modifiers = this.getModifiers((IASTNode)declSpec);
        switch (declSpec.getType()) {
            case 0: {
                ISourceLocation location = null;
                if (modifiers.isEmpty()) {
                    location = this.vf.sourceLocation(loc, loc.getOffset(), 0);
                } else {
                    ISourceLocation before = (ISourceLocation)modifiers.get(modifiers.size() - 1).asWithKeywordParameters().getParameter("src");
                    location = this.vf.sourceLocation(before, before.getOffset() + before.getLength(), 0);
                }
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_unspecified(location, isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 1: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_void(this.getTokenSourceLocation((IASTNode)declSpec, "void"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 2: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_char(this.getTokenSourceLocation((IASTNode)declSpec, "char"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 3: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_integer(this.getTokenSourceLocation((IASTNode)declSpec, "int"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 4: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_float(this.getTokenSourceLocation((IASTNode)declSpec, "float"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 5: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_double(this.getTokenSourceLocation((IASTNode)declSpec, "double"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 6: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_bool(this.getTokenSourceLocation((IASTNode)declSpec, "bool"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 7: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_wchar_t(this.getTokenSourceLocation((IASTNode)declSpec, "wchar_t"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 8: {
                declSpec.getDeclTypeExpression().accept((ASTVisitor)this);
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_typeof(this.stack.pop(), this.getTokenSourceLocation((IASTNode)declSpec, "typeof"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 9: {
                declSpec.getDeclTypeExpression().accept((ASTVisitor)this);
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_decltype(this.stack.pop(), this.getTokenSourceLocation((IASTNode)declSpec, "decltype"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 10: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_auto(this.getTokenSourceLocation((IASTNode)declSpec, "auto"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 11: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_char16_t(this.getTokenSourceLocation((IASTNode)declSpec, "char16_t"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 12: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_char32_t(this.getTokenSourceLocation((IASTNode)declSpec, "char32_t"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 13: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_int128(this.getTokenSourceLocation((IASTNode)declSpec, "__int128"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 14: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_float128(this.getTokenSourceLocation((IASTNode)declSpec, "__float128"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 15: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_decimal128(this.getTokenSourceLocation((IASTNode)declSpec, "_Decimal32"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 16: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_decimal64(this.getTokenSourceLocation((IASTNode)declSpec, "_Decimal64"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 17: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_decimal128(this.getTokenSourceLocation((IASTNode)declSpec, "_Decimal128"), isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            case 18: {
                this.stack.push(this.builder.DeclSpecifier_declSpecifier(modifiers, this.builder.Type_declTypeAuto(loc, isMacroExpansion), attributes, loc, isMacroExpansion));
                break;
            }
            default: {
                throw new RuntimeException("Unknown IASTSimpleDeclSpecifier kind " + declSpec.getType() + " at " + String.valueOf(loc) + ". Exiting");
            }
        }
        return 2;
    }

    private int visit(ICPPASTTypeTransformationSpecifier declSpec) {
        this.at((IASTNode)declSpec);
        this.err("ICPPASTTypeTransformationSpecifier: " + declSpec.getRawSignature());
        throw new RuntimeException("NYI at " + String.valueOf(this.locs.forNode((IASTNode)declSpec)));
    }

    public int visit(IASTArrayModifier arrayModifier) {
        this.at((IASTNode)arrayModifier);
        ISourceLocation loc = this.locs.forNode((IASTNode)arrayModifier);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)arrayModifier);
        IList attributes = this.getAttributes((IASTAttributeOwner)arrayModifier);
        IList modifiers = this.getModifiers((IASTNode)arrayModifier);
        IASTExpression constantExpression = arrayModifier.getConstantExpression();
        if (constantExpression == null) {
            this.stack.push(this.builder.Expression_arrayModifier(modifiers, attributes, loc, isMacroExpansion));
        } else {
            constantExpression.accept((ASTVisitor)this);
            this.stack.push(this.builder.Expression_arrayModifier(modifiers, this.stack.pop(), attributes, loc, isMacroExpansion));
        }
        return 2;
    }

    public int visit(IASTPointerOperator ptrOperator) {
        this.at((IASTNode)ptrOperator);
        if (ptrOperator instanceof IASTPointer) {
            this.visit((IASTPointer)ptrOperator);
        } else if (ptrOperator instanceof ICPPASTReferenceOperator) {
            this.visit((ICPPASTReferenceOperator)ptrOperator);
        } else {
            throw new RuntimeException("Unknown IASTPointerOperator subtype +" + ptrOperator.getClass().getName() + " at " + String.valueOf(this.locs.forNode((IASTNode)ptrOperator)) + ". Exiting");
        }
        return 2;
    }

    private int visit(IASTPointer pointer) {
        this.at((IASTNode)pointer);
        ISourceLocation loc = this.locs.forNode((IASTNode)pointer);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)pointer);
        IList attributes = this.getAttributes((IASTAttributeOwner)pointer);
        IList modifiers = this.getModifiers((IASTNode)pointer);
        if (pointer instanceof ICPPASTPointerToMember) {
            ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)((ICPPASTPointerToMember)pointer), this.locs.forNode((IASTNode)pointer));
            ((ICPPASTPointerToMember)pointer).getName().accept((ASTVisitor)this);
            this.stack.push(this.builder.Declaration_pointerToMember(modifiers, this.stack.pop(), attributes, loc, decl, isMacroExpansion));
        } else {
            this.stack.push(this.builder.Declaration_pointer(modifiers, attributes, loc, isMacroExpansion));
        }
        return 2;
    }

    private int visit(ICPPASTReferenceOperator referenceOperator) {
        this.at((IASTNode)referenceOperator);
        ISourceLocation loc = this.locs.forNode((IASTNode)referenceOperator);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)referenceOperator);
        IList attributes = this.getAttributes((IASTAttributeOwner)referenceOperator);
        if (referenceOperator.isRValueReference()) {
            this.stack.push(this.builder.Declaration_rvalueReference(attributes, loc, isMacroExpansion));
        } else {
            this.stack.push(this.builder.Declaration_reference(attributes, loc, isMacroExpansion));
        }
        return 2;
    }

    public int visit(IASTAttribute attribute) {
        this.at((IASTNode)attribute);
        ISourceLocation src = this.locs.forNode((IASTNode)attribute);
        if (attribute.getArgumentClause() == null || attribute.getArgumentClause().getTokenCharImage() == null) {
            this.stack.push(this.builder.Attribute_attribute(new String(attribute.getName()), src));
        } else {
            this.stack.push(this.builder.Attribute_attribute(new String(attribute.getName()), new String(attribute.getArgumentClause().getTokenCharImage()), src));
        }
        return 2;
    }

    public int visit(IASTAttributeSpecifier specifier) {
        this.at((IASTNode)specifier);
        ISourceLocation src = this.locs.forNode((IASTNode)specifier);
        if (specifier instanceof ICPPASTAlignmentSpecifier) {
            IASTExpression expression = ((ICPPASTAlignmentSpecifier)specifier).getExpression();
            if (expression != null) {
                expression.accept((ASTVisitor)this);
            } else {
                ((ICPPASTAlignmentSpecifier)specifier).getTypeId().accept((ASTVisitor)this);
            }
            this.stack.push(this.builder.Attribute_alignmentSpecifier(this.stack.pop(), src));
        } else if (specifier instanceof IASTAttributeList) {
            IASTAttributeList list = (IASTAttributeList)specifier;
            IListWriter attributes = this.vf.listWriter();
            Stream.of(list.getAttributes()).forEach(it -> {
                it.accept((ASTVisitor)this);
                attributes.append(new IValue[]{(IValue)this.stack.pop()});
            });
            if (specifier instanceof IMSASTDeclspecList) {
                this.stack.push(this.builder.Attribute_msDeclspecList((IList)attributes.done(), src));
            } else if (specifier instanceof IGCCASTAttributeList) {
                this.stack.push(this.builder.Attribute_gccAttributeList((IList)attributes.done(), src));
            } else {
                this.stack.push(this.builder.Attribute_attributeSpecifier((IList)attributes.done(), src));
            }
        } else {
            throw new RuntimeException("Unknown AttributeSpecifier type: " + specifier.getClass().getSimpleName() + " at " + String.valueOf(src));
        }
        return 2;
    }

    public int visit(IASTToken token) {
        this.at((IASTNode)token);
        this.err("Token: " + new String(token.getTokenCharImage()));
        throw new RuntimeException("NYI at " + String.valueOf(this.locs.forNode((IASTNode)token)));
    }

    public int visit(IASTExpression expression) {
        this.at((IASTNode)expression);
        if (expression instanceof IASTArraySubscriptExpression) {
            this.visit((IASTArraySubscriptExpression)expression);
        } else if (expression instanceof IASTBinaryExpression) {
            this.visit((IASTBinaryExpression)expression);
        } else if (expression instanceof IASTBinaryTypeIdExpression) {
            this.visit((IASTBinaryTypeIdExpression)expression);
        } else if (expression instanceof IASTCastExpression) {
            this.visit((IASTCastExpression)expression);
        } else if (expression instanceof IASTConditionalExpression) {
            this.visit((IASTConditionalExpression)expression);
        } else if (expression instanceof IASTExpressionList) {
            this.visit((IASTExpressionList)expression);
        } else if (expression instanceof IASTFieldReference) {
            this.visit((IASTFieldReference)expression);
        } else if (expression instanceof IASTFunctionCallExpression) {
            this.visit((IASTFunctionCallExpression)expression);
        } else if (expression instanceof IASTIdExpression) {
            this.visit((IASTIdExpression)expression);
        } else if (expression instanceof IASTLiteralExpression) {
            this.visit((IASTLiteralExpression)expression);
        } else if (expression instanceof IASTTypeIdExpression) {
            this.visit((IASTTypeIdExpression)expression);
        } else if (expression instanceof IASTTypeIdInitializerExpression) {
            this.visit((IASTTypeIdInitializerExpression)expression);
        } else if (expression instanceof IASTUnaryExpression) {
            this.visit((IASTUnaryExpression)expression);
        } else if (expression instanceof ICPPASTArraySubscriptExpression) {
            this.visit((ICPPASTArraySubscriptExpression)expression);
        } else if (expression instanceof ICPPASTBinaryExpression) {
            this.visit((ICPPASTBinaryExpression)expression);
        } else if (expression instanceof ICPPASTCastExpression) {
            this.visit((ICPPASTCastExpression)expression);
        } else if (expression instanceof ICPPASTDeleteExpression) {
            this.visit((ICPPASTDeleteExpression)expression);
        } else if (expression instanceof ICPPASTExpressionList) {
            this.visit((ICPPASTExpressionList)expression);
        } else if (expression instanceof ICPPASTFieldReference) {
            this.visit((ICPPASTFieldReference)expression);
        } else if (expression instanceof ICPPASTFunctionCallExpression) {
            this.visit((ICPPASTFunctionCallExpression)expression);
        } else if (expression instanceof ICPPASTLambdaExpression) {
            this.visit((ICPPASTLambdaExpression)expression);
        } else if (expression instanceof ICPPASTLiteralExpression) {
            this.visit((ICPPASTLiteralExpression)expression);
        } else if (expression instanceof ICPPASTNaryTypeIdExpression) {
            this.visit((ICPPASTNaryTypeIdExpression)expression);
        } else if (expression instanceof ICPPASTNewExpression) {
            this.visit((ICPPASTNewExpression)expression);
        } else if (expression instanceof ICPPASTPackExpansionExpression) {
            this.visit((ICPPASTPackExpansionExpression)expression);
        } else if (expression instanceof ICPPASTSimpleTypeConstructorExpression) {
            this.visit((ICPPASTSimpleTypeConstructorExpression)expression);
        } else if (expression instanceof ICPPASTTypeIdExpression) {
            this.visit((ICPPASTTypeIdExpression)expression);
        } else if (expression instanceof ICPPASTUnaryExpression) {
            this.visit((ICPPASTUnaryExpression)expression);
        } else if (expression instanceof IASTProblemExpression) {
            this.visit((IASTProblemExpression)expression);
        } else if (expression instanceof CPPASTCompoundStatementExpression) {
            this.visit((CPPASTCompoundStatementExpression)expression);
        } else if (expression instanceof CASTCompoundStatementExpression) {
            this.visit((CASTCompoundStatementExpression)expression);
        } else {
            throw new RuntimeException("Expression: encountered non-implemented subtype " + expression.getClass().getName() + " at " + String.valueOf(this.locs.forNode((IASTNode)expression)));
        }
        return 2;
    }

    private int visit(CASTArraySubscriptExpression expression) {
        this.at((IASTNode)expression);
        ISourceLocation loc = this.locs.forNode((IASTNode)expression);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)expression);
        IConstructor typ = this.tr.resolveType((IASTNode)expression);
        expression.getArrayExpression().accept((ASTVisitor)this);
        IConstructor arrayExpression = this.stack.pop();
        expression.getArgument().accept((ASTVisitor)this);
        IConstructor argument = this.stack.pop();
        this.stack.push(this.builder.Expression_arraySubscriptExpression(arrayExpression, argument, loc, null, typ, isMacroExpansion));
        return 2;
    }

    private int visit(ICPPASTArraySubscriptExpression expression) {
        this.at((IASTNode)expression);
        ISourceLocation loc = this.locs.forNode((IASTNode)expression);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)expression);
        IConstructor typ = this.tr.resolveType((IASTNode)expression);
        expression.getArrayExpression().accept((ASTVisitor)this);
        IConstructor arrayExpression = this.stack.pop();
        expression.getArgument().accept((ASTVisitor)this);
        IConstructor argument = this.stack.pop();
        this.stack.push(this.builder.Expression_arraySubscriptExpression(arrayExpression, argument, loc, null, typ, isMacroExpansion));
        return 2;
    }

    private int visit(ICPPASTBinaryExpression expression) {
        this.at((IASTNode)expression);
        this.out("CPPBinaryExpression: " + expression.getRawSignature());
        throw new RuntimeException("NYI at " + String.valueOf(this.locs.forNode((IASTNode)expression)));
    }

    private int visit(ICPPASTCastExpression expression) {
        this.at((IASTNode)expression);
        this.out("CPPCastExpression: " + expression.getRawSignature());
        throw new RuntimeException("NYI at " + String.valueOf(this.locs.forNode((IASTNode)expression)));
    }

    private int visit(ICPPASTDeleteExpression expression) {
        this.at((IASTNode)expression);
        ISourceLocation loc = this.locs.forNode((IASTNode)expression);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)expression);
        IConstructor typ = this.tr.resolveType((IASTNode)expression);
        expression.getOperand().accept((ASTVisitor)this);
        if (expression.isGlobal()) {
            if (expression.isVectored()) {
                this.stack.push(this.builder.Expression_globalVectoredDelete(this.stack.pop(), loc, null, typ, isMacroExpansion));
            } else {
                this.stack.push(this.builder.Expression_globalDelete(this.stack.pop(), loc, null, typ, isMacroExpansion));
            }
        } else if (expression.isVectored()) {
            this.stack.push(this.builder.Expression_vectoredDelete(this.stack.pop(), loc, null, typ, isMacroExpansion));
        } else {
            this.stack.push(this.builder.Expression_delete(this.stack.pop(), loc, null, typ, isMacroExpansion));
        }
        return 2;
    }

    private int visit(ICPPASTExpressionList expression) {
        this.at((IASTNode)expression);
        this.out("CPPExpressionList: " + expression.getRawSignature());
        throw new RuntimeException("NYI at " + String.valueOf(this.locs.forNode((IASTNode)expression)));
    }

    private int visit(ICPPASTFieldReference expression) {
        this.at((IASTNode)expression);
        this.out("CPPFieldReference: " + expression.getRawSignature());
        throw new RuntimeException("NYI at " + String.valueOf(this.locs.forNode((IASTNode)expression)));
    }

    private int visit(ICPPASTFunctionCallExpression expression) {
        this.at((IASTNode)expression);
        this.out("CPPFunctionCallExpression: " + expression.getRawSignature());
        throw new RuntimeException("NYI at " + String.valueOf(this.locs.forNode((IASTNode)expression)));
    }

    private int visit(ICPPASTLambdaExpression expression) {
        IConstructor declarator;
        this.at((IASTNode)expression);
        ISourceLocation loc = this.locs.forNode((IASTNode)expression);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)expression);
        ISourceLocation decl = URIUtil.correctLocation((String)"missingDecl", (String)"", (String)"");
        IConstructor typ = this.tr.resolveType((IASTNode)expression);
        ICPPASTLambdaExpression.CaptureDefault captureDefault = expression.getCaptureDefault();
        IListWriter captures = this.vf.listWriter();
        Stream.of(expression.getCaptures()).forEach(it -> {
            it.accept((ASTVisitor)this);
            captures.append(new IValue[]{(IValue)this.stack.pop()});
        });
        if (expression.getDeclarator() == null) {
            ISourceLocation endOfCapture = this.getTokenSourceLocation((IASTNode)expression, "]");
            declarator = this.builder.Declarator_missingDeclarator(this.vf.sourceLocation(endOfCapture, endOfCapture.getOffset() + 1, 0), decl, isMacroExpansion);
        } else {
            expression.getDeclarator().accept((ASTVisitor)this);
            declarator = this.stack.pop();
        }
        expression.getBody().accept((ASTVisitor)this);
        IConstructor body = this.stack.pop();
        switch (captureDefault) {
            case BY_COPY: {
                this.stack.push(this.builder.Expression_lambda(this.builder.Modifier_captDefByCopy(this.getTokenSourceLocation((IASTNode)expression, "="), isMacroExpansion), (IList)captures.done(), declarator, body, loc, null, typ, isMacroExpansion));
                break;
            }
            case BY_REFERENCE: {
                this.stack.push(this.builder.Expression_lambda(this.builder.Modifier_captDefByReference(this.getTokenSourceLocation((IASTNode)expression, "&"), isMacroExpansion), (IList)captures.done(), declarator, body, loc, null, typ, isMacroExpansion));
                break;
            }
            case UNSPECIFIED: {
                this.stack.push(this.builder.Expression_lambda(this.builder.Modifier_captDefUnspecified(this.vf.sourceLocation(loc, loc.getOffset(), 0), isMacroExpansion), (IList)captures.done(), declarator, body, loc, null, typ, isMacroExpansion));
                break;
            }
            default: {
                throw new RuntimeException("Unknown default capture type " + String.valueOf(captureDefault) + " encountered at " + String.valueOf(this.locs.forNode((IASTNode)expression)) + ", exiting");
            }
        }
        return 2;
    }

    private int visit(ICPPASTLiteralExpression expression) {
        this.at((IASTNode)expression);
        this.visit((IASTLiteralExpression)expression);
        return 2;
    }

    private int visit(ICPPASTNaryTypeIdExpression expression) {
        this.at((IASTNode)expression);
        ISourceLocation loc = this.locs.forNode((IASTNode)expression);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)expression);
        IConstructor typ = this.tr.resolveType((IASTNode)expression);
        IListWriter args = this.vf.listWriter();
        Stream.of(expression.getOperands()).forEach(it -> {
            it.accept((ASTVisitor)this);
            args.append(new IValue[]{(IValue)this.stack.pop()});
        });
        switch (expression.getOperator()) {
            case __is_constructible: {
                this.stack.push(this.builder.Expression_isConstructable((IList)args.done(), loc, null, typ, isMacroExpansion));
                return 2;
            }
            case __is_trivially_constructible: {
                this.stack.push(this.builder.Expression_isTriviallyConstructable((IList)args.done(), loc, null, typ, isMacroExpansion));
                return 2;
            }
        }
        throw new RuntimeException("Operator " + String.valueOf(expression.getOperator()) + " unknown at " + String.valueOf(loc) + ", exiting");
    }

    private ISourceLocation changeScheme(ISourceLocation l, String newScheme) {
        try {
            return URIUtil.changeScheme((ISourceLocation)l, (String)newScheme);
        }
        catch (URISyntaxException e) {
            assert (false);
            return l;
        }
    }

    private int visit(ICPPASTNewExpression expression) {
        ISourceLocation newDecl;
        ISourceLocation decl;
        this.at((IASTNode)expression);
        ISourceLocation loc = this.locs.forNode((IASTNode)expression);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)expression);
        IConstructor typ = this.tr.resolveType((IASTNode)expression);
        expression.getTypeId().accept((ASTVisitor)this);
        IConstructor typeId = this.stack.pop();
        IBinding constructor = CPPSemantics.findImplicitlyCalledConstructor((ICPPASTNewExpression)expression);
        ISourceLocation iSourceLocation = decl = constructor != null ? this.br.resolveBinding(null, constructor, loc) : null;
        ISourceLocation iSourceLocation2 = decl != null ? this.changeScheme(decl, "cpp+new") : (newDecl = URIUtil.correctLocation((String)"cpp+new", (String)"", (String)("builtinAllocator" + (String)(typ != null ? "/" + typ.getName() : ""))));
        if (decl != null && newDecl != null) {
            this.newResolutions.append(new IValue[]{this.vf.tuple(new IValue[]{newDecl, decl})});
        }
        this.implicitDeclarations.insert(new IValue[]{newDecl});
        IASTInitializerClause[] _placementArguments = expression.getPlacementArguments();
        IASTInitializer _initializer = expression.getInitializer();
        IListWriter placementArguments = this.vf.listWriter();
        IConstructor initializer = null;
        if (_placementArguments != null) {
            Stream.of(_placementArguments).forEach(it -> {
                it.accept((ASTVisitor)this);
                placementArguments.append(new IValue[]{(IValue)this.stack.pop()});
            });
        }
        if (_initializer != null) {
            _initializer.accept((ASTVisitor)this);
            initializer = this.stack.pop();
        }
        if (_placementArguments != null) {
            if (expression.isGlobal()) {
                if (initializer == null) {
                    this.stack.push(this.builder.Expression_globalNewWithArgs((IList)placementArguments.done(), typeId, loc, newDecl, typ, isMacroExpansion));
                } else {
                    this.stack.push(this.builder.Expression_globalNewWithArgs((IList)placementArguments.done(), typeId, initializer, loc, newDecl, typ, isMacroExpansion));
                }
            } else if (_initializer == null) {
                this.stack.push(this.builder.Expression_newWithArgs((IList)placementArguments.done(), typeId, loc, newDecl, typ, isMacroExpansion));
            } else {
                this.stack.push(this.builder.Expression_newWithArgs((IList)placementArguments.done(), typeId, initializer, loc, newDecl, typ, isMacroExpansion));
            }
        } else if (expression.isGlobal()) {
            if (_initializer == null) {
                this.stack.push(this.builder.Expression_globalNew(typeId, loc, newDecl, typ, isMacroExpansion));
            } else {
                this.stack.push(this.builder.Expression_globalNew(typeId, initializer, loc, newDecl, typ, isMacroExpansion));
            }
        } else if (initializer == null) {
            this.stack.push(this.builder.Expression_new(typeId, loc, newDecl, typ, isMacroExpansion));
        } else {
            this.stack.push(this.builder.Expression_new(typeId, initializer, loc, newDecl, typ, isMacroExpansion));
        }
        return 2;
    }

    private int visit(ICPPASTPackExpansionExpression expression) {
        this.at((IASTNode)expression);
        ISourceLocation loc = this.locs.forNode((IASTNode)expression);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)expression);
        IConstructor typ = this.tr.resolveType((IASTNode)expression);
        expression.getPattern().accept((ASTVisitor)this);
        this.stack.push(this.builder.Expression_packExpansion(this.stack.pop(), loc, null, typ, isMacroExpansion));
        return 2;
    }

    private int visit(ICPPASTSimpleTypeConstructorExpression expression) {
        this.at((IASTNode)expression);
        ISourceLocation loc = this.locs.forNode((IASTNode)expression);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)expression);
        IConstructor typ = this.tr.resolveType((IASTNode)expression);
        expression.getDeclSpecifier().accept((ASTVisitor)this);
        IConstructor declSpecifier = this.stack.pop();
        expression.getInitializer().accept((ASTVisitor)this);
        IConstructor initializer = this.stack.pop();
        this.stack.push(this.builder.Expression_simpleTypeConstructor(declSpecifier, initializer, loc, null, typ, isMacroExpansion));
        return 2;
    }

    private int visit(ICPPASTTypeIdExpression expression) {
        this.at((IASTNode)expression);
        this.out("CPPTypeIdExpression: " + expression.getRawSignature());
        throw new RuntimeException("NYI at " + String.valueOf(this.locs.forNode((IASTNode)expression)));
    }

    private int visit(ICPPASTUnaryExpression expression) {
        this.at((IASTNode)expression);
        this.out("CPPUnaryExpression: " + expression.getRawSignature());
        throw new RuntimeException("NYI at " + String.valueOf(this.locs.forNode((IASTNode)expression)));
    }

    private int visit(CASTCompoundStatementExpression expression) {
        IConstructor typ;
        this.at((IASTNode)expression);
        ISourceLocation loc = this.locs.forNode((IASTNode)expression);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)expression);
        try {
            typ = this.tr.resolveType((IASTNode)expression);
        }
        catch (Throwable t) {
            this.err("CASTCompoundStatement couldn't get type at " + String.valueOf(loc));
            t.printStackTrace(this.stdErr);
            typ = this.builder.TypeSymbol_any();
        }
        expression.getCompoundStatement().accept((ASTVisitor)this);
        this.stack.push(this.builder.Expression_compoundStatementExpression(this.stack.pop(), loc, null, typ, isMacroExpansion));
        return 2;
    }

    private int visit(CPPASTCompoundStatementExpression expression) {
        IConstructor typ;
        this.at((IASTNode)expression);
        ISourceLocation loc = this.locs.forNode((IASTNode)expression);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)expression);
        try {
            typ = this.tr.resolveType((IASTNode)expression);
        }
        catch (Throwable t) {
            this.err("CPPASTCompoundStatement couldn't get type at " + String.valueOf(loc));
            t.printStackTrace(this.stdErr);
            typ = this.builder.TypeSymbol_any();
        }
        expression.getCompoundStatement().accept((ASTVisitor)this);
        this.stack.push(this.builder.Expression_compoundStatementExpression(this.stack.pop(), loc, null, typ, isMacroExpansion));
        return 2;
    }

    private int visit(IASTArraySubscriptExpression expression) {
        this.at((IASTNode)expression);
        if (expression instanceof ICPPASTArraySubscriptExpression) {
            this.visit((ICPPASTArraySubscriptExpression)expression);
        } else if (expression instanceof CASTArraySubscriptExpression) {
            this.visit((CASTArraySubscriptExpression)expression);
        } else {
            throw new RuntimeException("NYI at " + String.valueOf(this.locs.forNode((IASTNode)expression)));
        }
        return 2;
    }

    private int visit(IASTBinaryExpression expression) {
        ICPPASTBinaryExpression cppe;
        ICPPFunction overload;
        this.at((IASTNode)expression);
        ISourceLocation loc = this.locs.forNode((IASTNode)expression);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)expression);
        IConstructor typ = this.tr.resolveType((IASTNode)expression);
        expression.getOperand1().accept((ASTVisitor)this);
        IConstructor lhs = this.stack.pop();
        expression.getInitOperand2().accept((ASTVisitor)this);
        IConstructor rhs = this.stack.pop();
        ISourceLocation decl = null;
        if (expression instanceof ICPPASTBinaryExpression && (overload = (cppe = (ICPPASTBinaryExpression)expression).getOverload()) != null) {
            decl = this.br.resolveBinding((ICPPBinding)overload, loc);
        }
        switch (expression.getOperator()) {
            case 1: {
                this.stack.push(this.builder.Expression_multiply(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 2: {
                this.stack.push(this.builder.Expression_divide(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 3: {
                this.stack.push(this.builder.Expression_modulo(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 4: {
                this.stack.push(this.builder.Expression_plus(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 5: {
                this.stack.push(this.builder.Expression_minus(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 6: {
                this.stack.push(this.builder.Expression_shiftLeft(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 7: {
                this.stack.push(this.builder.Expression_shiftRight(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 8: {
                this.stack.push(this.builder.Expression_lessThan(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 9: {
                this.stack.push(this.builder.Expression_greaterThan(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 10: {
                this.stack.push(this.builder.Expression_lessEqual(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 11: {
                this.stack.push(this.builder.Expression_greaterEqual(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 12: {
                this.stack.push(this.builder.Expression_binaryAnd(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 13: {
                this.stack.push(this.builder.Expression_binaryXor(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 14: {
                this.stack.push(this.builder.Expression_binaryOr(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 15: {
                this.stack.push(this.builder.Expression_logicalAnd(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 16: {
                this.stack.push(this.builder.Expression_logicalOr(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 17: {
                this.stack.push(this.builder.Expression_assign(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 18: {
                this.stack.push(this.builder.Expression_multiplyAssign(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 19: {
                this.stack.push(this.builder.Expression_divideAssign(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 20: {
                this.stack.push(this.builder.Expression_moduloAssign(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 21: {
                this.stack.push(this.builder.Expression_plusAssign(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 22: {
                this.stack.push(this.builder.Expression_minusAssign(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 23: {
                this.stack.push(this.builder.Expression_shiftLeftAssign(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 24: {
                this.stack.push(this.builder.Expression_shiftRightAssign(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 25: {
                this.stack.push(this.builder.Expression_binaryAndAssign(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 26: {
                this.stack.push(this.builder.Expression_binaryXorAssign(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 27: {
                this.stack.push(this.builder.Expression_binaryOrAssign(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 28: {
                this.stack.push(this.builder.Expression_equals(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 29: {
                this.stack.push(this.builder.Expression_notEquals(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 30: {
                this.stack.push(this.builder.Expression_pmDot(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 31: {
                this.stack.push(this.builder.Expression_pmArrow(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 32: {
                this.stack.push(this.builder.Expression_max(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 33: {
                this.stack.push(this.builder.Expression_min(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 34: {
                this.stack.push(this.builder.Expression_ellipses(lhs, rhs, loc, decl, typ, isMacroExpansion));
                break;
            }
            default: {
                throw new RuntimeException("Operator " + expression.getOperator() + " unknown at " + String.valueOf(loc) + ", exiting");
            }
        }
        return 2;
    }

    private int visit(IASTBinaryTypeIdExpression expression) {
        this.at((IASTNode)expression);
        ISourceLocation loc = this.locs.forNode((IASTNode)expression);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)expression);
        IConstructor typ = this.tr.resolveType((IASTNode)expression);
        expression.getOperand1().accept((ASTVisitor)this);
        IConstructor lhs = this.stack.pop();
        expression.getOperand2().accept((ASTVisitor)this);
        IConstructor rhs = this.stack.pop();
        switch (expression.getOperator()) {
            case __is_base_of: {
                this.stack.push(this.builder.Expression_isBaseOf(lhs, rhs, loc, null, typ, isMacroExpansion));
                break;
            }
            case __is_trivially_assignable: {
                this.stack.push(this.builder.Expression_isTriviallyAssignable(lhs, rhs, loc, null, typ, isMacroExpansion));
                break;
            }
            default: {
                throw new RuntimeException("Unknown binary TypeId expression " + expression.getOperator().name() + " at " + String.valueOf(loc));
            }
        }
        return 2;
    }

    private int visit(IASTCastExpression expression) {
        this.at((IASTNode)expression);
        ISourceLocation loc = this.locs.forNode((IASTNode)expression);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)expression);
        IConstructor typ = this.tr.resolveType((IASTNode)expression);
        expression.getOperand().accept((ASTVisitor)this);
        IConstructor operand = this.stack.pop();
        expression.getTypeId().accept((ASTVisitor)this);
        IConstructor type = this.stack.pop();
        switch (expression.getOperator()) {
            case 0: {
                this.stack.push(this.builder.Expression_cast(type, operand, loc, null, typ, isMacroExpansion));
                break;
            }
            case 1: {
                this.stack.push(this.builder.Expression_dynamicCast(type, operand, loc, null, typ, isMacroExpansion));
                break;
            }
            case 2: {
                this.stack.push(this.builder.Expression_staticCast(type, operand, loc, null, typ, isMacroExpansion));
                break;
            }
            case 3: {
                this.stack.push(this.builder.Expression_reinterpretCast(type, operand, loc, null, typ, isMacroExpansion));
                break;
            }
            case 4: {
                this.stack.push(this.builder.Expression_constCast(type, operand, loc, null, typ, isMacroExpansion));
                break;
            }
            default: {
                throw new RuntimeException("Unknown cast type " + expression.getOperator() + " at " + String.valueOf(loc));
            }
        }
        return 2;
    }

    private int visit(IASTConditionalExpression expression) {
        this.at((IASTNode)expression);
        ISourceLocation loc = this.locs.forNode((IASTNode)expression);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)expression);
        IConstructor typ = this.tr.resolveType((IASTNode)expression);
        expression.getLogicalConditionExpression().accept((ASTVisitor)this);
        IConstructor condition = this.stack.pop();
        expression.getNegativeResultExpression().accept((ASTVisitor)this);
        IConstructor negative = this.stack.pop();
        IASTExpression positiveResultExpression = expression.getPositiveResultExpression();
        if (positiveResultExpression != null) {
            positiveResultExpression.accept((ASTVisitor)this);
            IConstructor positive = this.stack.pop();
            this.stack.push(this.builder.Expression_conditional(condition, positive, negative, loc, null, typ, isMacroExpansion));
        } else {
            this.stack.push(this.builder.Expression_conditional(condition, negative, loc, null, typ, isMacroExpansion));
        }
        return 2;
    }

    private int visit(IASTExpressionList expression) {
        this.at((IASTNode)expression);
        ISourceLocation loc = this.locs.forNode((IASTNode)expression);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)expression);
        IConstructor typ = this.tr.resolveType((IASTNode)expression);
        IListWriter expressions = this.vf.listWriter();
        Stream.of(expression.getExpressions()).forEach(it -> {
            it.accept((ASTVisitor)this);
            expressions.append(new IValue[]{(IValue)this.stack.pop()});
        });
        this.stack.push(this.builder.Expression_expressionList((IList)expressions.done(), loc, null, typ, isMacroExpansion));
        return 2;
    }

    private int visit(IASTFieldReference expression) {
        this.at((IASTNode)expression);
        ISourceLocation loc = this.locs.forNode((IASTNode)expression);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)expression);
        ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)expression, loc);
        IConstructor typ = this.tr.resolveType((IASTNode)expression);
        if (expression instanceof ICPPASTFieldReference) {
            expression.getFieldOwner().accept((ASTVisitor)this);
            IConstructor fieldOwner = this.stack.pop();
            expression.getFieldName().accept((ASTVisitor)this);
            IConstructor fieldName = this.stack.pop();
            if (expression.isPointerDereference()) {
                this.stack.push(this.builder.Expression_fieldReferencePointerDeref(fieldOwner, fieldName, loc, decl, typ, isMacroExpansion));
            } else {
                this.stack.push(this.builder.Expression_fieldReference(fieldOwner, fieldName, loc, decl, typ, isMacroExpansion));
            }
        } else if (expression instanceof CASTFieldReference) {
            expression.getFieldOwner().accept((ASTVisitor)this);
            IConstructor fieldOwner = this.stack.pop();
            expression.getFieldName().accept((ASTVisitor)this);
            IConstructor fieldName = this.stack.pop();
            if (expression.isPointerDereference()) {
                this.stack.push(this.builder.Expression_fieldReferencePointerDeref(fieldOwner, fieldName, loc, decl, typ, isMacroExpansion));
            } else {
                this.stack.push(this.builder.Expression_fieldReference(fieldOwner, fieldName, loc, decl, typ, isMacroExpansion));
            }
        } else {
            throw new RuntimeException("IASTFieldReference: NYI at " + String.valueOf(loc));
        }
        return 2;
    }

    private int visit(IASTFunctionCallExpression expression) {
        ICPPASTFunctionCallExpression cppe;
        ICPPFunction overload;
        this.at((IASTNode)expression);
        ISourceLocation loc = this.locs.forNode((IASTNode)expression);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)expression);
        IConstructor typ = this.tr.resolveType((IASTNode)expression);
        ISourceLocation decl = null;
        if (expression instanceof ICPPASTFunctionCallExpression && (overload = (cppe = (ICPPASTFunctionCallExpression)expression).getOverload()) != null) {
            decl = this.br.resolveBinding((ICPPBinding)overload, loc);
        }
        expression.getFunctionNameExpression().accept((ASTVisitor)this);
        IConstructor functionName = this.stack.pop();
        IListWriter arguments = this.vf.listWriter();
        Stream.of(expression.getArguments()).forEach(it -> {
            it.accept((ASTVisitor)this);
            arguments.append(new IValue[]{(IValue)this.stack.pop()});
        });
        this.stack.push(this.builder.Expression_functionCall(functionName, (IList)arguments.done(), loc, decl, typ, isMacroExpansion));
        return 2;
    }

    private int visit(IASTIdExpression expression) {
        this.at((IASTNode)expression);
        ISourceLocation loc = this.locs.forNode((IASTNode)expression);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)expression);
        ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)expression, loc);
        IConstructor typ = this.tr.resolveType((IASTNode)expression);
        expression.getName().accept((ASTVisitor)this);
        this.stack.push(this.builder.Expression_idExpression(this.stack.pop(), loc, decl, typ, isMacroExpansion));
        return 2;
    }

    private int visit(IASTLiteralExpression expression) {
        this.at((IASTNode)expression);
        ISourceLocation loc = this.locs.forNode((IASTNode)expression);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)expression);
        IConstructor typ = this.tr.resolveType((IASTNode)expression);
        ISourceLocation decl = null;
        String value = new String(expression.getValue());
        switch (expression.getKind()) {
            case 0: {
                this.stack.push(this.builder.Expression_integerConstant(value, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 1: {
                this.stack.push(this.builder.Expression_floatConstant(value, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 2: {
                this.stack.push(this.builder.Expression_charConstant(value, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 3: {
                this.stack.push(this.builder.Expression_stringLiteral(value, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 4: {
                this.stack.push(this.builder.Expression_this(loc, decl, typ, isMacroExpansion));
                break;
            }
            case 5: {
                this.stack.push(this.builder.Expression_true(loc, decl, typ, isMacroExpansion));
                break;
            }
            case 6: {
                this.stack.push(this.builder.Expression_false(loc, decl, typ, isMacroExpansion));
                break;
            }
            case 7: {
                this.stack.push(this.builder.Expression_nullptr(loc, decl, typ, isMacroExpansion));
                break;
            }
            default: {
                throw new RuntimeException("Encountered unknown literal kind " + expression.getKind() + " at " + String.valueOf(loc) + ". Exiting");
            }
        }
        return 2;
    }

    private int visit(IASTProblemExpression expression) {
        this.at((IASTNode)expression);
        ISourceLocation loc = this.locs.forNode((IASTNode)expression);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)expression);
        IASTProblem problem = expression.getProblem();
        if (this.doProblemLogging) {
            this.err("ProblemExpression " + expression.getRawSignature() + ":" + problem.getMessageWithLocation());
        }
        this.stack.push(this.builder.Expression_problemExpression(loc, isMacroExpansion));
        return 2;
    }

    private int visit(IASTTypeIdInitializerExpression expression) {
        this.at((IASTNode)expression);
        ISourceLocation loc = this.locs.forNode((IASTNode)expression);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)expression);
        IConstructor typ = this.tr.resolveType((IASTNode)expression);
        expression.getTypeId().accept((ASTVisitor)this);
        IConstructor typeId = this.stack.pop();
        expression.getInitializer().accept((ASTVisitor)this);
        this.stack.push(this.builder.Expression_typeIdInitializerExpression(typeId, this.stack.pop(), loc, null, typ, isMacroExpansion));
        return 2;
    }

    private int visit(IASTTypeIdExpression expression) {
        this.at((IASTNode)expression);
        ISourceLocation loc = this.locs.forNode((IASTNode)expression);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)expression);
        IConstructor typ = this.tr.resolveType((IASTNode)expression);
        expression.getTypeId().accept((ASTVisitor)this);
        switch (expression.getOperator()) {
            case 0: {
                this.stack.push(this.builder.Expression_sizeof(this.stack.pop(), loc, null, typ, isMacroExpansion));
                break;
            }
            case 1: {
                this.stack.push(this.builder.Expression_typeid(this.stack.pop(), loc, null, typ, isMacroExpansion));
                break;
            }
            case 2: {
                this.stack.push(this.builder.Expression_alignOf(this.stack.pop(), loc, null, typ, isMacroExpansion));
                break;
            }
            case 3: {
                this.stack.push(this.builder.Expression_typeof(this.stack.pop(), loc, null, typ, isMacroExpansion));
                break;
            }
            case 4: {
                this.stack.push(this.builder.Expression_hasNothrowAssign(this.stack.pop(), loc, null, typ, isMacroExpansion));
                break;
            }
            case 5: {
                this.stack.push(this.builder.Expression_hasNothrowCopy(this.stack.pop(), loc, null, typ, isMacroExpansion));
                break;
            }
            case 6: {
                this.stack.push(this.builder.Expression_hasNothrowConstructor(this.stack.pop(), loc, null, typ, isMacroExpansion));
                break;
            }
            case 7: {
                this.stack.push(this.builder.Expression_hasTrivialAssign(this.stack.pop(), loc, null, typ, isMacroExpansion));
                break;
            }
            case 9: {
                this.stack.push(this.builder.Expression_hasTrivialConstructor(this.stack.pop(), loc, null, typ, isMacroExpansion));
                break;
            }
            case 8: {
                this.stack.push(this.builder.Expression_hasTrivialCopy(this.stack.pop(), loc, null, typ, isMacroExpansion));
                break;
            }
            case 10: {
                this.stack.push(this.builder.Expression_hasTrivialDestructor(this.stack.pop(), loc, null, typ, isMacroExpansion));
                break;
            }
            case 11: {
                this.stack.push(this.builder.Expression_hasVirtualDestructor(this.stack.pop(), loc, null, typ, isMacroExpansion));
                break;
            }
            case 12: {
                this.stack.push(this.builder.Expression_isAbstract(this.stack.pop(), loc, null, typ, isMacroExpansion));
                break;
            }
            case 13: {
                this.stack.push(this.builder.Expression_isClass(this.stack.pop(), loc, null, typ, isMacroExpansion));
                break;
            }
            case 14: {
                this.stack.push(this.builder.Expression_isEmpty(this.stack.pop(), loc, null, typ, isMacroExpansion));
                break;
            }
            case 15: {
                this.stack.push(this.builder.Expression_isEnum(this.stack.pop(), loc, null, typ, isMacroExpansion));
                break;
            }
            case 16: {
                this.stack.push(this.builder.Expression_isPod(this.stack.pop(), loc, null, typ, isMacroExpansion));
                break;
            }
            case 17: {
                this.stack.push(this.builder.Expression_isPolymorphic(this.stack.pop(), loc, null, typ, isMacroExpansion));
                break;
            }
            case 18: {
                this.stack.push(this.builder.Expression_isUnion(this.stack.pop(), loc, null, typ, isMacroExpansion));
                break;
            }
            case 19: {
                this.stack.push(this.builder.Expression_isLiteralType(this.stack.pop(), loc, null, typ, isMacroExpansion));
                break;
            }
            case 20: {
                this.stack.push(this.builder.Expression_isStandardLayout(this.stack.pop(), loc, null, typ, isMacroExpansion));
                break;
            }
            case 21: {
                this.stack.push(this.builder.Expression_isTrivial(this.stack.pop(), loc, null, typ, isMacroExpansion));
                break;
            }
            case 22: {
                this.stack.push(this.builder.Expression_sizeofParameterPack(this.stack.pop(), loc, null, typ, isMacroExpansion));
                break;
            }
            case 23: {
                this.stack.push(this.builder.Expression_isFinal(this.stack.pop(), loc, null, typ, isMacroExpansion));
                break;
            }
            case 24: {
                this.stack.push(this.builder.Expression_isTriviallyCopyable(this.stack.pop(), loc, null, typ, isMacroExpansion));
                break;
            }
            default: {
                throw new RuntimeException("ERROR: IASTTypeIdExpression called with unimplemented/unknown operator " + expression.getOperator() + " at " + String.valueOf(loc));
            }
        }
        return 2;
    }

    private int visit(IASTUnaryExpression expression) {
        ICPPASTUnaryExpression cppe;
        ICPPFunction overload;
        this.at((IASTNode)expression);
        ISourceLocation loc = this.locs.forNode((IASTNode)expression);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)expression);
        IConstructor typ = this.tr.resolveType((IASTNode)expression);
        ISourceLocation decl = null;
        IConstructor operand = null;
        if (expression.getOperand() != null) {
            expression.getOperand().accept((ASTVisitor)this);
            operand = this.stack.pop();
        }
        if (expression instanceof ICPPASTUnaryExpression && (overload = (cppe = (ICPPASTUnaryExpression)expression).getOverload()) != null) {
            decl = this.br.resolveBinding((ICPPBinding)overload, loc);
        }
        switch (expression.getOperator()) {
            case 0: {
                this.stack.push(this.builder.Expression_prefixIncr(operand, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 1: {
                this.stack.push(this.builder.Expression_prefixDecr(operand, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 2: {
                this.stack.push(this.builder.Expression_plus(operand, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 3: {
                this.stack.push(this.builder.Expression_minus(operand, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 4: {
                this.stack.push(this.builder.Expression_star(operand, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 5: {
                this.stack.push(this.builder.Expression_amper(operand, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 6: {
                this.stack.push(this.builder.Expression_tilde(operand, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 7: {
                this.stack.push(this.builder.Expression_not(operand, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 8: {
                this.stack.push(this.builder.Expression_sizeof(operand, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 9: {
                this.stack.push(this.builder.Expression_postfixIncr(operand, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 10: {
                this.stack.push(this.builder.Expression_postfixDecr(operand, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 11: {
                this.stack.push(this.builder.Expression_bracketed(operand, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 12: {
                if (operand == null) {
                    this.stack.push(this.builder.Expression_throw(loc, decl, typ, isMacroExpansion));
                    break;
                }
                this.stack.push(this.builder.Expression_throw(operand, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 13: {
                this.stack.push(this.builder.Expression_typeid(operand, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 15: {
                this.stack.push(this.builder.Expression_alignOf(operand, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 16: {
                this.stack.push(this.builder.Expression_sizeofParameterPack(operand, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 17: {
                this.stack.push(this.builder.Expression_noexcept(operand, loc, decl, typ, isMacroExpansion));
                break;
            }
            case 18: {
                this.stack.push(this.builder.Expression_labelReference(operand, loc, decl, typ, isMacroExpansion));
                break;
            }
            default: {
                throw new RuntimeException("Unknown unary operator " + expression.getOperator() + " at " + String.valueOf(loc) + ". Exiting");
            }
        }
        return 2;
    }

    public int visit(IASTStatement statement) {
        this.at((IASTNode)statement);
        if (statement instanceof IASTAmbiguousStatement) {
            this.visit((IASTAmbiguousStatement)statement);
        } else if (statement instanceof IASTBreakStatement) {
            this.visit((IASTBreakStatement)statement);
        } else if (statement instanceof IASTCaseStatement) {
            this.visit((IASTCaseStatement)statement);
        } else if (statement instanceof IASTCompoundStatement) {
            this.visit((IASTCompoundStatement)statement);
        } else if (statement instanceof IASTContinueStatement) {
            this.visit((IASTContinueStatement)statement);
        } else if (statement instanceof IASTDeclarationStatement) {
            this.visit((IASTDeclarationStatement)statement);
        } else if (statement instanceof IASTDefaultStatement) {
            this.visit((IASTDefaultStatement)statement);
        } else if (statement instanceof IASTDoStatement) {
            this.visit((IASTDoStatement)statement);
        } else if (statement instanceof IASTExpressionStatement) {
            this.visit((IASTExpressionStatement)statement);
        } else if (statement instanceof IASTForStatement) {
            this.visit((IASTForStatement)statement);
        } else if (statement instanceof IASTGotoStatement) {
            this.visit((IASTGotoStatement)statement);
        } else if (statement instanceof IASTIfStatement) {
            this.visit((IASTIfStatement)statement);
        } else if (statement instanceof IASTLabelStatement) {
            this.visit((IASTLabelStatement)statement);
        } else if (statement instanceof IASTNullStatement) {
            this.visit((IASTNullStatement)statement);
        } else if (statement instanceof IASTReturnStatement) {
            this.visit((IASTReturnStatement)statement);
        } else if (statement instanceof IASTSwitchStatement) {
            this.visit((IASTSwitchStatement)statement);
        } else if (statement instanceof IASTWhileStatement) {
            this.visit((IASTWhileStatement)statement);
        } else if (statement instanceof ICPPASTCatchHandler) {
            this.visit((ICPPASTCatchHandler)statement);
        } else if (statement instanceof ICPPASTRangeBasedForStatement) {
            this.visit((ICPPASTRangeBasedForStatement)statement);
        } else if (statement instanceof ICPPASTTryBlockStatement) {
            this.visit((ICPPASTTryBlockStatement)statement);
        } else if (statement instanceof IGNUASTGotoStatement) {
            this.visit((IGNUASTGotoStatement)statement);
        } else if (statement instanceof IASTProblemStatement) {
            this.visit((IASTProblemStatement)statement);
        } else {
            throw new RuntimeException("Statement: encountered non-implemented subtype " + statement.getClass().getName() + " at " + String.valueOf(this.locs.forNode((IASTNode)statement)));
        }
        return 2;
    }

    private int visit(IGNUASTGotoStatement statement) {
        this.at((IASTNode)statement);
        this.visit(statement.getLabelNameExpression());
        IList attributes = this.getAttributes((IASTAttributeOwner)statement);
        ISourceLocation loc = this.locs.forNode((IASTNode)statement);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)statement);
        this.stack.push(this.builder.Statement_computedGoto(this.stack.pop(), attributes, loc, isMacroExpansion));
        return 2;
    }

    private int visit(ICPPASTCatchHandler statement) {
        this.at((IASTNode)statement);
        ISourceLocation loc = this.locs.forNode((IASTNode)statement);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)statement);
        IList attributes = this.getAttributes((IASTAttributeOwner)statement);
        statement.getCatchBody().accept((ASTVisitor)this);
        IConstructor catchBody = this.stack.pop();
        if (statement.isCatchAll()) {
            this.stack.push(this.builder.Statement_catchAll(catchBody, attributes, loc, isMacroExpansion));
        } else {
            statement.getDeclaration().accept((ASTVisitor)this);
            this.stack.push(this.builder.Statement_catch(this.stack.pop(), catchBody, attributes, loc, isMacroExpansion));
        }
        return 2;
    }

    private int visit(ICPPASTRangeBasedForStatement statement) {
        this.at((IASTNode)statement);
        ISourceLocation loc = this.locs.forNode((IASTNode)statement);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)statement);
        IList attributes = this.getAttributes((IASTAttributeOwner)statement);
        statement.getDeclaration().accept((ASTVisitor)this);
        IConstructor declaration = this.stack.pop();
        statement.getInitializerClause().accept((ASTVisitor)this);
        IConstructor initializerClause = this.stack.pop();
        statement.getBody().accept((ASTVisitor)this);
        IConstructor body = this.stack.pop();
        this.stack.push(this.builder.Statement_rangeBasedFor(declaration, initializerClause, body, attributes, loc, isMacroExpansion));
        return 2;
    }

    private int visit(ICPPASTTryBlockStatement statement) {
        this.at((IASTNode)statement);
        ISourceLocation loc = this.locs.forNode((IASTNode)statement);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)statement);
        IList attributes = this.getAttributes((IASTAttributeOwner)statement);
        statement.getTryBody().accept((ASTVisitor)this);
        IConstructor tryBody = this.stack.pop();
        IListWriter catchHandlers = this.vf.listWriter();
        Stream.of(statement.getCatchHandlers()).forEach(it -> {
            it.accept((ASTVisitor)this);
            catchHandlers.append(new IValue[]{(IValue)this.stack.pop()});
        });
        this.stack.push(this.builder.Statement_tryBlock(tryBody, (IList)catchHandlers.done(), attributes, loc, isMacroExpansion));
        return 2;
    }

    private int visit(IASTAmbiguousStatement statement) {
        this.at((IASTNode)statement);
        ISourceLocation loc = this.locs.forNode((IASTNode)statement);
        this.out("visit(IASTAmbiguousStatement) " + String.valueOf(loc));
        this.out(statement.getRawSignature());
        IListWriter statements = this.vf.listWriter();
        this.prefix += 4;
        Stream.of(statement.getStatements()).forEach(it -> {
            this.out("Statement " + it.getClass().getSimpleName() + ": " + it.getRawSignature());
            it.accept((ASTVisitor)this);
            statements.append(new IValue[]{(IValue)this.stack.pop()});
        });
        this.prefix -= 4;
        throw new RuntimeException("Encountered Ambiguous statement at " + String.valueOf(loc));
    }

    private int visit(IASTBreakStatement statement) {
        this.at((IASTNode)statement);
        ISourceLocation loc = this.locs.forNode((IASTNode)statement);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)statement);
        IList attributes = this.getAttributes((IASTAttributeOwner)statement);
        this.stack.push(this.builder.Statement_break(attributes, loc, isMacroExpansion));
        return 2;
    }

    private int visit(IASTCaseStatement statement) {
        this.at((IASTNode)statement);
        ISourceLocation loc = this.locs.forNode((IASTNode)statement);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)statement);
        IList attributes = this.getAttributes((IASTAttributeOwner)statement);
        statement.getExpression().accept((ASTVisitor)this);
        IConstructor expression = this.stack.pop();
        this.stack.push(this.builder.Statement_case(expression, attributes, loc, isMacroExpansion));
        return 2;
    }

    private int visit(IASTCompoundStatement statement) {
        this.at((IASTNode)statement);
        ISourceLocation loc = this.locs.forNode((IASTNode)statement);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)statement);
        IList attributes = this.getAttributes((IASTAttributeOwner)statement);
        IListWriter statements = this.vf.listWriter();
        Stream.of(statement.getStatements()).forEach(it -> {
            it.accept((ASTVisitor)this);
            statements.append(new IValue[]{(IValue)this.stack.pop()});
        });
        this.stack.push(this.builder.Statement_compoundStatement((IList)statements.done(), attributes, loc, isMacroExpansion));
        return 2;
    }

    private int visit(IASTContinueStatement statement) {
        this.at((IASTNode)statement);
        ISourceLocation loc = this.locs.forNode((IASTNode)statement);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)statement);
        IList attributes = this.getAttributes((IASTAttributeOwner)statement);
        this.stack.push(this.builder.Statement_continue(attributes, loc, isMacroExpansion));
        return 2;
    }

    private int visit(IASTDeclarationStatement statement) {
        this.at((IASTNode)statement);
        ISourceLocation loc = this.locs.forNode((IASTNode)statement);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)statement);
        IList attributes = this.getAttributes((IASTAttributeOwner)statement);
        statement.getDeclaration().accept((ASTVisitor)this);
        this.stack.push(this.builder.Statement_declarationStatement(this.stack.pop(), attributes, loc, isMacroExpansion));
        return 2;
    }

    private int visit(IASTDefaultStatement statement) {
        this.at((IASTNode)statement);
        ISourceLocation loc = this.locs.forNode((IASTNode)statement);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)statement);
        IList attributes = this.getAttributes((IASTAttributeOwner)statement);
        this.stack.push(this.builder.Statement_defaultCase(attributes, loc, isMacroExpansion));
        return 2;
    }

    private int visit(IASTDoStatement statement) {
        this.at((IASTNode)statement);
        ISourceLocation loc = this.locs.forNode((IASTNode)statement);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)statement);
        IList attributes = this.getAttributes((IASTAttributeOwner)statement);
        statement.getBody().accept((ASTVisitor)this);
        IConstructor body = this.stack.pop();
        statement.getCondition().accept((ASTVisitor)this);
        IConstructor condition = this.stack.pop();
        this.stack.push(this.builder.Statement_do(body, condition, attributes, loc, isMacroExpansion));
        return 2;
    }

    private int visit(IASTExpressionStatement statement) {
        this.at((IASTNode)statement);
        ISourceLocation loc = this.locs.forNode((IASTNode)statement);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)statement);
        IList attributes = this.getAttributes((IASTAttributeOwner)statement);
        statement.getExpression().accept((ASTVisitor)this);
        this.stack.push(this.builder.Statement_expressionStatement(this.stack.pop(), attributes, loc, isMacroExpansion));
        return 2;
    }

    private int visit(IASTForStatement statement) {
        IASTDeclaration _conditionDeclaration;
        IConstructor iteration;
        IConstructor condition;
        IASTExpression _condition;
        this.at((IASTNode)statement);
        ISourceLocation loc = this.locs.forNode((IASTNode)statement);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)statement);
        IList attributes = this.getAttributes((IASTAttributeOwner)statement);
        IASTStatement _initializer = statement.getInitializerStatement();
        IConstructor initializer = null;
        if (_initializer != null) {
            _initializer.accept((ASTVisitor)this);
            initializer = this.stack.pop();
        }
        if ((_condition = statement.getConditionExpression()) == null) {
            ISourceLocation initializerLoc = (ISourceLocation)initializer.asWithKeywordParameters().getParameter("src");
            condition = this.builder.Expression_empty(this.vf.sourceLocation(initializerLoc, initializerLoc.getOffset() + initializerLoc.getLength(), 0), isMacroExpansion);
        } else {
            _condition.accept((ASTVisitor)this);
            condition = this.stack.pop();
        }
        IASTExpression _iteration = statement.getIterationExpression();
        if (_iteration == null) {
            ISourceLocation conditionLoc = (ISourceLocation)condition.asWithKeywordParameters().getParameter("src");
            iteration = this.builder.Expression_empty(this.vf.sourceLocation(conditionLoc, conditionLoc.getOffset() + conditionLoc.getLength(), 0), isMacroExpansion);
        } else {
            _iteration.accept((ASTVisitor)this);
            iteration = this.stack.pop();
        }
        statement.getBody().accept((ASTVisitor)this);
        IConstructor body = this.stack.pop();
        if (statement instanceof ICPPASTForStatement && (_conditionDeclaration = ((ICPPASTForStatement)statement).getConditionDeclaration()) != null) {
            _conditionDeclaration.accept((ASTVisitor)this);
            this.stack.push(this.builder.Statement_forWithDecl(initializer, this.stack.pop(), iteration, body, attributes, loc, isMacroExpansion));
            return 2;
        }
        this.stack.push(this.builder.Statement_for(initializer, condition, iteration, body, attributes, loc, isMacroExpansion));
        return 2;
    }

    private int visit(IASTGotoStatement statement) {
        this.at((IASTNode)statement);
        ISourceLocation loc = this.locs.forNode((IASTNode)statement);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)statement);
        ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)statement, loc);
        IList attributes = this.getAttributes((IASTAttributeOwner)statement);
        statement.getName().accept((ASTVisitor)this);
        this.stack.push(this.builder.Statement_goto(this.stack.pop(), attributes, loc, decl, isMacroExpansion));
        return 2;
    }

    private int visit(IASTIfStatement statement) {
        this.at((IASTNode)statement);
        ISourceLocation loc = this.locs.forNode((IASTNode)statement);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)statement);
        IList attributes = this.getAttributes((IASTAttributeOwner)statement);
        statement.getThenClause().accept((ASTVisitor)this);
        IConstructor thenClause = this.stack.pop();
        IConstructor elseClause = null;
        if (statement.getElseClause() != null) {
            statement.getElseClause().accept((ASTVisitor)this);
            elseClause = this.stack.pop();
        }
        if (statement.getConditionExpression() == null && statement instanceof ICPPASTIfStatement) {
            ((ICPPASTIfStatement)statement).getConditionDeclaration().accept((ASTVisitor)this);
            if (elseClause == null) {
                this.stack.push(this.builder.Statement_ifWithDecl(this.stack.pop(), thenClause, attributes, loc, isMacroExpansion));
            } else {
                this.stack.push(this.builder.Statement_ifWithDecl(this.stack.pop(), thenClause, elseClause, attributes, loc, isMacroExpansion));
            }
        } else {
            statement.getConditionExpression().accept((ASTVisitor)this);
            if (elseClause == null) {
                this.stack.push(this.builder.Statement_if(this.stack.pop(), thenClause, attributes, loc, isMacroExpansion));
            } else {
                this.stack.push(this.builder.Statement_if(this.stack.pop(), thenClause, elseClause, attributes, loc, isMacroExpansion));
            }
        }
        return 2;
    }

    private int visit(IASTLabelStatement statement) {
        this.at((IASTNode)statement);
        ISourceLocation loc = this.locs.forNode((IASTNode)statement);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)statement);
        ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)statement, loc);
        IList attributes = this.getAttributes((IASTAttributeOwner)statement);
        statement.getName().accept((ASTVisitor)this);
        IConstructor name = this.stack.pop();
        statement.getNestedStatement().accept((ASTVisitor)this);
        IConstructor nestedStatement = this.stack.pop();
        this.stack.push(this.builder.Statement_label(name, nestedStatement, attributes, loc, decl, isMacroExpansion));
        return 2;
    }

    private int visit(IASTNullStatement statement) {
        this.at((IASTNode)statement);
        ISourceLocation loc = this.locs.forNode((IASTNode)statement);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)statement);
        IList attributes = this.getAttributes((IASTAttributeOwner)statement);
        this.stack.push(this.builder.Statement_nullStatement(attributes, loc, isMacroExpansion));
        return 2;
    }

    private int visit(IASTProblemStatement statement) {
        this.at((IASTNode)statement);
        ISourceLocation loc = this.locs.forNode((IASTNode)statement);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)statement);
        if (this.doProblemLogging) {
            this.err("IASTProblemStatement:");
            this.prefix += 4;
            this.err(statement.getProblem().getMessageWithLocation());
            this.err("" + statement.getProblem().getID());
            this.err(statement.getRawSignature());
            this.prefix -= 4;
        }
        this.stack.push(this.builder.Statement_problem(statement.getRawSignature(), loc, isMacroExpansion));
        return 2;
    }

    private int visit(IASTReturnStatement statement) {
        this.at((IASTNode)statement);
        ISourceLocation loc = this.locs.forNode((IASTNode)statement);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)statement);
        IList attributes = this.getAttributes((IASTAttributeOwner)statement);
        IASTExpression returnValue = statement.getReturnValue();
        IASTInitializerClause returnArgument = statement.getReturnArgument();
        if (returnValue == null && returnArgument == null) {
            this.stack.push(this.builder.Statement_return(attributes, loc, isMacroExpansion));
        } else if (returnValue != null) {
            returnValue.accept((ASTVisitor)this);
            this.stack.push(this.builder.Statement_return(this.stack.pop(), attributes, loc, isMacroExpansion));
        } else {
            returnArgument.accept((ASTVisitor)this);
            this.stack.push(this.builder.Statement_return(this.stack.pop(), attributes, loc, isMacroExpansion));
        }
        return 2;
    }

    private int visit(IASTSwitchStatement statement) {
        this.at((IASTNode)statement);
        ISourceLocation loc = this.locs.forNode((IASTNode)statement);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)statement);
        IList attributes = this.getAttributes((IASTAttributeOwner)statement);
        statement.getBody().accept((ASTVisitor)this);
        IConstructor body = this.stack.pop();
        IASTExpression _controller = statement.getControllerExpression();
        if (_controller == null && statement instanceof ICPPASTSwitchStatement) {
            ((ICPPASTSwitchStatement)statement).getControllerDeclaration().accept((ASTVisitor)this);
            this.stack.push(this.builder.Statement_switchWithDecl(this.stack.pop(), body, attributes, loc, isMacroExpansion));
            return 2;
        }
        _controller.accept((ASTVisitor)this);
        this.stack.push(this.builder.Statement_switch(this.stack.pop(), body, attributes, loc, isMacroExpansion));
        return 2;
    }

    private int visit(IASTWhileStatement statement) {
        this.at((IASTNode)statement);
        ISourceLocation loc = this.locs.forNode((IASTNode)statement);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)statement);
        IList attributes = this.getAttributes((IASTAttributeOwner)statement);
        statement.getBody().accept((ASTVisitor)this);
        IConstructor body = this.stack.pop();
        IASTExpression _condition = statement.getCondition();
        if (_condition == null && statement instanceof ICPPASTWhileStatement) {
            ((ICPPASTWhileStatement)statement).getConditionDeclaration().accept((ASTVisitor)this);
            this.stack.push(this.builder.Statement_whileWithDecl(this.stack.pop(), body, attributes, loc, isMacroExpansion));
            return 2;
        }
        _condition.accept((ASTVisitor)this);
        this.stack.push(this.builder.Statement_while(this.stack.pop(), body, attributes, loc, isMacroExpansion));
        return 2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int visit(IASTTypeId typeId) {
        this.at((IASTNode)typeId);
        ISourceLocation loc = this.locs.forNode((IASTNode)typeId);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)typeId);
        if (typeId instanceof IASTProblemTypeId) {
            if (!typeId.getRawSignature().equals("...") && !typeId.getRawSignature().contains("_THROW1(")) {
                this.out("ProblemTypeId " + typeId.getClass().getSimpleName() + ": " + typeId.getRawSignature());
                throw new RuntimeException("IASTProblemTypeId encountered at " + String.valueOf(loc) + "! " + ((IASTProblemTypeId)typeId).getProblem().getMessageWithLocation());
            }
            this.stack.push(this.builder.Expression_typeId(this.builder.DeclSpecifier_msThrowEllipsis(loc, BindingsResolver.failedBinding("unknown"), false), loc, isMacroExpansion));
            return 2;
        }
        typeId.getDeclSpecifier().accept((ASTVisitor)this);
        IConstructor declSpecifier = this.stack.pop();
        typeId.getAbstractDeclarator().accept((ASTVisitor)this);
        IConstructor abstractDeclarator = this.stack.pop();
        if (abstractDeclarator.has("name")) {
            ISourceLocation declaratorLoc = this.locs.forNode((IASTNode)typeId.getAbstractDeclarator());
            abstractDeclarator = abstractDeclarator.set("name", (IValue)this.builder.Name_abstractEmptyName(declaratorLoc, false));
            abstractDeclarator = (IConstructor)abstractDeclarator.asWithKeywordParameters().unsetParameter("decl");
        }
        this.stack.push(this.builder.Expression_typeId(declSpecifier, abstractDeclarator, loc, isMacroExpansion));
        return 2;
    }

    public int visit(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
        this.at((IASTNode)enumerator);
        ISourceLocation loc = this.locs.forNode((IASTNode)enumerator);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)enumerator);
        ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)enumerator, loc);
        enumerator.getName().accept((ASTVisitor)this);
        IConstructor name = this.stack.pop();
        IASTExpression value = enumerator.getValue();
        if (value == null) {
            this.stack.push(this.builder.Declaration_enumerator(name, loc, decl, isMacroExpansion));
        } else {
            value.accept((ASTVisitor)this);
            this.stack.push(this.builder.Declaration_enumerator(name, this.stack.pop(), loc, decl, isMacroExpansion));
        }
        return 2;
    }

    public int visit(IASTProblem problem) {
        this.at((IASTNode)problem);
        this.err("Problem: " + problem.getMessage());
        throw new RuntimeException("NYI at " + String.valueOf(this.locs.forNode((IASTNode)problem)));
    }

    public int visit(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier baseSpecifier) {
        ICPPASTNameSpecifier nameSpecifier;
        this.at((IASTNode)baseSpecifier);
        ISourceLocation loc = this.locs.forNode((IASTNode)baseSpecifier);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)baseSpecifier);
        ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)baseSpecifier, loc);
        IListWriter modifiers = this.vf.listWriter();
        switch (baseSpecifier.getVisibility()) {
            case 1: {
                modifiers.append(new IValue[]{this.builder.Modifier_public(this.getTokenSourceLocation((IASTNode)baseSpecifier, "public"), isMacroExpansion)});
                break;
            }
            case 2: {
                modifiers.append(new IValue[]{this.builder.Modifier_protected(this.getTokenSourceLocation((IASTNode)baseSpecifier, "protected"), isMacroExpansion)});
                break;
            }
            case 3: {
                modifiers.append(new IValue[]{this.builder.Modifier_private(this.getTokenSourceLocation((IASTNode)baseSpecifier, "private"), isMacroExpansion)});
                break;
            }
            case 0: {
                modifiers.append(new IValue[]{this.builder.Modifier_unspecifiedInheritance(this.vf.sourceLocation(loc, loc.getOffset(), 0), isMacroExpansion)});
                break;
            }
            default: {
                throw new RuntimeException("Unknown BaseSpecifier visibility code " + baseSpecifier.getVisibility() + " at " + String.valueOf(loc));
            }
        }
        if (baseSpecifier.isVirtual()) {
            modifiers.append(new IValue[]{this.builder.Modifier_virtual(this.getTokenSourceLocation((IASTNode)baseSpecifier, "virtual"), isMacroExpansion)});
        }
        if ((nameSpecifier = baseSpecifier.getNameSpecifier()) == null) {
            this.stack.push(this.builder.Declaration_baseSpecifier((IList)modifiers.done(), loc, decl, isMacroExpansion));
        } else {
            nameSpecifier.accept((ASTVisitor)this);
            this.stack.push(this.builder.Declaration_baseSpecifier((IList)modifiers.done(), this.stack.pop(), loc, decl, isMacroExpansion));
        }
        return 2;
    }

    public int visit(ICPPASTNamespaceDefinition namespaceDefinition) {
        this.at((IASTNode)namespaceDefinition);
        ISourceLocation loc = this.locs.forNode((IASTNode)namespaceDefinition);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)namespaceDefinition);
        ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)namespaceDefinition, loc);
        IList attributes = this.getAttributes((IASTAttributeOwner)namespaceDefinition);
        namespaceDefinition.getName().accept((ASTVisitor)this);
        IConstructor name = this.stack.pop();
        IListWriter declarations = this.vf.listWriter();
        Stream.of(namespaceDefinition.getDeclarations()).forEach(it -> {
            it.accept((ASTVisitor)this);
            declarations.append(new IValue[]{(IValue)this.stack.pop()});
        });
        if (namespaceDefinition.isInline()) {
            this.stack.push(this.builder.Declaration_namespaceDefinitionInline(name, (IList)declarations.done(), attributes, loc, decl, isMacroExpansion));
        } else {
            this.stack.push(this.builder.Declaration_namespaceDefinition(name, (IList)declarations.done(), attributes, loc, decl, isMacroExpansion));
        }
        return 2;
    }

    public int visit(ICPPASTTemplateParameter templateParameter) {
        block14: {
            boolean isMacroExpansion;
            ISourceLocation loc;
            block12: {
                IConstructor name;
                ICPPASTSimpleTypeTemplateParameter parameter;
                ISourceLocation decl;
                block13: {
                    this.at((IASTNode)templateParameter);
                    loc = this.locs.forNode((IASTNode)templateParameter);
                    isMacroExpansion = this.isMacroExpansion((IASTNode)templateParameter);
                    if (!(templateParameter instanceof ICPPASTSimpleTypeTemplateParameter)) break block12;
                    decl = this.br.resolveBinding((IASTNameOwner)((ICPPASTSimpleTypeTemplateParameter)templateParameter), loc);
                    parameter = (ICPPASTSimpleTypeTemplateParameter)templateParameter;
                    parameter.getName().accept((ASTVisitor)this);
                    name = this.stack.pop();
                    if (parameter.getDefaultType() == null) break block13;
                    parameter.getDefaultType().accept((ASTVisitor)this);
                    switch (parameter.getParameterType()) {
                        case 1: {
                            this.stack.push(this.builder.Declaration_sttClass(name, this.stack.pop(), loc, decl, isMacroExpansion));
                            break block14;
                        }
                        case 2: {
                            this.stack.push(this.builder.Declaration_sttTypename(name, this.stack.pop(), loc, decl, isMacroExpansion));
                            break block14;
                        }
                        default: {
                            throw new RuntimeException("ICPPASTTemplateParameter encountered non-implemented parameter type " + parameter.getParameterType() + " at " + String.valueOf(loc));
                        }
                    }
                }
                switch (parameter.getParameterType()) {
                    case 1: {
                        this.stack.push(this.builder.Declaration_sttClass(name, loc, decl, isMacroExpansion));
                        break;
                    }
                    case 2: {
                        this.stack.push(this.builder.Declaration_sttTypename(name, loc, decl, isMacroExpansion));
                        break;
                    }
                    default: {
                        throw new RuntimeException("ICPPASTTemplateParameter encountered non-implemented parameter type " + parameter.getParameterType() + " at " + String.valueOf(loc));
                    }
                }
                break block14;
            }
            if (templateParameter instanceof ICPPASTTemplatedTypeTemplateParameter) {
                ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)((ICPPASTTemplatedTypeTemplateParameter)templateParameter), this.locs.forNode((IASTNode)templateParameter));
                IListWriter templateParameters = this.vf.listWriter();
                Stream.of(((ICPPASTTemplatedTypeTemplateParameter)templateParameter).getTemplateParameters()).forEach(it -> {
                    it.accept((ASTVisitor)this);
                    templateParameters.append(new IValue[]{(IValue)this.stack.pop()});
                });
                ((ICPPASTTemplatedTypeTemplateParameter)templateParameter).getName().accept((ASTVisitor)this);
                IConstructor name = this.stack.pop();
                IASTExpression defaultValue = ((ICPPASTTemplatedTypeTemplateParameter)templateParameter).getDefaultValue();
                if (defaultValue == null) {
                    this.stack.push(this.builder.Declaration_tttParameter((IList)templateParameters.done(), name, loc, decl, isMacroExpansion));
                } else {
                    defaultValue.accept((ASTVisitor)this);
                    this.stack.push(this.builder.Declaration_tttParameterWithDefault((IList)templateParameters.done(), name, this.stack.pop(), loc, decl, isMacroExpansion));
                }
            } else {
                throw new RuntimeException("ICPPASTTemplateParameter encountered unknown subtype " + templateParameter.getClass().getName() + " at " + String.valueOf(loc) + ". Exiting");
            }
        }
        return 2;
    }

    public int visit(ICPPASTCapture capture) {
        this.at((IASTNode)capture);
        ISourceLocation loc = this.locs.forNode((IASTNode)capture);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)capture);
        if (capture.capturesThisPointer()) {
            this.stack.push(this.builder.Expression_captureThisPtr(loc, isMacroExpansion));
        } else {
            ISourceLocation decl = this.br.resolveBinding((IASTNameOwner)capture, this.locs.forNode((IASTNode)capture));
            capture.getIdentifier().accept((ASTVisitor)this);
            if (capture.isByReference()) {
                this.stack.push(this.builder.Expression_captureByRef(this.stack.pop(), loc, decl, isMacroExpansion));
            } else {
                this.stack.push(this.builder.Expression_capture(this.stack.pop(), loc, decl, isMacroExpansion));
            }
        }
        return 2;
    }

    public int visit(ICASTDesignator designator) {
        this.at((IASTNode)designator);
        ISourceLocation loc = this.locs.forNode((IASTNode)designator);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)designator);
        if (designator instanceof ICASTArrayDesignator) {
            ((ICASTArrayDesignator)designator).getSubscriptExpression().accept((ASTVisitor)this);
            this.stack.push(this.builder.Expression_arrayDesignator(this.stack.pop(), loc, isMacroExpansion));
        } else if (designator instanceof ICASTFieldDesignator) {
            ((ICASTFieldDesignator)designator).getName().accept((ASTVisitor)this);
            this.stack.push(this.builder.Expression_fieldDesignator(this.stack.pop(), loc, isMacroExpansion));
        } else if (designator instanceof IGCCASTArrayRangeDesignator) {
            ((IGCCASTArrayRangeDesignator)designator).getRangeFloor().accept((ASTVisitor)this);
            IConstructor rangeFloor = this.stack.pop();
            ((IGCCASTArrayRangeDesignator)designator).getRangeCeiling().accept((ASTVisitor)this);
            IConstructor rangeCeiling = this.stack.pop();
            this.stack.push(this.builder.Expression_arrayRangeDesignator(rangeFloor, rangeCeiling, loc, isMacroExpansion));
        } else {
            this.err("Designator: " + designator.getRawSignature());
            throw new RuntimeException("Unknown Designator at " + String.valueOf(this.locs.forNode((IASTNode)designator)));
        }
        return 2;
    }

    public int visit(ICPPASTDesignator designator) {
        this.at((IASTNode)designator);
        ISourceLocation loc = this.locs.forNode((IASTNode)designator);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)designator);
        if (designator instanceof ICPPASTArrayDesignator) {
            ((ICPPASTArrayDesignator)designator).getSubscriptExpression().accept((ASTVisitor)this);
            this.stack.push(this.builder.Expression_arrayDesignator(this.stack.pop(), loc, isMacroExpansion));
        } else if (designator instanceof ICPPASTFieldDesignator) {
            ((ICPPASTFieldDesignator)designator).getName().accept((ASTVisitor)this);
            this.stack.push(this.builder.Expression_fieldDesignator(this.stack.pop(), loc, isMacroExpansion));
        } else if (designator instanceof IGPPASTArrayRangeDesignator) {
            ((IGPPASTArrayRangeDesignator)designator).getRangeFloor().accept((ASTVisitor)this);
            IConstructor rangeFloor = this.stack.pop();
            ((IGPPASTArrayRangeDesignator)designator).getRangeCeiling().accept((ASTVisitor)this);
            IConstructor rangeCeiling = this.stack.pop();
            this.stack.push(this.builder.Expression_arrayRangeDesignator(rangeFloor, rangeCeiling, loc, isMacroExpansion));
        } else {
            throw new RuntimeException("ICPPASTDesignator encountered unknown subclass at " + String.valueOf(loc) + ", exiting");
        }
        return 2;
    }

    public int visit(ICPPASTVirtSpecifier virtSpecifier) {
        this.at((IASTNode)virtSpecifier);
        ISourceLocation loc = this.locs.forNode((IASTNode)virtSpecifier);
        boolean isMacroExpansion = this.isMacroExpansion((IASTNode)virtSpecifier);
        switch (virtSpecifier.getKind()) {
            case Final: {
                this.stack.push(this.builder.Declaration_virtSpecifier(this.builder.Modifier_final(this.getTokenSourceLocation((IASTNode)virtSpecifier, "final"), isMacroExpansion), loc, isMacroExpansion));
                break;
            }
            case Override: {
                this.stack.push(this.builder.Declaration_virtSpecifier(this.builder.Modifier_override(this.getTokenSourceLocation((IASTNode)virtSpecifier, "override"), isMacroExpansion), loc, isMacroExpansion));
                break;
            }
            default: {
                throw new RuntimeException("ICPPASTVirtSpecifier encountered unknown SpecifierKind " + virtSpecifier.getKind().name() + " at " + String.valueOf(loc));
            }
        }
        return 2;
    }

    public int visit(ICPPASTClassVirtSpecifier classVirtSpecifier) {
        this.at((IASTNode)classVirtSpecifier);
        this.err("ClassVirtSpecifier: " + classVirtSpecifier.getRawSignature());
        throw new RuntimeException("NYI at " + String.valueOf(this.locs.forNode((IASTNode)classVirtSpecifier)));
    }

    public int visit(ICPPASTDecltypeSpecifier decltypeSpecifier) {
        this.at((IASTNode)decltypeSpecifier);
        decltypeSpecifier.getDecltypeExpression().accept((ASTVisitor)this);
        this.stack.push(this.builder.Name_decltypeName(this.stack.pop(), this.locs.forNode((IASTNode)decltypeSpecifier), this.isMacroExpansion((IASTNode)decltypeSpecifier)));
        return 2;
    }

    public int visit(ASTAmbiguousNode astAmbiguousNode) {
        this.at((IASTNode)astAmbiguousNode);
        this.err("AstAmbiguousNode: " + astAmbiguousNode.getRawSignature());
        throw new RuntimeException("NYI at " + String.valueOf(this.locs.forNode((IASTNode)astAmbiguousNode)));
    }
}

