---
title: "module analysis::m3::LearnPrettyPrinter"
id: LearnPrettyPrinter
slug: /Packages/org.rascalmpl.clair/API/analysis/m3/LearnPrettyPrinter
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.2</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.clair-0.13.3</div>

#### Usage

```rascal
import analysis::m3::LearnPrettyPrinter;
```

#### Dependencies
```rascal
import IO;
import Node;
import Type;
import List;
import Location;
import String;
import Set;
import util::FileSystem;
import lang::cpp::AST;
```


## function generateFormatterForC {#analysis-m3-LearnPrettyPrinter-generateFormatterForC}

this is a demo/test function that learns a C pretty printer from the C files in the `example` folder.

```rascal
void generateFormatterForC()
```

## function filesToPrettyPrinter {#analysis-m3-LearnPrettyPrinter-filesToPrettyPrinter}

Takes a corpus of example files and an (external) parser for the given language and produces a pretty printing function as Rascal code.

```rascal
str filesToPrettyPrinter(set[loc] files, type[node] grammar, node (loc) parser)
```


If the external parser satisfies the specification in `analysis::m3::AST` then this function will learn a basic
`unparser` (a.k.a. pretty printer) from the corpus of files. 

The code that is generated is Rascal code which can be expanded into a module that imports the right AST format, and nothing else.

The "pretty" aspect should not be over-estimated:
* The generated formatter does not deal with nested indentation. 
* It has one rule for every unique AST node kind (constructor), so special combinations do not get special treatment
* It is not able to generate syntactically correct files for layout-sensitive languages
* If the core example for a node contains source code comments, these will end up in the output

This function is typically used in source-to-source transformations where an intermediate AST to AST transformation
takes place. To derive source code from fresh syntax nodes, the format function is required.

## function treesToPrettyPrinter {#analysis-m3-LearnPrettyPrinter-treesToPrettyPrinter}

Takes a corpus of syntax trees (for the same language!) and produces Rascal code that can generate code back from ASTs.

```rascal
str treesToPrettyPrinter(set[node] asts, type[node] _grammar)
```

## function formatFunction {#analysis-m3-LearnPrettyPrinter-formatFunction}

```rascal
str formatFunction(str yield, node n)
```

## data Template {#analysis-m3-LearnPrettyPrinter-Template}

```rascal
data Template  
     = hole(int n)
     | sep(str chars)
     | \list(str sep, int n)
     | const(str chars, int n)
     ;
```

## function cutOut {#analysis-m3-LearnPrettyPrinter-cutOut}

get a template out of an example node by replacing the children with holes

```rascal
list[Template] cutOut(str yield, node n)
```

## function template {#analysis-m3-LearnPrettyPrinter-template}

Turns a child into a template element

```rascal
Template template(int _begin, int _, int i, str _yield)

Template template(int _begin, str s, int i, str _yield)

Template template(int _begin, node _, int i, str _yield)

Template template(int _begin, [], int i, str _yield)

Template template(int _begin, [node a], int i, str yield)

Template template(int  begin, [node a, node b, *_], int i, str yield)
```

## function print {#analysis-m3-LearnPrettyPrinter-print}

Prints a rascal code template part, including recursive calls.

```rascal
str print(hole(int i))

str print(sep(str chars))

str print(const(str _chars, int i))

str print(\list(str sep, int i))
```

## function position {#analysis-m3-LearnPrettyPrinter-position}

Give every element a true location for later processing.

```rascal
list[loc] position(loc span, list[value] l)
```

## function pos {#analysis-m3-LearnPrettyPrinter-pos}

```rascal
loc pos(loc span, int _)

loc pos(loc span, str _)

loc pos(loc _span, [])

loc pos(loc _span, node n)

loc pos(loc _span, [node n])

loc pos(loc _span, [node a, *_, node b])
```

## function infer {#analysis-m3-LearnPrettyPrinter-infer}

Replaces all |empty:///| with a correct loc inferred from the surroundings

```rascal
list[loc] infer(loc span, [loc l, *loc rest])

list[loc] infer(loc span, [*loc rest, loc l])

list[loc] infer(loc span, [*loc pre, loc before, loc l, *loc post])

list[loc] infer(loc span, [*loc pre, loc l, loc after, *loc post])

default list[loc] infer(loc _span, list[loc] done)
```

## function \type {#analysis-m3-LearnPrettyPrinter-\type}

Print the type of a value, as Rascal code

```rascal
str \type(value n)
```

## function escape {#analysis-m3-LearnPrettyPrinter-escape}

Escape string elements for use in a Rascal template string

```rascal
str escape(str s)
```

## function \loc {#analysis-m3-LearnPrettyPrinter-\loc}

Waiting for `node.src` to be available in Rascal for good...

```rascal
loc \loc(node n)
```

