---
title: "module lang::cpp::AST"
id: AST
slug: /Packages/org.rascalmpl.clair/API/lang/cpp/AST
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.2</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.clair-0.13.3</div>

A definition of abstract syntax trees for C and C++
#### Usage

```rascal
import lang::cpp::AST;
```

#### Dependencies
```rascal
import lang::cpp::TypeSymbol;
```


## data Declarator {#lang-cpp-AST-Declarator}

```rascal
data Declarator (list[Attribute] attributes = [], loc src = |unknown:///|, loc decl = |unknown:///|, bool isMacroExpansion = false) 
     = \declarator(list[Declaration] pointerOperators, Name name)
     | \declarator(list[Declaration] pointerOperators, Name name, Expression initializer)
     | \fieldDeclarator(list[Declaration] pointerOperators, Name name, Expression bitFieldSize)
     | \fieldDeclarator(list[Declaration] pointerOperators, Name name, Expression bitFieldSize, Expression initializer)
     | \functionDeclarator(list[Declaration] pointerOperators, Name name, list[Declaration] parameters)
     | \functionDeclarator(list[Declaration] pointerOperators, list[Modifier] modifiers, Name name, list[Declaration] parameters, list[Declaration] virtSpecifiers)
     | \functionDeclarator(list[Declaration] pointerOperators, list[Modifier] modifiers, Name name, list[Declaration] parameters, list[Declaration] virtSpecifiers, Expression trailingReturnType)
     | \functionDeclaratorNested(list[Declaration] pointerOperators, list[Modifier] modifiers, Declarator declarator, list[Declaration] parameters, list[Declaration] virtSpecifiers)
     | \functionDeclaratorNested(list[Declaration] pointerOperators, list[Modifier] modifiers, Declarator declarator, list[Declaration] parameters, list[Declaration] virtSpecifiers, Expression initializer)
     | \functionDeclaratorNoexcept(list[Declaration] pointerOperators, list[Modifier] modifiers, Name name, list[Declaration] parameters, list[Declaration] virtSpecifiers, Expression noexceptExpression)
     | \functionDeclaratorWithES(list[Declaration] pointerOperators, list[Modifier] modifiers, Name name, list[Declaration] parameters, list[Declaration] virtSpecifiers)
     | \functionDeclaratorWithES(list[Declaration] pointerOperators, list[Modifier] modifiers, Name name, list[Declaration] parameters, list[Declaration] virtSpecifiers, list[Expression] exceptionSpecification)
     | \arrayDeclarator(list[Declaration] pointerOperators, Name name, list[Expression] arrayModifier)
     | \arrayDeclarator(list[Declaration] pointerOperators, Name name, list[Expression] arrayModifier, Expression initializer)
     | \arrayDeclaratorNested(list[Declaration] pointerOperators, Declarator declarator, list[Expression] arrayModifier)
     | \arrayDeclaratorNested(list[Declaration] pointerOperators, Declarator declarator, list[Expression] arrayModifier, Expression initializer)
     | \knrFunctionDeclarator(list[Declaration] pointerOperators, list[Modifier] modifiers, list[Name] parameterNames, list[Declaration] parameterDeclarations)
     | \missingDeclarator()
     ;
```

## data DeclSpecifier {#lang-cpp-AST-DeclSpecifier}

```rascal
data DeclSpecifier (list[Attribute] attributes = [], loc src = |unknown:///|, bool isMacroExpansion = false) 
     = \declSpecifier(list[Modifier] modifiers, Type \type)
     | \etsEnum(list[Modifier] modifiers, Name name, loc decl = |unknown:///|)
     | \etsStruct(list[Modifier] modifiers, Name name, loc decl = |unknown:///|)
     | \etsUnion(list[Modifier] modifiers, Name name, loc decl = |unknown:///|)
     | \etsClass(list[Modifier] modifiers, Name name, loc decl = |unknown:///|)
     | \namedTypeSpecifier(list[Modifier] modifiers, Name name, loc decl = |unknown:///|)
     | \struct(list[Modifier] modifiers, Name name, list[Declaration] members, loc decl = |unknown:///|)
     | \union(list[Modifier] modifiers, Name name, list[Declaration] members, loc decl = |unknown:///|)
     | \class(list[Modifier] modifiers, Name name, list[Declaration] members, loc decl = |unknown:///|)
     | \struct(list[Modifier] modifiers, Name name, list[Declaration] baseSpecifiers, list[Declaration] members, loc decl = |unknown:///|)
     | \union(list[Modifier] modifiers, Name name, list[Declaration] baseSpecifiers, list[Declaration] members, loc decl = |unknown:///|)
     | \class(list[Modifier] modifiers, Name name, list[Declaration] baseSpecifiers, list[Declaration] members, loc decl = |unknown:///|)
     | \structFinal(list[Modifier] modifiers, Name name, list[Declaration] baseSpecifiers, list[Declaration] members, loc decl = |unknown:///|)
     | \unionFinal(list[Modifier] modifiers, Name name, list[Declaration] baseSpecifiers, list[Declaration] members, loc decl = |unknown:///|)
     | \classFinal(list[Modifier] modifiers, Name name, list[Declaration] baseSpecifiers, list[Declaration] members, loc decl = |unknown:///|)
     | \enum(list[Modifier] modifiers, Name name, list[Declaration] enumerators, loc decl = |unknown:///|)
     | \enum(list[Modifier] modifiers, DeclSpecifier baseType, Name name, list[Declaration] enumerators, loc decl = |unknown:///|)
     | \enumOpaque(list[Modifier] modifiers, DeclSpecifier baseType, Name name, loc decl = |unknown:///|)
     | \enumScoped(list[Modifier] modifiers, Name name, list[Declaration] enumerators, loc decl = |unknown:///|)
     | \enumScoped(list[Modifier] modifiers, DeclSpecifier baseType, Name name, list[Declaration] enumerators, loc decl = |unknown:///|)
     | \enumScopedOpaque(list[Modifier] modifiers, Name name, loc decl = |unknown:///|)
     | \enumScopedOpaque(list[Modifier] modifiers, DeclSpecifier baseType, Name name, loc decl = |unknown:///|)
     | \msThrowEllipsis()
     ;
```

## data Declaration {#lang-cpp-AST-Declaration}

```rascal
data Declaration (list[Attribute] attributes = [], loc src=|unknown:///|, bool isMacroExpansion = false) 
     = \translationUnit(list[Declaration] declarations, loc decl=|unknown:///|)
     | \simpleDeclaration(DeclSpecifier declSpecifier, list[Declarator] declarators)
     | \functionDefinition(Expression returnSpec, Declarator declarator, Statement body)
     | \defaultedFunctionDefinition(DeclSpecifier declSpecifier, list[Expression] memberInitializer, Declarator declarator)
     | \deletedFunctionDefinition(DeclSpecifier declSpecifier, list[Expression] memberInitializer, Declarator declarator)
     | \functionDefinition(DeclSpecifier declSpecifier, Declarator declarator, list[Expression] memberInitializer, Statement body)
     | \functionWithTryBlockDefinition(DeclSpecifier declSpecifier, Declarator declarator, list[Expression] memberInitializers, Statement sbody, list[Statement] catchHandlers)
     | \asmDeclaration(str assembly)
     | \enumerator(Name name, Expression \value, loc decl = |unknown:///|)
     | \enumerator(Name name, loc decl = |unknown:///|)
     | \usingDirective(Name qualifiedName, loc decl = |unknown:///|)
     | \visibilityLabel(Modifier visibility)
     | \pointer(list[Modifier] modifiers)
     | \pointerToMember(list[Modifier] modifiers, Name nestedName)
     | \reference()
     | \rvalueReference()
     | \parameter(DeclSpecifier declSpecifier)
     | \parameter(DeclSpecifier declSpecifier, Declarator declarator)
     | \template(list[Declaration] parameters, Declaration declaration, TypeSymbol \type)
     | \sttClass(Name name, loc decl = |unknown:///|)
     | \sttTypename(Name name, loc decl = |unknown:///|)
     | \sttClass(Name name, Expression defaultType, loc decl = |unknown:///|)
     | \sttTypename(Name name, Expression defaultType, loc decl = |unknown:///|)
     | \tttParameter(list[Declaration] nestedParameters, Name name, loc decl = |unknown:///|)
     | \tttParameterWithDefault(list[Declaration] nestedParameters, Name name, Expression defaultValue, loc decl = |unknown:///|)
     | \baseSpecifier(list[Modifier] modifiers, loc decl = |unknown:///|)
     | \baseSpecifier(list[Modifier] modifiers, Name name, loc decl = |unknown:///|)
     | \virtSpecifier(Modifier modifier)
     | \namespaceDefinition(Name name, list[Declaration] declarations, loc decl = |unknown:///|)
     | \namespaceDefinitionInline(Name name, list[Declaration] declarations, loc decl = |unknown:///|)
     | \usingDeclaration(list[Modifier] modifiers, Name name, loc decl = |unknown:///|)
     | \namespaceAlias(Name \alias, Name mapping, loc decl = |unknown:///|)
     | \linkageSpecification(str literal, list[Declaration] declarations)
     | \alias(Name \alias, Expression mappingTypeId, loc decl = |unknown:///|)
     | \staticAssert(Expression condition, Expression message)
     | \staticAssert(Expression condition)
     | \explicitTemplateInstantiation(Declaration declaration)
     | \explicitTemplateInstantiation(Modifier modifier, Declaration declaration)
     | \explicitTemplateSpecialization(Declaration declaration)
     | \varArgs()
     | \problemDeclaration()
     ;
```

## data Expression {#lang-cpp-AST-Expression}

```rascal
data Expression (loc src = |unknown:///|, loc decl=|not-overloaded:///|, TypeSymbol typ = \unresolved(), bool isMacroExpansion = false) 
     = \multiply(Expression lhs, Expression rhs)
     | \divide(Expression lhs, Expression rhs)
     | \modulo(Expression lhs, Expression rhs)
     | \plus(Expression lhs, Expression rhs)
     | \minus(Expression lhs, Expression rhs)
     | \shiftLeft(Expression lhs, Expression rhs)
     | \shiftRight(Expression lhs, Expression rhs)
     | \lessThan(Expression lhs, Expression rhs)
     | \greaterThan(Expression lhs, Expression rhs)
     | \lessEqual(Expression lhs, Expression rhs)
     | \greaterEqual(Expression lhs, Expression rhs)
     | \binaryAnd(Expression lhs, Expression rhs)
     | \binaryXor(Expression lhs, Expression rhs)
     | \binaryOr(Expression lhs, Expression rhs)
     | \logicalAnd(Expression lhs, Expression rhs)
     | \logicalOr(Expression lhs, Expression rhs)
     | \assign(Expression lhs, Expression rhs)
     | \multiplyAssign(Expression lhs, Expression rhs)
     | \divideAssign(Expression lhs, Expression rhs)
     | \moduloAssign(Expression lhs, Expression rhs)
     | \plusAssign(Expression lhs, Expression rhs)
     | \minusAssign(Expression lhs, Expression rhs)
     | \shiftLeftAssign(Expression lhs, Expression rhs)
     | \shiftRightAssign(Expression lhs, Expression rhs)
     | \binaryAndAssign(Expression lhs, Expression rhs)
     | \binaryXorAssign(Expression lhs, Expression rhs)
     | \binaryOrAssign(Expression lhs, Expression rhs)
     | \equals(Expression lhs, Expression rhs)
     | \notEquals(Expression lhs, Expression rhs)
     | \pmDot(Expression lhs, Expression rhs)
     | \pmArrow(Expression lhs, Expression rhs)
     | \max(Expression lhs, Expression rhs)
     | \min(Expression lhs, Expression rhs)
     | \ellipses(Expression lhs, Expression rhs)
     | \prefixIncr(Expression expression)
     | \prefixDecr(Expression expression)
     | \plus(Expression expression)
     | \minus(Expression expression)
     | \star(Expression expression)
     | \amper(Expression expression)
     | \tilde(Expression expression)
     | \not(Expression expression)
     | \sizeof(Expression expression)
     | \postfixIncr(Expression expression)
     | \postfixDecr(Expression expression)
     | \bracketed(Expression expression)
     | \throw()
     | \throw(Expression expression)
     | \typeid(Expression expression)
     | \alignOf(Expression expression)
     | \typeof(Expression expression)
     | \hasNothrowAssign(Expression expression)
     | \hasNothrowCopy(Expression expression)
     | \hasNothrowConstructor(Expression expression)
     | \hasTrivialAssign(Expression expression)
     | \hasTrivialCopy(Expression expression)
     | \hasTrivialConstructor(Expression expression)
     | \hasTrivialDestructor(Expression expression)
     | \hasVirtualDestructor(Expression expression)
     | \isAbstract(Expression expression)
     | \isClass(Expression expression)
     | \isEmpty(Expression expression)
     | \isEnum(Expression expression)
     | \isPod(Expression expression)
     | \isPolymorphic(Expression expression)
     | \isUnion(Expression expression)
     | \isLiteralType(Expression expression)
     | \isStandardLayout(Expression expression)
     | \isTrivial(Expression expression)
     | \sizeofParameterPack(Expression expression)
     | \isFinal(Expression expression)
     | \isTriviallyCopyable(Expression expression)
     | \noexcept(Expression expression)
     | \labelReference(Expression expression)
     | \cast(Expression typeId, Expression expression)
     | \dynamicCast(Expression typeId, Expression expression)
     | \staticCast(Expression typeId, Expression expression)
     | \reinterpretCast(Expression typeId, Expression expression)
     | \constCast(Expression typeId, Expression expression)
     | \idExpression(Name name, loc decl = |unknown:///|)
     | \integerLiteral(int number)
     | \conditional(Expression condition, Expression positive, Expression negative)
     | \conditional(Expression condition, Expression negative)
     | \integerConstant(str \value)
     | \floatConstant(str \value)
     | \charConstant(str \value)
     | \stringLiteral(str \value)
     | \this()
     | \true()
     | \false()
     | \nullptr()
     | \functionCall(Expression functionName, list[Expression] arguments)
     | \fieldReference(Expression fieldOwner, Name name, loc decl = |unknown:///|)
     | \fieldReferencePointerDeref(Expression fieldOwner, Name name, loc decl = |unknown:///|)
     | \new(Expression typeId, loc decl=|unknown:///|)
     | \new(Expression typeId, Expression initializer, loc decl=|unknown:///|)
     | \newWithArgs(list[Expression] arguments, Expression typeId, loc decl=|unknown:///|)
     | \newWithArgs(list[Expression] arguments, Expression typeId, Expression initializer, loc decl=|unknown:///|)
     | \globalNew(Expression typeId, loc decl=|unknown:///|)
     | \globalNew(Expression typeId, Expression initializer, loc decl=|unknown:///|)
     | \globalNewWithArgs(list[Expression] arguments, Expression typeId, loc decl=|unknown:///|)
     | \globalNewWithArgs(list[Expression] arguments, Expression typeId, Expression initializer, loc decl=|unknown:///|)
     | \delete(Expression expression)
     | \vectoredDelete(Expression expression)
     | \globalDelete(Expression expression)
     | \globalVectoredDelete(Expression expression)
     | \arraySubscriptExpression(Expression array, Expression argument)
     | \arrayModifier(list[Modifier] modifiers, list[Attribute] attributes = [])
     | \arrayModifier(list[Modifier] modifiers, Expression constExpression, list[Attribute] attributes = [])
     | \simpleTypeConstructor(DeclSpecifier declSpecifier, Expression initializer)
     | \expressionList(list[Expression] expressions)
     | \compoundStatementExpression(Statement compoundStatement)
     | \empty()
     | \nyi(str raw)
     | \lambda(Modifier captureDefault, list[Expression] captures, Declarator declarator, Statement body)
     | \packExpansion(Expression pattern)
     | \typeIdInitializerExpression(Expression typeId, Expression initializer)
     | \isBaseOf(Expression lhs, Expression rhs)
     | \isTriviallyAssignable(Expression lhs, Expression rhs)
     | \isConstructable(list[Expression] args)
     | \isTriviallyConstructable(list[Expression] args)
     | \typeId(DeclSpecifier declSpecifier)
     | \typeId(DeclSpecifier declSpecifier, Declarator abstractDeclarator)
     | \equalsInitializer(Expression initializer)
     | \initializerList(list[Expression] clauses)
     | \constructorChainInitializer(Name name, Expression initializer, loc decl = |unknown:///|)
     | \constructorInitializer(list[Expression] arguments)
     | \designatedInitializer(list[Expression] designators, Expression operand)
     | \arrayDesignator(Expression subscript)
     | \fieldDesignator(Name fieldName)
     | \arrayRangeDesignator(Expression rangeFloor, Expression rangeCeiling)
     | \capture(Name name, loc decl = |unknown:///|)
     | \captureByRef(Name name, loc decl = |unknown:///|)
     | \captureThisPtr()
     | \problemExpression()
     ;
```

## data Name {#lang-cpp-AST-Name}

```rascal
data Name (loc src = |unknown:///|, bool isMacroExpansion = false) 
     = \name(str \value)
     | \qualifiedName(list[Name] qualifiers, Name lastName, loc decl = |unknown:///|)
     | \operatorName(str \value)
     | \conversionName(str \value, Expression typeId)
     | \templateId(Name name, list[Expression] argumentTypes, loc decl = |unknown:///|)
     | \abstractEmptyName()
     | decltypeName(Expression expression)
     ;
```

## data Statement {#lang-cpp-AST-Statement}

```rascal
data Statement (list[Attribute] attributes = [], loc src = |unknown:///|, bool isMacroExpansion = false) 
     = \compoundStatement(list[Statement] statements)
     | \declarationStatement(Declaration declaration)
     | \expressionStatement(Expression expression)
     | \if(Expression condition, Statement thenClause)
     | \if(Expression condition, Statement thenClause, Statement elseClause)
     | \ifWithDecl(Declaration conditionDeclaration, Statement thenClause)
     | \ifWithDecl(Declaration conditionDeclaration, Statement thenClause, Statement elseClause)
     | \for(Statement sInitializer, Expression condition, Expression iteration, Statement body)
     | \forWithDecl(Statement sInitializer, Declaration conditionDeclaration, Expression iteration, Statement body)
     | \rangeBasedFor(Declaration declaration, Expression initializer, Statement body)
     | \switch(Expression controller, Statement body)
     | \switchWithDecl(Declaration controllerDeclaration, Statement body)
     | \case(Expression expression)
     | \defaultCase()
     | \break()
     | \while(Expression condition, Statement body)
     | \whileWithDecl(Declaration conditionDeclaration, Statement body)
     | \continue()
     | \do(Statement body, Expression condition)
     | \return(Expression expression)
     | \return()
     | \nullStatement()
     | \label(Name name, Statement nestedStatement, loc decl = |unknown:///|)
     | \goto(Name name, loc decl = |unknown:///|)
     | \computedGoto(Expression labelName)
     | \tryBlock(Statement tryBody, list[Statement] catchHandlers)
     | \catch(Declaration declaration, Statement body)
     | \catchAll(Statement body)
     | \problem(str raw)
     ;
```

## data Type {#lang-cpp-AST-Type}

```rascal
data Type (loc src = |unknown:///|, bool isMacroExpansion = false) 
     = \unspecified()
     | \void()
     | \char()
     | \integer()
     | \float()
     | \double()
     | \bool()
     | \wchar_t()
     | \typeof(Expression expression)
     | \decltype(Expression expression)
     | \auto()
     | \char16_t()
     | \char32_t()
     | \int128()
     | \float128()
     | \decimal32()
     | \decimal64()
     | \decimal128()
     | \declTypeAuto()
     | \arrayType(Type \type, int size)
     | \basicType(Type \type, list[Modifier] modifiers)
     | \nullptr()
     | \structType(Name name)
     | \unionType(Name name)
     | \classType(Name name)
     ;
```

## data Modifier {#lang-cpp-AST-Modifier}

```rascal
data Modifier (loc src = |unknown:///|, bool isMacroExpansion = false) 
     = typedef()
     | \extern()
     | \static()
     | \modAuto()
     | \register()
     | \mutable()
     | \public()
     | \protected()
     | \private()
     | \unspecifiedInheritance()
     | \signed()
     | \unsigned()
     | \short()
     | \long()
     | \longlong()
     | \complex()
     | \imaginary()
     | \const()
     | \volatile()
     | \restrict()
     | \inline()
     | \final()
     | \override()
     | \friend()
     | \virtual()
     | \explicit()
     | \constexpr()
     | \threadLocal()
     | \pureVirtual()
     | \typename()
     | \captDefUnspecified()
     | \captDefByCopy()
     | \captDefByReference()
     ;
```

## data Attribute {#lang-cpp-AST-Attribute}

```rascal
data Attribute (loc src = |unknown:///|) 
     = \attribute(str name)
     | \attribute(str name, str argumentClause)
     | \attributeSpecifier(list[Attribute] attributes)
     | \alignmentSpecifier(Expression typeIdOrExpression)
     | \msDeclspecList(list[Attribute] attributes)
     | \gccAttributeList(list[Attribute] attributes)
     ;
```

## function provideStandardMacros {#lang-cpp-AST-provideStandardMacros}

```rascal
map[str, str] provideStandardMacros()
```

## function parseC {#lang-cpp-AST-parseC}

Uses the CDT parsers to produce an accurate C AST.

```rascal
Declaration parseC(loc file, str charset=DEFAULT_CHARSET, bool inferCharset=!(charset?), list[loc] stdLib = [], list[loc] includeDirs = [], map[str,str] standardMacros=provideStandardMacros(), map[str,str] additionalMacros = (), bool includeStdLib = false)
```

#### Benefits


* This reuses the CDT parser which has great coverage of many C dialects.
* This is accurately representing C syntax and static semantics

#### Pitfalls


* Accuracy of the AST and the M3 model depend greatly on the `stdLib` and `includeDirs` parameters.
If those are not fitting the current project and its files, then this function will produce lots of
`problems` and also possibly have the wrong resolutions for names and types.  

## function parseCpp {#lang-cpp-AST-parseCpp}

Uses the CDT parsers to produce an accurate C++ AST.

```rascal
Declaration parseCpp(loc file, str charset=DEFAULT_CHARSET, bool inferCharset=!(charset?), list[loc] stdLib = classPaths["vs12"], list[loc] includeDirs = [], map[str,str] standardMacros=provideStandardMacros(), map[str,str] additionalMacros = (), bool includeStdLib = false)
```

#### Benefits


* This reuses the CDT parser which has great coverage of many C++ dialects.
* This is accurately representing C++ syntax and static semantics

#### Pitfalls


* Accuracy of the AST and the M3 model depend greatly on the `stdLib` and `includeDirs` parameters.
If those are not fitting the current project and its files, then this function will produce lots of
`problems` and also possibly have the wrong resolutions for names and types.  

## function parseFiles {#lang-cpp-AST-parseFiles}

```rascal
list[Declaration] parseFiles(list[loc] files, str charset=DEFAULT_CHARSET, bool inferCharset=!(charset?), list[loc] stdLib = classPaths["vs12"], list[loc] includeDirs = [],  map[str,str] standardMacros=provideStandardMacros(), map[str,str] additionalMacros = (), bool includeStdLib = false)
```

## function parseString {#lang-cpp-AST-parseString}

```rascal
Declaration parseString(str code)

Declaration parseString(str code, loc l)
```

## function parseForComments {#lang-cpp-AST-parseForComments}

```rascal
list[loc] parseForComments(loc file, str charset=DEFAULT_CHARSET, bool inferCharset=!(charset?), list[loc] includePaths = classPaths["vs12"],  map[str,str] standardMacros=provideStandardMacros(), map[str,str] additionalMacros = ())
```

## function parseForMacros {#lang-cpp-AST-parseForMacros}

```rascal
rel[loc,loc] parseForMacros(loc file, str charset=DEFAULT_CHARSET, bool inferCharset=!(charset?), list[loc] includePaths = classPaths["vs12"], map[str,str] standardMacros=provideStandardMacros(), map[str,str] additionalMacros = ())
```

