---
title: "module lang::cpp::tests::AST"
id: AST
slug: /Packages/org.rascalmpl.clair/API/lang/cpp/tests/AST
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.2</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.clair-0.13.3</div>

#### Usage

```rascal
import lang::cpp::tests::AST;
```

#### Dependencies
```rascal
extend lang::cpp::AST;
import analysis::m3::AST;
import List;
import util::Monitor;
import IO;
```


## function testFiles {#lang-cpp-tests-AST-testFiles}

```rascal
list[loc] testFiles()
```

## function astContract {#lang-cpp-tests-AST-astContract}

```rascal
bool astContract()
```

# Tests
## test declTypeFeature {#lang-cpp-tests-AST-declTypeFeature}

```rascal
test bool declTypeFeature() {
  t = parseCpp(|project://clair/src/test/declTypes.cpp|);

  /* we expect at two qualified names with a computed type expression in it: */
  computedNames = [q | /q:qualifiedName([decltypeName(Expression _), *_], _) := t];

  /* and we expect three declarations where the type of the declared variable is computed */
  computedTypes = [q | /q:declSpecifier(_, decltype(Expression _)) := t];
  
  return size(computedNames) == 2 && size(computedTypes) == 3;
}
```

