/*
 * This code was generated by openai's chat-gpt on Wed Apr 26, 2023 on the following prompt:
 *
 * > I need the code for a simple phonebook database written from scratch in C++, in object-oriented style. 
 * > Could you generate that?
 * 
 * It does not necessarily work but it does exercise a number of c++ name and type analysis features.
 * 
 * Later we added code to test operator overloading.
 */

void strncpy(char* dst, const char* src, int len) { return; /* dummy */}
int strcmp(const char* a, const char* b) { return 0; /* dummy */}

class Contact {
public:
    Contact(const char* name, const char* phoneNumber) {
        strncpy(this->name, name, sizeof(this->name) - 1);
        strncpy(this->phoneNumber, phoneNumber, sizeof(this->phoneNumber) - 1);
        this->name[sizeof(this->name) - 1] = '\0';
        this->phoneNumber[sizeof(this->phoneNumber) - 1] = '\0';
    }
    const char* getName() const {
        return name;
    }
    const char* getPhoneNumber() const {
        return phoneNumber;
    }
private:
    char name[256];
    char phoneNumber[256];
};

class Phonebook {
public:
    Phonebook() {
        contacts = new Contact*[MAX_CONTACTS];
        numContacts = 0;
    }
    ~Phonebook() {
        for (int i = 0; i < numContacts; i++) {
            delete contacts[i];
        }
        delete[] contacts;
    }

    Phonebook operator <<(const Contact& fresh) {
        addContact(fresh);
        return *this;
    }

    Phonebook operator ()(const Contact& fresh) {
        return *this << fresh;
    }

    void addContact(const Contact& contact) {
        contacts[numContacts++] = new Contact(contact.getName(), contact.getPhoneNumber());
    }

    Contact** searchByName(const char* name, int* numMatches) const {
        Contact** matchingContacts = new Contact*[MAX_CONTACTS];
        *numMatches = 0;
        for (int i = 0; i < numContacts; i++) {
            if (strcmp(contacts[i]->getName(), name) == 0) {
                matchingContacts[(*numMatches)++] = contacts[i];
            }
        }
        return matchingContacts;
    }

    Contact** searchByPhoneNumber(const char* phoneNumber, int* numMatches) const {
        Contact** matchingContacts = new Contact*[MAX_CONTACTS];
        *numMatches = 0;
        for (int i = 0; i < numContacts; i++) {
            if (strcmp(contacts[i]->getPhoneNumber(), phoneNumber) == 0) {
                matchingContacts[(*numMatches)++] = contacts[i];
            }
        }
        return matchingContacts;
    }
    
private:
    static const int MAX_CONTACTS = 1000;
    Contact** contacts;
    int numContacts;
};


int main(int argc, char* argv[]) {
    Phonebook* book = new Phonebook();
    Contact* c = new Contact("Jurgen", "075-6354020");
    Contact* d = new Contact("Paul", "035-6354020");
    Contact* e = new Contact("Rodin", "+31-756158557");
    
    // let's play with some overloaded operators
    book = &(*book << *c << *d);

    // here we use the overloaded function call operator
    (*book)(*new Contact("Bla", "1"));
}