/*
 * Decompiled with CFR 0.152.
 */
package lang.flybytes.internal;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.INumber;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import lang.flybytes.internal.Mirror;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.classloaders.SourceLocationClassLoader;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.ValueFactoryFactory;

public class ClassCompiler {
    private final IRascalValueFactory vf;
    private final TypeStore ts;
    private final PrintWriter out;
    private final Mirror mirror;
    private final ClassLoader loader;

    public ClassCompiler(IRascalValueFactory vf, TypeStore store, PrintWriter out, ClassLoader loader) {
        this.vf = vf;
        this.ts = store;
        this.out = out;
        this.mirror = new Mirror(vf, this.ts, out);
        this.loader = loader;
    }

    public void compileClass(IConstructor cls, ISourceLocation classFile, IBool enableAsserts, IConstructor version, IBool debugMode) {
        try (OutputStream output = URIResolverRegistry.getInstance().getOutputStream(classFile, false);){
            ClassWriter cw;
            ClassWriter cv = cw = new ClassWriter(3);
            new Compile((ClassVisitor)cv, AST.$getVersionCode(version), debugMode.getValue()).compileClass(cls);
            output.write(cw.toByteArray());
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io((String)e.getMessage());
        }
    }

    public IMap loadClasses(IList classes, IConstructor prefix, IList classpath, IBool enableAsserts, IConstructor version, IBool debugMode) {
        SourceLocationClassLoader locLoader = new SourceLocationClassLoader(classpath.append((IValue)URIUtil.rootLocation((String)"system")), this.loader);
        ClassMapLoader l = new ClassMapLoader((ClassLoader)locLoader);
        ISourceLocation classFolder = null;
        if (prefix.getConstructorType().getName().equals("just")) {
            classFolder = (ISourceLocation)prefix.get("val");
        }
        for (IValue elem : classes) {
            ClassWriter cw;
            IConstructor cls = (IConstructor)elem;
            String name = AST.$getName(AST.$getType(cls));
            ClassWriter cv = cw = new ClassWriter(2);
            new Compile((ClassVisitor)cv, AST.$getVersionCode(version), debugMode.getValue()).compileClass(cls);
            byte[] bytes = cw.toByteArray();
            l.putBytes(name, cw.toByteArray());
            if (classFolder == null) continue;
            ISourceLocation classFile = URIUtil.getChildLocation((ISourceLocation)classFolder, (String)(name.replace('.', '/') + ".class"));
            try {
                OutputStream out = URIResolverRegistry.getInstance().getOutputStream(classFile, false);
                try {
                    out.write(bytes);
                }
                finally {
                    if (out == null) continue;
                    out.close();
                }
            }
            catch (IOException e) {
                RuntimeExceptionFactory.io((IString)this.vf.string(e.getMessage()), null, null);
            }
        }
        try {
            Mirror m = new Mirror(this.vf, this.ts, this.out);
            IMapWriter w = this.vf.mapWriter();
            for (String name : l) {
                w.put((IValue)this.vf.string(name), (IValue)m.mirrorClass(name, l.getClass(name)));
            }
            return (IMap)w.done();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public IValue loadClass(IConstructor cls, IConstructor output, IList classpath, IBool enableAsserts, IConstructor version, IBool debugMode) {
        try {
            ClassWriter cw;
            SourceLocationClassLoader locLoader = new SourceLocationClassLoader(classpath.append((IValue)URIUtil.rootLocation((String)"system")), this.getClass().getClassLoader());
            String className = AST.$getName(AST.$getType(cls));
            ClassWriter cv = cw = new ClassWriter(2);
            new Compile((ClassVisitor)cv, AST.$getVersionCode(version), debugMode.getValue()).compileClass(cls);
            Class<?> loaded = this.loadSingleClass(className, cw, (ClassLoader)locLoader);
            if (output.getConstructorType().getName().equals("just")) {
                ISourceLocation classFile = (ISourceLocation)output.get("val");
                try (OutputStream out = URIResolverRegistry.getInstance().getOutputStream(classFile, false);){
                    out.write(cw.toByteArray());
                }
                catch (IOException e) {
                    RuntimeExceptionFactory.io((IString)this.vf.string(e.getMessage()), null, null);
                }
            }
            return this.mirror.mirrorClass(className, loaded);
        }
        catch (Throwable e) {
            e.printStackTrace(this.out);
            throw new RuntimeException(e);
        }
    }

    public IValue val(IValue v) {
        return this.mirror.mirrorObject(v);
    }

    public IValue array(IConstructor type, IList elems) throws ClassNotFoundException {
        return this.mirror.mirrorArray(type, elems);
    }

    public IValue array(IConstructor type, IInteger length) throws ClassNotFoundException {
        return this.mirror.mirrorArray(type, length.intValue());
    }

    public IValue classMirror(IString n, IList classpath) {
        try {
            SourceLocationClassLoader loader = new SourceLocationClassLoader(classpath, this.loader);
            String name = n.getValue();
            return this.mirror.mirrorClass(name, loader.loadClass(name));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(n.getValue());
        }
    }

    private Class<?> loadSingleClass(String className, ClassWriter cw, ClassLoader loader) throws ClassNotFoundException {
        ClassMapLoader l = new ClassMapLoader(loader);
        l.putBytes(className, cw.toByteArray());
        return l.getClass(className);
    }

    private static class LeveledLabel
    extends Label {
        private final int finallyNestingLevel;

        public LeveledLabel(int level) {
            this.finallyNestingLevel = level;
        }

        public int getFinallyNestingLevel() {
            return this.finallyNestingLevel;
        }
    }

    private static class Types {
        private static final TypeFactory tf = TypeFactory.getInstance();
        private static final IValueFactory vf = ValueFactoryFactory.getValueFactory();
        private static final TypeStore store = new TypeStore(new TypeStore[0]);
        private static final Type TYPE = tf.abstractDataType(store, "Type", new Type[0]);
        private static final Type BOOLEAN = tf.constructor(store, TYPE, "boolean", new Type[0]);
        private static final IConstructor BOOL_CONS = vf.constructor(BOOLEAN);
        private static final Type INTEGER = tf.constructor(store, TYPE, "integer", new Type[0]);
        private static final IConstructor INTEGER_CONS = vf.constructor(INTEGER);
        private static final Type VOID = tf.constructor(store, TYPE, "void", new Type[0]);
        private static final IConstructor VOID_CONS = vf.constructor(VOID);
        private static final Type REF = tf.constructor(store, TYPE, "object", new Object[]{tf.stringType(), "name"});

        private Types() {
        }

        static IConstructor booleanType() {
            return BOOL_CONS;
        }

        static IConstructor integerType() {
            return INTEGER_CONS;
        }

        static IConstructor voidType() {
            return VOID_CONS;
        }

        static String throwableName() {
            return "java/lang/Throwable";
        }

        static IConstructor throwableType() {
            return vf.constructor(REF, new IValue[]{vf.string(Types.throwableName())});
        }
    }

    public static class Switch {
        public static void type0(IConstructor type, Consumer<IConstructor> bools, Consumer<IConstructor> ints, Consumer<IConstructor> shorts, Consumer<IConstructor> bytes, Consumer<IConstructor> chars, Consumer<IConstructor> floats, Consumer<IConstructor> doubles, Consumer<IConstructor> longs, Consumer<IConstructor> voids, Consumer<IConstructor> classes, Consumer<IConstructor> arrays, Consumer<IConstructor> strings) {
            switch (AST.$getConstructorName((IValue)type)) {
                case "boolean": {
                    bools.accept(type);
                    break;
                }
                case "integer": {
                    ints.accept(type);
                    break;
                }
                case "short": {
                    shorts.accept(type);
                    break;
                }
                case "byte": {
                    bytes.accept(type);
                    break;
                }
                case "character": {
                    chars.accept(type);
                    break;
                }
                case "float": {
                    floats.accept(type);
                    break;
                }
                case "double": {
                    doubles.accept(type);
                    break;
                }
                case "long": {
                    longs.accept(type);
                    break;
                }
                case "void": {
                    voids.accept(type);
                    break;
                }
                case "object": {
                    classes.accept(type);
                    break;
                }
                case "array": {
                    arrays.accept(type);
                    break;
                }
                case "string": {
                    strings.accept(type);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("type not supported: " + String.valueOf(type));
                }
            }
        }

        public static <T> T type(IConstructor type, Function<IConstructor, T> bools, Function<IConstructor, T> ints, Function<IConstructor, T> shorts, Function<IConstructor, T> bytes, Function<IConstructor, T> chars, Function<IConstructor, T> floats, Function<IConstructor, T> doubles, Function<IConstructor, T> longs, Function<IConstructor, T> voids, Function<IConstructor, T> classes, Function<IConstructor, T> arrays, Function<IConstructor, T> strings) {
            switch (AST.$getConstructorName((IValue)type)) {
                case "boolean": {
                    return bools.apply(type);
                }
                case "integer": {
                    return ints.apply(type);
                }
                case "short": {
                    return shorts.apply(type);
                }
                case "byte": {
                    return bytes.apply(type);
                }
                case "character": {
                    return chars.apply(type);
                }
                case "float": {
                    return floats.apply(type);
                }
                case "double": {
                    return doubles.apply(type);
                }
                case "long": {
                    return longs.apply(type);
                }
                case "void": {
                    return voids.apply(type);
                }
                case "object": {
                    return classes.apply(type);
                }
                case "array": {
                    return arrays.apply(type);
                }
                case "string": {
                    return strings.apply(type);
                }
            }
            throw new IllegalArgumentException("type not supported: " + String.valueOf(type));
        }

        public static <T> void type(IConstructor type, T arg, BiConsumer<IConstructor, T> bools, BiConsumer<IConstructor, T> ints, BiConsumer<IConstructor, T> shorts, BiConsumer<IConstructor, T> bytes, BiConsumer<IConstructor, T> chars, BiConsumer<IConstructor, T> floats, BiConsumer<IConstructor, T> doubles, BiConsumer<IConstructor, T> longs, BiConsumer<IConstructor, T> voids, BiConsumer<IConstructor, T> classes, BiConsumer<IConstructor, T> arrays, BiConsumer<IConstructor, T> strings) {
            switch (AST.$getConstructorName((IValue)type)) {
                case "boolean": {
                    bools.accept(type, (IConstructor)arg);
                    break;
                }
                case "integer": {
                    ints.accept(type, (IConstructor)arg);
                    break;
                }
                case "short": {
                    shorts.accept(type, (IConstructor)arg);
                    break;
                }
                case "byte": {
                    bytes.accept(type, (IConstructor)arg);
                    break;
                }
                case "character": {
                    chars.accept(type, (IConstructor)arg);
                    break;
                }
                case "float": {
                    floats.accept(type, (IConstructor)arg);
                    break;
                }
                case "double": {
                    doubles.accept(type, (IConstructor)arg);
                    break;
                }
                case "long": {
                    longs.accept(type, (IConstructor)arg);
                    break;
                }
                case "void": {
                    voids.accept(type, (IConstructor)arg);
                    break;
                }
                case "object": {
                    classes.accept(type, (IConstructor)arg);
                    break;
                }
                case "array": {
                    arrays.accept(type, (IConstructor)arg);
                    break;
                }
                case "string": {
                    strings.accept(type, (IConstructor)arg);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("type not supported: " + String.valueOf(type));
                }
            }
        }
    }

    public static class AST {
        public static int $getKey(IConstructor exp) {
            return ((IInteger)exp.get("key")).intValue();
        }

        public static int $getMin(IConstructor exp) {
            return ((IInteger)exp.get("min")).intValue();
        }

        public static int $getMax(IConstructor exp) {
            return ((IInteger)exp.get("max")).intValue();
        }

        public static String $getDefaultLabel(IConstructor instr) {
            return ((IString)instr.get("defaultLabel")).getValue();
        }

        public static int $getVar(IConstructor exp) {
            return ((IInteger)exp.get("var")).intValue();
        }

        public static int $getNumDimensions(IConstructor exp) {
            return ((IInteger)exp.get("numDimensions")).intValue();
        }

        public static int $getIntVal(IConstructor exp) {
            return ((IInteger)exp.get("val")).intValue();
        }

        public static IList $getInstructions(IConstructor stat) {
            return (IList)stat.get("instructions");
        }

        public static IList $getCaseLabels(IConstructor stat) {
            return (IList)stat.get("labels");
        }

        public static IList $getCaseKeys(IConstructor stat) {
            return (IList)stat.get("keys");
        }

        public static boolean $getIsInterface(IConstructor stat) {
            return ((IBool)stat.get("isInterface")).getValue();
        }

        public static IConstructor $getSpecial(IConstructor cons) {
            return (IConstructor)cons.get("special");
        }

        public static IConstructor $getThenExp(IConstructor exp) {
            return (IConstructor)exp.get("thenExp");
        }

        public static IConstructor $getElseExp(IConstructor exp) {
            return (IConstructor)exp.get("elseExp");
        }

        public static IConstructor $getHandle(IConstructor exp) {
            return (IConstructor)exp.get("handle");
        }

        public static IValue $getVal(IConstructor anno) {
            return anno.get("val");
        }

        public static String $getRetention(IConstructor elem) {
            if (elem.asWithKeywordParameters().hasParameter("retention")) {
                return ((IString)elem.asWithKeywordParameters().getParameter("runtime")).getValue();
            }
            return "class";
        }

        public static IValue $getConstant(IConstructor exp) {
            return exp.get("constant");
        }

        public static IList $getCases(IConstructor stat) {
            return (IList)stat.get("cases");
        }

        public static IList $getCatch(IConstructor stat) {
            return (IList)stat.get("catch");
        }

        public static IList $getFinally(IConstructor stat) {
            return (IList)stat.get("finally");
        }

        public static String $getLabel(IConstructor stat) {
            return ((IString)stat.get("label")).getValue();
        }

        public static boolean $is(String string, IConstructor parameter) {
            return parameter.getConstructorType().getName().equals(string);
        }

        public static IConstructor $getDefault(IConstructor var) {
            IWithKeywordParameters kws = var.asWithKeywordParameters();
            if (!kws.hasParameter("init")) {
                return null;
            }
            return (IConstructor)kws.getParameter("init");
        }

        public static IList $getNext(IConstructor stat) {
            return (IList)stat.get("next");
        }

        public static IList $getInit(IConstructor stat) {
            return (IList)stat.get("init");
        }

        public static IConstructor $getCondition(IConstructor stat) {
            return (IConstructor)stat.get("condition");
        }

        public static IList $getThenBlock(IConstructor stat) {
            return (IList)stat.get("thenBlock");
        }

        public static IList $getElseBlock(IConstructor stat) {
            return (IList)stat.get("elseBlock");
        }

        public static IConstructor $getSize(IConstructor exp) {
            return (IConstructor)exp.get("size");
        }

        public static IConstructor $getLhs(IConstructor exp) {
            return (IConstructor)exp.get("lhs");
        }

        public static IConstructor $getRhs(IConstructor exp) {
            return (IConstructor)exp.get("rhs");
        }

        public static IConstructor $getFrom(IConstructor exp) {
            return (IConstructor)exp.get("from");
        }

        public static IConstructor $getTo(IConstructor exp) {
            return (IConstructor)exp.get("to");
        }

        public static IConstructor $getValue(IConstructor stat) {
            return (IConstructor)stat.get("value");
        }

        public static IConstructor $getIndex(IConstructor exp) {
            return (IConstructor)exp.get("index");
        }

        public static IConstructor $getArray(IConstructor exp) {
            return (IConstructor)exp.get("array");
        }

        public static IConstructor $getReceiver(IConstructor exp) {
            return (IConstructor)exp.get("receiver");
        }

        public static IConstructor $getReturn(IConstructor sig) {
            return (IConstructor)sig.get("return");
        }

        public static IList $getArgs(IConstructor sig) {
            return (IList)sig.get("args");
        }

        public static IConstructor $getClass(IConstructor parameter) {
            return (IConstructor)parameter.get("class");
        }

        public static String $getClassStr(IConstructor parameter) {
            return ((IString)parameter.get("class")).getValue();
        }

        public static String $getRefClassFromType(IConstructor type, String currentClass) {
            return Switch.type(type, z -> {
                throw new IllegalArgumentException("expected object type");
            }, i -> {
                throw new IllegalArgumentException("expected object type");
            }, s -> {
                throw new IllegalArgumentException("expected object type");
            }, b -> {
                throw new IllegalArgumentException("expected object type");
            }, c -> {
                throw new IllegalArgumentException("expected object type");
            }, f -> {
                throw new IllegalArgumentException("expected object type");
            }, d -> {
                throw new IllegalArgumentException("expected object type");
            }, j -> {
                throw new IllegalArgumentException("expected object type");
            }, v -> {
                throw new IllegalArgumentException("expected object type");
            }, c -> {
                String name = AST.$getName(type).replace('.', '/');
                if (name.equals("<current>")) {
                    name = currentClass;
                }
                return name;
            }, a -> {
                throw new IllegalArgumentException("can not instantiate array types, use newArray instead of newInstance");
            }, s -> "java/lang/String");
        }

        public static String $getConstructorName(IValue parameter) {
            return ((IConstructor)parameter).getConstructorType().getName();
        }

        public static String $getName(IConstructor exp) {
            return ((IString)exp.get("name")).getValue();
        }

        public static String $getAnnotationName(IConstructor exp) {
            IWithKeywordParameters kws = exp.asWithKeywordParameters();
            if (kws.hasParameter("name")) {
                return ((IString)kws.getParameter("name")).getValue();
            }
            return "value";
        }

        public static String $getAnnoClass(IConstructor exp) {
            return ((IString)exp.get("annoClass")).getValue();
        }

        public static IConstructor $getType(IConstructor exp) {
            return (IConstructor)exp.get("type");
        }

        public static boolean $getBooleanConstant(IValue parameter) {
            return ((IBool)parameter).getValue();
        }

        public static int $getIntegerConstant(IValue parameter) {
            return ((IInteger)parameter).intValue();
        }

        public static long $getLongConstant(IValue parameter) {
            return ((IInteger)parameter).longValue();
        }

        public static float $getFloatConstant(IValue parameter) {
            return ((IReal)parameter).floatValue();
        }

        public static double $getDoubleConstant(IValue parameter) {
            return ((IReal)parameter).doubleValue();
        }

        public static String $getStringConstant(IValue parameter) {
            return ((IString)parameter).getValue();
        }

        public static boolean $getBoolean(IValue parameter) {
            return ((IBool)parameter).getValue();
        }

        public static double $getDouble(IValue parameter) {
            return ((INumber)parameter).toReal(10).doubleValue();
        }

        public static IList $getStatements(IConstructor block) {
            return (IList)block.get("statements");
        }

        public static IList $getVariables(IConstructor block) {
            return (IList)block.get("variables");
        }

        public static ISet $getModifiersParameter(IWithKeywordParameters<? extends IConstructor> kws) {
            return (ISet)kws.getParameter("modifiers");
        }

        public static IConstructor $getDesc(IConstructor cons) {
            return (IConstructor)cons.get("desc");
        }

        public static IList $getFormals(IConstructor sig) {
            return (IList)sig.get("formals");
        }

        public static IList $getBlock(IConstructor cons) {
            return (IList)cons.get("block");
        }

        public static IList $getMethodsParameter(IWithKeywordParameters<? extends IConstructor> kws) {
            return (IList)kws.getParameter("methods");
        }

        public static IList $getAnnotations(IWithKeywordParameters<? extends IConstructor> kws) {
            return (IList)kws.getParameter("annotations");
        }

        public static IList $getFieldsParameter(IWithKeywordParameters<? extends IConstructor> kws) {
            return (IList)kws.getParameter("fields");
        }

        public static String $getSourceParameter(IWithKeywordParameters<? extends IConstructor> kws) {
            return kws.getParameter("source").toString();
        }

        public static ISet $getModifiers(IConstructor o) {
            return (ISet)o.asWithKeywordParameters().getParameter("modifiers");
        }

        public static String $getSuper(IWithKeywordParameters<? extends IConstructor> kws) {
            return AST.$getName((IConstructor)kws.getParameter("super")).replace('.', '/');
        }

        public static String $string(IValue v) {
            return ((IString)v).getValue();
        }

        public static IValue $getDefaultParameter(IWithKeywordParameters<? extends IConstructor> kws) {
            return kws.getParameter("init");
        }

        public static IConstructor $getArg(IConstructor type) {
            return (IConstructor)type.get("arg");
        }

        public static int $getInc(IConstructor type) {
            return ((IInteger)type.get("inc")).intValue();
        }

        public static int $getLine(IConstructor instr) {
            return ((IInteger)instr.get("line")).intValue();
        }

        public static int $getVersionCode(IConstructor version) {
            switch (version.getConstructorType().getName()) {
                case "v1_6": {
                    return 50;
                }
                case "v1_7": {
                    return 51;
                }
                case "v1_8": {
                    return 52;
                }
                case "v9": {
                    return 53;
                }
                case "v10": {
                    return 54;
                }
                case "v11": {
                    return 55;
                }
                case "v12": {
                    return 56;
                }
                case "v13": {
                    return 57;
                }
                case "v14": {
                    return 58;
                }
                case "v15": {
                    return 59;
                }
                case "v16": {
                    return 60;
                }
                case "v17": {
                    return 61;
                }
                case "v18": {
                    return 62;
                }
            }
            throw new IllegalArgumentException(version.toString());
        }

        public static IList $getInterfaces(IWithKeywordParameters<? extends IConstructor> kws) {
            return (IList)kws.getParameter("interfaces");
        }
    }

    public static class Signature {
        public static final String objectName = "java/lang/Object";
        public static final String stringName = "java/lang/String";
        public static final String objectType = "Ljava/lang/Object;";
        public static final String stringType = "Ljava/lang/String;";

        public static String constructor(IConstructor sig) {
            StringBuilder val = new StringBuilder();
            val.append("(");
            for (IValue formal : AST.$getFormals(sig)) {
                val.append(Signature.type((IConstructor)formal));
            }
            val.append(")V");
            return val.toString();
        }

        public static String method(IConstructor sig) {
            StringBuilder val = new StringBuilder();
            val.append("(");
            for (IValue formal : AST.$getFormals(sig)) {
                val.append(Signature.type((IConstructor)formal));
            }
            val.append(")");
            val.append(Signature.type(AST.$getReturn(sig)));
            return val.toString();
        }

        public static MethodType methodType(IConstructor sig) {
            return MethodType.fromMethodDescriptorString(Signature.method(sig), Signature.class.getClassLoader());
        }

        public static MethodType constructorType(IConstructor sig) {
            return MethodType.fromMethodDescriptorString(Signature.constructor(sig), Signature.class.getClassLoader());
        }

        public static String type(IConstructor t) {
            IConstructor type = t;
            return Switch.type(type, z -> "Z", i -> "I", s -> "S", b -> "B", c -> "C", f -> "F", d -> "D", j -> "J", v -> "V", c -> "L" + AST.$getName(c).replace('.', '/') + ";", a -> "[" + Signature.type(AST.$getArg(a)), S -> stringType);
        }

        public static Class<?>[] binaryClasses(IList formals, PrintWriter out) throws ClassNotFoundException {
            Class[] result = new Class[formals.length()];
            int i = 0;
            for (IValue elem : formals) {
                result[i++] = Signature.binaryClass((IConstructor)elem);
            }
            return result;
        }

        public static Class<?> binaryClass(IConstructor type) throws ClassNotFoundException {
            return Switch.type(type, z -> Boolean.TYPE, i -> Integer.TYPE, s -> Short.TYPE, b -> Byte.TYPE, c -> Character.TYPE, f -> Float.TYPE, d -> Double.TYPE, j -> Long.TYPE, v -> Void.TYPE, c -> Signature.forName(AST.$getName(type)), a -> Signature.arrayClass(AST.$getArg(type)), S -> String.class);
        }

        private static Class<?> arrayClass(IConstructor component) {
            try {
                Class<?> elem = Signature.binaryClass(component);
                return Array.newInstance(elem, 0).getClass();
            }
            catch (ClassNotFoundException e) {
                return Object[].class;
            }
        }

        public static Class<?> forName(String name) {
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                return Object.class;
            }
        }
    }

    private static class Compile {
        private static final Builder<IConstructor> DONE = () -> null;
        private final ClassVisitor cw;
        private final int version;
        private ArrayList<IConstructor> variableTypes;
        private ArrayList<String> variableNames;
        private ArrayList<IConstructor> variableDefaults;
        private ArrayList<IList> variableAnnotations;
        private boolean hasDefaultConstructor = false;
        private boolean hasStaticInitializer;
        private boolean isInterface;
        private Map<String, IConstructor> fieldInitializers = new HashMap<String, IConstructor>();
        private Map<String, IConstructor> staticFieldInitializers = new HashMap<String, IConstructor>();
        private LeveledLabel methodStartLabel;
        private LeveledLabel methodEndLabel;
        private MethodNode method;
        private ArrayList<Builder<IConstructor>> tryFinallyNestingLevel = new ArrayList();
        private IConstructor classType;
        private ClassNode classNode;
        private final Builder<IConstructor> pushTrue = () -> this.trueExp();
        private final Builder<IConstructor> pushFalse = () -> this.falseExp();
        private Map<String, LeveledLabel> labels;
        private Map<String, Label> asmLabels;
        private int currentLine = 0;
        private boolean emittingFinally = false;
        private final boolean debug;

        public Compile(ClassVisitor cw, int version, boolean debug) {
            this.cw = cw;
            this.version = version;
            this.debug = debug;
        }

        public void compileClass(IConstructor o) {
            this.classNode = new ClassNode();
            IWithKeywordParameters kws = o.asWithKeywordParameters();
            this.isInterface = AST.$is("interface", o);
            this.classType = AST.$getType(o);
            this.classNode.version = this.version;
            this.classNode.signature = null;
            this.classNode.name = AST.$getName(this.classType);
            this.classNode.visitSource(this.sourceFile(o), null);
            this.classNode.access = kws.hasParameter("modifiers") ? this.access(AST.$getModifiers(o)) : 1;
            if (this.isInterface) {
                this.classNode.access += 1536;
            }
            this.classNode.superName = kws.hasParameter("super") ? AST.$getSuper((IWithKeywordParameters<? extends IConstructor>)kws) : "java/lang/Object";
            if (kws.hasParameter("interfaces")) {
                ArrayList<String> interfaces = new ArrayList<String>();
                for (IValue v : AST.$getInterfaces((IWithKeywordParameters<? extends IConstructor>)kws)) {
                    interfaces.add(AST.$getName((IConstructor)v).replace('.', '/'));
                }
                this.classNode.interfaces = interfaces;
            }
            if (kws.hasParameter("fields")) {
                this.fields(this.classNode, AST.$getFieldsParameter((IWithKeywordParameters<? extends IConstructor>)kws), this.isInterface, this.getLineNumber(o, -1));
            }
            if (kws.hasParameter("methods")) {
                this.methods(this.classNode, AST.$getMethodsParameter((IWithKeywordParameters<? extends IConstructor>)kws), this.getLineNumber(o, -1));
            }
            if (!this.hasDefaultConstructor && !this.isInterface) {
                this.generateDefaultConstructor(this.classNode);
            }
            if (!this.hasStaticInitializer && !this.staticFieldInitializers.isEmpty()) {
                this.staticInitializer(this.classNode, null, this.getLineNumber(o, -1));
            }
            if (kws.hasParameter("annotations")) {
                this.annotations(this.classNode, AST.$getAnnotations((IWithKeywordParameters<? extends IConstructor>)kws));
            }
            this.classNode.accept(this.cw);
        }

        private String sourceFile(IConstructor o) {
            ISourceLocation loc;
            if (o.mayHaveKeywordParameters() && (loc = (ISourceLocation)o.asWithKeywordParameters().getParameter("src")) != null) {
                if (!loc.hasLineColumn()) {
                    throw new IllegalArgumentException("debug mode requires line/column information on the src fields to weave in line number information.");
                }
                return loc.getPath();
            }
            if (this.debug) {
                throw new IllegalArgumentException("debug mode is requires src annotation on the class to determine the source file name.");
            }
            return null;
        }

        private LeveledLabel newLabel() {
            return this.newLabel(this.tryFinallyNestingLevel);
        }

        private int getLineNumber(IConstructor o, int parentLine) {
            ISourceLocation loc;
            if (o.mayHaveKeywordParameters() && (loc = (ISourceLocation)o.asWithKeywordParameters().getParameter("src")) != null && loc.hasLineColumn()) {
                return loc.getBeginLine();
            }
            return parentLine;
        }

        private void annotations(ClassNode cn, IList annotations) {
            this.annotations((String d, Boolean v) -> cn.visitAnnotation(d, v.booleanValue()), annotations);
        }

        private void annotations(MethodNode mn, IList annotations) {
            this.annotations((String d, Boolean v) -> mn.visitAnnotation(d, v.booleanValue()), annotations);
        }

        private void annotations(BiFunction<String, Boolean, AnnotationVisitor> cn, IList annotations) {
            for (IValue elem : annotations) {
                this.annotation(cn, elem);
            }
        }

        private void annotation(BiFunction<String, Boolean, AnnotationVisitor> cn, IValue elem) {
            String retention = AST.$getRetention((IConstructor)elem);
            boolean visible = true;
            switch (retention) {
                case "source": {
                    return;
                }
                case "class": {
                    visible = false;
                }
                case "runtime": {
                    visible = true;
                }
            }
            IConstructor anno = (IConstructor)elem;
            String sig = "L" + AST.$getAnnoClass(anno) + ";";
            AnnotationVisitor an = cn.apply(sig, visible);
            if (anno.arity() > 1) {
                this.annotation(an, (IConstructor)elem);
            }
            an.visitEnd();
        }

        private void annotation(AnnotationVisitor node, IConstructor anno) {
            String name = AST.$getAnnotationName(anno);
            IConstructor type = AST.$getType(anno);
            Object val = this.object(type, AST.$getVal(anno));
            String descriptor = Signature.type(type);
            Switch.type0(type, z -> node.visit(name, val), i -> node.visit(name, val), s -> node.visit(name, val), b -> node.visit(name, val), c -> node.visit(name, val), f -> node.visit(name, val), d -> node.visit(name, val), l -> node.visit(name, val), v -> node.visit(name, val), C -> node.visitEnum(name, descriptor, (String)val), a -> {
                AnnotationVisitor aav = node.visitArray(name);
                for (int i = 0; i < Array.getLength(val); ++i) {
                    aav.visit(name, Array.get(val, i));
                }
                aav.visitEnd();
            }, S -> node.visit(name, val));
        }

        Object object(IConstructor type, IValue val) {
            return Switch.type(type, z -> ((IBool)val).getValue(), i -> ((IInteger)val).intValue(), s -> (short)((IInteger)val).intValue(), b -> (byte)((IInteger)val).intValue(), c -> Character.valueOf((char)((IInteger)val).intValue()), f -> Float.valueOf(((IReal)val).floatValue()), d -> ((IReal)val).doubleValue(), j -> ((IInteger)val).longValue(), v -> null, C -> ((IString)val).getValue(), a -> this.array(type, val), s -> ((IString)val).getValue());
        }

        private Object array(IConstructor type, IValue val) {
            try {
                if (!(val instanceof IList)) {
                    throw new IllegalArgumentException("array annotations must be provided as lists");
                }
                IList list = (IList)val;
                Object arr = Array.newInstance(Signature.binaryClass(AST.$getArg(type)), list.length());
                int i = 0;
                for (IValue elem : (IList)val) {
                    Array.set(arr, i++, this.object(AST.$getArg(type), elem));
                }
                return arr;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("could not construct annotation array of " + String.valueOf(type) + " due to " + e.getMessage(), e);
            }
        }

        private void generateDefaultConstructor(ClassNode cn) {
            this.method = new MethodNode(1, "<init>", "()V", null, null);
            this.method.visitCode();
            LeveledLabel l0 = new LeveledLabel(0);
            LeveledLabel l1 = new LeveledLabel(0);
            this.method.visitLocalVariable("this", "L" + cn.name + ";", null, (Label)l0, (Label)l1, 0);
            this.method.visitVarInsn(25, 0);
            this.method.visitMethodInsn(183, cn.superName, "<init>", "()V", false);
            this.fieldInitializers(this.classNode, this.method);
            this.method.visitInsn(177);
            this.method.visitLabel((Label)l1);
            this.method.visitMaxs(0, 0);
            this.method.visitEnd();
            this.classNode.methods.add(this.method);
        }

        private void fields(ClassNode classNode, IList fields, boolean interf, int parentLine) {
            for (IValue field : fields) {
                IConstructor cons = (IConstructor)field;
                this.field(classNode, cons, interf, parentLine);
            }
        }

        private void methods(ClassNode classNode, IList methods, int parentLine) {
            for (IValue field : methods) {
                IConstructor cons = (IConstructor)field;
                if (cons.getConstructorType().getName().equals("static")) {
                    this.staticInitializer(classNode, cons, parentLine);
                    continue;
                }
                this.method(classNode, cons, parentLine);
            }
        }

        private void staticInitializer(ClassNode classNode, IConstructor cons, int parentLine) {
            if (this.hasStaticInitializer) {
                throw new IllegalArgumentException("can only have one static initializer per class");
            }
            this.hasStaticInitializer = true;
            this.method = new MethodNode(8, "<clinit>", "()V", null, null);
            this.variableTypes = new ArrayList();
            this.variableNames = new ArrayList();
            this.variableDefaults = new ArrayList();
            this.variableAnnotations = new ArrayList();
            this.methodStartLabel = new LeveledLabel(0);
            this.methodEndLabel = new LeveledLabel(0);
            this.method.visitCode();
            this.method.visitLabel((Label)this.methodStartLabel);
            this.staticFieldInitializers(classNode, this.method, this.getLineNumber(cons, parentLine));
            IList block = AST.$getBlock(cons);
            if (block != null) {
                this.statements(block, null, null, this.methodEndLabel, this.getLineNumber(cons, parentLine));
            }
            this.method.visitLabel((Label)this.methodEndLabel);
            this.method.visitInsn(177);
            this.method.visitMaxs(0, 0);
            this.method.visitEnd();
            classNode.methods.add(this.method);
        }

        private void method(ClassNode classNode, IConstructor cons, int parentLine) {
            IConstructor sig;
            boolean isConstructor;
            IWithKeywordParameters kws = cons.asWithKeywordParameters();
            boolean isAbstract = cons.getConstructorType().getArity() == 1;
            int modifiers = 1;
            modifiers += isAbstract ? 1024 : 0;
            if (kws.hasParameter("modifiers")) {
                modifiers = this.modifiers(AST.$getModifiersParameter((IWithKeywordParameters<? extends IConstructor>)kws));
            }
            String name = (isConstructor = (sig = AST.$getDesc(cons)).getConstructorType().getName().equals("constructorDesc")) ? "<init>" : AST.$getName(sig);
            this.method = new MethodNode(modifiers, name, isConstructor ? Signature.constructor(sig) : Signature.method(sig), null, null);
            this.labels = new HashMap<String, LeveledLabel>();
            this.asmLabels = new HashMap<String, Label>();
            if (!isAbstract) {
                if (this.isInterface && classNode.version < 52) {
                    throw new IllegalArgumentException("default methods requires at least JVM version v1_8()");
                }
                if ((modifiers & 0x400) != 0) {
                    throw new IllegalArgumentException("method with body should not be abstract");
                }
                IList sigFormals = AST.$getFormals(sig);
                this.hasDefaultConstructor |= isConstructor && sigFormals.isEmpty();
                IList varFormals = AST.$getFormals(cons);
                if (sigFormals.length() != varFormals.length()) {
                    throw new IllegalArgumentException("type signature of " + name + " has different number of types (" + sigFormals.length() + ") from formal parameters (" + varFormals.length() + "), see: " + String.valueOf(sigFormals) + " versus " + String.valueOf(varFormals));
                }
                boolean isStatic = (modifiers & 8) != 0;
                this.variableTypes = new ArrayList();
                this.variableNames = new ArrayList();
                this.variableDefaults = new ArrayList();
                this.variableAnnotations = new ArrayList();
                if (!isStatic) {
                    this.declareVariable(this.classType, "this", null, false, null, this.getLineNumber(cons, parentLine));
                }
                this.methodStartLabel = new LeveledLabel(0);
                this.methodEndLabel = new LeveledLabel(0);
                this.method.visitCode();
                this.method.visitLabel((Label)this.methodStartLabel);
                this.formalVariables(varFormals, false);
                if (isConstructor && !this.fieldInitializers.isEmpty()) {
                    this.fieldInitializers(classNode, this.method);
                }
                if (AST.$is("procedure", cons)) {
                    this.instructions(AST.$getInstructions(cons), this.methodEndLabel, this.methodEndLabel, this.methodEndLabel, this.getLineNumber(cons, parentLine));
                } else {
                    this.statements(AST.$getBlock(cons), this.methodStartLabel, this.methodEndLabel, this.methodEndLabel, this.getLineNumber(cons, parentLine));
                }
                this.method.visitLabel((Label)this.methodEndLabel);
                for (int i = 0; i < this.variableNames.size(); ++i) {
                    String varName = this.variableNames.get(i);
                    if (varName == null) continue;
                    String varType = Signature.type(this.variableTypes.get(i));
                    this.method.visitLocalVariable(varName, varType, null, (Label)this.methodStartLabel, (Label)this.methodEndLabel, i);
                    IList annotations = this.variableAnnotations.get(i);
                    if (annotations == null) continue;
                    int index = i;
                    this.annotations((String s, Boolean v) -> this.method.visitLocalVariableAnnotation(64, null, new Label[]{this.methodStartLabel}, new Label[]{this.methodEndLabel}, new int[]{index}, s, v.booleanValue()), annotations);
                }
                this.method.visitMaxs(0, 0);
            }
            if (kws.hasParameter("annotations")) {
                this.annotations(this.method, (IList)kws.getParameter("annotations"));
            }
            this.method.visitEnd();
            classNode.methods.add(this.method);
        }

        private void declareVariable(IConstructor type, String name, IConstructor def, boolean alwaysInitialize, IList annotations, int line) {
            int pos = this.variableNames.size();
            this.variableTypes.add(type);
            this.variableNames.add(name);
            this.variableDefaults.add(def);
            this.variableAnnotations.add(null);
            String typeName = type.getConstructorType().getName();
            if (typeName.equals("double") || typeName.equals("long")) {
                this.variableTypes.add(null);
                this.variableNames.add(null);
                this.variableDefaults.add(null);
                this.variableAnnotations.add(null);
            }
            if (alwaysInitialize) {
                if (def == null) {
                    this.computeDefaultValueForVariable(type, pos);
                } else {
                    this.storeStat(name, def, line);
                }
            } else if (def != null && (typeName.equals("object") || typeName.equals("array"))) {
                this.loadExp(name, line);
                this.invertedConditionalFlow(0, 199, () -> this.storeStat(name, def, line), null, null, line);
            }
        }

        private void fieldInitializers(ClassNode classNode, MethodNode method) {
            for (String field : this.fieldInitializers.keySet()) {
                IConstructor def = this.fieldInitializers.get(field);
                IConstructor exp = (IConstructor)def.asWithKeywordParameters().getParameter("init");
                this.loadExp("this", this.getLineNumber(exp, -1));
                this.expr(exp, -1);
                method.visitFieldInsn(181, classNode.name, field, Signature.type(AST.$getType(def)));
            }
        }

        private void staticFieldInitializers(ClassNode classNode, MethodNode method, int parentLine) {
            for (String field : this.staticFieldInitializers.keySet()) {
                IConstructor def = this.staticFieldInitializers.get(field);
                IConstructor exp = (IConstructor)def.asWithKeywordParameters().getParameter("init");
                this.expr(exp, parentLine);
                method.visitFieldInsn(179, classNode.name, field, Signature.type(AST.$getType(def)));
            }
        }

        private void formalVariables(IList formals, boolean initialize) {
            int i = 0;
            for (IValue elem : formals) {
                int index = i;
                IConstructor var = (IConstructor)elem;
                IConstructor varType = AST.$getType(var);
                this.declareVariable(varType, AST.$getName(var), AST.$getDefault(var), initialize, null, this.getLineNumber(var, -1));
                if (var.asWithKeywordParameters().hasParameter("annotations")) {
                    this.annotation((String s, Boolean v) -> this.method.visitParameterAnnotation(index, s, v.booleanValue()), (IValue)((IList)var.asWithKeywordParameters().getParameter("annotations")));
                }
                ++i;
            }
        }

        private void computeDefaultValueForVariable(IConstructor type, int pos) {
            Switch.type(type, pos, (z, j) -> {
                this.method.visitInsn(3);
                this.method.visitVarInsn(54, j.intValue());
            }, (ii, j) -> {
                this.method.visitInsn(3);
                this.method.visitVarInsn(54, j.intValue());
            }, (s, j) -> {
                this.method.visitInsn(3);
                this.method.visitVarInsn(54, j.intValue());
            }, (b, j) -> {
                this.method.visitInsn(3);
                this.method.visitVarInsn(54, j.intValue());
            }, (c, j) -> {
                this.method.visitInsn(3);
                this.method.visitVarInsn(54, j.intValue());
            }, (f, j) -> {
                this.method.visitInsn(11);
                this.method.visitVarInsn(56, j.intValue());
            }, (d, j) -> {
                this.method.visitInsn(14);
                this.method.visitVarInsn(57, j.intValue());
            }, (l, j) -> {
                this.method.visitInsn(9);
                this.method.visitVarInsn(55, j.intValue());
            }, (v, j) -> {
                throw new IllegalArgumentException("void variable");
            }, (c, j) -> {
                this.method.visitInsn(1);
                this.method.visitVarInsn(58, j.intValue());
            }, (a, j) -> {
                this.method.visitInsn(1);
                this.method.visitVarInsn(58, j.intValue());
            }, (S, j) -> {
                this.stringConstant("");
                this.method.visitVarInsn(58, j.intValue());
            });
        }

        private IConstructor statements(IList statements, LeveledLabel continueLabel, LeveledLabel breakLabel, LeveledLabel joinLabel, int parentLine) {
            int i = 0;
            int len = statements.length();
            for (IValue elem : statements) {
                LeveledLabel nextLabel = ++i < len ? this.newLabel() : joinLabel;
                this.statement((IConstructor)elem, continueLabel, breakLabel, nextLabel, parentLine);
                if (i >= len) continue;
                this.method.visitLabel((Label)nextLabel);
            }
            return null;
        }

        private void statement(IConstructor stat, LeveledLabel continueLabel, LeveledLabel breakLabel, LeveledLabel joinLabel, int parentLine) {
            int line = this.getLineNumber(stat, parentLine);
            switch (stat.getConstructorType().getName()) {
                case "incr": {
                    this.incStat(AST.$getName(stat), AST.$getInc(stat));
                    break;
                }
                case "invokeSuper": {
                    this.invokeSuper(this.classNode.superName, AST.$getDesc(stat), AST.$getArgs(stat), line);
                    break;
                }
                case "decl": {
                    this.declStat(stat, joinLabel, line);
                    break;
                }
                case "block": {
                    String blockLabel = stat.asWithKeywordParameters().hasParameter("label") ? ((IString)stat.asWithKeywordParameters().getParameter("label")).getValue() : null;
                    this.blockStat(blockLabel, AST.$getBlock(stat), joinLabel, line);
                    break;
                }
                case "do": {
                    this.doStat((IConstructor)stat.get("exp"), line);
                    break;
                }
                case "store": {
                    this.storeStat(AST.$getName(stat), AST.$getValue(stat), line);
                    break;
                }
                case "astore": {
                    this.aastoreStat(AST.$getArray(stat), AST.$getIndex(stat), AST.$getArg(stat), line);
                    break;
                }
                case "putField": {
                    this.putFieldStat(AST.$getRefClassFromType(AST.$getClass(stat), this.classNode.name), AST.$getReceiver(stat), AST.$getType(stat), AST.$getName(stat), AST.$getArg(stat), line);
                    break;
                }
                case "putStatic": {
                    this.putStaticStat(AST.$getRefClassFromType(AST.$getClass(stat), this.classNode.name), AST.$getType(stat), AST.$getName(stat), AST.$getArg(stat), line);
                    break;
                }
                case "return": {
                    this.returnStat(stat, line);
                    break;
                }
                case "break": {
                    this.breakStat(stat, breakLabel);
                    break;
                }
                case "continue": {
                    this.continueStat(stat, continueLabel);
                    break;
                }
                case "if": {
                    if (stat.getConstructorType().getArity() == 3) {
                        this.ifThenElseStat(AST.$getCondition(stat), AST.$getThenBlock(stat), AST.$getElseBlock(stat), continueLabel, breakLabel, joinLabel, line);
                        break;
                    }
                    assert (stat.getConstructorType().getArity() == 2);
                    this.ifStat(AST.$getCondition(stat), AST.$getThenBlock(stat), continueLabel, breakLabel, joinLabel, line);
                    break;
                }
                case "for": {
                    String forLabel = stat.asWithKeywordParameters().hasParameter("label") ? ((IString)stat.asWithKeywordParameters().getParameter("label")).getValue() : null;
                    this.forStat(forLabel, AST.$getInit(stat), AST.$getCondition(stat), AST.$getNext(stat), AST.$getStatements(stat), continueLabel, breakLabel, joinLabel, line);
                    break;
                }
                case "while": {
                    String whileLabel = stat.asWithKeywordParameters().hasParameter("label") ? ((IString)stat.asWithKeywordParameters().getParameter("label")).getValue() : null;
                    this.whileStat(whileLabel, AST.$getCondition(stat), AST.$getBlock(stat), continueLabel, breakLabel, joinLabel, line);
                    break;
                }
                case "doWhile": {
                    String doWhileLabel = stat.asWithKeywordParameters().hasParameter("label") ? ((IString)stat.asWithKeywordParameters().getParameter("label")).getValue() : null;
                    this.doWhileStat(doWhileLabel, AST.$getCondition(stat), AST.$getBlock(stat), continueLabel, breakLabel, joinLabel, line);
                    break;
                }
                case "throw": {
                    this.throwStat(AST.$getArg(stat), line);
                    break;
                }
                case "monitor": {
                    this.monitorStat(AST.$getArg(stat), AST.$getBlock(stat), continueLabel, breakLabel, joinLabel, line);
                    break;
                }
                case "acquire": {
                    this.acquireStat(AST.$getArg(stat), line);
                    break;
                }
                case "release": {
                    this.releaseStat(AST.$getArg(stat), line);
                    break;
                }
                case "try": {
                    this.tryStat(AST.$getBlock(stat), AST.$getCatch(stat), continueLabel, breakLabel, joinLabel, line);
                    break;
                }
                case "switch": {
                    String option = stat.asWithKeywordParameters().hasParameter("option") ? ((IConstructor)stat.asWithKeywordParameters().getParameter("option")).getConstructorType().getName() : "lookup";
                    this.switchStat(option, AST.$getArg(stat), AST.$getCases(stat), continueLabel, breakLabel, joinLabel, line);
                    break;
                }
                case "asm": {
                    this.instructions(AST.$getInstructions(stat), continueLabel, breakLabel, joinLabel, line);
                }
            }
        }

        private void instructions(IList instructions, LeveledLabel continueLabel, LeveledLabel breakLabel, LeveledLabel joinLabel, int parentLine) {
            for (IValue elem : instructions) {
                this.instruction((IConstructor)elem, continueLabel, breakLabel, joinLabel, parentLine);
            }
        }

        private void instruction(IConstructor instr, LeveledLabel continueLabel, LeveledLabel breakLabel, LeveledLabel joinLabel, int parentLine) {
            switch (instr.getName()) {
                case "exp": {
                    this.expr((IConstructor)instr.get("expression"), parentLine);
                    break;
                }
                case "stat": {
                    this.statement((IConstructor)instr.get("statement"), continueLabel, breakLabel, joinLabel, parentLine);
                    break;
                }
                case "NOP": {
                    this.simpleInstruction(0);
                    break;
                }
                case "ACONST_NULL": {
                    this.simpleInstruction(1);
                    break;
                }
                case "ICONST_M1": {
                    this.simpleInstruction(2);
                    break;
                }
                case "ICONST_0": {
                    this.simpleInstruction(3);
                    break;
                }
                case "ICONST_1": {
                    this.simpleInstruction(4);
                    break;
                }
                case "ICONST_2": {
                    this.simpleInstruction(5);
                    break;
                }
                case "ICONST_3": {
                    this.simpleInstruction(6);
                    break;
                }
                case "ICONST_4": {
                    this.simpleInstruction(7);
                    break;
                }
                case "ICONST_5": {
                    this.simpleInstruction(8);
                    break;
                }
                case "LCONST_0": {
                    this.simpleInstruction(9);
                    break;
                }
                case "LCONST_1": {
                    this.simpleInstruction(10);
                    break;
                }
                case "FCONST_0": {
                    this.simpleInstruction(11);
                    break;
                }
                case "FCONST_1": {
                    this.simpleInstruction(12);
                    break;
                }
                case "FCONST_2": {
                    this.simpleInstruction(13);
                    break;
                }
                case "DCONST_0": {
                    this.simpleInstruction(14);
                    break;
                }
                case "DCONST_1": {
                    this.simpleInstruction(15);
                    break;
                }
                case "IALOAD": {
                    this.simpleInstruction(46);
                    break;
                }
                case "LALOAD": {
                    this.simpleInstruction(47);
                    break;
                }
                case "FALOAD": {
                    this.simpleInstruction(48);
                    break;
                }
                case "DALOAD": {
                    this.simpleInstruction(49);
                    break;
                }
                case "AALOAD": {
                    this.simpleInstruction(50);
                    break;
                }
                case "BALOAD": {
                    this.simpleInstruction(51);
                    break;
                }
                case "CALOAD": {
                    this.simpleInstruction(52);
                    break;
                }
                case "SALOAD": {
                    this.simpleInstruction(53);
                    break;
                }
                case "IASTORE": {
                    this.simpleInstruction(79);
                    break;
                }
                case "LASTORE": {
                    this.simpleInstruction(80);
                    break;
                }
                case "FASTORE": {
                    this.simpleInstruction(81);
                    break;
                }
                case "DASTORE": {
                    this.simpleInstruction(82);
                    break;
                }
                case "AASTORE": {
                    this.simpleInstruction(83);
                    break;
                }
                case "BASTORE": {
                    this.simpleInstruction(84);
                    break;
                }
                case "CASTORE": {
                    this.simpleInstruction(85);
                    break;
                }
                case "SASTORE": {
                    this.simpleInstruction(86);
                    break;
                }
                case "POP": {
                    this.simpleInstruction(87);
                    break;
                }
                case "POP2": {
                    this.simpleInstruction(88);
                    break;
                }
                case "DUP": {
                    this.simpleInstruction(89);
                    break;
                }
                case "DUP_X1": {
                    this.simpleInstruction(90);
                    break;
                }
                case "DUP_X2": {
                    this.simpleInstruction(91);
                    break;
                }
                case "DUP2": {
                    this.simpleInstruction(92);
                    break;
                }
                case "DUP2_X1": {
                    this.simpleInstruction(93);
                    break;
                }
                case "DUP2_X2": {
                    this.simpleInstruction(94);
                    break;
                }
                case "SWAP": {
                    this.simpleInstruction(95);
                    break;
                }
                case "IADD": {
                    this.simpleInstruction(96);
                    break;
                }
                case "LADD": {
                    this.simpleInstruction(97);
                    break;
                }
                case "FADD": {
                    this.simpleInstruction(98);
                    break;
                }
                case "DADD": {
                    this.simpleInstruction(99);
                    break;
                }
                case "ISUB": {
                    this.simpleInstruction(100);
                    break;
                }
                case "LSUB": {
                    this.simpleInstruction(101);
                    break;
                }
                case "FSUB": {
                    this.simpleInstruction(102);
                    break;
                }
                case "DSUB": {
                    this.simpleInstruction(103);
                    break;
                }
                case "IMUL": {
                    this.simpleInstruction(104);
                    break;
                }
                case "LMUL": {
                    this.simpleInstruction(105);
                    break;
                }
                case "FMUL": {
                    this.simpleInstruction(106);
                    break;
                }
                case "DMUL": {
                    this.simpleInstruction(107);
                    break;
                }
                case "IDIV": {
                    this.simpleInstruction(108);
                    break;
                }
                case "LDIV": {
                    this.simpleInstruction(109);
                    break;
                }
                case "FDIV": {
                    this.simpleInstruction(110);
                    break;
                }
                case "DDIV": {
                    this.simpleInstruction(111);
                    break;
                }
                case "IREM": {
                    this.simpleInstruction(112);
                    break;
                }
                case "LREM": {
                    this.simpleInstruction(113);
                    break;
                }
                case "FREM": {
                    this.simpleInstruction(114);
                    break;
                }
                case "DREM": {
                    this.simpleInstruction(115);
                    break;
                }
                case "INEG": {
                    this.simpleInstruction(116);
                    break;
                }
                case "LNEG": {
                    this.simpleInstruction(117);
                    break;
                }
                case "FNEG": {
                    this.simpleInstruction(118);
                    break;
                }
                case "DNEG": {
                    this.simpleInstruction(119);
                    break;
                }
                case "ISHL": {
                    this.simpleInstruction(120);
                    break;
                }
                case "LSHL": {
                    this.simpleInstruction(121);
                    break;
                }
                case "ISHR": {
                    this.simpleInstruction(122);
                    break;
                }
                case "LSHR": {
                    this.simpleInstruction(123);
                    break;
                }
                case "IUSHR": {
                    this.simpleInstruction(124);
                    break;
                }
                case "LUSHR": {
                    this.simpleInstruction(125);
                    break;
                }
                case "IAND": {
                    this.simpleInstruction(126);
                    break;
                }
                case "LAND": {
                    this.simpleInstruction(127);
                    break;
                }
                case "IOR": {
                    this.simpleInstruction(128);
                    break;
                }
                case "LOR": {
                    this.simpleInstruction(129);
                    break;
                }
                case "IXOR": {
                    this.simpleInstruction(130);
                    break;
                }
                case "LXOR": {
                    this.simpleInstruction(131);
                    break;
                }
                case "I2L": {
                    this.simpleInstruction(133);
                    break;
                }
                case "I2F": {
                    this.simpleInstruction(134);
                    break;
                }
                case "I2D": {
                    this.simpleInstruction(135);
                    break;
                }
                case "L2I": {
                    this.simpleInstruction(136);
                    break;
                }
                case "L2F": {
                    this.simpleInstruction(137);
                    break;
                }
                case "L2D": {
                    this.simpleInstruction(138);
                    break;
                }
                case "F2I": {
                    this.simpleInstruction(139);
                    break;
                }
                case "F2L": {
                    this.simpleInstruction(140);
                    break;
                }
                case "F2D": {
                    this.simpleInstruction(141);
                    break;
                }
                case "D2I": {
                    this.simpleInstruction(142);
                    break;
                }
                case "D2L": {
                    this.simpleInstruction(143);
                    break;
                }
                case "D2F": {
                    this.simpleInstruction(144);
                    break;
                }
                case "I2B": {
                    this.simpleInstruction(145);
                    break;
                }
                case "I2C": {
                    this.simpleInstruction(146);
                    break;
                }
                case "I2S": {
                    this.simpleInstruction(147);
                    break;
                }
                case "LCMP": {
                    this.simpleInstruction(148);
                    break;
                }
                case "FCMPL": {
                    this.simpleInstruction(149);
                    break;
                }
                case "FCMPG": {
                    this.simpleInstruction(150);
                    break;
                }
                case "DCMPL": {
                    this.simpleInstruction(151);
                    break;
                }
                case "DCMPG": {
                    this.simpleInstruction(152);
                    break;
                }
                case "IRETURN": {
                    this.simpleInstruction(172);
                    break;
                }
                case "LRETURN": {
                    this.simpleInstruction(173);
                    break;
                }
                case "FRETURN": {
                    this.simpleInstruction(174);
                    break;
                }
                case "DRETURN": {
                    this.simpleInstruction(175);
                    break;
                }
                case "ARETURN": {
                    this.simpleInstruction(176);
                    break;
                }
                case "RETURN": {
                    this.simpleInstruction(177);
                    break;
                }
                case "ARRAYLENGTH": {
                    this.simpleInstruction(190);
                    break;
                }
                case "ATHROW": {
                    this.simpleInstruction(191);
                    break;
                }
                case "MONITORENTER": {
                    this.simpleInstruction(194);
                    break;
                }
                case "MONITOREXIT": {
                    this.simpleInstruction(195);
                    break;
                }
                case "ILOAD": {
                    this.varInstruction(21, instr);
                    break;
                }
                case "LLOAD": {
                    this.varInstruction(22, instr);
                    break;
                }
                case "FLOAD": {
                    this.varInstruction(23, instr);
                    break;
                }
                case "DLOAD": {
                    this.varInstruction(24, instr);
                    break;
                }
                case "ALOAD": {
                    this.varInstruction(25, instr);
                    break;
                }
                case "ISTORE": {
                    this.varInstruction(54, instr);
                    break;
                }
                case "LSTORE": {
                    this.varInstruction(55, instr);
                    break;
                }
                case "FSTORE": {
                    this.varInstruction(56, instr);
                    break;
                }
                case "DSTORE": {
                    this.varInstruction(57, instr);
                    break;
                }
                case "ASTORE": {
                    this.varInstruction(58, instr);
                    break;
                }
                case "RET": {
                    this.varInstruction(169, instr);
                    break;
                }
                case "BIPUSH": {
                    this.intInstruction(16, instr);
                    break;
                }
                case "SIPUSH": {
                    this.intInstruction(17, instr);
                    break;
                }
                case "NEWARRAY": {
                    this.newArrayInstruction(instr, parentLine);
                    break;
                }
                case "LDC": {
                    this.loadConstantInstruction(instr, parentLine);
                    break;
                }
                case "IINC": {
                    this.iIncInstruction(instr);
                    break;
                }
                case "LABEL": {
                    this.labelInstruction(instr);
                    break;
                }
                case "LINENUMBER": {
                    this.lineNumberInstruction(instr);
                    break;
                }
                case "IFEQ": {
                    this.jumpInstruction(instr, 153);
                    break;
                }
                case "IFNE": {
                    this.jumpInstruction(instr, 154);
                    break;
                }
                case "IFLT": {
                    this.jumpInstruction(instr, 155);
                    break;
                }
                case "IFGE": {
                    this.jumpInstruction(instr, 156);
                    break;
                }
                case "IFGT": {
                    this.jumpInstruction(instr, 157);
                    break;
                }
                case "IFLE": {
                    this.jumpInstruction(instr, 158);
                    break;
                }
                case "IF_ICMPEQ": {
                    this.jumpInstruction(instr, 159);
                    break;
                }
                case "IF_ICMPNE": {
                    this.jumpInstruction(instr, 160);
                    break;
                }
                case "IF_ICMPLT": {
                    this.jumpInstruction(instr, 161);
                    break;
                }
                case "IF_ICMPGE": {
                    this.jumpInstruction(instr, 162);
                    break;
                }
                case "IF_ICMPGT": {
                    this.jumpInstruction(instr, 163);
                    break;
                }
                case "IF_ICMPLE": {
                    this.jumpInstruction(instr, 164);
                    break;
                }
                case "IF_ACMPEQ": {
                    this.jumpInstruction(instr, 165);
                    break;
                }
                case "IF_ACMPNE": {
                    this.jumpInstruction(instr, 166);
                    break;
                }
                case "GOTO": {
                    this.jumpInstruction(instr, 167);
                    break;
                }
                case "JSR": {
                    this.jumpInstruction(instr, 168);
                    break;
                }
                case "IFNULL": {
                    this.jumpInstruction(instr, 198);
                    break;
                }
                case "IFNONNULL": {
                    this.jumpInstruction(instr, 199);
                    break;
                }
                case "TABLESWITCH": {
                    this.tableSwitchInstruction(instr);
                    break;
                }
                case "LOOKUPSWITCH": {
                    this.lookupSwitchInstruction(instr);
                    break;
                }
                case "GETSTATIC": {
                    this.fieldInstruction(178, instr);
                    break;
                }
                case "PUTSTATIC": {
                    this.fieldInstruction(179, instr);
                    break;
                }
                case "GETFIELD": {
                    this.fieldInstruction(180, instr);
                    break;
                }
                case "PUTFIELD": {
                    this.fieldInstruction(181, instr);
                    break;
                }
                case "INVOKEVIRTUAL": {
                    this.methodInstruction(182, instr);
                    break;
                }
                case "INVOKESPECIAL": {
                    this.methodInstruction(183, instr);
                    break;
                }
                case "INVOKESTATIC": {
                    this.methodInstruction(184, instr);
                    break;
                }
                case "INVOKEINTERFACE": {
                    this.methodInstruction(185, instr);
                    break;
                }
                case "NEW": {
                    this.typeInstruction(187, instr);
                    break;
                }
                case "ANEWARRAY": {
                    this.typeInstruction(189, instr);
                    break;
                }
                case "CHECKCAST": {
                    this.typeInstruction(192, instr);
                    break;
                }
                case "INSTANCEOF": {
                    this.typeInstruction(193, instr);
                    break;
                }
                case "MULTIANEWARRAY": {
                    this.multiNewArrayInstruction(instr);
                    break;
                }
                case "INVOKEDYNAMIC": {
                    this.invokeDynamicInstruction(instr);
                    break;
                }
                case "LOCALVARIABLE": {
                    this.localVariableInstruction(instr);
                }
            }
        }

        private void localVariableInstruction(IConstructor instr) {
            String name = AST.$getName(instr);
            String desc = Signature.type(AST.$getType(instr));
            Label start = this.getOrCreateAsmLabel(((IString)instr.get("start")).getValue());
            Label end = this.getOrCreateAsmLabel(((IString)instr.get("end")).getValue());
            int var = ((IInteger)instr.get("var")).intValue();
            this.method.visitLocalVariable(name, desc, null, start, end, var);
        }

        private void newArrayInstruction(IConstructor instr, int parentLine) {
            this.newArrayWithSizeOnStack(AST.$getType(instr), parentLine);
        }

        private void loadConstantInstruction(IConstructor instr, int parentLine) {
            this.constExp(AST.$getType(instr), AST.$getConstant(instr), parentLine);
        }

        private void iIncInstruction(IConstructor instr) {
            this.method.visitIincInsn(AST.$getVar(instr), AST.$getInc(instr));
        }

        private void labelInstruction(IConstructor instr) {
            Label l = this.getOrCreateAsmLabel(AST.$getLabel(instr));
            this.method.visitLabel(l);
        }

        private void lineNumberInstruction(IConstructor instr) {
            Label start = this.getOrCreateAsmLabel(AST.$getLabel(instr));
            this.method.visitLineNumber(AST.$getLine(instr), start);
        }

        private void invokeDynamicInstruction(IConstructor instr) {
            IConstructor handle = AST.$getHandle(instr);
            IConstructor dynDesc = AST.$getDesc(instr);
            this.method.visitInvokeDynamicInsn(AST.$getName(dynDesc), Signature.method(dynDesc), this.bootstrapHandler(handle), this.bootstrapArgs(handle));
        }

        private void multiNewArrayInstruction(IConstructor instr) {
            this.method.visitMultiANewArrayInsn(AST.$getRefClassFromType(AST.$getClass(instr), this.classNode.name), AST.$getNumDimensions(instr));
        }

        private void typeInstruction(int opcode, IConstructor instr) {
            this.method.visitTypeInsn(opcode, Signature.type(AST.$getType(instr)));
        }

        private void methodInstruction(int opcode, IConstructor instr) {
            IConstructor cls = AST.$getClass(instr);
            IConstructor desc = AST.$getDesc(instr);
            switch (desc.getName()) {
                case "constructorDesc": {
                    this.method.visitMethodInsn(opcode, AST.$getRefClassFromType(cls, this.classNode.name), "<init>", Signature.constructor(desc), false);
                    break;
                }
                case "methodDesc": {
                    this.method.visitMethodInsn(opcode, AST.$getRefClassFromType(cls, this.classNode.name), AST.$getName(desc), Signature.method(desc), AST.$getIsInterface(instr));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown method kind: " + String.valueOf(instr));
                }
            }
        }

        private void fieldInstruction(int opcode, IConstructor instr) {
            IConstructor cls = AST.$getClass(instr);
            IConstructor type = AST.$getType(instr);
            this.method.visitFieldInsn(opcode, AST.$getRefClassFromType(cls, this.classNode.name), AST.$getName(instr), Signature.type(type));
        }

        private void lookupSwitchInstruction(IConstructor instr) {
            IList lucases = AST.$getCaseLabels(instr);
            IList lukeys = AST.$getCaseKeys(instr);
            Label[] lulabels = new Label[lucases.length()];
            int[] keys = new int[lucases.length()];
            for (int i = 0; i < lulabels.length; ++i) {
                lulabels[i] = this.getOrCreateAsmLabel(((IString)lucases.get(i)).getValue());
                keys[i] = ((IInteger)lukeys.get(i)).intValue();
            }
            this.method.visitLookupSwitchInsn(this.getOrCreateAsmLabel(AST.$getDefaultLabel(instr)), keys, lulabels);
        }

        private void tableSwitchInstruction(IConstructor instr) {
            IList cases = AST.$getCaseLabels(instr);
            Label[] labels = new Label[cases.length()];
            for (int i = 0; i < labels.length; ++i) {
                labels[i] = this.getOrCreateAsmLabel(((IString)cases.get(i)).getValue());
            }
            this.method.visitTableSwitchInsn(AST.$getMin(instr), AST.$getMax(instr), this.getOrCreateAsmLabel(AST.$getDefaultLabel(instr)), labels);
        }

        private void simpleInstruction(int opcode) {
            this.method.visitInsn(opcode);
        }

        private void intInstruction(int opcode, IConstructor instr) {
            this.method.visitIntInsn(opcode, AST.$getIntVal(instr));
        }

        private void varInstruction(int opcode, IConstructor instr) {
            this.method.visitVarInsn(opcode, AST.$getVar(instr));
        }

        private void jumpInstruction(IConstructor instr, int opcode) {
            this.method.visitJumpInsn(opcode, this.getOrCreateAsmLabel(AST.$getLabel(instr)));
        }

        private Label getOrCreateAsmLabel(String label) {
            Label result = this.asmLabels.get(label);
            if (result == null) {
                result = new Label();
                this.asmLabels.put(label, result);
            }
            return result;
        }

        private void releaseStat(IConstructor arg, int parentLine) {
            this.expr(arg, parentLine);
            this.method.visitInsn(195);
        }

        private void acquireStat(IConstructor arg, int parentLine) {
            this.expr(arg, parentLine);
            this.method.visitInsn(194);
        }

        private void switchStat(String option, IConstructor arg, IList cases, LeveledLabel continueLabel, LeveledLabel breakLabel, LeveledLabel joinLabel, int line) {
            switch (option) {
                case "table": {
                    this.tableSwitch(arg, cases, continueLabel, joinLabel, line);
                    return;
                }
                case "lookup": {
                    this.lookupSwitch(arg, cases, continueLabel, joinLabel, line);
                    return;
                }
                case "auto": {
                    this.autoSwitch(arg, cases, continueLabel, joinLabel, line);
                    return;
                }
            }
            this.lookupSwitch(arg, cases, continueLabel, joinLabel, line);
        }

        private void autoSwitch(IConstructor arg, IList cases, LeveledLabel continueLabel, LeveledLabel joinLabel, int line) {
            int max = Integer.MAX_VALUE;
            int min = Integer.MIN_VALUE;
            long labelCount = 0L;
            for (int i = 0; i < cases.length(); ++i) {
                IConstructor c = (IConstructor)cases.get(i);
                boolean isDefault = AST.$is("default", c);
                if (isDefault) continue;
                int key = AST.$getKey(c);
                min = Math.min(key, min);
                max = Math.max(key, max);
                ++labelCount;
            }
            long tableSpaceCost = 4L + (long)(max - min + 1);
            long tableTimeCost = 3L;
            long lookupSpaceCost = 3L + 2L * labelCount;
            long lookupTimeCost = labelCount;
            long tableCost = tableSpaceCost + 3L * tableTimeCost;
            long lookupCost = lookupSpaceCost + 3L * lookupTimeCost;
            if (labelCount > 0L && tableCost <= lookupCost) {
                this.tableSwitch(arg, cases, continueLabel, joinLabel, line);
            } else {
                this.lookupSwitch(arg, cases, continueLabel, joinLabel, line);
            }
        }

        private void lookupSwitch(IConstructor arg, IList cases, LeveledLabel continueLabel, LeveledLabel joinLabel, int line) {
            ArrayList<CaseLabel> labels = new ArrayList<CaseLabel>();
            Label defaultLabel = new Label();
            boolean hasDef = false;
            for (int i = 0; i < cases.length(); ++i) {
                IConstructor c = (IConstructor)cases.get(i);
                if (AST.$is("default", c)) {
                    defaultLabel = new Label();
                    hasDef = true;
                    if (i == cases.length() - 1) continue;
                    throw new IllegalArgumentException("default handler should be the last of the cases");
                }
                labels.add(new CaseLabel(AST.$getKey(c)));
            }
            this.expr(arg, line);
            ArrayList sorted = (ArrayList)labels.clone();
            sorted.sort((a, b) -> Integer.compare(a.key, b.key));
            int[] keyArray = sorted.stream().mapToInt(l -> l.key).toArray();
            Label[] labelArray = sorted.toArray(new Label[0]);
            this.method.visitLookupSwitchInsn(defaultLabel, keyArray, labelArray);
            for (int i = 0; i < cases.length(); ++i) {
                IConstructor c = (IConstructor)cases.get(i);
                boolean isDef = AST.$is("default", c);
                if (isDef) {
                    this.method.visitLabel(defaultLabel);
                } else {
                    this.method.visitLabel((Label)labels.get(i));
                }
                LeveledLabel endCase = this.newLabel();
                this.statements(AST.$getBlock(c), continueLabel, joinLabel, endCase, this.getLineNumber(c, line));
                this.method.visitLabel((Label)endCase);
            }
            if (!hasDef) {
                this.method.visitLabel(defaultLabel);
            }
        }

        private void tableSwitch(IConstructor arg, IList cases, LeveledLabel continueLabel, LeveledLabel joinLabel, int line) {
            int i;
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            boolean hasDefault = false;
            for (int i2 = 0; i2 < cases.length(); ++i2) {
                IConstructor c = (IConstructor)cases.get(i2);
                boolean isLast = i2 == cases.length() - 1;
                boolean isDefault = AST.$is("default", c);
                if (!isDefault) {
                    int key = AST.$getKey(c);
                    min = Math.min(key, min);
                    max = Math.max(key, max);
                    continue;
                }
                hasDefault = true;
                if (isLast) continue;
                throw new IllegalArgumentException("default handler should be the last of the cases");
            }
            LeveledLabel defaultLabel = hasDefault ? this.newLabel() : joinLabel;
            Label[] labels = new LeveledLabel[max - min + 1];
            for (i = 0; i < labels.length; ++i) {
                labels[i] = defaultLabel;
            }
            for (int j = 0; j < cases.length(); ++j) {
                IConstructor c = (IConstructor)cases.get(j);
                if (AST.$is("default", c)) continue;
                labels[AST.$getKey((IConstructor)c) - min] = this.newLabel();
            }
            this.expr(arg, line);
            this.method.visitTableSwitchInsn(min, max, (Label)defaultLabel, labels);
            for (i = 0; i < cases.length(); ++i) {
                IConstructor c = (IConstructor)cases.get(i);
                boolean isDef = AST.$is("default", c);
                if (isDef) {
                    this.method.visitLabel((Label)defaultLabel);
                } else {
                    this.method.visitLabel(labels[AST.$getKey(c) - min]);
                }
                LeveledLabel endCase = this.newLabel();
                this.statements(AST.$getBlock(c), continueLabel, joinLabel, endCase, this.getLineNumber(c, line));
                this.method.visitLabel((Label)endCase);
            }
        }

        private void incStat(String name, int inc) {
            this.method.visitIincInsn(this.positionOf(name), inc);
        }

        private void tryStat(IList block, IList catches, LeveledLabel continueLabel, LeveledLabel breakLabel, LeveledLabel joinLabel, int line) {
            boolean isLast;
            boolean isFinally;
            IConstructor catcher;
            int i;
            if (block.length() == 0) {
                return;
            }
            LeveledLabel tryStart = this.newLabel();
            LeveledLabel tryEnd = this.newLabel();
            LeveledLabel[] handlers = new LeveledLabel[catches.length()];
            String finallyVarName = null;
            Builder<IConstructor> finallyCode = null;
            for (i = 0; i < catches.length(); ++i) {
                catcher = (IConstructor)catches.get(i);
                isFinally = AST.$is("finally", catcher);
                isLast = i == catches.length() - 1;
                handlers[i] = this.newLabel();
                if (isLast && isFinally) {
                    finallyVarName = "finally:" + String.valueOf(UUID.randomUUID());
                    this.declareVariable(Types.throwableType(), finallyVarName, null, false, null, line);
                    finallyCode = () -> this.statements(AST.$getBlock(catcher), breakLabel, continueLabel, joinLabel, line);
                    this.pushFinally(finallyCode);
                    continue;
                }
                if (isFinally) {
                    throw new IllegalArgumentException("finally block should be the last handler");
                }
                IConstructor exceptionType = AST.$getType(catcher);
                String varName = AST.$getName(catcher);
                this.declareVariable(exceptionType, varName, null, false, null, line);
            }
            this.method.visitLabel((Label)tryStart);
            this.statements(block, continueLabel, breakLabel, joinLabel, line);
            this.method.visitLabel((Label)tryEnd);
            this.method.visitJumpInsn(167, (Label)joinLabel);
            for (i = 0; i < catches.length(); ++i) {
                catcher = (IConstructor)catches.get(i);
                isFinally = AST.$is("finally", catcher);
                boolean bl = isLast = i == catches.length() - 1;
                if (isLast && isFinally) {
                    this.method.visitLabel((Label)handlers[i]);
                    finallyCode.build();
                    this.popFinally();
                    continue;
                }
                this.method.visitLabel((Label)handlers[i]);
                String varName = AST.$getName(catcher);
                IConstructor exceptionType = AST.$getType(catcher);
                String clsName = AST.$getRefClassFromType(exceptionType, this.classNode.name);
                this.method.visitVarInsn(58, this.positionOf(varName));
                this.statements(AST.$getBlock(catcher), continueLabel, breakLabel, joinLabel, this.getLineNumber(catcher, line));
                this.method.visitTryCatchBlock((Label)tryStart, (Label)tryEnd, (Label)handlers[i], clsName);
                if (isLast) continue;
                this.method.visitJumpInsn(167, (Label)joinLabel);
            }
        }

        private Builder<IConstructor> popFinally() {
            return this.tryFinallyNestingLevel.remove(this.tryFinallyNestingLevel.size() - 1);
        }

        private boolean pushFinally(Builder<IConstructor> finallyCode) {
            return this.tryFinallyNestingLevel.add(finallyCode);
        }

        private void monitorStat(IConstructor lock, IList block, LeveledLabel continueLabel, LeveledLabel breakLabel, LeveledLabel joinLabel, int line) {
            if (block.isEmpty()) {
                return;
            }
            LeveledLabel startExceptionBlock = this.newLabel();
            LeveledLabel endExceptionBlock = this.newLabel();
            LeveledLabel handlerStart = this.newLabel();
            LeveledLabel handlerEnd = this.newLabel();
            this.method.visitTryCatchBlock((Label)startExceptionBlock, (Label)endExceptionBlock, (Label)handlerStart, null);
            this.method.visitTryCatchBlock((Label)handlerStart, (Label)handlerEnd, (Label)handlerStart, null);
            String lockVarName = "$lock:" + UUID.randomUUID().toString();
            Builder<IConstructor> finallyCode = () -> {
                this.lineNumber(line);
                this.method.visitVarInsn(25, this.positionOf(lockVarName));
                this.method.visitInsn(195);
                return null;
            };
            IConstructor type = this.expr(lock, line);
            this.declareVariable(type, lockVarName, null, false, null, this.getLineNumber(lock, line));
            this.dup();
            this.method.visitVarInsn(58, this.positionOf(lockVarName));
            this.method.visitInsn(194);
            this.method.visitLabel((Label)startExceptionBlock);
            this.pushFinally(finallyCode);
            this.statements(block, continueLabel, breakLabel, endExceptionBlock, line);
            this.popFinally();
            this.method.visitVarInsn(25, this.positionOf(lockVarName));
            this.method.visitInsn(195);
            this.method.visitLabel((Label)endExceptionBlock);
            this.method.visitJumpInsn(167, (Label)joinLabel);
            this.method.visitLabel((Label)handlerStart);
            this.method.visitVarInsn(25, this.positionOf(lockVarName));
            this.method.visitInsn(195);
            this.method.visitLabel((Label)handlerEnd);
            this.method.visitInsn(191);
        }

        private void throwStat(IConstructor arg, int parentLine) {
            this.expr(arg, parentLine);
            this.method.visitInsn(191);
        }

        private void whileStat(String label, IConstructor cond, IList body, LeveledLabel continueLabel, LeveledLabel breakLabel, LeveledLabel joinLabel, int line) {
            LeveledLabel testConditional = this.newLabel();
            if (label != null) {
                this.labels.put("break:" + label, joinLabel);
                this.labels.put("continue:" + label, testConditional);
            }
            this.method.visitLabel((Label)testConditional);
            this.lineNumber(line, testConditional);
            int cmpCode = 153;
            if (cond.getConstructorType().getName().equals("neg")) {
                cond = this.expr(AST.$getArg(cond), line);
                cmpCode = 154;
            }
            this.expr(cond, line);
            this.invertedConditionalFlow(0, cmpCode, () -> this.statements(body, testConditional, joinLabel, testConditional, line), () -> this.jumpTo(joinLabel), testConditional, this.getLineNumber(cond, line));
            this.jumpTo(testConditional);
        }

        private void doWhileStat(String label, IConstructor cond, IList body, LeveledLabel continueLabel, LeveledLabel breakLabel, LeveledLabel joinLabel, int line) {
            LeveledLabel nextIteration = this.newLabel();
            if (label != null) {
                this.labels.put("break:" + label, joinLabel);
                this.labels.put("continue:" + label, nextIteration);
            }
            this.method.visitLabel((Label)nextIteration);
            this.statements(body, nextIteration, joinLabel, nextIteration, line);
            int cmpCode = 153;
            if (cond.getConstructorType().getName().equals("neg")) {
                cond = this.expr(AST.$getArg(cond), line);
                cmpCode = 154;
            }
            this.expr(cond, line);
            this.invertedConditionalFlow(0, cmpCode, () -> this.jumpTo(nextIteration), null, joinLabel, this.getLineNumber(cond, line));
        }

        private void breakStat(IConstructor stat, LeveledLabel join) {
            if (join == null) {
                throw new IllegalArgumentException("no loop to break from (or inside an expression or monitor block");
            }
            LeveledLabel target = join;
            if (stat.asWithKeywordParameters().hasParameter("label")) {
                String loopLabel = ((IString)stat.asWithKeywordParameters().getParameter("label")).getValue();
                target = this.getLabel(this.tryFinallyNestingLevel.size(), "break:" + loopLabel);
            }
            this.emitFinally(target.getFinallyNestingLevel());
            this.method.visitJumpInsn(167, (Label)target);
        }

        private void continueStat(IConstructor stat, LeveledLabel join) {
            if (join == null) {
                throw new IllegalArgumentException("no loop to continue with (or inside an expression or monitor block");
            }
            LeveledLabel target = join;
            if (stat.asWithKeywordParameters().hasParameter("label")) {
                String loopLabel = ((IString)stat.asWithKeywordParameters().getParameter("label")).getValue();
                target = this.getLabel(this.tryFinallyNestingLevel.size(), "continue:" + loopLabel);
            }
            this.emitFinally(target.getFinallyNestingLevel());
            this.method.visitJumpInsn(167, (Label)target);
        }

        private LeveledLabel getLabel(int level, String label) {
            LeveledLabel l = this.labels.get(label);
            if (l == null) {
                throw new IllegalArgumentException("unknown label: " + label);
            }
            return l;
        }

        private void blockStat(String label, IList body, LeveledLabel joinLabel, int line) {
            LeveledLabel again = this.newLabel();
            this.labels.put("break:" + label, joinLabel);
            this.labels.put("continue:" + label, again);
            if (label != null) {
                this.method.visitLabel(this.getOrCreateAsmLabel(label));
            }
            this.method.visitLabel((Label)again);
            this.statements(body, again, joinLabel, joinLabel, line);
        }

        private void declStat(IConstructor stat, LeveledLabel joinLabel, int line) {
            IConstructor def = null;
            IList annotations = null;
            IWithKeywordParameters kws = stat.asWithKeywordParameters();
            if (kws.hasParameter("init")) {
                def = (IConstructor)kws.getParameter("init");
            }
            if (kws.hasParameter("annotations")) {
                annotations = (IList)kws.getParameter("annotations");
            }
            this.declareVariable(AST.$getType(stat), AST.$getName(stat), def, true, annotations, this.getLineNumber(stat, line));
        }

        private void forStat(String label, IList init, IConstructor cond, IList next, IList body, LeveledLabel continueLabel, LeveledLabel breakLabel, LeveledLabel joinLabel, int line) {
            LeveledLabel testConditional = this.newLabel();
            LeveledLabel nextIterationLabel = this.newLabel();
            if (label != null) {
                this.labels.put("break:" + label, joinLabel);
                this.labels.put("continue:" + label, nextIterationLabel);
            }
            this.statements(init, continueLabel, breakLabel, testConditional, line);
            this.method.visitLabel((Label)testConditional);
            int cmpCode = 153;
            if (cond.getConstructorType().getName().equals("neg")) {
                cond = this.expr(AST.$getArg(cond), line);
                cmpCode = 154;
            }
            this.expr(cond, line);
            this.invertedConditionalFlow(0, cmpCode, () -> this.statements(body, nextIterationLabel, joinLabel, nextIterationLabel, line), () -> this.jumpTo(joinLabel), nextIterationLabel, this.getLineNumber(cond, line));
            this.method.visitLabel((Label)nextIterationLabel);
            LeveledLabel endNext = this.newLabel();
            this.statements(next, continueLabel, breakLabel, endNext, line);
            this.method.visitLabel((Label)endNext);
            this.jumpTo(testConditional);
        }

        private IConstructor jumpTo(Label join) {
            this.method.visitJumpInsn(167, join);
            return null;
        }

        private void ifStat(IConstructor cond, IList thenBlock, LeveledLabel continueLabel, LeveledLabel breakLabel, LeveledLabel joinLabel, int line) {
            this.ifThenElseStat(cond, thenBlock, null, continueLabel, breakLabel, joinLabel, line);
        }

        private void ifThenElseStat(IConstructor cond, IList thenBlock, IList elseBlock, LeveledLabel continueLabel, LeveledLabel breakLabel, LeveledLabel joinLabel, int line) {
            Builder<IConstructor> thenBuilder = () -> this.statements(thenBlock, continueLabel, breakLabel, joinLabel, line);
            Builder<IConstructor> elseBuilder = elseBlock != null ? () -> this.statements(elseBlock, continueLabel, breakLabel, joinLabel, line) : DONE;
            this.ifThenElse(cond, thenBuilder, elseBuilder, continueLabel, breakLabel, joinLabel, line);
        }

        private IConstructor ifThenElse(IConstructor cond, Builder<IConstructor> thenBuilder, Builder<IConstructor> elseBuilder, LeveledLabel continueLabel, LeveledLabel breakLabel, LeveledLabel joinLabel, int line) {
            switch (cond.getConstructorType().getName()) {
                case "true": {
                    return thenBuilder.build();
                }
                case "false": {
                    return elseBuilder.build();
                }
                case "eq": {
                    return this.eqExp(AST.$getLhs(cond), AST.$getRhs(cond), thenBuilder, elseBuilder, joinLabel, this.getLineNumber(cond, line));
                }
                case "ne": {
                    return this.neExp(AST.$getLhs(cond), AST.$getRhs(cond), thenBuilder, elseBuilder, joinLabel, this.getLineNumber(cond, line));
                }
                case "le": {
                    return this.leExp(AST.$getLhs(cond), AST.$getRhs(cond), thenBuilder, elseBuilder, joinLabel, this.getLineNumber(cond, line));
                }
                case "gt": {
                    return this.gtExp(AST.$getLhs(cond), AST.$getRhs(cond), thenBuilder, elseBuilder, joinLabel, this.getLineNumber(cond, line));
                }
                case "ge": {
                    return this.geExp(AST.$getLhs(cond), AST.$getRhs(cond), thenBuilder, elseBuilder, joinLabel, this.getLineNumber(cond, line));
                }
                case "lt": {
                    return this.ltExp(AST.$getLhs(cond), AST.$getRhs(cond), thenBuilder, elseBuilder, joinLabel, this.getLineNumber(cond, line));
                }
                case "neg": {
                    this.expr(AST.$getArg(cond), line);
                    return this.invertedConditionalFlow(0, 154, thenBuilder, elseBuilder, joinLabel, this.getLineNumber(cond, line));
                }
            }
            this.expr(cond, line);
            return this.invertedConditionalFlow(0, 153, thenBuilder, elseBuilder, joinLabel, this.getLineNumber(cond, line));
        }

        private void putStaticStat(String cls, IConstructor type, String name, IConstructor arg, int parentLine) {
            this.expr(arg, parentLine);
            this.method.visitFieldInsn(179, cls, name, Signature.type(type));
        }

        private void putFieldStat(String cls, IConstructor receiver, IConstructor type, String name, IConstructor arg, int parentLine) {
            this.expr(receiver, parentLine);
            this.expr(arg, parentLine);
            this.method.visitFieldInsn(181, cls, name, Signature.type(type));
        }

        private IConstructor storeStat(String name, IConstructor expression, int parentLine) {
            int pos = this.positionOf(name);
            this.expr(expression, parentLine);
            Switch.type0(this.variableTypes.get(pos), z -> this.method.visitVarInsn(54, pos), i -> this.method.visitVarInsn(54, pos), s -> this.method.visitVarInsn(54, pos), b -> this.method.visitVarInsn(54, pos), c -> this.method.visitVarInsn(54, pos), f -> this.method.visitVarInsn(56, pos), d -> this.method.visitVarInsn(57, pos), l -> this.method.visitVarInsn(55, pos), v -> {}, c -> this.method.visitVarInsn(58, pos), a -> this.method.visitVarInsn(58, pos), S -> this.method.visitVarInsn(58, pos));
            return null;
        }

        private void returnStat(IConstructor stat, int line) {
            if (stat.getConstructorType().getArity() == 0) {
                this.method.visitInsn(177);
            } else {
                IConstructor type = this.expr(AST.$getArg(stat), line);
                this.emitFinally(0);
                this.lineNumber(this.getLineNumber(stat, line));
                Switch.type0(type, z -> this.method.visitInsn(172), i -> this.method.visitInsn(172), s -> this.method.visitInsn(172), b -> this.method.visitInsn(172), c -> this.method.visitInsn(172), f -> this.method.visitInsn(174), d -> this.method.visitInsn(175), l -> this.method.visitInsn(173), v -> this.method.visitInsn(177), c -> this.method.visitInsn(176), a -> this.method.visitInsn(176), S -> this.method.visitInsn(176));
            }
        }

        private void emitFinally(int toLevel) {
            if (!this.emittingFinally) {
                this.emittingFinally = true;
                for (int i = this.tryFinallyNestingLevel.size() - 1; i >= 0 && i >= toLevel; --i) {
                    this.tryFinallyNestingLevel.get(i).build();
                }
                this.emittingFinally = false;
            }
        }

        private IConstructor doStat(IConstructor exp, int line) {
            IConstructor type = this.expr(exp, line);
            Switch.type0(type, z -> this.pop(), i -> this.pop(), s -> this.pop(), b -> this.pop(), c -> this.pop(), f -> this.pop(), d -> this.pop2(), j -> this.pop2(), v -> {}, c -> this.pop(), a -> this.pop(), S -> this.pop());
            return null;
        }

        private void pop() {
            this.method.visitInsn(87);
        }

        private void pop2() {
            this.method.visitInsn(88);
        }

        private IConstructor expr(IConstructor exp, int parentLine) {
            int line = this.getLineNumber(exp, parentLine);
            switch (exp.getConstructorType().getName()) {
                case "const": {
                    return this.constExp(AST.$getType(exp), AST.$getConstant(exp), line);
                }
                case "this": {
                    return this.loadExp("this", line);
                }
                case "newInstance": {
                    return this.newInstanceExp(exp, line);
                }
                case "newArray": {
                    return this.newArrayExp(AST.$getType(exp), AST.$getSize(exp), line);
                }
                case "newInitArray": {
                    return this.newArrayExp(AST.$getType(exp), AST.$getArgs(exp), line);
                }
                case "alength": {
                    return this.alengthExp(AST.$getArg(exp), line);
                }
                case "load": {
                    return this.loadExp(AST.$getName(exp), line);
                }
                case "aload": {
                    return this.aaloadExp(AST.$getArray(exp), AST.$getIndex(exp), line);
                }
                case "getStatic": {
                    return this.getstaticExp(AST.$getRefClassFromType(AST.$getClass(exp), this.classNode.name), AST.$getType(exp), AST.$getName(exp), line);
                }
                case "invokeVirtual": {
                    return this.invokeVirtualExp(AST.$getRefClassFromType(AST.$getClass(exp), this.classNode.name), AST.$getDesc(exp), AST.$getReceiver(exp), AST.$getArgs(exp), line);
                }
                case "invokeInterface": {
                    return this.invokeInterfaceExp(AST.$getRefClassFromType(AST.$getClass(exp), this.classNode.name), AST.$getDesc(exp), AST.$getReceiver(exp), AST.$getArgs(exp), line);
                }
                case "invokeSpecial": {
                    return this.invokeSpecialExp(AST.$getRefClassFromType(AST.$getClass(exp), this.classNode.name), AST.$getDesc(exp), AST.$getReceiver(exp), AST.$getArgs(exp), line);
                }
                case "invokeStatic": {
                    return this.invokeStaticExp(AST.$getRefClassFromType(AST.$getClass(exp), this.classNode.name), AST.$getDesc(exp), AST.$getArgs(exp), line);
                }
                case "invokeDynamic": {
                    return this.invokeDynamicExp(AST.$getHandle(exp), AST.$getDesc(exp), AST.$getArgs(exp), line);
                }
                case "getField": {
                    return this.getfieldExp(AST.$getReceiver(exp), AST.$getRefClassFromType(AST.$getClass(exp), this.classNode.name), AST.$getType(exp), AST.$getName(exp), line);
                }
                case "instanceof": {
                    return this.instanceofExp(AST.$getArg(exp), AST.$getRefClassFromType(exp, this.classNode.name), line);
                }
                case "sblock": {
                    return this.sblockExp(AST.$getStatements(exp), AST.$getArg(exp), line);
                }
                case "null": {
                    this.lineNumber(line);
                    return this.nullExp();
                }
                case "true": {
                    this.lineNumber(line);
                    return this.trueExp();
                }
                case "false": {
                    this.lineNumber(line);
                    return this.falseExp();
                }
                case "coerce": {
                    return this.coerceExp(AST.$getFrom(exp), AST.$getTo(exp), AST.$getArg(exp), line);
                }
                case "eq": {
                    this.eqExp(AST.$getLhs(exp), AST.$getRhs(exp), this.pushTrue, this.pushFalse, null, line);
                    return Types.booleanType();
                }
                case "ne": {
                    this.neExp(AST.$getLhs(exp), AST.$getRhs(exp), this.pushTrue, this.pushFalse, null, line);
                    return Types.booleanType();
                }
                case "le": {
                    this.leExp(AST.$getLhs(exp), AST.$getRhs(exp), this.pushTrue, this.pushFalse, null, line);
                    return Types.booleanType();
                }
                case "gt": {
                    this.gtExp(AST.$getLhs(exp), AST.$getRhs(exp), this.pushTrue, this.pushFalse, null, line);
                    return Types.booleanType();
                }
                case "ge": {
                    this.geExp(AST.$getLhs(exp), AST.$getRhs(exp), this.pushTrue, this.pushFalse, null, line);
                    return Types.booleanType();
                }
                case "lt": {
                    this.ltExp(AST.$getLhs(exp), AST.$getRhs(exp), this.pushTrue, this.pushFalse, null, line);
                    return Types.booleanType();
                }
                case "add": {
                    return this.addExp(AST.$getLhs(exp), AST.$getRhs(exp), line);
                }
                case "div": {
                    return this.divExp(AST.$getLhs(exp), AST.$getRhs(exp), line);
                }
                case "rem": {
                    return this.remExp(AST.$getLhs(exp), AST.$getRhs(exp), line);
                }
                case "sub": {
                    return this.subExp(AST.$getLhs(exp), AST.$getRhs(exp), line);
                }
                case "mul": {
                    return this.mulExp(AST.$getLhs(exp), AST.$getRhs(exp), line);
                }
                case "and": {
                    return this.andExp(AST.$getLhs(exp), AST.$getRhs(exp), line);
                }
                case "sand": {
                    return this.cond(AST.$getLhs(exp), AST.$getRhs(exp), this.falseExp(), line);
                }
                case "or": {
                    return this.orExp(AST.$getLhs(exp), AST.$getRhs(exp), line);
                }
                case "sor": {
                    return this.cond(AST.$getLhs(exp), this.trueExp(), AST.$getRhs(exp), line);
                }
                case "xor": {
                    return this.xorExp(AST.$getLhs(exp), AST.$getRhs(exp), line);
                }
                case "neg": {
                    return this.negExp(AST.$getArg(exp), line);
                }
                case "inc": {
                    return this.incExp(AST.$getName(exp), AST.$getInc(exp), line);
                }
                case "shr": {
                    return this.shrExp(AST.$getLhs(exp), AST.$getRhs(exp), line);
                }
                case "shl": {
                    return this.shlExp(AST.$getLhs(exp), AST.$getRhs(exp), line);
                }
                case "ushr": {
                    return this.ushrExp(AST.$getLhs(exp), AST.$getRhs(exp), line);
                }
                case "checkcast": {
                    return this.checkCastExp(AST.$getArg(exp), AST.$getType(exp), line);
                }
                case "cond": {
                    return this.cond(AST.$getCondition(exp), AST.$getThenExp(exp), AST.$getElseExp(exp), line);
                }
            }
            throw new IllegalArgumentException("unknown expression: " + String.valueOf(exp));
        }

        private IConstructor cond(IConstructor cond, IConstructor thenExp, IConstructor elseExp, int line) {
            LeveledLabel joinLabel = this.newLabel();
            IConstructor res = this.ifThenElse(cond, () -> this.expr(thenExp, line), () -> this.expr(elseExp, line), null, null, joinLabel, line);
            this.method.visitLabel((Label)joinLabel);
            return res;
        }

        private IConstructor shlExp(IConstructor lhs, IConstructor rhs, int line) {
            IConstructor type = this.prepareShiftArguments(lhs, rhs, line);
            this.lineNumber(line);
            Switch.type0(type, z -> this.method.visitInsn(120), i -> this.method.visitInsn(120), s -> this.method.visitInsn(120), b -> this.method.visitInsn(120), c -> this.method.visitInsn(120), f -> {
                throw new IllegalArgumentException("shl on void");
            }, d -> {
                throw new IllegalArgumentException("shl on void");
            }, l -> this.method.visitInsn(121), v -> {
                throw new IllegalArgumentException("shl on void");
            }, c -> {
                throw new IllegalArgumentException("shl on object");
            }, a -> {
                throw new IllegalArgumentException("shl on array");
            }, S -> {
                throw new IllegalArgumentException("shl on string");
            });
            return type;
        }

        private IConstructor prepareShiftArguments(IConstructor lhs, IConstructor rhs, int parentLine) {
            IConstructor type = this.expr(lhs, parentLine);
            if (this.expr(rhs, parentLine).getConstructorType() != Types.integerType().getConstructorType()) {
                throw new IllegalArgumentException("shift should get an integer as second parameter");
            }
            return type;
        }

        private IConstructor ushrExp(IConstructor lhs, IConstructor rhs, int line) {
            IConstructor type = this.prepareShiftArguments(lhs, rhs, line);
            this.lineNumber(line);
            Switch.type0(type, z -> this.method.visitInsn(124), i -> this.method.visitInsn(124), s -> this.method.visitInsn(124), b -> this.method.visitInsn(124), c -> this.method.visitInsn(124), f -> {
                throw new IllegalArgumentException("ushr on void");
            }, d -> {
                throw new IllegalArgumentException("ushr on void");
            }, l -> this.method.visitInsn(125), v -> {
                throw new IllegalArgumentException("ushr on void");
            }, c -> {
                throw new IllegalArgumentException("ushr on object");
            }, a -> {
                throw new IllegalArgumentException("ushr on array");
            }, S -> {
                throw new IllegalArgumentException("ushr on string");
            });
            return type;
        }

        private IConstructor shrExp(IConstructor lhs, IConstructor rhs, int line) {
            IConstructor type = this.prepareShiftArguments(lhs, rhs, line);
            this.lineNumber(line);
            Switch.type0(type, z -> this.method.visitInsn(122), i -> this.method.visitInsn(122), s -> this.method.visitInsn(122), b -> this.method.visitInsn(122), c -> this.method.visitInsn(122), f -> {
                throw new IllegalArgumentException("shr on void");
            }, d -> {
                throw new IllegalArgumentException("shr on void");
            }, l -> this.method.visitInsn(123), v -> {
                throw new IllegalArgumentException("shr on void");
            }, c -> {
                throw new IllegalArgumentException("shr on object");
            }, a -> {
                throw new IllegalArgumentException("shr on array");
            }, S -> {
                throw new IllegalArgumentException("shr on string");
            });
            return type;
        }

        private IConstructor incExp(String name, int inc, int line) {
            this.lineNumber(line);
            this.method.visitIincInsn(this.positionOf(name), inc);
            this.loadExp(name, line);
            return Types.integerType();
        }

        private IConstructor addExp(IConstructor lhs, IConstructor rhs, int line) {
            IConstructor type = this.prepareArguments(lhs, rhs, line);
            this.lineNumber(line);
            Switch.type0(type, z -> this.method.visitInsn(128), i -> this.method.visitInsn(96), s -> this.method.visitInsn(96), b -> this.method.visitInsn(96), c -> this.method.visitInsn(96), f -> this.method.visitInsn(98), d -> this.method.visitInsn(99), l -> this.method.visitInsn(97), v -> {
                throw new IllegalArgumentException("add on void");
            }, c -> {
                throw new IllegalArgumentException("add on object");
            }, a -> {
                throw new IllegalArgumentException("add on array");
            }, S -> {
                throw new IllegalArgumentException("add on string");
            });
            return type;
        }

        private IConstructor subExp(IConstructor lhs, IConstructor rhs, int line) {
            IConstructor type = this.prepareArguments(lhs, rhs, line);
            this.lineNumber(line);
            Switch.type0(type, z -> {
                throw new IllegalArgumentException("sub on bool");
            }, i -> this.method.visitInsn(100), s -> this.method.visitInsn(100), b -> this.method.visitInsn(100), c -> this.method.visitInsn(100), f -> this.method.visitInsn(102), d -> this.method.visitInsn(103), l -> this.method.visitInsn(101), v -> {
                throw new IllegalArgumentException("add on void");
            }, c -> {
                throw new IllegalArgumentException("add on object");
            }, a -> {
                throw new IllegalArgumentException("add on array");
            }, S -> {
                throw new IllegalArgumentException("add on string");
            });
            return type;
        }

        private IConstructor remExp(IConstructor lhs, IConstructor rhs, int line) {
            IConstructor type = this.prepareArguments(lhs, rhs, line);
            this.lineNumber(line);
            Switch.type0(type, z -> {
                throw new IllegalArgumentException("rem on bool");
            }, i -> this.method.visitInsn(112), s -> this.method.visitInsn(112), b -> this.method.visitInsn(112), c -> this.method.visitInsn(112), f -> this.method.visitInsn(114), d -> this.method.visitInsn(115), l -> this.method.visitInsn(113), v -> {
                throw new IllegalArgumentException("add on void");
            }, c -> {
                throw new IllegalArgumentException("add on object");
            }, a -> {
                throw new IllegalArgumentException("add on array");
            }, S -> {
                throw new IllegalArgumentException("add on string");
            });
            return type;
        }

        private IConstructor divExp(IConstructor lhs, IConstructor rhs, int line) {
            IConstructor type = this.prepareArguments(lhs, rhs, line);
            this.lineNumber(line);
            Switch.type0(type, z -> {
                throw new IllegalArgumentException("div on bool");
            }, i -> this.method.visitInsn(108), s -> this.method.visitInsn(108), b -> this.method.visitInsn(108), c -> this.method.visitInsn(108), f -> this.method.visitInsn(110), d -> this.method.visitInsn(111), l -> this.method.visitInsn(109), v -> {
                throw new IllegalArgumentException("div on void");
            }, c -> {
                throw new IllegalArgumentException("div on object");
            }, a -> {
                throw new IllegalArgumentException("div on array");
            }, S -> {
                throw new IllegalArgumentException("div on string");
            });
            return type;
        }

        private IConstructor mulExp(IConstructor lhs, IConstructor rhs, int line) {
            IConstructor type = this.prepareArguments(lhs, rhs, line);
            this.lineNumber(line);
            Switch.type0(type, z -> this.method.visitInsn(126), i -> this.method.visitInsn(104), s -> this.method.visitInsn(104), b -> this.method.visitInsn(104), c -> this.method.visitInsn(104), f -> this.method.visitInsn(106), d -> this.method.visitInsn(107), l -> this.method.visitInsn(105), v -> {
                throw new IllegalArgumentException("add on void");
            }, c -> {
                throw new IllegalArgumentException("add on object");
            }, a -> {
                throw new IllegalArgumentException("add on array");
            }, S -> {
                throw new IllegalArgumentException("add on string");
            });
            return type;
        }

        private IConstructor andExp(IConstructor lhs, IConstructor rhs, int line) {
            IConstructor type = this.prepareArguments(lhs, rhs, line);
            this.lineNumber(line);
            Switch.type0(type, z -> this.method.visitInsn(126), i -> this.method.visitInsn(126), s -> this.method.visitInsn(126), b -> this.method.visitInsn(126), c -> this.method.visitInsn(126), f -> {
                throw new IllegalArgumentException("and on float");
            }, d -> {
                throw new IllegalArgumentException("and on double");
            }, l -> {
                throw new IllegalArgumentException("and on long");
            }, v -> {
                throw new IllegalArgumentException("and on void");
            }, c -> {
                throw new IllegalArgumentException("and on object");
            }, a -> {
                throw new IllegalArgumentException("and on array");
            }, S -> {
                throw new IllegalArgumentException("and on string");
            });
            return type;
        }

        private IConstructor orExp(IConstructor lhs, IConstructor rhs, int line) {
            IConstructor type = this.prepareArguments(lhs, rhs, line);
            this.lineNumber(line);
            Switch.type0(type, z -> this.method.visitInsn(128), i -> this.method.visitInsn(128), s -> this.method.visitInsn(128), b -> this.method.visitInsn(128), c -> this.method.visitInsn(128), f -> {
                throw new IllegalArgumentException("or on float");
            }, d -> {
                throw new IllegalArgumentException("or on double");
            }, l -> {
                throw new IllegalArgumentException("or on long");
            }, v -> {
                throw new IllegalArgumentException("or on void");
            }, c -> {
                throw new IllegalArgumentException("or on object");
            }, a -> {
                throw new IllegalArgumentException("or on array");
            }, S -> {
                throw new IllegalArgumentException("or on string");
            });
            return type;
        }

        private IConstructor xorExp(IConstructor lhs, IConstructor rhs, int line) {
            IConstructor type = this.prepareArguments(lhs, rhs, line);
            this.lineNumber(line);
            Switch.type0(type, z -> this.method.visitInsn(130), i -> this.method.visitInsn(130), s -> this.method.visitInsn(130), b -> this.method.visitInsn(130), c -> this.method.visitInsn(130), f -> {
                throw new IllegalArgumentException("xor on void");
            }, d -> {
                throw new IllegalArgumentException("xor on void");
            }, l -> {
                throw new IllegalArgumentException("xor on void");
            }, v -> {
                throw new IllegalArgumentException("xor on void");
            }, c -> {
                throw new IllegalArgumentException("xor on object");
            }, a -> {
                throw new IllegalArgumentException("xor on array");
            }, S -> {
                throw new IllegalArgumentException("xor on string");
            });
            return type;
        }

        private IConstructor negExp(IConstructor arg, int line) {
            IConstructor type = this.expr(arg, line);
            this.lineNumber(line);
            Switch.type0(type, z -> {
                LeveledLabel zeroLabel = this.newLabel();
                LeveledLabel contLabel = this.newLabel();
                this.method.visitJumpInsn(153, (Label)zeroLabel);
                this.falseExp();
                this.jumpTo(contLabel);
                this.method.visitLabel((Label)zeroLabel);
                this.trueExp();
                this.method.visitLabel((Label)contLabel);
            }, i -> this.method.visitInsn(116), s -> this.method.visitInsn(116), b -> this.method.visitInsn(116), c -> this.method.visitInsn(116), f -> this.method.visitInsn(118), d -> this.method.visitInsn(119), l -> this.method.visitInsn(117), v -> {
                throw new IllegalArgumentException("neg on void");
            }, c -> {
                throw new IllegalArgumentException("neg on object");
            }, a -> {
                throw new IllegalArgumentException("neg on array");
            }, S -> {
                throw new IllegalArgumentException("neg on string");
            });
            return type;
        }

        private void invokeSuper(String superclass, IConstructor sig, IList args, int line) {
            this.loadExp("this", line);
            this.expressions(args, line);
            this.lineNumber(line);
            this.method.visitMethodInsn(183, superclass, "<init>", Signature.constructor(sig), false);
        }

        private void aastoreStat(IConstructor array, IConstructor index, IConstructor arg, int parentLine) {
            IConstructor type = this.expr(array, parentLine);
            this.expr(index, parentLine);
            this.expr(arg, parentLine);
            this.arrayStoreExpWithArrayIndexValueOnStack(AST.$getArg(type));
        }

        private void arrayStoreExpWithArrayIndexValueOnStack(IConstructor type) {
            Switch.type0(type, z -> this.method.visitInsn(84), i -> this.method.visitInsn(79), s -> this.method.visitInsn(86), b -> this.method.visitInsn(84), c -> this.method.visitInsn(85), f -> this.method.visitInsn(81), d -> this.method.visitInsn(82), l -> this.method.visitInsn(80), v -> {
                throw new IllegalArgumentException("store void in array");
            }, c -> this.method.visitInsn(83), a -> this.method.visitInsn(83), S -> this.method.visitInsn(83));
        }

        private IConstructor checkCastExp(IConstructor arg, IConstructor type, int line) {
            String cons = type.getConstructorType().getName();
            this.expr(arg, line);
            if (cons == "object") {
                this.lineNumber(line);
                this.method.visitTypeInsn(192, AST.$getName(type).replace('.', '/'));
            } else if (cons == "array") {
                this.lineNumber(line);
                this.method.visitTypeInsn(192, Signature.type(type));
            } else {
                throw new IllegalArgumentException("can not check cast to " + String.valueOf(type));
            }
            return type;
        }

        private IConstructor alengthExp(IConstructor arg, int line) {
            this.expr(arg, line);
            this.lineNumber(line);
            this.method.visitInsn(190);
            return Types.integerType();
        }

        private IConstructor newArrayExp(IConstructor type, IConstructor size, int line) {
            this.expr(size, line);
            if (!type.getConstructorType().getName().equals("array")) {
                throw new IllegalArgumentException("arg should be an array type");
            }
            this.newArrayWithSizeOnStack(AST.$getArg(type), line);
            return type;
        }

        private IConstructor newArrayExp(IConstructor type, IList elems, int line) {
            this.lineNumber(line);
            this.intConstant(elems.length());
            if (!type.getConstructorType().getName().equals("array")) {
                throw new IllegalArgumentException("arg should be an array type");
            }
            this.newArrayWithSizeOnStack(AST.$getArg(type), line);
            int i = 0;
            for (IValue elem : elems) {
                this.dup();
                this.intConstant(i++);
                this.expr((IConstructor)elem, line);
                this.arrayStoreExpWithArrayIndexValueOnStack(AST.$getArg(type));
            }
            return type;
        }

        private void newArrayWithSizeOnStack(IConstructor type, int line) {
            this.lineNumber(line);
            Switch.type0(type, z -> this.method.visitIntInsn(188, 4), i -> this.method.visitIntInsn(188, 10), s -> this.method.visitIntInsn(188, 9), b -> this.method.visitIntInsn(188, 8), c -> this.method.visitIntInsn(188, 5), f -> this.method.visitIntInsn(188, 6), d -> this.method.visitIntInsn(188, 7), j -> this.method.visitIntInsn(188, 11), v -> {
                throw new IllegalArgumentException("void array");
            }, c -> this.method.visitTypeInsn(189, AST.$getRefClassFromType(type, this.classNode.name)), a -> this.method.visitTypeInsn(189, AST.$getRefClassFromType(type, this.classNode.name)), S -> this.method.visitTypeInsn(189, AST.$getRefClassFromType(type, this.classNode.name)));
        }

        private IConstructor ltExp(IConstructor lhs, IConstructor rhs, Builder<IConstructor> thenPart, Builder<IConstructor> elsePart, LeveledLabel joinLabel, int line) {
            IConstructor type = this.prepareArguments(lhs, rhs, line);
            return Switch.type(type, z -> this.invertedConditionalFlow(0, 162, thenPart, elsePart, joinLabel, line), i -> this.invertedConditionalFlow(0, 162, thenPart, elsePart, joinLabel, line), s -> this.invertedConditionalFlow(0, 162, thenPart, elsePart, joinLabel, line), b -> this.invertedConditionalFlow(0, 162, thenPart, elsePart, joinLabel, line), c -> this.invertedConditionalFlow(0, 162, thenPart, elsePart, joinLabel, line), f -> this.invertedConditionalFlow(150, 156, thenPart, elsePart, joinLabel, line), d -> this.invertedConditionalFlow(152, 156, thenPart, elsePart, joinLabel, line), l -> this.invertedConditionalFlow(148, 156, thenPart, elsePart, joinLabel, line), v -> {
                throw new IllegalArgumentException("< on void");
            }, c -> {
                throw new IllegalArgumentException("< on class");
            }, a -> {
                throw new IllegalArgumentException("< on array");
            }, S -> {
                throw new IllegalArgumentException("< on string");
            });
        }

        private IConstructor leExp(IConstructor lhs, IConstructor rhs, Builder<IConstructor> thenPart, Builder<IConstructor> elsePart, LeveledLabel joinLabel, int line) {
            IConstructor type = this.prepareArguments(lhs, rhs, line);
            return Switch.type(type, z -> this.invertedConditionalFlow(0, 163, thenPart, elsePart, joinLabel, line), i -> this.invertedConditionalFlow(0, 163, thenPart, elsePart, joinLabel, line), s -> this.invertedConditionalFlow(0, 163, thenPart, elsePart, joinLabel, line), b -> this.invertedConditionalFlow(0, 163, thenPart, elsePart, joinLabel, line), c -> this.invertedConditionalFlow(0, 163, thenPart, elsePart, joinLabel, line), f -> this.invertedConditionalFlow(150, 157, thenPart, elsePart, joinLabel, line), d -> this.invertedConditionalFlow(152, 157, thenPart, elsePart, joinLabel, line), l -> this.invertedConditionalFlow(148, 157, thenPart, elsePart, joinLabel, line), v -> {
                throw new IllegalArgumentException("<= on void");
            }, c -> {
                throw new IllegalArgumentException("<= on class");
            }, a -> {
                throw new IllegalArgumentException("<= on array");
            }, a -> {
                throw new IllegalArgumentException("<= on string");
            });
        }

        private IConstructor gtExp(IConstructor lhs, IConstructor rhs, Builder<IConstructor> thenPart, Builder<IConstructor> elsePart, LeveledLabel joinLabel, int line) {
            IConstructor type = this.prepareArguments(lhs, rhs, line);
            return Switch.type(type, z -> this.invertedConditionalFlow(0, 164, thenPart, elsePart, joinLabel, line), i -> this.invertedConditionalFlow(0, 164, thenPart, elsePart, joinLabel, line), s -> this.invertedConditionalFlow(0, 164, thenPart, elsePart, joinLabel, line), b -> this.invertedConditionalFlow(0, 164, thenPart, elsePart, joinLabel, line), c -> this.invertedConditionalFlow(0, 164, thenPart, elsePart, joinLabel, line), f -> this.invertedConditionalFlow(150, 158, thenPart, elsePart, joinLabel, line), d -> this.invertedConditionalFlow(152, 158, thenPart, elsePart, joinLabel, line), l -> this.invertedConditionalFlow(148, 158, thenPart, elsePart, joinLabel, line), v -> {
                throw new IllegalArgumentException("> on void");
            }, c -> {
                throw new IllegalArgumentException("> on class");
            }, a -> {
                throw new IllegalArgumentException("> on array");
            }, S -> {
                throw new IllegalArgumentException("> on array");
            });
        }

        private IConstructor geExp(IConstructor lhs, IConstructor rhs, Builder<IConstructor> thenPart, Builder<IConstructor> elsePart, LeveledLabel joinLabel, int line) {
            IConstructor type = this.prepareArguments(lhs, rhs, line);
            return Switch.type(type, z -> this.invertedConditionalFlow(0, 161, thenPart, elsePart, joinLabel, line), i -> this.invertedConditionalFlow(0, 161, thenPart, elsePart, joinLabel, line), s -> this.invertedConditionalFlow(0, 161, thenPart, elsePart, joinLabel, line), b -> this.invertedConditionalFlow(0, 161, thenPart, elsePart, joinLabel, line), c -> this.invertedConditionalFlow(0, 161, thenPart, elsePart, joinLabel, line), f -> this.invertedConditionalFlow(150, 155, thenPart, elsePart, joinLabel, line), d -> this.invertedConditionalFlow(152, 155, thenPart, elsePart, joinLabel, line), l -> this.invertedConditionalFlow(148, 155, thenPart, elsePart, joinLabel, line), v -> {
                throw new IllegalArgumentException(">= on void");
            }, c -> {
                throw new IllegalArgumentException(">= on class");
            }, a -> {
                throw new IllegalArgumentException(">= on array");
            }, S -> {
                throw new IllegalArgumentException(">= on array");
            });
        }

        private IConstructor eqExp(IConstructor lhs, IConstructor rhs, Builder<IConstructor> thenPart, Builder<IConstructor> elsePart, LeveledLabel joinLabel, int line) {
            if (lhs.getConstructorType().getName().equals("null")) {
                return this.isNullTest(rhs, thenPart, elsePart, joinLabel, line);
            }
            if (rhs.getConstructorType().getName().equals("null")) {
                return this.isNullTest(lhs, thenPart, elsePart, joinLabel, line);
            }
            IConstructor type = this.prepareArguments(lhs, rhs, line);
            return Switch.type(type, z -> this.invertedConditionalFlow(0, 160, thenPart, elsePart, joinLabel, line), i -> this.invertedConditionalFlow(0, 160, thenPart, elsePart, joinLabel, line), s -> this.invertedConditionalFlow(0, 160, thenPart, elsePart, joinLabel, line), b -> this.invertedConditionalFlow(0, 160, thenPart, elsePart, joinLabel, line), c -> this.invertedConditionalFlow(0, 160, thenPart, elsePart, joinLabel, line), f -> this.invertedConditionalFlow(150, 154, thenPart, elsePart, joinLabel, line), d -> this.invertedConditionalFlow(152, 154, thenPart, elsePart, joinLabel, line), l -> this.invertedConditionalFlow(148, 154, thenPart, elsePart, joinLabel, line), v -> {
                throw new IllegalArgumentException(">= on void");
            }, c -> this.invertedConditionalFlow(0, 166, thenPart, elsePart, joinLabel, line), a -> this.invertedConditionalFlow(0, 166, thenPart, elsePart, joinLabel, line), S -> this.invertedConditionalFlow(0, 166, thenPart, elsePart, joinLabel, line));
        }

        private IConstructor prepareArguments(IConstructor lhs, IConstructor rhs, int line) {
            IConstructor type = this.expr(lhs, line);
            if (type.getConstructorType() != this.expr(rhs, line).getConstructorType()) {
                throw new IllegalArgumentException("incomparable types for operator");
            }
            return type;
        }

        private IConstructor invertedConditionalFlow(int compare, int opcode, Builder<IConstructor> thenPart, Builder<IConstructor> elsePart, LeveledLabel joinLabel, int line) {
            LeveledLabel jump = this.newLabel();
            LeveledLabel next = joinLabel == null ? this.newLabel() : joinLabel;
            IConstructor res1 = null;
            IConstructor res2 = null;
            this.lineNumber(line);
            if (compare != 0) {
                this.method.visitInsn(compare);
            }
            this.method.visitJumpInsn(opcode, (Label)(elsePart != null ? jump : next));
            res1 = thenPart.build();
            if (elsePart != null) {
                this.jumpTo(next);
                this.method.visitLabel((Label)jump);
                res2 = elsePart.build();
            }
            if (joinLabel == null) {
                this.method.visitLabel((Label)next);
                this.lineNumber(line, next);
            }
            return this.merge(res1, res2);
        }

        private IConstructor merge(IConstructor res1, IConstructor res2) {
            if (res1 == null) {
                return res2;
            }
            if (res2 == null) {
                return res1;
            }
            if (AST.$is("void", res1)) {
                return res2;
            }
            if (AST.$is("void", res2)) {
                return res1;
            }
            return res1;
        }

        private IConstructor isNullTest(IConstructor arg, Builder<IConstructor> thenPart, Builder<IConstructor> elsePart, LeveledLabel joinLabel, int line) {
            this.expr(arg, line);
            return this.invertedConditionalFlow(0, 199, thenPart, elsePart, joinLabel, line);
        }

        private IConstructor isNonNullTest(IConstructor arg, Builder<IConstructor> thenPart, Builder<IConstructor> elsePart, LeveledLabel joinLabel, int line) {
            this.expr(arg, line);
            return this.invertedConditionalFlow(0, 198, thenPart, elsePart, joinLabel, line);
        }

        private IConstructor neExp(IConstructor lhs, IConstructor rhs, Builder<IConstructor> thenPart, Builder<IConstructor> elsePart, LeveledLabel joinLabel, int line) {
            if (lhs.getConstructorType().getName().equals("null")) {
                return this.isNonNullTest(rhs, thenPart, elsePart, joinLabel, line);
            }
            if (rhs.getConstructorType().getName().equals("null")) {
                return this.isNonNullTest(lhs, thenPart, elsePart, joinLabel, line);
            }
            IConstructor type = this.prepareArguments(lhs, rhs, line);
            return Switch.type(type, z -> this.invertedConditionalFlow(0, 159, thenPart, elsePart, joinLabel, line), i -> this.invertedConditionalFlow(0, 159, thenPart, elsePart, joinLabel, line), s -> this.invertedConditionalFlow(0, 159, thenPart, elsePart, joinLabel, line), b -> this.invertedConditionalFlow(0, 159, thenPart, elsePart, joinLabel, line), c -> this.invertedConditionalFlow(0, 159, thenPart, elsePart, joinLabel, line), f -> this.invertedConditionalFlow(150, 153, thenPart, elsePart, joinLabel, line), d -> this.invertedConditionalFlow(152, 153, thenPart, elsePart, joinLabel, line), l -> this.invertedConditionalFlow(148, 153, thenPart, elsePart, joinLabel, line), v -> {
                throw new IllegalArgumentException("!= on void");
            }, c -> this.invertedConditionalFlow(0, 165, thenPart, elsePart, joinLabel, line), a -> this.invertedConditionalFlow(0, 165, thenPart, elsePart, joinLabel, line), S -> this.invertedConditionalFlow(0, 165, thenPart, elsePart, joinLabel, line));
        }

        private IConstructor coerceExp(IConstructor from, IConstructor to, IConstructor arg, int line) {
            Switch.type0(from, z -> this.coerceFromBool(to, arg, line), i -> this.coerceFromInt(to, arg, line), s -> this.coerceFromShort(to, arg, line), b -> this.coerceFromByte(to, arg, line), c -> this.coerceFromChar(to, arg, line), f -> this.coerceFromFloat(to, arg, line), d -> this.coerceFromDouble(to, arg, line), l -> this.coerceFromLong(to, arg, line), v -> this.failedCoercion("void", to), c -> this.coerceFromClass(from, to, arg, line), a -> this.coerceFromArray(from, to, arg, line), S -> this.coerceFromString(from, to, arg, line));
            return to;
        }

        private void coerceFromString(IConstructor from, IConstructor to, IConstructor arg, int line) {
            this.lineNumber(line);
            Switch.type0(to, z -> {
                this.expr(arg, line);
                this.method.visitMethodInsn(184, "java/lang/Boolean", "parseBoolean", "Ljava/lang/String;", false);
            }, i -> {
                this.expr(arg, line);
                this.method.visitMethodInsn(184, "java/lang/Integer", "parseInt", "I", false);
            }, s -> {
                this.expr(arg, line);
                this.method.visitMethodInsn(184, "java/lang/Short", "parseShort", "S", false);
            }, b -> {
                this.expr(arg, line);
                this.method.visitMethodInsn(184, "java/lang/Byte", "parseByte", "B", false);
            }, c -> this.failedCoercion("string", to), f -> {
                this.expr(arg, line);
                this.method.visitMethodInsn(184, "java/lang/Float", "parseFloat", "F", false);
            }, d -> {
                this.expr(arg, line);
                this.method.visitMethodInsn(184, "java/lang/Double", "parseDouble", "D", false);
            }, j -> {
                this.expr(arg, line);
                this.method.visitMethodInsn(184, "java/lang/Long", "parseLong", "J", false);
            }, v -> this.failedCoercion("string", to), a -> this.failedCoercion("string", to), c -> this.failedCoercion("object", to), S -> {});
        }

        private void coerceFromBool(IConstructor to, IConstructor arg, int line) {
            throw new IllegalArgumentException("Can not coerce bool to " + to.getConstructorType().getName());
        }

        private void failedCoercion(String from, IConstructor to) {
            throw new IllegalArgumentException("Can not coerce " + from + " to " + to.getConstructorType().getName());
        }

        private void coerceFromArray(IConstructor from, IConstructor to, IConstructor arg, int line) {
            this.lineNumber(line);
            Switch.type0(to, z -> this.failedCoercion("int", to), i -> this.failedCoercion("int", to), s -> this.failedCoercion("short", to), b -> this.failedCoercion("boolean", to), c -> this.failedCoercion("char", to), f -> this.failedCoercion("float", to), d -> this.failedCoercion("double", to), l -> this.failedCoercion("long", to), v -> this.failedCoercion("void", to), c -> this.failedCoercion("object", to), a -> this.coerceArrayToArray(from, to, arg), S -> this.failedCoercion("string", to));
        }

        private void coerceArrayToArray(IConstructor from, IConstructor to, IConstructor arg) {
            this.failedCoercion(from.toString(), to);
        }

        private void coerceFromLong(IConstructor to, IConstructor arg, int line) {
            this.expr(arg, line);
            Switch.type0(to, z -> this.failedCoercion("boolean", to), i -> this.method.visitInsn(136), s -> this.method.visitInsn(136), b -> this.method.visitInsn(136), c -> this.method.visitInsn(136), f -> this.method.visitInsn(137), d -> this.method.visitInsn(138), l -> {}, v -> {
                this.pop();
                this.nullExp();
            }, c -> this.failedCoercion("object", to), a -> this.failedCoercion("array", to), S -> this.method.visitMethodInsn(183, "java/lang/Object", "toString", "()V", false));
        }

        private void coerceFromClass(IConstructor from, IConstructor to, IConstructor arg, int line) {
            String cls = AST.$getName(from);
            this.expr(arg, line);
            Switch.type0(to, z -> {
                if (cls.equals("java/lang/Boolean")) {
                    this.expr(from, line);
                    this.method.visitMethodInsn(183, "java/lang/Integer", "booleanValue", "()Z", false);
                } else {
                    this.failedCoercion(cls, to);
                }
            }, i -> {
                if (cls.equals("java/lang/Integer")) {
                    this.expr(from, line);
                    this.method.visitMethodInsn(183, "java/lang/Integer", "intValue", "()I", false);
                } else {
                    this.failedCoercion(cls, to);
                }
            }, s -> {
                if (cls.equals("java/lang/Integer")) {
                    this.expr(from, line);
                    this.method.visitMethodInsn(183, "java/lang/Integer", "shortValue", "()S", false);
                } else {
                    this.failedCoercion(cls, to);
                }
            }, b -> {
                if (cls.equals("java/lang/Integer")) {
                    this.expr(from, line);
                    this.method.visitMethodInsn(183, "java/lang/Integer", "byteValue", "()B", false);
                } else {
                    this.failedCoercion(cls, to);
                }
            }, c -> this.failedCoercion(cls, arg), f -> {
                if (cls.equals("java/lang/Float")) {
                    this.expr(from, line);
                    this.method.visitMethodInsn(183, "java/lang/Float", "floatValue", "()F", false);
                } else {
                    this.failedCoercion(cls, to);
                }
            }, d -> {
                if (cls.equals("java/lang/Double")) {
                    this.expr(from, line);
                    this.method.visitMethodInsn(183, "java/lang/Double", "doubleValue", "()D", false);
                } else {
                    this.failedCoercion(cls, to);
                }
            }, l -> {
                if (cls.equals("java/lang/Long")) {
                    this.expr(from, line);
                    this.method.visitMethodInsn(183, "java/lang/Long", "longValue", "()L", false);
                } else {
                    this.failedCoercion(cls, to);
                }
            }, v -> {
                this.pop();
                this.nullExp();
            }, c -> {
                if (!cls.equals(AST.$getName(to))) {
                    this.failedCoercion("object", to);
                }
            }, a -> this.failedCoercion("array", to), S -> this.method.visitMethodInsn(183, "java/lang/Object", "toString", "()V", false));
        }

        private void coerceFromDouble(IConstructor to, IConstructor arg, int line) {
            this.expr(arg, line);
            Switch.type0(to, z -> this.failedCoercion("boolean", to), i -> this.method.visitInsn(142), s -> this.method.visitInsn(142), b -> this.method.visitInsn(142), c -> this.method.visitInsn(142), f -> this.method.visitInsn(144), d -> {}, l -> this.method.visitInsn(143), v -> {
                this.pop();
                this.nullExp();
            }, c -> this.failedCoercion("object", to), a -> this.failedCoercion("array", to), S -> this.method.visitMethodInsn(183, "java/lang/Object", "toString", "()V", false));
        }

        private void coerceFromFloat(IConstructor to, IConstructor arg, int line) {
            this.expr(arg, line);
            Switch.type0(to, z -> this.failedCoercion("boolean", to), i -> this.method.visitInsn(139), s -> this.method.visitInsn(139), b -> this.method.visitInsn(139), c -> this.method.visitInsn(139), f -> {}, d -> this.method.visitInsn(141), l -> this.method.visitInsn(140), v -> {
                this.pop();
                this.nullExp();
            }, c -> this.failedCoercion("object", to), a -> this.failedCoercion("array", to), S -> this.method.visitMethodInsn(183, "java/lang/Object", "toString", "()V", false));
        }

        private void coerceFromChar(IConstructor to, IConstructor arg, int line) {
            this.expr(arg, line);
            Switch.type0(to, z -> this.failedCoercion("boolean", to), i -> {}, s -> {}, b -> {}, c -> {}, f -> this.method.visitInsn(134), d -> this.method.visitInsn(135), l -> this.method.visitInsn(133), v -> {
                this.pop();
                this.nullExp();
            }, c -> this.failedCoercion("object", to), a -> this.failedCoercion("array", to), S -> this.method.visitMethodInsn(183, "java/lang/Object", "toString", "()V", false));
        }

        private void coerceFromByte(IConstructor to, IConstructor arg, int line) {
            this.expr(arg, line);
            Switch.type0(to, z -> this.failedCoercion("boolean", to), i -> {}, s -> {}, b -> {}, c -> {}, f -> this.method.visitInsn(134), d -> this.method.visitInsn(135), l -> this.method.visitInsn(133), v -> {
                this.pop();
                this.nullExp();
            }, c -> this.failedCoercion("object", to), a -> this.failedCoercion("array", to), S -> this.method.visitMethodInsn(183, "java/lang/Object", "toString", "()V", false));
        }

        private void coerceFromShort(IConstructor to, IConstructor arg, int line) {
            this.expr(arg, line);
            Switch.type0(to, z -> this.failedCoercion("boolean", to), i -> {}, s -> {}, b -> {}, c -> {}, f -> this.method.visitInsn(134), d -> this.method.visitInsn(135), l -> this.method.visitInsn(133), v -> {
                this.pop();
                this.nullExp();
            }, c -> this.failedCoercion("object", to), a -> this.failedCoercion("array", to), S -> this.method.visitMethodInsn(183, "java/lang/Object", "toString", "()V", false));
        }

        private void coerceFromInt(IConstructor to, IConstructor arg, int line) {
            this.expr(arg, line);
            Switch.type0(to, z -> this.failedCoercion("boolean", to), i -> {}, s -> {}, b -> {}, c -> {}, f -> this.method.visitInsn(134), d -> this.method.visitInsn(135), l -> this.method.visitInsn(133), v -> {
                this.pop();
                this.nullExp();
            }, c -> this.failedCoercion("object", to), a -> this.failedCoercion("array", to), S -> this.method.visitMethodInsn(183, "java/lang/Object", "toString", "()V", false));
        }

        private IConstructor falseExp() {
            this.method.visitInsn(3);
            return Types.booleanType();
        }

        private IConstructor trueExp() {
            this.method.visitInsn(4);
            return Types.booleanType();
        }

        private IConstructor nullExp() {
            this.method.visitInsn(1);
            return Types.voidType();
        }

        private IConstructor sblockExp(IList block, IConstructor arg, int line) {
            LeveledLabel blockEnd = this.newLabel();
            this.statements(block, null, null, blockEnd, line);
            this.method.visitLabel((Label)blockEnd);
            IConstructor type = this.expr(arg, line);
            return type;
        }

        private LeveledLabel newLabel(ArrayList<Builder<IConstructor>> level) {
            return new LeveledLabel(level.size());
        }

        private IConstructor instanceofExp(IConstructor arg, String cls, int line) {
            this.expr(arg, line);
            this.lineNumber(line);
            this.method.visitTypeInsn(193, cls);
            return Types.booleanType();
        }

        private IConstructor getfieldExp(IConstructor receiver, String cls, IConstructor type, String name, int line) {
            this.expr(receiver, line);
            this.lineNumber(line);
            this.method.visitFieldInsn(180, cls, name, Signature.type(type));
            return type;
        }

        private IConstructor newInstanceExp(IConstructor exp, int line) {
            IConstructor type = AST.$getClass(exp);
            String cls = AST.$getRefClassFromType(type, this.classNode.name);
            String desc = Signature.constructor(AST.$getDesc(exp));
            this.method.visitTypeInsn(187, cls);
            this.dup();
            this.expressions(AST.$getArgs(exp), line);
            this.lineNumber(line);
            this.method.visitMethodInsn(183, cls, "<init>", desc, false);
            return type;
        }

        private IConstructor aaloadExp(IConstructor array, IConstructor index, int line) {
            IConstructor type = this.expr(array, line);
            this.expr(index, line);
            this.lineNumber(line);
            Switch.type0(AST.$getArg(type), b -> this.method.visitInsn(51), i -> this.method.visitInsn(46), s -> this.method.visitInsn(53), b -> this.method.visitInsn(51), c -> this.method.visitInsn(52), f -> this.method.visitInsn(48), d -> this.method.visitInsn(49), j -> this.method.visitInsn(47), v -> {
                throw new IllegalArgumentException("loading into a void array");
            }, L -> this.method.visitInsn(50), a -> this.method.visitInsn(50), s -> this.method.visitInsn(50));
            return AST.$getArg(type);
        }

        private IConstructor getstaticExp(String cls, IConstructor type, String name, int line) {
            this.lineNumber(line);
            this.method.visitFieldInsn(178, cls, name, Signature.type(type));
            return type;
        }

        private IConstructor invokeSpecialExp(String cls, IConstructor sig, IConstructor receiver, IList args, int line) {
            this.expr(receiver, line);
            this.expressions(args, line);
            this.lineNumber(line);
            this.method.visitMethodInsn(183, cls, AST.$getName(sig), Signature.method(sig), false);
            return AST.$getReturn(sig);
        }

        private IConstructor invokeDynamicExp(IConstructor handler, IConstructor sig, IList args, int line) {
            String name = AST.$getName(sig);
            Handle bootstrapper = this.bootstrapHandler(handler);
            Object[] bArgs = this.bootstrapArgs(handler);
            this.expressions(args, line);
            this.lineNumber(line);
            this.method.visitInvokeDynamicInsn(name, Signature.method(sig), bootstrapper, bArgs);
            return AST.$getReturn(sig);
        }

        private Object[] bootstrapArgs(IConstructor handler) {
            IList args = AST.$getArgs(handler);
            Object[] results = new Object[args.length()];
            try {
                int i = 0;
                for (IValue elem : args) {
                    IConstructor cons = (IConstructor)elem;
                    switch (cons.getConstructorType().getName()) {
                        case "stringInfo": {
                            results[i++] = ((IString)cons.get("s")).getValue();
                            break;
                        }
                        case "classInfo": {
                            results[i++] = Signature.forName(((IString)cons.get("name")).getValue());
                            break;
                        }
                        case "integerInfo": {
                            results[i++] = ((IInteger)cons.get("i")).intValue();
                            break;
                        }
                        case "longInfo": {
                            results[i++] = ((IInteger)cons.get("l")).longValue();
                            break;
                        }
                        case "floatInfo": {
                            results[i++] = Float.valueOf(((IReal)cons.get("f")).floatValue());
                            break;
                        }
                        case "doubleInfo": {
                            results[i++] = ((IReal)cons.get("d")).doubleValue();
                            break;
                        }
                        case "virtualHandle": {
                            Class<?> clzTmp = Class.forName(AST.$getRefClassFromType(AST.$getClass(cons), this.classNode.name));
                            results[i++] = MethodHandles.lookup().findVirtual(clzTmp, AST.$getName(cons), Signature.methodType(AST.$getDesc(cons)));
                            break;
                        }
                        case "specialHandle": {
                            Class<?> clzTmp = Class.forName(AST.$getRefClassFromType(AST.$getClass(cons), this.classNode.name));
                            Class<?> specialTmp = Class.forName(AST.$getRefClassFromType(AST.$getSpecial(cons), this.classNode.name));
                            results[i++] = MethodHandles.lookup().findSpecial(clzTmp, AST.$getName(cons), Signature.methodType(AST.$getDesc(cons)), specialTmp);
                            break;
                        }
                        case "getterHandle": {
                            Class<?> clzTmp = Class.forName(AST.$getRefClassFromType(AST.$getClass(cons), this.classNode.name));
                            results[i++] = MethodHandles.lookup().findGetter(clzTmp, AST.$getName(cons), Signature.binaryClass(AST.$getType(cons)));
                            break;
                        }
                        case "setterHandle": {
                            Class<?> clzTmp = Class.forName(AST.$getRefClassFromType(AST.$getClass(cons), this.classNode.name));
                            results[i++] = MethodHandles.lookup().findSetter(clzTmp, AST.$getName(cons), Signature.binaryClass(AST.$getType(cons)));
                            break;
                        }
                        case "staticGetterHandle": {
                            Class<?> clzTmp = Class.forName(AST.$getRefClassFromType(AST.$getClass(cons), this.classNode.name));
                            results[i++] = MethodHandles.lookup().findStaticGetter(clzTmp, AST.$getName(cons), Signature.binaryClass(AST.$getType(cons)));
                            break;
                        }
                        case "staticSetterHandle": {
                            Class<?> clzTmp = Class.forName(AST.$getRefClassFromType(AST.$getClass(cons), this.classNode.name));
                            results[i++] = MethodHandles.lookup().findStaticSetter(clzTmp, AST.$getName(cons), Signature.binaryClass(AST.$getType(cons)));
                            break;
                        }
                        case "constructorHandle": {
                            Class<?> clzTmp = Class.forName(AST.$getRefClassFromType(AST.$getClass(cons), this.classNode.name));
                            results[i++] = MethodHandles.lookup().findConstructor(clzTmp, Signature.constructorType(AST.$getDesc(cons)));
                            break;
                        }
                        case "methodTypeInfo": {
                            results[i++] = Signature.methodType(AST.$getDesc(cons));
                        }
                    }
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
                throw new IllegalArgumentException("Could not construct the right type for building argument for bootstrap method", e);
            }
            return results;
        }

        private Handle bootstrapHandler(IConstructor handler) {
            return new Handle(6, AST.$getRefClassFromType(AST.$getClass(handler), this.classNode.name), AST.$getName(handler), Signature.method(AST.$getDesc(handler)), false);
        }

        private IConstructor invokeVirtualExp(String cls, IConstructor sig, IConstructor receiver, IList args, int line) {
            this.expr(receiver, line);
            this.expressions(args, line);
            this.lineNumber(line);
            this.method.visitMethodInsn(182, cls, AST.$getName(sig), Signature.method(sig), false);
            return AST.$getReturn(sig);
        }

        private IConstructor invokeInterfaceExp(String interf, IConstructor sig, IConstructor receiver, IList args, int line) {
            this.expr(receiver, line);
            this.expressions(args, line);
            this.lineNumber(line);
            this.method.visitMethodInsn(185, interf, AST.$getName(sig), Signature.method(sig), true);
            return AST.$getReturn(sig);
        }

        private IConstructor expressions(IList args, int parentLine) {
            if (args.length() == 0) {
                return null;
            }
            this.expr((IConstructor)args.get(0), parentLine);
            this.expressions(args.delete(0), parentLine);
            return null;
        }

        private IConstructor invokeStaticExp(String cls, IConstructor sig, IList args, int line) {
            this.expressions(args, line);
            this.lineNumber(line);
            this.method.visitMethodInsn(184, cls, AST.$getName(sig), Signature.method(sig), false);
            return AST.$getReturn(sig);
        }

        private IConstructor loadExp(String name, int line) {
            int pos = this.positionOf(name);
            IConstructor type = this.variableTypes.get(pos);
            this.lineNumber(line);
            Switch.type(type, pos, (z, p) -> this.method.visitVarInsn(21, p.intValue()), (i, p) -> this.method.visitVarInsn(21, p.intValue()), (s, p) -> this.method.visitVarInsn(21, p.intValue()), (b, p) -> this.method.visitVarInsn(21, p.intValue()), (c, p) -> this.method.visitVarInsn(21, p.intValue()), (f, p) -> this.method.visitVarInsn(23, p.intValue()), (d, p) -> this.method.visitVarInsn(24, p.intValue()), (l, p) -> this.method.visitVarInsn(22, p.intValue()), (v, p) -> {}, (c, p) -> this.method.visitVarInsn(25, p.intValue()), (a, p) -> this.method.visitVarInsn(25, p.intValue()), (S, p) -> this.method.visitVarInsn(25, p.intValue()));
            return type;
        }

        private void intConstant(int constant) {
            switch (constant) {
                case 0: {
                    this.method.visitInsn(3);
                    return;
                }
                case 1: {
                    this.method.visitInsn(4);
                    return;
                }
                case 2: {
                    this.method.visitInsn(5);
                    return;
                }
                case 3: {
                    this.method.visitInsn(6);
                    return;
                }
                case 4: {
                    this.method.visitInsn(7);
                    return;
                }
                case 5: {
                    this.method.visitInsn(8);
                    return;
                }
            }
            if (constant < 127) {
                this.method.visitIntInsn(16, constant);
            } else if (constant < Short.MAX_VALUE) {
                this.method.visitIntInsn(17, constant);
            } else {
                this.method.visitLdcInsn((Object)constant);
            }
        }

        private void longConstant(long constant) {
            if (constant == 0L) {
                this.method.visitInsn(9);
            } else if (constant == 1L) {
                this.method.visitInsn(10);
            } else {
                this.method.visitLdcInsn((Object)constant);
            }
        }

        private void stringConstant(String constant) {
            this.method.visitLdcInsn((Object)constant);
        }

        private void floatConstant(float constant) {
            if (constant == 0.0f) {
                this.method.visitInsn(11);
            } else if (constant == 1.0f) {
                this.method.visitInsn(12);
            } else if (constant == 2.0f) {
                this.method.visitInsn(13);
            } else {
                this.method.visitLdcInsn((Object)Float.valueOf(Float.toString(constant)));
            }
        }

        private void doubleConstant(double constant) {
            if (constant == 0.0) {
                this.method.visitInsn(14);
            } else if (constant == 1.0) {
                this.method.visitInsn(15);
            } else {
                this.method.visitLdcInsn((Object)Double.valueOf(Double.toString(constant)));
            }
        }

        private int positionOf(String name) {
            for (int pos = 0; pos < this.variableNames.size(); ++pos) {
                if (!name.equals(this.variableNames.get(pos))) continue;
                return pos;
            }
            throw new IllegalArgumentException("name not found: " + name);
        }

        private IConstructor constExp(IConstructor type, IValue constant, int line) {
            this.lineNumber(line);
            Switch.type0(type, z -> this.booleanConstant(AST.$getBooleanConstant(constant)), i -> this.intConstant(AST.$getIntegerConstant(constant)), s -> this.intConstant(AST.$getIntegerConstant(constant)), b -> this.intConstant(AST.$getIntegerConstant(constant)), c -> this.intConstant(AST.$getIntegerConstant(constant)), f -> this.floatConstant(AST.$getFloatConstant(constant)), d -> this.doubleConstant(AST.$getDoubleConstant(constant)), j -> this.longConstant(AST.$getLongConstant(constant)), v -> {
                throw new IllegalArgumentException("void constant");
            }, c -> {
                throw new IllegalArgumentException("object constant");
            }, a -> {
                if (!(constant instanceof IList)) {
                    throw new IllegalArgumentException("array constant without list input");
                }
                this.constantArray(AST.$getArg(type), (IList)constant, line);
            }, S -> this.stringConstant(AST.$getStringConstant(constant)));
            return type;
        }

        private void lineNumber(int line, Label label) {
            if (this.debug && line != -1) {
                this.method.visitLineNumber(line, label);
                this.currentLine = line;
            }
        }

        private void lineNumber(int line) {
            if (this.debug && line != -1 && line != this.currentLine) {
                Label label = new Label();
                this.method.visitLabel(label);
                this.method.visitLineNumber(line, label);
                this.currentLine = line;
            }
        }

        private void constantArray(IConstructor type, IList constant, int line) {
            this.intConstant(constant.length());
            this.newArrayWithSizeOnStack(type, line);
            int index = 0;
            for (IValue elem : constant) {
                this.dup();
                this.intConstant(index);
                this.constExp((IConstructor)elem, elem, line);
                this.arrayStoreExpWithArrayIndexValueOnStack(type);
            }
        }

        private void booleanConstant(boolean val) {
            if (val) {
                this.trueExp();
            } else {
                this.falseExp();
            }
        }

        private void dup() {
            this.method.visitInsn(89);
        }

        private void field(ClassNode classNode, IConstructor cons, boolean interf, int parentLine) {
            IWithKeywordParameters kws = cons.asWithKeywordParameters();
            int access = 0;
            access = interf ? 25 : (kws.hasParameter("modifiers") ? this.modifiers(AST.$getModifiersParameter((IWithKeywordParameters<? extends IConstructor>)kws)) : 2);
            String name = AST.$getName(cons);
            IConstructor type = AST.$getType(cons);
            String signature = Signature.type(type);
            Serializable value = null;
            if (kws.hasParameter("init")) {
                IConstructor defaultExpr = (IConstructor)kws.getParameter("init");
                if (!AST.$is("const", defaultExpr)) {
                    if ((access & 8) != 0) {
                        this.staticFieldInitializers.put(name, cons);
                    } else {
                        this.fieldInitializers.put(name, cons);
                    }
                } else {
                    IValue val = AST.$getConstant(defaultExpr);
                    value = Switch.type(type, z -> Boolean.valueOf(((IBool)val).getValue()), i -> Integer.valueOf(((IInteger)val).intValue()), s -> Integer.valueOf(((IInteger)val).intValue()), b -> Integer.valueOf(((IInteger)val).intValue()), c -> Integer.valueOf(((IInteger)val).intValue()), f -> Float.valueOf(((IReal)val).floatValue()), d -> Double.valueOf(((IReal)val).doubleValue()), l -> Long.valueOf(((IInteger)val).longValue()), v -> {
                        throw new IllegalArgumentException("constant void initializer");
                    }, c -> {
                        throw new IllegalArgumentException("constant object initializer");
                    }, a -> {
                        throw new IllegalArgumentException("constant array initializer");
                    }, s -> ((IString)val).getValue());
                }
            } else {
                value = Switch.type(type, z -> Boolean.valueOf(false), i -> Integer.valueOf(0), s -> Integer.valueOf(0), b -> Integer.valueOf(0), c -> Integer.valueOf(0), f -> Float.valueOf(0.0f), d -> Double.valueOf(0.0), l -> Long.valueOf(0L), v -> null, c -> null, a -> null, s -> null);
            }
            FieldNode fieldNode = new FieldNode(access, name, signature, null, (Object)value);
            if (kws.hasParameter("annotations")) {
                this.annotations((String a, Boolean b) -> fieldNode.visitAnnotation(a, b.booleanValue()), (IList)kws.getParameter("annotations"));
            }
            classNode.fields.add(fieldNode);
        }

        private int access(ISet modifiers) {
            for (IValue cons : modifiers) {
                switch (((IConstructor)cons).getName()) {
                    case "public": {
                        return 1;
                    }
                    case "private": {
                        return 2;
                    }
                    case "protected": {
                        return 4;
                    }
                }
            }
            return 0;
        }

        private int modifiers(ISet modifiers) {
            int res = 0;
            for (IValue cons : modifiers) {
                switch (((IConstructor)cons).getName()) {
                    case "public": {
                        ++res;
                        break;
                    }
                    case "private": {
                        res += 2;
                        break;
                    }
                    case "protected": {
                        res += 4;
                        break;
                    }
                    case "static": {
                        res += 8;
                        break;
                    }
                    case "final": {
                        res += 16;
                        break;
                    }
                    case "abstract": {
                        res += 1024;
                        break;
                    }
                    case "interface": {
                        res += 512;
                        break;
                    }
                    case "synchronized": {
                        res += 32;
                    }
                }
            }
            return res;
        }

        @FunctionalInterface
        private static interface Builder<T> {
            public T build();
        }

        private static class CaseLabel
        extends Label {
            final int key;

            public CaseLabel(int key) {
                this.key = key;
            }
        }
    }

    private static class ClassMapLoader
    extends ClassLoader
    implements Iterable<String>,
    Opcodes {
        private final Map<String, byte[]> bytecodes = new HashMap<String, byte[]>();
        private final Map<String, Class<?>> cache = new HashMap();

        public ClassMapLoader(ClassLoader parent) {
            super(parent);
        }

        public void putBytes(String name, byte[] bytes) {
            this.bytecodes.put(name, bytes);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            return this.getClass(name);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return this.getClass(name);
        }

        public Class<?> getClass(String name) throws ClassNotFoundException {
            if (this.cache.containsKey(name)) {
                return this.cache.get(name);
            }
            byte[] bytes = this.bytecodes.get(name);
            if (bytes == null) {
                return this.getParent().loadClass(name);
            }
            Class<?> result = super.defineClass(name, bytes, 0, bytes.length);
            this.cache.put(name, result);
            return result;
        }

        @Override
        public Iterator<String> iterator() {
            return this.bytecodes.keySet().iterator();
        }
    }
}

