/*
 * Decompiled with CFR 0.152.
 */
package lang.flybytes.internal;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import lang.flybytes.internal.AST;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.ParameterNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.uri.URIResolverRegistry;

public class ClassDisassembler {
    private final IValueFactory VF;
    private final AST ast;

    public ClassDisassembler(IValueFactory VF) {
        this.VF = VF;
        this.ast = new AST(VF);
    }

    public IConstructor disassemble(ISourceLocation classLoc, IBool signaturesOnly) {
        try {
            ClassReader reader = new ClassReader(URIResolverRegistry.getInstance().getInputStream(classLoc));
            return this.readClass(reader, signaturesOnly.getValue());
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io((IString)this.VF.string(e.getMessage()), null, null);
        }
    }

    private IConstructor readClass(ClassReader reader, boolean signaturesOnly) {
        ClassNode cn = new ClassNode();
        reader.accept((ClassVisitor)cn, 4);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("fields", this.fields(cn.fields));
        params.put("methods", this.methods(cn.methods, signaturesOnly));
        params.put("modifiers", this.modifiers(cn.access));
        if (cn.superName != null) {
            params.put("super", this.objectType(cn.superName));
        }
        params.put("interfaces", this.interfaces(cn.interfaces));
        if (this.set(cn.access, 512)) {
            return (IConstructor)this.ast.Class_interface(this.objectType(cn.name)).asWithKeywordParameters().setParameters(params);
        }
        return (IConstructor)this.ast.Class_class(this.objectType(cn.name)).asWithKeywordParameters().setParameters(params);
    }

    private IList interfaces(List<String> interfaces) {
        IListWriter w = this.VF.listWriter();
        for (String iface : interfaces) {
            w.append(new IValue[]{this.objectType(iface)});
        }
        return (IList)w.done();
    }

    private IConstructor objectType(String name) {
        return this.ast.Type_object(name.replaceAll("/", "."));
    }

    private ISet modifiers(int access) {
        ISetWriter sw = this.VF.setWriter();
        if (this.set(access, 1)) {
            sw.insert(new IValue[]{this.ast.Modifier_public()});
        } else if (this.set(access, 2)) {
            sw.insert(new IValue[]{this.ast.Modifier_private()});
        } else if (this.set(access, 4)) {
            sw.insert(new IValue[]{this.ast.Modifier_protected()});
        } else {
            sw.insert(new IValue[]{this.ast.Modifier_friendly()});
        }
        if (this.set(access, 8)) {
            sw.insert(new IValue[]{this.ast.Modifier_static()});
        }
        if (this.set(access, 16)) {
            sw.insert(new IValue[]{this.ast.Modifier_final()});
        }
        if (this.set(access, 32)) {
            sw.insert(new IValue[]{this.ast.Modifier_synchronized()});
        }
        if (this.set(access, 1024)) {
            sw.insert(new IValue[]{this.ast.Modifier_abstract()});
        }
        return (ISet)sw.done();
    }

    private boolean set(int access, int bit) {
        return (access & bit) != 0;
    }

    private IList methods(List<MethodNode> methods, boolean signaturesOnly) {
        IListWriter lw = this.VF.listWriter();
        for (MethodNode fn : methods) {
            lw.append(new IValue[]{this.method(fn, signaturesOnly)});
        }
        return (IList)lw.done();
    }

    private IConstructor method(MethodNode fn, boolean signaturesOnly) {
        IConstructor desc = this.descriptor(fn.name, fn.desc);
        IList instructions = this.VF.list(new IValue[0]);
        if (!signaturesOnly) {
            instructions = this.instructions(fn.instructions);
            if (fn.tryCatchBlocks != null) {
                for (TryCatchBlockNode tc : fn.tryCatchBlocks) {
                    instructions = instructions.append((IValue)this.ast.Instruction_TRYCATCH(this.typeName(tc.type), tc.start.getLabel().toString(), tc.end.getLabel().toString(), tc.handler.getLabel().toString()));
                }
            }
            if (fn.localVariables != null) {
                for (LocalVariableNode var : fn.localVariables) {
                    instructions = instructions.append((IValue)this.ast.Instruction_LOCALVARIABLE(var.name, this.type(var.desc), var.start.getLabel().toString(), var.end.getLabel().toString(), var.index));
                }
            }
        }
        IList formals = this.formals(fn.parameters, fn.localVariables, (IList)desc.get("formals"), this.set(fn.access, 8));
        if (fn.name.equals("<clinit>")) {
            return this.ast.Method_static(this.VF.list(new IValue[]{this.ast.Stat_asm(instructions)}));
        }
        return this.ast.Method_procedure(desc, formals, instructions);
    }

    private IList formals(List<ParameterNode> parameters, List<LocalVariableNode> locals, IList types, boolean isStatic) {
        IListWriter lw = this.VF.listWriter();
        if (parameters != null && !parameters.isEmpty()) {
            int i = 0;
            for (IValue elem : types) {
                lw.append(new IValue[]{this.ast.Formal_var((IConstructor)elem, parameters.get((int)i++).name)});
            }
        } else if (locals != null && locals.size() > 0 && locals.size() >= types.length() - (isStatic ? 0 : 1)) {
            int i = 0;
            for (IValue elem : types) {
                LocalVariableNode local = locals.get(i + (isStatic ? 0 : 1));
                lw.append(new IValue[]{this.ast.Formal_var((IConstructor)elem, local.name)});
                ++i;
            }
        } else {
            int i = 0;
            for (IValue elem : types) {
                lw.append(new IValue[]{this.ast.Formal_var((IConstructor)elem, "arg_" + i)});
            }
        }
        return (IList)lw.done();
    }

    private IList instructions(InsnList instructions) {
        IListWriter lw = this.VF.listWriter();
        ListIterator iter = instructions.iterator();
        while (iter.hasNext()) {
            lw.append(new IValue[]{this.instruction((AbstractInsnNode)iter.next())});
        }
        return (IList)lw.done();
    }

    private IConstructor instruction(AbstractInsnNode instr) {
        switch (instr.getOpcode()) {
            case 0: {
                return this.ast.Instruction_NOP();
            }
            case 1: {
                return this.ast.Instruction_ACONST_NULL();
            }
            case 2: {
                return this.ast.Instruction_ICONST_M1();
            }
            case 3: {
                return this.ast.Instruction_ICONST_0();
            }
            case 4: {
                return this.ast.Instruction_ICONST_1();
            }
            case 5: {
                return this.ast.Instruction_ICONST_2();
            }
            case 6: {
                return this.ast.Instruction_ICONST_3();
            }
            case 7: {
                return this.ast.Instruction_ICONST_4();
            }
            case 8: {
                return this.ast.Instruction_ICONST_5();
            }
            case 9: {
                return this.ast.Instruction_LCONST_0();
            }
            case 10: {
                return this.ast.Instruction_LCONST_1();
            }
            case 11: {
                return this.ast.Instruction_FCONST_0();
            }
            case 12: {
                return this.ast.Instruction_FCONST_1();
            }
            case 13: {
                return this.ast.Instruction_FCONST_2();
            }
            case 14: {
                return this.ast.Instruction_DCONST_0();
            }
            case 15: {
                return this.ast.Instruction_DCONST_1();
            }
            case 46: {
                return this.ast.Instruction_IALOAD();
            }
            case 47: {
                return this.ast.Instruction_LALOAD();
            }
            case 48: {
                return this.ast.Instruction_FALOAD();
            }
            case 49: {
                return this.ast.Instruction_DALOAD();
            }
            case 50: {
                return this.ast.Instruction_AALOAD();
            }
            case 51: {
                return this.ast.Instruction_BALOAD();
            }
            case 52: {
                return this.ast.Instruction_CALOAD();
            }
            case 53: {
                return this.ast.Instruction_SALOAD();
            }
            case 79: {
                return this.ast.Instruction_IASTORE();
            }
            case 80: {
                return this.ast.Instruction_LASTORE();
            }
            case 81: {
                return this.ast.Instruction_FASTORE();
            }
            case 82: {
                return this.ast.Instruction_DASTORE();
            }
            case 83: {
                return this.ast.Instruction_AASTORE();
            }
            case 84: {
                return this.ast.Instruction_BASTORE();
            }
            case 85: {
                return this.ast.Instruction_CASTORE();
            }
            case 86: {
                return this.ast.Instruction_SASTORE();
            }
            case 87: {
                return this.ast.Instruction_POP();
            }
            case 88: {
                return this.ast.Instruction_POP2();
            }
            case 89: {
                return this.ast.Instruction_DUP();
            }
            case 90: {
                return this.ast.Instruction_DUP_X1();
            }
            case 91: {
                return this.ast.Instruction_DUP_X2();
            }
            case 92: {
                return this.ast.Instruction_DUP2();
            }
            case 93: {
                return this.ast.Instruction_DUP2_X1();
            }
            case 94: {
                return this.ast.Instruction_DUP2_X2();
            }
            case 95: {
                return this.ast.Instruction_SWAP();
            }
            case 96: {
                return this.ast.Instruction_IADD();
            }
            case 97: {
                return this.ast.Instruction_LADD();
            }
            case 98: {
                return this.ast.Instruction_FADD();
            }
            case 99: {
                return this.ast.Instruction_DADD();
            }
            case 100: {
                return this.ast.Instruction_ISUB();
            }
            case 101: {
                return this.ast.Instruction_LSUB();
            }
            case 102: {
                return this.ast.Instruction_FSUB();
            }
            case 103: {
                return this.ast.Instruction_DSUB();
            }
            case 104: {
                return this.ast.Instruction_IMUL();
            }
            case 105: {
                return this.ast.Instruction_LMUL();
            }
            case 106: {
                return this.ast.Instruction_FMUL();
            }
            case 107: {
                return this.ast.Instruction_DMUL();
            }
            case 108: {
                return this.ast.Instruction_IDIV();
            }
            case 109: {
                return this.ast.Instruction_LDIV();
            }
            case 110: {
                return this.ast.Instruction_FDIV();
            }
            case 111: {
                return this.ast.Instruction_DDIV();
            }
            case 112: {
                return this.ast.Instruction_IREM();
            }
            case 113: {
                return this.ast.Instruction_LREM();
            }
            case 114: {
                return this.ast.Instruction_FREM();
            }
            case 115: {
                return this.ast.Instruction_DREM();
            }
            case 116: {
                return this.ast.Instruction_INEG();
            }
            case 117: {
                return this.ast.Instruction_LNEG();
            }
            case 118: {
                return this.ast.Instruction_FNEG();
            }
            case 119: {
                return this.ast.Instruction_DNEG();
            }
            case 120: {
                return this.ast.Instruction_ISHL();
            }
            case 121: {
                return this.ast.Instruction_LSHL();
            }
            case 122: {
                return this.ast.Instruction_ISHR();
            }
            case 123: {
                return this.ast.Instruction_LSHR();
            }
            case 124: {
                return this.ast.Instruction_IUSHR();
            }
            case 125: {
                return this.ast.Instruction_LUSHR();
            }
            case 126: {
                return this.ast.Instruction_IAND();
            }
            case 127: {
                return this.ast.Instruction_LAND();
            }
            case 128: {
                return this.ast.Instruction_IOR();
            }
            case 129: {
                return this.ast.Instruction_LOR();
            }
            case 130: {
                return this.ast.Instruction_IXOR();
            }
            case 131: {
                return this.ast.Instruction_LXOR();
            }
            case 133: {
                return this.ast.Instruction_I2L();
            }
            case 134: {
                return this.ast.Instruction_I2F();
            }
            case 135: {
                return this.ast.Instruction_I2D();
            }
            case 136: {
                return this.ast.Instruction_L2I();
            }
            case 137: {
                return this.ast.Instruction_L2F();
            }
            case 138: {
                return this.ast.Instruction_L2D();
            }
            case 139: {
                return this.ast.Instruction_F2I();
            }
            case 140: {
                return this.ast.Instruction_F2L();
            }
            case 141: {
                return this.ast.Instruction_F2D();
            }
            case 142: {
                return this.ast.Instruction_D2I();
            }
            case 143: {
                return this.ast.Instruction_D2L();
            }
            case 144: {
                return this.ast.Instruction_D2F();
            }
            case 145: {
                return this.ast.Instruction_I2B();
            }
            case 146: {
                return this.ast.Instruction_I2C();
            }
            case 147: {
                return this.ast.Instruction_I2S();
            }
            case 148: {
                return this.ast.Instruction_LCMP();
            }
            case 149: {
                return this.ast.Instruction_FCMPL();
            }
            case 150: {
                return this.ast.Instruction_FCMPG();
            }
            case 151: {
                return this.ast.Instruction_DCMPL();
            }
            case 152: {
                return this.ast.Instruction_DCMPG();
            }
            case 172: {
                return this.ast.Instruction_IRETURN();
            }
            case 173: {
                return this.ast.Instruction_LRETURN();
            }
            case 174: {
                return this.ast.Instruction_FRETURN();
            }
            case 175: {
                return this.ast.Instruction_DRETURN();
            }
            case 176: {
                return this.ast.Instruction_ARETURN();
            }
            case 177: {
                return this.ast.Instruction_RETURN();
            }
            case 190: {
                return this.ast.Instruction_ARRAYLENGTH();
            }
            case 191: {
                return this.ast.Instruction_ATHROW();
            }
            case 194: {
                return this.ast.Instruction_MONITORENTER();
            }
            case 195: {
                return this.ast.Instruction_MONITOREXIT();
            }
            case 21: {
                return this.ast.Instruction_ILOAD(((VarInsnNode)instr).var);
            }
            case 22: {
                return this.ast.Instruction_LLOAD(((VarInsnNode)instr).var);
            }
            case 23: {
                return this.ast.Instruction_FLOAD(((VarInsnNode)instr).var);
            }
            case 24: {
                return this.ast.Instruction_DLOAD(((VarInsnNode)instr).var);
            }
            case 25: {
                return this.ast.Instruction_ALOAD(((VarInsnNode)instr).var);
            }
            case 54: {
                return this.ast.Instruction_ISTORE(((VarInsnNode)instr).var);
            }
            case 55: {
                return this.ast.Instruction_LSTORE(((VarInsnNode)instr).var);
            }
            case 56: {
                return this.ast.Instruction_FSTORE(((VarInsnNode)instr).var);
            }
            case 57: {
                return this.ast.Instruction_DSTORE(((VarInsnNode)instr).var);
            }
            case 58: {
                return this.ast.Instruction_ASTORE(((VarInsnNode)instr).var);
            }
            case 169: {
                return this.ast.Instruction_RET(((VarInsnNode)instr).var);
            }
            case 16: {
                return this.ast.Instruction_BIPUSH(((IntInsnNode)instr).operand);
            }
            case 17: {
                return this.ast.Instruction_BIPUSH(((IntInsnNode)instr).operand);
            }
            case 18: {
                return this.ast.Instruction_LDC(this.constType(((LdcInsnNode)instr).cst), this.initializer(((LdcInsnNode)instr).cst).get("constant"));
            }
            case 132: {
                return this.ast.Instruction_IINC(((IincInsnNode)instr).var, ((IincInsnNode)instr).incr);
            }
            case 153: {
                return this.ast.Instruction_IFEQ(((JumpInsnNode)instr).label.getLabel().toString());
            }
            case 154: {
                return this.ast.Instruction_IFNE(((JumpInsnNode)instr).label.getLabel().toString());
            }
            case 155: {
                return this.ast.Instruction_IFLT(((JumpInsnNode)instr).label.getLabel().toString());
            }
            case 156: {
                return this.ast.Instruction_IFGE(((JumpInsnNode)instr).label.getLabel().toString());
            }
            case 157: {
                return this.ast.Instruction_IFGT(((JumpInsnNode)instr).label.getLabel().toString());
            }
            case 158: {
                return this.ast.Instruction_IFLE(((JumpInsnNode)instr).label.getLabel().toString());
            }
            case 159: {
                return this.ast.Instruction_IF_ICMPEQ(((JumpInsnNode)instr).label.getLabel().toString());
            }
            case 160: {
                return this.ast.Instruction_IF_ICMPNE(((JumpInsnNode)instr).label.getLabel().toString());
            }
            case 161: {
                return this.ast.Instruction_IF_ICMPLT(((JumpInsnNode)instr).label.getLabel().toString());
            }
            case 162: {
                return this.ast.Instruction_IF_ICMPGE(((JumpInsnNode)instr).label.getLabel().toString());
            }
            case 163: {
                return this.ast.Instruction_IF_ICMPGT(((JumpInsnNode)instr).label.getLabel().toString());
            }
            case 164: {
                return this.ast.Instruction_IF_ICMPLE(((JumpInsnNode)instr).label.getLabel().toString());
            }
            case 165: {
                return this.ast.Instruction_IF_ACMPEQ(((JumpInsnNode)instr).label.getLabel().toString());
            }
            case 166: {
                return this.ast.Instruction_IF_ACMPNE(((JumpInsnNode)instr).label.getLabel().toString());
            }
            case 167: {
                return this.ast.Instruction_GOTO(((JumpInsnNode)instr).label.getLabel().toString());
            }
            case 168: {
                return this.ast.Instruction_JSR(((JumpInsnNode)instr).label.getLabel().toString());
            }
            case 198: {
                return this.ast.Instruction_IFNULL(((JumpInsnNode)instr).label.getLabel().toString());
            }
            case 199: {
                return this.ast.Instruction_IFNONNULL(((JumpInsnNode)instr).label.getLabel().toString());
            }
            case 170: {
                return this.tableSwitchInstruction((TableSwitchInsnNode)instr);
            }
            case 171: {
                return this.lookupSwitchInstruction((LookupSwitchInsnNode)instr);
            }
            case 178: {
                return this.ast.Instruction_GETSTATIC(this.typeName(((FieldInsnNode)instr).owner), ((FieldInsnNode)instr).name, this.type(((FieldInsnNode)instr).desc));
            }
            case 179: {
                return this.ast.Instruction_PUTSTATIC(this.typeName(((FieldInsnNode)instr).owner), ((FieldInsnNode)instr).name, this.type(((FieldInsnNode)instr).desc));
            }
            case 180: {
                return this.ast.Instruction_GETFIELD(this.typeName(((FieldInsnNode)instr).owner), ((FieldInsnNode)instr).name, this.type(((FieldInsnNode)instr).desc));
            }
            case 181: {
                return this.ast.Instruction_PUTFIELD(this.typeName(((FieldInsnNode)instr).owner), ((FieldInsnNode)instr).name, this.type(((FieldInsnNode)instr).desc));
            }
            case 182: {
                return this.ast.Instruction_INVOKEVIRTUAL(this.typeName(((MethodInsnNode)instr).owner), this.descriptor(((MethodInsnNode)instr).name, ((MethodInsnNode)instr).desc), ((MethodInsnNode)instr).itf);
            }
            case 183: {
                return this.ast.Instruction_INVOKESPECIAL(this.typeName(((MethodInsnNode)instr).owner), this.descriptor(((MethodInsnNode)instr).name, ((MethodInsnNode)instr).desc), ((MethodInsnNode)instr).itf);
            }
            case 184: {
                return this.ast.Instruction_INVOKESTATIC(this.typeName(((MethodInsnNode)instr).owner), this.descriptor(((MethodInsnNode)instr).name, ((MethodInsnNode)instr).desc), ((MethodInsnNode)instr).itf);
            }
            case 185: {
                return this.ast.Instruction_INVOKEINTERFACE(this.typeName(((MethodInsnNode)instr).owner), this.descriptor(((MethodInsnNode)instr).name, ((MethodInsnNode)instr).desc), ((MethodInsnNode)instr).itf);
            }
            case 186: {
                InvokeDynamicInsnNode invokeDynamicNode = (InvokeDynamicInsnNode)instr;
                return this.ast.Instruction_INVOKEDYNAMIC(this.descriptor(invokeDynamicNode.name, invokeDynamicNode.desc), this.handle(invokeDynamicNode.bsm, invokeDynamicNode.bsmArgs));
            }
            case 188: {
                if (instr instanceof IntInsnNode) {
                    return this.ast.Instruction_NEWARRAY(this.type(((IntInsnNode)instr).operand));
                }
                if (instr instanceof TypeInsnNode) {
                    return this.ast.Instruction_NEWARRAY(this.type(((TypeInsnNode)instr).desc));
                }
                throw new IllegalArgumentException("unsupported shape of NEWARRAY instruction: " + String.valueOf(instr));
            }
            case 187: {
                return this.ast.Instruction_NEW(this.typeName(((TypeInsnNode)instr).desc));
            }
            case 189: {
                return this.ast.Instruction_ANEWARRAY(this.typeName(((TypeInsnNode)instr).desc));
            }
            case 192: {
                return this.ast.Instruction_CHECKCAST(this.typeName(((TypeInsnNode)instr).desc));
            }
            case 193: {
                return this.ast.Instruction_INSTANCEOF(this.typeName(((TypeInsnNode)instr).desc));
            }
            case 197: {
                return this.ast.Instruction_MULTIANEWARRAY(this.typeName(((MultiANewArrayInsnNode)instr).desc), ((MultiANewArrayInsnNode)instr).dims);
            }
            case -1: {
                if (instr instanceof LabelNode) {
                    return this.ast.Instruction_LABEL(((LabelNode)instr).getLabel().toString());
                }
                if (!(instr instanceof LineNumberNode)) break;
                return this.ast.Instruction_LINENUMBER(((LineNumberNode)instr).line, ((LineNumberNode)instr).start.getLabel().toString());
            }
        }
        throw new IllegalArgumentException("unrecognized instruction: " + String.valueOf(instr));
    }

    private IConstructor handle(Handle bootstrapMethod, Object[] bootstrapMethodArgs) {
        IConstructor cls = this.typeName(bootstrapMethod.getOwner());
        IConstructor descriptor = this.descriptor(bootstrapMethod.getName(), bootstrapMethod.getDesc());
        return this.ast.BootstrapCall_bootstrap(cls, descriptor, this.bootstrapArgs(bootstrapMethodArgs));
    }

    private IList bootstrapArgs(Object[] bootstrapMethodArgs) {
        IListWriter w = this.VF.listWriter();
        for (Object arg : bootstrapMethodArgs) {
            w.append(new IValue[]{this.bootstrapArg(arg)});
        }
        return (IList)w.done();
    }

    private IValue bootstrapArg(Object arg) {
        if (arg instanceof String) {
            return this.ast.CallSiteInfo_stringInfo((String)arg);
        }
        if (arg instanceof Integer) {
            return this.ast.CallSiteInfo_integerInfo((Integer)arg);
        }
        if (arg instanceof Double) {
            return this.ast.CallSiteInfo_doubleInfo((Double)arg);
        }
        if (arg instanceof Long) {
            return this.ast.CallSiteInfo_longInfo((Long)arg);
        }
        if (arg instanceof Class) {
            return this.ast.CallSiteInfo_classInfo(((Class)arg).getName());
        }
        if (arg instanceof Type) {
            Type t = (Type)arg;
            switch (t.getSort()) {
                case 11: {
                    return this.ast.CallSiteInfo_methodTypeInfo(this.descriptor("$anonymous", t.getDescriptor()));
                }
            }
        } else if (arg instanceof Handle) {
            Handle h = (Handle)arg;
            return this.ast.CallSiteInfo_virtualHandle(this.typeName(h.getOwner()), h.getName(), this.descriptor(h.getName(), h.getDesc()));
        }
        throw new IllegalArgumentException("no support for this bootstrap argument yet: " + String.valueOf(arg));
    }

    private IConstructor lookupSwitchInstruction(LookupSwitchInsnNode instr) {
        IListWriter labels = this.VF.listWriter();
        for (LabelNode l : instr.labels) {
            labels.append(new IValue[]{this.VF.string(l.getLabel().toString())});
        }
        IListWriter keys = this.VF.listWriter();
        Iterator iterator = instr.keys.iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            keys.append(new IValue[]{this.VF.integer(key)});
        }
        return this.ast.Instruction_LOOKUPSWITCH(instr.dflt.getLabel().toString(), (IList)keys.done(), (IList)labels.done());
    }

    private IConstructor tableSwitchInstruction(TableSwitchInsnNode instr) {
        IListWriter labels = this.VF.listWriter();
        for (LabelNode l : instr.labels) {
            labels.append(new IValue[]{this.VF.string(l.getLabel().toString())});
        }
        return this.ast.Instruction_TABLESWITCH(instr.min, instr.max, instr.dflt.getLabel().toString(), (IList)labels.done());
    }

    private IConstructor descriptor(String name, String desc) {
        Type d = Type.getType((String)desc);
        Type ret = d.getReturnType();
        Type[] args = d.getArgumentTypes();
        if ("<init>".equals(name)) {
            return this.ast.Signature_constructorDesc(this.sigFormals(args));
        }
        return this.ast.Signature_methodDesc(this.type(ret.getDescriptor()), name, this.sigFormals(args));
    }

    private IList sigFormals(Type[] args) {
        IListWriter lw = this.VF.listWriter();
        for (Type t : args) {
            lw.append(new IValue[]{this.type(t.getDescriptor())});
        }
        return (IList)lw.done();
    }

    private IList fields(List<FieldNode> fields) {
        IListWriter lw = this.VF.listWriter();
        for (FieldNode fn : fields) {
            lw.append(new IValue[]{this.field(fn)});
        }
        return (IList)lw.done();
    }

    private IValue field(FieldNode fn) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (fn.value != null) {
            params.put("init", this.initializer(fn.value));
        }
        params.put("modifiers", this.modifiers(fn.access));
        return this.ast.Field_field(this.type(fn.desc), fn.name).asWithKeywordParameters().setParameters(params);
    }

    private IConstructor initializer(Object value) {
        if (value instanceof String) {
            return this.ast.Exp_const(this.ast.Type_string(), (IValue)this.VF.string((String)value));
        }
        if (value instanceof Float) {
            return this.ast.Exp_const(this.ast.Type_float(), (IValue)this.VF.real((double)((Float)value).floatValue()));
        }
        if (value instanceof Double) {
            return this.ast.Exp_const(this.ast.Type_double(), (IValue)this.VF.real(((Double)value).doubleValue()));
        }
        if (value instanceof Byte) {
            return this.ast.Exp_const(this.ast.Type_byte(), (IValue)this.VF.integer((int)((Byte)value).byteValue()));
        }
        if (value instanceof Short) {
            return this.ast.Exp_const(this.ast.Type_short(), (IValue)this.VF.integer((int)((Short)value).shortValue()));
        }
        if (value instanceof Character) {
            return this.ast.Exp_const(this.ast.Type_character(), (IValue)this.VF.integer((int)((Character)value).charValue()));
        }
        if (value instanceof Integer) {
            return this.ast.Exp_const(this.ast.Type_integer(), (IValue)this.VF.integer(((Integer)value).intValue()));
        }
        if (value instanceof Long) {
            return this.ast.Exp_const(this.ast.Type_long(), (IValue)this.VF.integer(((Long)value).longValue()));
        }
        return this.ast.Exp_null();
    }

    private IConstructor constType(Object value) {
        if (value instanceof String) {
            return this.ast.Type_string();
        }
        if (value instanceof Float) {
            return this.ast.Type_float();
        }
        if (value instanceof Double) {
            return this.ast.Type_double();
        }
        if (value instanceof Byte) {
            return this.ast.Type_byte();
        }
        if (value instanceof Short) {
            return this.ast.Type_short();
        }
        if (value instanceof Character) {
            return this.ast.Type_character();
        }
        if (value instanceof Integer) {
            return this.ast.Type_integer();
        }
        if (value instanceof Long) {
            return this.ast.Type_long();
        }
        throw new IllegalArgumentException("constant type not detected: " + String.valueOf(value));
    }

    private IConstructor typeName(String cls) {
        return this.type("L" + cls + ";");
    }

    private IConstructor type(int index) {
        switch (index) {
            case 4: {
                return this.ast.Type_boolean();
            }
            case 8: {
                return this.ast.Type_byte();
            }
            case 5: {
                return this.ast.Type_character();
            }
            case 7: {
                return this.ast.Type_double();
            }
            case 6: {
                return this.ast.Type_float();
            }
            case 10: {
                return this.ast.Type_integer();
            }
            case 11: {
                return this.ast.Type_long();
            }
            case 9: {
                return this.ast.Type_short();
            }
        }
        throw new IllegalArgumentException("not a supported type enum: " + index);
    }

    private IConstructor type(String desc) {
        if ("Ljava/lang/String;".equals(desc)) {
            return this.ast.Type_string();
        }
        if (desc.startsWith("L")) {
            return this.objectType(desc.substring(1, desc.indexOf(";")));
        }
        if (desc.startsWith("[")) {
            return this.ast.Type_array(this.type(desc.substring(1)));
        }
        if ("Z".equals(desc)) {
            return this.ast.Type_boolean();
        }
        if ("I".equals(desc)) {
            return this.ast.Type_integer();
        }
        if ("S".equals(desc)) {
            return this.ast.Type_short();
        }
        if ("B".equals(desc)) {
            return this.ast.Type_byte();
        }
        if ("C".equals(desc)) {
            return this.ast.Type_character();
        }
        if ("F".equals(desc)) {
            return this.ast.Type_float();
        }
        if ("D".equals(desc)) {
            return this.ast.Type_double();
        }
        if ("J".equals(desc)) {
            return this.ast.Type_long();
        }
        if ("V".equals(desc)) {
            return this.ast.Type_void();
        }
        throw new IllegalArgumentException("not a type descriptor: " + desc);
    }
}

