/*
 * Decompiled with CFR 0.152.
 */
package lang.flybytes.internal;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.ITypeVisitor;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeStore;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import lang.flybytes.internal.ClassCompiler;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.types.TypeReifier;
import org.rascalmpl.values.IRascalValueFactory;

public class Mirror {
    private final IRascalValueFactory vf;
    private final TypeReifier tr;
    private final PrintWriter out;
    private final Type Mirror;
    private final Type classCons;
    private final Type invokeStaticFunc;
    private final Type getStaticFunc;
    private final Type newInstanceFunc;
    private final Type getAnnotationFunc;
    private final Type objectCons;
    private final Type invokeFunc;
    private final Type getFieldFunc;
    private final Type toValueFunc;
    private final Type arrayCons;
    private final Type lengthFunc;
    private final Type loadFunc;
    private final Type nullCons;
    private final Map<IConstructor, Class<?>> unreflectClass = new WeakHashMap();
    private final Map<IConstructor, Object> unreflectObject = new WeakHashMap<IConstructor, Object>();

    public Mirror(IRascalValueFactory rvf, TypeStore store, PrintWriter out) {
        this.vf = rvf;
        this.tr = new TypeReifier((IValueFactory)this.vf);
        this.out = out;
        this.Mirror = store.lookupAbstractDataType("Mirror");
        this.classCons = (Type)store.lookupConstructor(this.Mirror, "class").iterator().next();
        this.invokeStaticFunc = this.classCons.getFieldType(1);
        this.getStaticFunc = this.classCons.getFieldType(2);
        this.newInstanceFunc = this.classCons.getFieldType(3);
        this.getAnnotationFunc = this.classCons.getFieldType(4);
        this.objectCons = (Type)store.lookupConstructor(this.Mirror, "object").iterator().next();
        this.invokeFunc = this.objectCons.getFieldType(1);
        this.getFieldFunc = this.objectCons.getFieldType(2);
        this.toValueFunc = this.objectCons.getFieldType(3);
        this.arrayCons = (Type)store.lookupConstructor(this.Mirror, "array").iterator().next();
        this.lengthFunc = this.arrayCons.getFieldType(0);
        this.loadFunc = this.arrayCons.getFieldType(1);
        this.nullCons = (Type)store.lookupConstructor(this.Mirror, "null").iterator().next();
    }

    public IConstructor mirrorClass(String className, Class<?> cls) {
        IConstructor result = this.vf.constructor(this.classCons, new IValue[]{this.vf.string(className), this.invokeStatic(className, cls), this.getStatic(className, cls), this.newInstance(className, cls), this.getAnnotation(className, cls)});
        this.unreflectClass.put(result, cls);
        return result;
    }

    public IConstructor mirrorObject(Object object) {
        if (object == null) {
            return this.vf.constructor(this.nullCons);
        }
        Class<?> cls = object.getClass();
        IConstructor classMirror = this.mirrorClass(cls.getName(), cls);
        IConstructor objectMirror = this.mirrorObject(classMirror, object);
        this.unreflectObject.put(objectMirror, object);
        return objectMirror;
    }

    private IConstructor mirrorObject(IConstructor classMirror, Object object) {
        if (object.getClass().isArray()) {
            IConstructor arrayMirror = this.vf.constructor(this.arrayCons, new IValue[]{this.length(object), this.load(object)});
            this.unreflectObject.put(arrayMirror, object);
            return arrayMirror;
        }
        IConstructor objectMirror = this.vf.constructor(this.objectCons, new IValue[]{classMirror, this.invoke(object), this.field(object), this.toValue(object)});
        this.unreflectObject.put(objectMirror, object);
        return objectMirror;
    }

    private IValue load(Object object) {
        return this.vf.function(this.loadFunc, (actuals, keywordParameters) -> {
            int index = ((IInteger)actuals[0]).intValue();
            return this.mirrorObject(Array.get(object, index));
        });
    }

    private IValue length(Object object) {
        return this.vf.function(this.lengthFunc, (actuals, keywordParameters) -> this.vf.integer(Array.getLength(object)));
    }

    private IValue toValue(Object object) {
        return this.vf.function(this.toValueFunc, (actuals, keywordParameters) -> {
            Type expected = this.tr.valueToType((IConstructor)actuals[0]);
            Object wrapped = object;
            IValue result = null;
            result = wrapped instanceof IValue ? (IValue)wrapped : this.asValue(expected, wrapped);
            if (result.getType().comparable(expected)) {
                return result;
            }
            throw RuntimeExceptionFactory.illegalTypeArgument((String)expected.toString(), null, null);
        });
    }

    private IValue asValue(final Type expected, final Object wrapped) {
        return (IValue)expected.accept((ITypeVisitor)new ITypeVisitor<IValue, RuntimeException>(){

            public IValue visitAbstractData(Type arg0) throws RuntimeException {
                throw this.illegalType(expected);
            }

            private RuntimeException illegalType(Type expected2) {
                return RuntimeExceptionFactory.illegalTypeArgument((String)(wrapped.getClass().toString() + " can not convert to " + expected2.toString()), null, null);
            }

            public IValue visitAlias(Type arg0) throws RuntimeException {
                return (IValue)arg0.getAliased().accept((ITypeVisitor)this);
            }

            public IValue visitBool(Type arg0) throws RuntimeException {
                if (wrapped instanceof Boolean) {
                    return Mirror.this.vf.bool(((Boolean)wrapped).booleanValue());
                }
                throw this.illegalType(arg0);
            }

            public IValue visitConstructor(Type arg0) throws RuntimeException {
                throw this.illegalType(expected);
            }

            public IValue visitDateTime(Type arg0) throws RuntimeException {
                throw this.illegalType(expected);
            }

            public IValue visitExternal(Type arg0) throws RuntimeException {
                throw this.illegalType(expected);
            }

            public IValue visitInteger(Type arg0) throws RuntimeException {
                if (wrapped instanceof Integer) {
                    return Mirror.this.vf.integer(((Integer)wrapped).intValue());
                }
                if (wrapped instanceof Byte) {
                    return Mirror.this.vf.integer(((Byte)wrapped).intValue());
                }
                if (wrapped instanceof Short) {
                    return Mirror.this.vf.integer(((Short)wrapped).intValue());
                }
                if (wrapped instanceof Character) {
                    return Mirror.this.vf.integer((int)((Character)wrapped).charValue());
                }
                if (wrapped instanceof Long) {
                    return Mirror.this.vf.integer(((Long)wrapped).longValue());
                }
                throw this.illegalType(expected);
            }

            public IValue visitList(Type arg0) throws RuntimeException {
                throw this.illegalType(expected);
            }

            public IValue visitMap(Type arg0) throws RuntimeException {
                throw this.illegalType(expected);
            }

            public IValue visitNode(Type arg0) throws RuntimeException {
                throw this.illegalType(expected);
            }

            public IValue visitNumber(Type arg0) throws RuntimeException {
                throw this.illegalType(expected);
            }

            public IValue visitParameter(Type arg0) throws RuntimeException {
                throw this.illegalType(expected);
            }

            public IValue visitRational(Type arg0) throws RuntimeException {
                throw this.illegalType(expected);
            }

            public IValue visitReal(Type arg0) throws RuntimeException {
                if (wrapped instanceof Double) {
                    return Mirror.this.vf.real(((Double)wrapped).doubleValue());
                }
                if (wrapped instanceof Float) {
                    return Mirror.this.vf.real(Float.toString(((Float)wrapped).floatValue()));
                }
                throw this.illegalType(expected);
            }

            public IValue visitSet(Type arg0) throws RuntimeException {
                throw this.illegalType(expected);
            }

            public IValue visitSourceLocation(Type arg0) throws RuntimeException {
                throw this.illegalType(expected);
            }

            public IValue visitString(Type arg0) throws RuntimeException {
                if (wrapped instanceof String) {
                    return Mirror.this.vf.string((String)wrapped);
                }
                return Mirror.this.vf.string(wrapped.toString());
            }

            public IValue visitTuple(Type arg0) throws RuntimeException {
                throw this.illegalType(expected);
            }

            public IValue visitValue(Type arg0) throws RuntimeException {
                return this.visitString(arg0);
            }

            public IValue visitVoid(Type arg0) throws RuntimeException {
                throw this.illegalType(expected);
            }

            public IValue visitFunction(Type type) throws RuntimeException {
                throw this.illegalType(expected);
            }
        });
    }

    private IValue newInstance(String className, Class<?> cls) {
        return this.vf.function(this.newInstanceFunc, (actuals, keywordParameters) -> {
            try {
                IConstructor signature = (IConstructor)actuals[0];
                IList args = (IList)actuals[1];
                Constructor meth = this.getDeclaredConstructor(cls, signature);
                Object object = meth.newInstance(this.unreflect(args));
                return this.mirrorObject(object);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private IValue getStatic(String className, Class<?> cls) {
        return this.vf.function(this.getStaticFunc, (actuals, keywordParameters) -> {
            try {
                String name = ((IString)actuals[0]).getValue();
                Field field = cls.getField(name);
                Object result = field.get(null);
                return this.mirrorObject(result);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private IValue getAnnotation(String className, Class<?> cls) {
        return this.vf.function(this.getAnnotationFunc, (actuals, keywordParameters) -> {
            try {
                Class<?> annoClass = ClassCompiler.Signature.binaryClass((IConstructor)actuals[0]);
                Object annoObject = cls.getAnnotation(annoClass);
                return this.mirrorObject(annoObject);
            }
            catch (ClassNotFoundException | IllegalArgumentException | SecurityException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private IValue field(Object object) {
        return this.vf.function(this.getFieldFunc, (actuals, keywordParameters) -> {
            try {
                String name = ((IString)actuals[0]).getValue();
                Field field = object.getClass().getDeclaredField(name);
                field.setAccessible(true);
                Object result = field.get(object);
                return this.mirrorObject(result);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private IValue invoke(Object object) {
        return this.vf.function(this.invokeFunc, (actuals, keywordParameters) -> {
            try {
                IConstructor signature = (IConstructor)actuals[0];
                IList args = (IList)actuals[1];
                Class<?> objectClass = object.getClass();
                Method meth = this.getMethod(objectClass, signature);
                meth.setAccessible(true);
                Object obj = meth.invoke(object, this.unreflect(args));
                return this.mirrorObject(obj);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private IValue invokeStatic(String className, Class<?> cls) {
        return this.vf.function(this.invokeStaticFunc, (actuals, keywordParameters) -> {
            try {
                IConstructor signature = (IConstructor)actuals[0];
                IList args = (IList)actuals[1];
                Method meth = this.getMethod(cls, signature);
                meth.setAccessible(true);
                Object obj = meth.invoke(null, this.unreflect(args));
                return this.mirrorObject(obj);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        });
    }

    protected Object[] unreflect(IList args) {
        Object[] result = new Object[args.length()];
        int i = 0;
        for (IValue elem : args) {
            result[i++] = this.unreflect((IConstructor)elem);
        }
        return result;
    }

    private Method getMethod(Class<?> cls, IConstructor sig) throws NoSuchMethodException, SecurityException, ClassNotFoundException {
        return cls.getMethod(ClassCompiler.AST.$getName(sig), ClassCompiler.Signature.binaryClasses(ClassCompiler.AST.$getFormals(sig), this.out));
    }

    private <T> Constructor<T> getDeclaredConstructor(Class<T> cls, IConstructor sig) throws NoSuchMethodException, SecurityException, ClassNotFoundException {
        return cls.getDeclaredConstructor(ClassCompiler.Signature.binaryClasses(ClassCompiler.AST.$getFormals(sig), this.out));
    }

    public IValue mirrorArray(IConstructor type, int length) throws ClassNotFoundException {
        return this.mirrorObject(this.newArray(type, length));
    }

    private Object newArray(IConstructor type, int length) throws ClassNotFoundException {
        return Array.newInstance(ClassCompiler.Signature.binaryClass(type), length);
    }

    public IValue mirrorArray(IConstructor type, IList elems) throws ClassNotFoundException {
        Object newInstance = this.newArray(type, elems.length());
        for (int i = 0; i < elems.length(); ++i) {
            IConstructor mirror = (IConstructor)elems.get(i);
            Object object = this.unreflect(mirror);
            try {
                ClassCompiler.Switch.type(type, i, (z, ind) -> Array.setBoolean(newInstance, ind, (Boolean)object), (I, ind) -> Array.setInt(newInstance, ind, (Integer)object), (s, ind) -> Array.setShort(newInstance, ind, (Short)object), (b, ind) -> Array.setByte(newInstance, ind, (Byte)object), (c, ind) -> Array.setChar(newInstance, ind, ((Character)object).charValue()), (f, ind) -> Array.setFloat(newInstance, ind, ((Float)object).floatValue()), (d, ind) -> Array.setDouble(newInstance, ind, (Double)object), (l, ind) -> Array.setLong(newInstance, ind, (Long)object), (v, ind) -> Array.set(newInstance, ind, null), (c, ind) -> Array.set(newInstance, ind, object), (a, ind) -> Array.set(newInstance, ind, object), (S, ind) -> Array.set(newInstance, ind, object));
                continue;
            }
            catch (IllegalArgumentException e) {
                if (object == null) continue;
                throw new IllegalArgumentException("element type mismatch: " + String.valueOf(newInstance.getClass().getComponentType()) + " vs " + String.valueOf(object.getClass()));
            }
        }
        return this.mirrorObject(newInstance);
    }

    private Object unreflect(IConstructor mirror) {
        switch (mirror.getConstructorType().getName()) {
            case "null": {
                return null;
            }
            case "class": {
                Class<?> cls = this.unreflectClass.get(mirror);
                if (cls == null) {
                    throw RuntimeExceptionFactory.illegalArgument((IValue)mirror);
                }
                return cls;
            }
            case "object": 
            case "array": {
                Object obj = this.unreflectObject.get(mirror);
                if (obj == null) {
                    throw RuntimeExceptionFactory.illegalArgument((IValue)mirror);
                }
                return obj;
            }
        }
        throw new IllegalArgumentException(mirror.toString());
    }
}

