/*
 * Decompiled with CFR 0.152.
 */
package lang.flybytes.tests.examples;

public class RoundtripTestClass {
    int ofield1 = 1;
    double ofield2 = 0.1;
    static int sfield1;

    int simpleIfThenElse(int x) {
        x = x < 2 ? 2 : 3;
        return x;
    }

    int simpleWhileLoop(int x) {
        while (x < 10) {
            ++x;
        }
        return x;
    }

    int simpleDoWhileLoop(int x) {
        while (++x < 10) {
        }
        return x;
    }

    int lotsOfDecls() {
        int x = 1;
        int y = x + 1;
        int z = y + 1;
        return x + y + z;
    }

    int simpleForLoop(int x) {
        int l = 0;
        for (int i = 0; i < x; ++i) {
            l += i;
        }
        return l;
    }

    int nestedForLoop(int x, int y) {
        int l = 0;
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                l += i + j;
            }
        }
        return l;
    }

    int forLoopWithMultipleWalkers(int x) {
        int l = 0;
        int i = 0;
        for (int j = 0; i < x || j < x; ++i, ++j) {
            System.err.println(l += i + j);
        }
        return l;
    }

    int simpleThrow(int x) throws Exception {
        throw new Exception("catch!");
    }

    int simpleSwitchWithDefault(int x) throws Exception {
        switch (x) {
            case 0: {
                x = 1;
                break;
            }
            case 1: {
                x = 2;
                break;
            }
            case 2: {
                x = 3;
                break;
            }
            case 3: {
                x = 4;
                break;
            }
            default: {
                x = 5;
            }
        }
        return x;
    }

    int simpleSwitchWithoutDefault(int x) throws Exception {
        switch (x) {
            case 0: {
                x = 1;
                break;
            }
            case 1: {
                x = 2;
                break;
            }
            case 2: {
                x = 3;
                break;
            }
            case 3: {
                x = 4;
            }
        }
        return x;
    }

    int switchWithFallThrough(int x) throws Exception {
        switch (x) {
            case 0: {
                x = 1;
                break;
            }
            case 1: {
                x = 2;
            }
            case 2: {
                x = 3;
            }
        }
        return x;
    }

    int switchWithEmptyCase(int x) throws Exception {
        switch (x) {
            case 0: {
                x = 1;
                break;
            }
            case 1: 
            case 2: {
                x = 2;
            }
        }
        return x;
    }

    int switchWithLastEmptyCase(int x) throws Exception {
        switch (x) {
            case 0: {
                x = 1;
                break;
            }
            case 1: 
            case 2: {
                x = 2;
                break;
            }
        }
        return x;
    }

    int switchWithLastEmptyCaseToDefault(int x) throws Exception {
        switch (x) {
            case 0: {
                x = 1;
                break;
            }
            case 1: 
            case 2: {
                x = 2;
                break;
            }
            default: {
                x = 3;
            }
        }
        return x;
    }

    int switchWithOnlyFallThroughs(int x) throws Exception {
        switch (x) {
            case 0: {
                ++x;
            }
            case 1: {
                ++x;
            }
            case 2: {
                ++x;
            }
            case 3: {
                ++x;
            }
        }
        return x;
    }

    int switchWithReverseFallThroughs(int x) throws Exception {
        switch (x) {
            case 3: {
                ++x;
            }
            case 2: {
                ++x;
            }
            case 1: {
                ++x;
            }
            case 0: {
                ++x;
            }
        }
        return x;
    }

    int switchWithReverseFallThroughsWithHoles(int x) throws Exception {
        switch (x) {
            case 5: {
                ++x;
            }
            case 3: {
                ++x;
            }
            case 1: {
                ++x;
            }
            case 0: {
                ++x;
            }
        }
        return x;
    }

    int tryCatch(int x) {
        try {
            return x / 0;
        }
        catch (ArithmeticException e) {
            ++x;
        }
        catch (Throwable y) {
            System.err.println(x);
        }
        return x;
    }

    int tryMultiCatch(int x) {
        try {
            x /= 0;
        }
        catch (ArithmeticException | IllegalArgumentException e) {
            ++x;
        }
        return x;
    }

    int tryMultiCatchReturnFromBlock(int x) {
        try {
            return x / 0;
        }
        catch (ArithmeticException | IllegalArgumentException e) {
            return ++x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int tryCatchFinally(int x) {
        try {
            int n = x / 0;
            return n;
        }
        catch (Throwable e) {
            int n = 0;
            return n;
        }
        finally {
            System.err.println("watch out!");
        }
    }

    int[] arrayInitTest(int x) {
        return new int[]{x, x, x};
    }

    static {
        System.err.println("static initializer");
        sfield1 = 1;
    }
}

