---
title: "module lang::flybytes::Compiler"
id: Compiler
slug: /Packages/org.rascalmpl.flybytes/API/lang/flybytes/Compiler
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.2</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.flybytes-0.2.10</div>

#### Usage

```rascal
import lang::flybytes::Compiler;
```

#### Dependencies
```rascal
extend lang::flybytes::Mirror;
extend lang::flybytes::Syntax;
extend util::Maybe;
```


## data JDKVersion {#lang-flybytes-Compiler-JDKVersion}

```rascal
data JDKVersion  
     = v1_6()
     | v1_7()
     | v1_8()
     | v9()
     | v10()
     | v11()
     | v12()
     | v13()
     | v14()
     | v15()
     | v16()
     | v17()
     | v18()
     ;
```

## function compileClass {#lang-flybytes-Compiler-compileClass}

```rascal
void compileClass(Class cls, loc classFile, bool enableAsserts=false, JDKVersion version=v11(), bool debugMode=false)
```

compiles a flybytes class to a JVM bytecode class and saves the result to the target location

## function loadClass {#lang-flybytes-Compiler-loadClass}

```rascal
Mirror loadClass(Class cls, Maybe[loc] file=nothing(), list[loc] classpath=[], bool enableAsserts=false, JDKVersion version=v11(), bool debugMode=false)
```

compiles a flybytes class to a JVM bytecode class and loads the result as a class Mirror value.

## function loadClasses {#lang-flybytes-Compiler-loadClasses}

```rascal
map[str,Mirror] loadClasses(list[Class] classes, Maybe[loc] prefix=nothing(), list[loc] classpath=[], bool enableAsserts=false, JDKVersion version=v11(), bool debugMode=false)
```

compiles a list of flybytes classes to JVM bytecode classes and loads the results as a class Mirror values (into the same classloader such
that the classes can see eachother.

