---
title: "module lang::flybytes::demo::pico::Syntax"
id: Syntax
slug: /Packages/org.rascalmpl.flybytes/API/lang/flybytes/demo/pico/Syntax
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.2</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.flybytes-0.2.10</div>

#### Usage

```rascal
import lang::flybytes::demo::pico::Syntax;
```

#### Dependencies
```rascal
import ParseTree;
```


## syntax Program {#lang-flybytes-demo-pico-Syntax-Program}

```rascal
start syntax Program 
  = program: "begin" Declarations decls {Statement  ";"}* body "end" ;
```

## syntax Declarations {#lang-flybytes-demo-pico-Syntax-Declarations}

```rascal
syntax Declarations 
  = "declare" {IdType ","}* decls ";" ;
```

## syntax IdType {#lang-flybytes-demo-pico-Syntax-IdType}

```rascal
syntax IdType = idtype: Id id ":" Type t;
```

## syntax Statement {#lang-flybytes-demo-pico-Syntax-Statement}

```rascal
syntax Statement 
  = assign: Id var ":="  Expression val 
  | cond: "if" Expression cond "then" {Statement ";"}*  thenPart "else" {Statement ";"}* elsePart "fi"
  | cond: "if" Expression cond "then" {Statement ";"}*  thenPart "fi"
  | loop: "while" Expression cond "do" {Statement ";"}* body "od"
  ;
```

## syntax Type {#lang-flybytes-demo-pico-Syntax-Type}

```rascal
syntax Type 
  = natural:"natural" 
  | string :"string" 
  | nil    :"nil-type"
  ;
```

## syntax Expression {#lang-flybytes-demo-pico-Syntax-Expression}

```rascal
syntax Expression 
  = id: Id name
  | strcon: String string
  | natcon: Natural natcon
  | bracket "(" Expression e ")"
  > left concat: Expression lhs "||" Expression rhs
  > left ( add: Expression lhs "+" Expression rhs
         | min: Expression lhs "-" Expression rhs
         )
  ;
```

## syntax Id {#lang-flybytes-demo-pico-Syntax-Id}

```rascal
lexical Id  = [a-z][a-z0-9]* !>> [a-z0-9];
```

## syntax Natural {#lang-flybytes-demo-pico-Syntax-Natural}

```rascal
lexical Natural = [0-9]+ ;
```

## syntax String {#lang-flybytes-demo-pico-Syntax-String}

```rascal
lexical String = "\"" ![\"]*  "\"";
```

## syntax Layout {#lang-flybytes-demo-pico-Syntax-Layout}

```rascal
layout Layout = WhitespaceAndComment* !>> [\ \t\n\r%];
```

## syntax WhitespaceAndComment {#lang-flybytes-demo-pico-Syntax-WhitespaceAndComment}

```rascal
lexical WhitespaceAndComment 
   = [\ \t\n\r]
   | @category="Comment" "%" ![%]+ "%"
   | @category="Comment" "%%" ![\n]* $
   ;
```

## function program {#lang-flybytes-demo-pico-Syntax-program}

```rascal
public start[Program] program(str s) {
  return parse(#start[Program], s);
}

public start[Program] program(str s, loc l) {
  return parse(#start[Program], s, l);
}
```

