---
title: "module lang::flybytes::demo::protol::Syntax"
id: Syntax
slug: /Packages/org.rascalmpl.flybytes/API/lang/flybytes/demo/protol/Syntax
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.2</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.flybytes-0.2.10</div>

#### Usage

```rascal
import lang::flybytes::demo::protol::Syntax;
```



## syntax Program {#lang-flybytes-demo-protol-Syntax-Program}

```rascal
start syntax Program = Command* commands;
```

## syntax Command {#lang-flybytes-demo-protol-Syntax-Command}

```rascal
syntax Command 
  = assign: Assignable assign "=" Expr val ";"
  | \if: "if" "(" Expr cond ")"  "{" Command* thenPart "}" "else" "{" Command* elsePart "}"
  | \for: "while" "(" Expr cond ")" "{" Command* body "}" 
  | exp: Expr e ";"
  | \return: "return" Expr e ";" 
  | print: "print" Expr e ";"
  ;
```

## syntax Assignable {#lang-flybytes-demo-protol-Syntax-Assignable}

```rascal
syntax Assignable
  = var: Id name
  | field: Expr obj "." Id name
  | array: Expr array "[" Expr index "]"
  ;
```

## syntax Expr {#lang-flybytes-demo-protol-Syntax-Expr}

```rascal
syntax Expr
  = "this"
  | send: Expr receiver "." Id name "(" {Expr ","}* args ")"
  | array: "[" {Expr ","}* "]"
  | new: "new" Expr? prototype
  | \extend: "new" Expr? prototype "{" Definition* definitions "}" 
  | bracket "(" Expr ")"
  | ref: Id id
  | \int: Int
  | \str: String
  | field: Expr receiver "." Id name
  > array: Expr array "[" Expr index "]"
  > left  Expr "\<\<" Expr
  > left  (Expr "*" Expr | Expr "/" Expr)
  > left  (Expr "+" Expr | Expr "-" Expr )
  > right (Expr "==" Expr | Expr "!=" Expr)
  > right (Expr "\<=" Expr | Expr "\<" Expr | Expr "\>" Expr | Expr "\>=" Expr)
  ;
```

## syntax Definition {#lang-flybytes-demo-protol-Syntax-Definition}

```rascal
syntax Definition
  = field:   Id name \ "missing" "=" Expr val
  | method:  Id name \ "missing" "(" {Id ","}* args ")" "{" Command* commands "}"
  | missing: "missing" "(" Id name "," Id args ")" "{" Command* commands "}"
  ;
```

## syntax Id {#lang-flybytes-demo-protol-Syntax-Id}

```rascal
lexical Id     = ([A-Za-z][a-zA-Z0-9]*) \ "if" \ "new" \ "else" \ "while"  \ "return" \ "this";
```

## syntax Int {#lang-flybytes-demo-protol-Syntax-Int}

```rascal
lexical Int    = [0-9]+;
```

## syntax String {#lang-flybytes-demo-protol-Syntax-String}

```rascal
lexical String = "\"" ![\"]* "\"";
```

## syntax WSC {#lang-flybytes-demo-protol-Syntax-WSC}

```rascal
layout WSC = (WS | COMM)* !>> "//" !>> [\t\n\r\ ];
```

## syntax WS {#lang-flybytes-demo-protol-Syntax-WS}

```rascal
lexical WS = [\t\n\r\ ]+ !>> [\t\n\r\ ];
```

## syntax COMM {#lang-flybytes-demo-protol-Syntax-COMM}

```rascal
lexical COMM = "//" ![\n]* "\n";
```

