---
title: "module lang::flybytes::tests::ComparisonTests"
id: ComparisonTests
slug: /Packages/org.rascalmpl.flybytes/API/lang/flybytes/tests/ComparisonTests
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.2</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.flybytes-0.2.10</div>

#### Usage

```rascal
import lang::flybytes::tests::ComparisonTests;
```

#### Dependencies
```rascal
import lang::flybytes::Compiler;
import lang::flybytes::Mirror;
import lang::flybytes::api::JavaLang;
import Node;
import util::Math;
```


## alias CompOp {#lang-flybytes-tests-ComparisonTests-CompOp}

```rascal
Exp (Exp, Exp)
```

## function cmpOpClass {#lang-flybytes-tests-ComparisonTests-cmpOpClass}

```rascal
Class cmpOpClass(Type t, CompOp op)
```

## function testCmpOp {#lang-flybytes-tests-ComparisonTests-testCmpOp}

```rascal
bool testCmpOp(Class c, Type t, Mirror lhs, Mirror rhs, bool answer)
```

## function make {#lang-flybytes-tests-ComparisonTests-make}

```rascal
value make(object(str cl), int _)

value make(string(), int i)

value make(array(integer()), int i)
```

## function fit {#lang-flybytes-tests-ComparisonTests-fit}

```rascal
real fit(float(), real r)

real fit(double(), real r)
```

# Tests
## test testEqTrue {#lang-flybytes-tests-ComparisonTests-testEqTrue}

```rascal
test bool testEqTrue(int i) 
  = all (t <- intTypes, 
         I := prim(t, abs(i) % maxIntValue(t)),
         testCmpOp(cmpOpClass(t, eq), t, I, I, true));
```

## test testEqFalse {#lang-flybytes-tests-ComparisonTests-testEqFalse}

```rascal
test bool testEqFalse(int i) 
  = all (t <- intTypes, 
         I := abs(i) % maxIntValue(t),
         testCmpOp(cmpOpClass(t, eq), t, prim(t, I), prim(t, I - 1), false));
```

## test testNEqTrue {#lang-flybytes-tests-ComparisonTests-testNEqTrue}

```rascal
test bool testNEqTrue(int i) 
  = all (t <- intTypes, 
         I := abs(i) % maxIntValue(t),
         testCmpOp(cmpOpClass(t, ne), t, prim(t, I), prim(t, I - 1), true));
```

## test testNEqFalse {#lang-flybytes-tests-ComparisonTests-testNEqFalse}

```rascal
test bool testNEqFalse(int i) 
  = all (t <- intTypes, 
         I := prim(t, abs(i) % maxIntValue(t)),
         testCmpOp(cmpOpClass(t, ne), t, I, I, false));
```

## test testLt {#lang-flybytes-tests-ComparisonTests-testLt}

```rascal
test bool testLt(int i, int j) 
  = all (t <- intTypes, 
         I := (i % maxIntValue(t)),
         J := (j % maxIntValue(t)),
         testCmpOp(cmpOpClass(t, lt), t, prim(t, I), prim(t, J), I < J));
```

## test testGt {#lang-flybytes-tests-ComparisonTests-testGt}

```rascal
test bool testGt(int i, int j) 
  = all (t <- intTypes, 
         I := (i % maxIntValue(t)),
         J := (j % maxIntValue(t)),
         testCmpOp(cmpOpClass(t, gt), t, prim(t, I), prim(t, J), I > J));
```

## test testGeInt {#lang-flybytes-tests-ComparisonTests-testGeInt}

```rascal
test bool testGeInt(int i, int j) 
  = all (t <- intTypes, 
         I := (i % maxIntValue(t)),
         J := (j % maxIntValue(t)),
         testCmpOp(cmpOpClass(t, ge), t, prim(t, I), prim(t, J), I >= J));
```

## test testLe {#lang-flybytes-tests-ComparisonTests-testLe}

```rascal
test bool testLe(int i, int j) 
  = all (t <- intTypes, 
         I := (i % maxIntValue(t)),
         J := (j % maxIntValue(t)),
         testCmpOp(cmpOpClass(t, le), t, prim(t, I), prim(t, J), I <= J));
```

## test testEqTrue2 {#lang-flybytes-tests-ComparisonTests-testEqTrue2}

```rascal
test bool testEqTrue2(real r) 
  = all (t <- floatTypes, 
         I := 1. / (r + .1),
         testCmpOp(cmpOpClass(t, eq), t, prim(t, I), prim(t, I), true));
```

## test testEqFalse2 {#lang-flybytes-tests-ComparisonTests-testEqFalse2}

```rascal
test bool testEqFalse2(real r) 
  = all (t <- floatTypes, 
         I := 1. / (r + .1),
         testCmpOp(cmpOpClass(t, eq), t, prim(t, I), prim(t, I + .1), false));
```

## test testLe2 {#lang-flybytes-tests-ComparisonTests-testLe2}

```rascal
test bool testLe2(real i, real j) 
  = all (t <- floatTypes, 
         I := fit(t, 1. / (i + .1)),
         J := fit(t, 1. / (j + .1)),
         testCmpOp(cmpOpClass(t, le), t, prim(t, I), prim(t, J), I <= J));
```

## test testLt2 {#lang-flybytes-tests-ComparisonTests-testLt2}

```rascal
test bool testLt2(real i, real j) 
  = all (t <- floatTypes, 
         I := fit(t, 1. / (i + .1)),
         J := fit(t, 1. / (j + .1)),
         testCmpOp(cmpOpClass(t, lt), t, prim(t, I), prim(t, J), I < J));
```

## test testGt2 {#lang-flybytes-tests-ComparisonTests-testGt2}

```rascal
test bool testGt2(real i, real j) 
  = all (t <- floatTypes, 
         I := fit(t, 1. / (i + .1)),
         J := fit(t, 1. / (j + .1)),
         testCmpOp(cmpOpClass(t, gt), t, prim(t, I), prim(t, J), I > J));
```

## test testGeReal {#lang-flybytes-tests-ComparisonTests-testGeReal}

```rascal
test bool testGeReal(real i, real j) 
  = all (t <- floatTypes, 
         I := fit(t, 1. / (i + .1)),
         J := fit(t, 1. / (j + .1)),
         testCmpOp(cmpOpClass(t, ge), t, prim(t, I), prim(t, J), I >= J));
```

## test testEqTrue3 {#lang-flybytes-tests-ComparisonTests-testEqTrue3}

```rascal
test bool testEqTrue3() 
  = all (t <- objectTypes, 
         v := make(t, 1),
         testCmpOp(cmpOpClass(t, eq), t, v, v, true));
```

## test testEqFalse3 {#lang-flybytes-tests-ComparisonTests-testEqFalse3}

```rascal
test bool testEqFalse3() 
  = all (t <- objectTypes, 
         v1 := make(t, 1),
         v2 := make(t, 2),
         testCmpOp(cmpOpClass(t, eq), t, v1, v2, false));
```

